########################################################
# K3D_CHECK_X86 - tests to see if we're building for an x86 platform

AC_DEFUN([K3D_CHECK_X86], [
AC_MSG_CHECKING([for an x86 CPU])

if echo $target_cpu | grep "i.86" >/dev/null 2>/dev/null; then
	AC_MSG_RESULT([found $x86])
	AC_DEFINE([K3D_HAVE_X86], [1], [Define to 1 if you are building for an architecture that uses an Intel x86 CPU])
else
	AC_MSG_RESULT([not found])
fi

])

########################################################
# K3D_CHECK_PLATFORM - tests to see what platform we're building on - posix, win32, darwin, etc.

AC_DEFUN([K3D_CHECK_PLATFORM], [
AC_MSG_CHECKING([for platform])
AC_ARG_WITH(win32-prefix,[  --with-win32-prefix[[=PATH]]    change location of win32 libs [[/c/Projects/k3d-win32]]],[],[withval=/c/Projects/k3d-win32])
if test x$withval != x; then
	k3d_win32_prefix=$withval
fi

k3d_win32=false 
k3d_darwin=false

case $host in
  *-*-cygwin* | *-*-mingw*)
	AC_MSG_RESULT([found Win32 native (cygwin or mingw)])
	k3d_win32=true 
	LDFLAGS="-no-undefined -Wl,--export-all-symbols -Wl,--enable-auto-import -Wl,--enable-runtime-pseudo-reloc"
	AC_DEFINE([K3D_PLATFORM_WIN32_NATIVE], [1], [Define to 1 if you are building K-3D on Win32 (cygwin or mingw)])
	;;
  *-*-darwin*)
  	AC_MSG_RESULT([found Darwin (including Mac OS-X)])
	k3d_darwin=true 
	AC_DEFINE([K3D_PLATFORM_DARWIN], [1], [Define to 1 if you are building K-3D on Darwin (including Mac OS-X)])
	;;
  *)
	AC_MSG_RESULT([defaulting to posix])
	AC_DEFINE([K3D_PLATFORM_POSIX], [1], [Define to 1 if you are building K-3D on most Posix platforms, including GNU/Linux])
	;;

esac
AM_CONDITIONAL(K3D_WIN32, test x$k3d_win32 = xtrue)
])

#############################################################
# K3D_CHECK_OPENGL - tests for an installed OpenGL library

AC_DEFUN([K3D_CHECK_OPENGL], [
AC_SUBST(K3D_OPENGL_CFLAGS)
AC_SUBST(K3D_OPENGL_LIBS)
AC_MSG_CHECKING([for OpenGL])

if $k3d_win32; then
	K3D_OPENGL_CFLAGS=""
	K3D_OPENGL_LIBS="-lopengl32 -lgdi32"
	AC_MSG_RESULT([presumed to be in default lib/include paths under Win32])
else
	k3d_check_opengl_lib_dir=""
	k3d_check_opengl_directories="/usr/lib /usr/local/lib /usr/X11R6/lib"
	for k3d_check_opengl_directory in $k3d_check_opengl_directories; do
		if test -f $k3d_check_opengl_directory/libGL.so || test -f $k3d_check_opengl_directory/libGL.a; then
			k3d_check_opengl_lib_dir=$k3d_check_opengl_directory
		fi
	done

	k3d_check_opengl_header_dir=""
	k3d_check_opengl_directories="/usr/include /usr/local/include /usr/X11R6/include"
	for k3d_check_opengl_directory in $k3d_check_opengl_directories; do
		if test -f $k3d_check_opengl_directory/GL/gl.h; then
			k3d_check_opengl_header_dir=$k3d_check_opengl_directory
		fi
	done

	if test -n $k3d_check_opengl_lib_dir && test -n $k3d_check_opengl_header_dir; then
		K3D_OPENGL_CFLAGS="-I$k3d_check_opengl_header_dir"
		K3D_OPENGL_LIBS="-L$k3d_check_opengl_lib_dir -lGL"
		AC_MSG_RESULT([found in $k3d_check_opengl_lib_dir and $k3d_check_opengl_header_dir])
	else
		AC_MSG_ERROR([OpenGL required but not found])
	fi
fi

])

########################################################
# K3D_CHECK_OPENGLU - tests for an installed OpenGLU library

AC_DEFUN([K3D_CHECK_OPENGLU], [
AC_SUBST(K3D_OPENGLU_CFLAGS)
AC_SUBST(K3D_OPENGLU_LIBS)
AC_MSG_CHECKING([for OpenGLU])

if $k3d_win32; then
	K3D_OPENGLU_CFLAGS=""
	K3D_OPENGLU_LIBS="-lglu32"
	AC_MSG_RESULT([presumed to be in default lib/include paths under Win32])
else
	k3d_check_openglu_lib_dir=""
	k3d_check_openglu_directories="/usr/lib /usr/local/lib /usr/X11R6/lib"
	for k3d_check_openglu_directory in $k3d_check_openglu_directories; do
		if test -f $k3d_check_openglu_directory/libGLU.so || test -f $k3d_check_openglu_directory/libGLU.a; then
			k3d_check_openglu_lib_dir=$k3d_check_openglu_directory
		fi
	done

	k3d_check_openglu_header_dir=""
	k3d_check_openglu_directories="/usr/include /usr/local/include /usr/X11R6/include"
	for k3d_check_openglu_directory in $k3d_check_openglu_directories; do
		if test -f $k3d_check_openglu_directory/GL/gl.h; then
			k3d_check_openglu_header_dir=$k3d_check_openglu_directory
		fi
	done

	if test -n $k3d_check_openglu_lib_dir && test -n $k3d_check_openglu_header_dir; then
		K3D_OPENGLU_CFLAGS="-I$k3d_check_openglu_header_dir"
		K3D_OPENGLU_LIBS="-L$k3d_check_openglu_lib_dir -lGLU"
		AC_MSG_RESULT([found in $k3d_check_openglu_lib_dir and $k3d_check_openglu_header_dir])
	else
		AC_MSG_ERROR([OpenGLU required but not found])
	fi
fi

])

########################################################
# K3D_CHECK_COMPILERS

AC_DEFUN([K3D_CHECK_COMPILERS], [

AC_ARG_WITH(gcc-2-96, [  --with-gcc-2-96         build using gcc 2.96, which may generate unusable executables [[no]]],[],[withval=no])
if test x"$withval" = xyes; then
	k3d_use_gcc_2_96="yes"
fi

AC_MSG_CHECKING([for problematic compiler versions])

if $CXX --version | grep "2\.96" >/dev/null 2>/dev/null; then

	AC_MSG_RESULT([found gcc 2.96])

	if test "$k3d_use_gcc_2_96" = yes; then
		AC_MSG_WARN([

Building K-3D with gcc 2.96.  This is an unofficial release of gcc that has been known to
produce unusable K-3D executables.  If you have problems, our recommendation is that you
switch to gcc 2.95 or gcc 3.0 or above.
])
	else
		AC_MSG_ERROR([

It appears that you're using gcc 2.96.  This is an unofficial release of gcc that has been known to produce
unusable K-3D executables.  It's possible that an incremental upgrade to gcc 2.96 may have fixed whatever
problems existed in the past, so you may re-run configure with the --with-gcc-2-96 option to override this test.
If you do so and continue to have problems, our recommendation is that you switch to gcc 2.95 or gcc 3.0 or above.
])
	fi

else

	AC_MSG_RESULT([none found])

fi

])

########################################################
# K3D_COMPILER_FLAGS

AC_DEFUN([K3D_COMPILER_FLAGS], [
AC_SUBST(K3D_CFLAGS)
AC_SUBST(K3D_CPPFLAGS)
AC_SUBST(K3D_CXXFLAGS)

if $k3d_win32; then
	K3D_CFLAGS="-Wall"
	K3D_CPPFLAGS="-I\$(top_srcdir) -I\$(top_srcdir)/boost"
	K3D_CXXFLAGS="-Wall -Wno-ctor-dtor-privacy -mms-bitfields"
else
	K3D_CFLAGS="-Wall"
	K3D_CPPFLAGS="-I\$(top_srcdir) -I\$(top_srcdir)/boost"
	K3D_CXXFLAGS="-Wall -Wno-ctor-dtor-privacy"
fi

])

########################################################
# K3D_WITH_FREETYPE2

AC_DEFUN([K3D_WITH_FREETYPE2], [
AC_SUBST(K3D_FREETYPE2_SUBDIR)
AC_SUBST(K3D_FREETYPE2_CFLAGS)
AC_SUBST(K3D_FREETYPE2_LIBS)
AC_ARG_WITH(freetype2, [  --with-freetype2        build freetype2-based text plug-in [[yes]]],[],[withval=yes])
if test x$withval != xno; then
	AC_MSG_CHECKING([for freetype2])
	if pkg-config --exists freetype2 >/dev/null 2>/dev/null; then
		K3D_FREETYPE2_VERSION=`pkg-config --modversion freetype2`
		K3D_FREETYPE2_CFLAGS=`pkg-config --cflags freetype2`
		K3D_FREETYPE2_LIBS=`pkg-config --libs freetype2`
		K3D_FREETYPE2_SUBDIR=freetype2
		AC_MSG_RESULT([found version $K3D_FREETYPE2_VERSION])
	elif freetype-config --version >/dev/null 2>/dev/null; then
		K3D_FREETYPE2_VERSION=`freetype-config --version`
		K3D_FREETYPE2_CFLAGS=`freetype-config --cflags`
		K3D_FREETYPE2_LIBS=`freetype-config --libs`
		K3D_FREETYPE2_SUBDIR=freetype2
		AC_MSG_RESULT([found version $K3D_FREETYPE2_VERSION])
	else
		AC_MSG_ERROR([couldn't find freetype2 library ... if you don't require freetype2 support, re-run configure with the --without-freetype2 option])
	fi

	if $k3d_win32; then
		K3D_FREETYPE2_CFLAGS="$K3D_FREETYPE2_CFLAGS -I$k3d_win32_prefix/include"
	fi
fi
])

########################################################
# K3D_WITH_PYTHON

AC_DEFUN([K3D_WITH_PYTHON], [
AC_SUBST(K3D_PYTHON_SUBDIR)
AC_SUBST(K3D_PYTHON_CPPFLAGS)
AC_SUBST(K3D_PYTHON_LIBADD)
AC_SUBST(K3D_PYTHON_LDFLAGS)
AC_ARG_WITH(python,[  --with-python[[=PATH]]    build python-based script engine [[no]]],[],[withval=no])
if test x$withval != xno; then
	if test -z "$PYTHON"; then
		AC_PATH_PROGS(PYTHON, python python2.2 python2.3)
	fi
	changequote(, )
	K3D_PYTHON_VERSION=`$PYTHON -c "import sys; print sys.version[:3]"`
	changequote([, ])
	AC_MSG_RESULT([found Python version $K3D_PYTHON_VERSION])
	if test x$withval = xyes; then
		k3d_python_prefix=/usr
	else
		k3d_python_prefix=$withval
	fi

	if $k3d_win32; then
		AC_CHECK_HEADER([$k3d_python_prefix/include/Python.h],
		[
			K3D_PYTHON_SUBDIR="python"
			K3D_PYTHON_CPPFLAGS="-I$k3d_python_prefix/include"
			K3D_PYTHON_LIBADD=""
			K3D_PYTHON_LDFLAGS="c:/windows/system32/python${K3D_PYTHON_VERSION}.dll"
		],
		[
		AC_MSG_ERROR([
	Couldn't find Python.h ... if you don't require python support, re-run
	configure with the --without-python option

	If you wish to include support and have Python installed in a directory
	configure can't find, try specify the basepath to library and header:

		./configure --with-python=c:/pythonXX

		])
		])
	else
		AC_CHECK_HEADER([$k3d_python_prefix/include/python${K3D_PYTHON_VERSION}/Python.h],
		[
			K3D_PYTHON_SUBDIR="python"
			K3D_PYTHON_CPPFLAGS="-I$k3d_python_prefix/include/python${K3D_PYTHON_VERSION}"
			K3D_PYTHON_LIBADD="-L$k3d_python_prefix/lib/python${K3D_PYTHON_VERSION}/config -lpython${K3D_PYTHON_VERSION} -lutil"
			K3D_PYTHON_LDFLAGS="-Xlinker -export-dynamic"
		],
		[
		AC_MSG_ERROR([
	Couldn't find Python.h ... if you don't require python support, re-run
	configure with the --without-python option

	If you wish to include support and have Python installed in a directory
	configure can't find, try specify the basepath to library and header:

		./configure --with-python=/usr/local

	To find out the path, type:

		locate Python.h

	If the above return '/usr/local/include/python2.3/Python.h' the basepath
	will in that case be '/usr/local'.
		])
		])
	fi
fi
])

########################################################
# K3D_WITH_PLIB

AC_DEFUN([K3D_WITH_PLIB], [
AC_SUBST(K3D_PLIB_SUBDIR)
AC_SUBST(K3D_PLIB_CFLAGS)
AC_SUBST(K3D_PLIB_LIBS)
AC_ARG_WITH(plib, [  --with-plib             build plib-based import/export library [[no]]],[],[withval=no])
if test x$withval != xno; then
	AC_CHECK_HEADER([plib/ssg.h], [],
	[
	AC_MSG_ERROR([couldn't find plib/ssg.h ... if you don't require plib support, re-run configure with the --without-plib option])
	])
	AC_CHECK_LIB(plibul, ulInit,
	[
	K3D_PLIB_SUBDIR="plib"
	K3D_PLIB_LIBS="-lplibssg -lplibssgaux -lplibsg -lplibul"
	],
	[
	AC_MSG_ERROR([couldn't link with plib ... if you don't require plib support, re-run configure with the --without-plib option])
	])
fi
])

########################################################
# K3D_WITH_ODE

AC_DEFUN([K3D_WITH_ODE], [
AC_SUBST(K3D_ODE_SUBDIR)
AC_SUBST(K3D_ODE_CFLAGS)
AC_SUBST(K3D_ODE_LIBS)
AC_ARG_WITH(ode, [  --with-ode              build ode-based dynamic physical simulation objects [[no]]],[],[withval=no])
if test x$withval != xno; then
	AC_CHECK_HEADER([ode/ode.h], [],
	[
	AC_MSG_ERROR([couldn't find ode/ode.h ... if you don't require ode support, re-run configure with the --without-ode option])
	])
	K3D_ODE_SUBDIR="ode"
	K3D_ODE_CFLAGS=-I/usr/local/include/ode
	K3D_ODE_LIBS="-lode"
fi
])

########################################################
# K3D_WITH_MONO

AC_DEFUN([K3D_WITH_MONO], [
AC_SUBST(K3D_MONO_SUBDIR)
AC_SUBST(K3D_MONO_CFLAGS)
AC_SUBST(K3D_MONO_LIBS)
AC_ARG_WITH(mono, [  --with-mono             build embedded mono interpreter [[no]]],[],[withval=no])
if test x$withval != xno; then
	AC_MSG_CHECKING([for mono])
	if pkg-config --exists mono >/dev/null 2>/dev/null; then
		K3D_MONO_VERSION=`pkg-config --modversion mono`
		K3D_MONO_CFLAGS=`pkg-config --cflags mono`
		K3D_MONO_LIBS=`pkg-config --libs mono`
		K3D_MONO_SUBDIR=mono
	else
		AC_MSG_ERROR([couldn't find an installed mono ... if you don't require mono support, re-run configure using the --without-mono option])
	fi
fi
])

########################################################
# K3D_WITH_RUBY

AC_DEFUN([K3D_WITH_RUBY], [
AC_SUBST(K3D_RUBY_SUBDIR)
AC_SUBST(K3D_RUBY_CPPFLAGS)
AC_SUBST(K3D_RUBY_LIBADD)
AC_ARG_WITH(ruby, [  --with-ruby[[=PATH]]      build ruby-based script engine [[no]]],[],[withval=no])
if test x$withval != xno; then
	if test x$withval = xyes; then
		k3d_ruby_prefix=/usr/lib/ruby/1.6/i386-linux
	else
		k3d_ruby_prefix=$withval
	fi
	AC_CHECK_HEADER([$k3d_ruby_prefix/ruby.h],
	[
	K3D_RUBY_CPPFLAGS="-I$k3d_ruby_prefix"
	],
	[
	AC_MSG_ERROR([
Couldn't find ruby.h ... if you don't require ruby support, re-run
configure with the --without-ruby option

If you wish to include support and have Ruby installed in a directory
configure can't find, try specify the path to library and header:

	./configure --with-ruby=/usr/lib/ruby/1.6/i686-linux

To find out the path type:

	locate ruby.h

If the above return '/usr/lib/ruby/1.6/i686-linux/ruby.h' the path
will in that case be '/usr/lib/ruby/1.6/i686-linux'.
	])
	])
	AC_CHECK_LIB(ruby, ruby_init,
	[
	K3D_RUBY_SUBDIR="ruby"
	K3D_RUBY_LIBADD="-L$k3d_ruby_prefix -lruby -ldl -lcrypt"
	],
	[
	AC_MSG_ERROR([couldn't link with ruby ... if you don't require ruby support, re-run configure with the --without-ruby option])
	],
	[-L$k3d_ruby_prefix -lruby -ldl -lcrypt])
fi
])

########################################################
# K3D_WITH_DOCBOOK

AC_DEFUN([K3D_WITH_DOCBOOK], [
AC_SUBST(K3D_USERREFERENCE_SUBDIR)
AC_SUBST(K3D_DEVELOPERGUIDE_SUBDIR)
AC_ARG_WITH(docbook, [  --with-docbook          generate documentation from DocBook sources [[yes]]],[],[withval=yes])
if test x$withval != xno; then
	AC_CHECK_PROG(k3d_have_xsltproc, xsltproc, yes, no)
	if test x$k3d_have_xsltproc = xno; then
		AC_MSG_ERROR([couldn't find xsltproc ... if you don't require documentation, re-run configure with the --without-docbook option])
	else
		K3D_USERREFERENCE_SUBDIR=user_reference
		K3D_DEVELOPERGUIDE_SUBDIR=developer_guide
	fi
fi
])

########################################################
# K3D_WITH_GRAPHVIZ

AC_DEFUN([K3D_WITH_GRAPHVIZ], [
AC_SUBST(K3D_HAVE_DOT)

K3D_HAVE_DOT="NO"

AC_ARG_WITH(graphviz, [  --with-graphviz         use the graphviz tools to create source documentation diagrams [[yes]]],[],[withval=yes])

if test x$withval = xyes; then

	AC_CHECK_PROG(k3d_have_dot, dot, yes, no)

	if test x$k3d_have_dot = xno; then
		AC_MSG_ERROR([couldn't find graphviz ... if you don't require graphviz support, re-run configure with the --without-graphviz option])
	else
		K3D_HAVE_DOT="YES"
	fi
fi

])

########################################################
# K3D_WITH_NETPBM

AC_DEFUN([K3D_WITH_NETPBM], [
AC_SUBST(K3D_HAVE_NETPBM)

K3D_HAVE_NETPBM="no"

AC_ARG_WITH(netpbm, [  --with-netpbm           use the netpbm tools to read & write bitmap file formats [[yes]]],[],[withval=yes])

if test x$withval = xyes; then

	AC_MSG_CHECKING([for netpbm])
	if ppmmake 0,0,0 16 16 | pnmtotiff --version >/dev/null 2>/dev/null; then
		AC_MSG_RESULT([found])
		K3D_HAVE_NETPBM="yes"
	else
		AC_MSG_ERROR([
It appears that you don't have an installation of the netpbm tools.  netpbm is a collection of programs
that read and write a large number of bitmap file formats.  K-3D can use netpbm to read and write
bitmap images for use as textures, so a working netpbm installation is highly recommended.  If you wish to
bypass this error message, re-run configure with the --without-netpbm option.  In this case you will not be
able to load images for use as textures.
		])
	fi
fi
])

#######################################################
# K3D_WITH_NEW_PNMTOTIFF

AC_DEFUN([K3D_WITH_NEW_PNMTOTIFF], [
AC_SUBST(K3D_PNMTOTIFF_FLAGS)

K3D_PNMTOTIFF_FLAGS=""

if test x$K3D_HAVE_NETPBM = xyes; then

	AC_ARG_WITH(new-pnmtotiff, [  --with-new-pnmtotiff    test for newer versions of pnmtotiff for writing textures [[yes]]],[],[withval=yes])

	if test x$withval = xyes; then

		AC_MSG_CHECKING([for newer versions of pnmtotiff])
		if ppmmake 0,0,0 16 16 | pnmtotiff -color -truecolor >/dev/null 2>/dev/null; then
			AC_MSG_RESULT([found])
			K3D_PNMTOTIFF_FLAGS="-color -truecolor"
		else
			AC_MSG_ERROR([
It appears that you're using an older version of the netpbm tools.  netpbm is a collection of programs
that read and write a large number of bitmap file formats.  K-3D can use netpbm to read and write
bitmap images for use as textures.  In particular, K-3D uses pnmtotiff to write image files in TIFF format
for use with RenderMan compatible render engines.  Unfortunately, the version of pnmtotiff installed on your
system automatically stores greyscale images and images containing fewer than 256 distinct colors in a
format that most RenderMan compatible render engines can't load.  It is strongly recommended that you upgrade
to a newer version of netpbm.  If you wish to bypass this error message, re-run configure with the
--without-new-pnmtotiff option.  In this case, any greyscale or low-color images you use as textures will
probably fail to render, regardless of their source file format.  If you upgrade netpbm later on, be sure to
re-run configure and re-install K-3D, or manually add the -color and -truecolor options to your
share/netpbm.conf file.
			])
		fi
	fi
fi

])

#######################################################
# K3D_WITH_IMAGEMAGICK

AC_DEFUN([K3D_WITH_IMAGEMAGICK], [
AC_SUBST(K3D_IMAGEMAGICK_CPPFLAGS)
AC_SUBST(K3D_IMAGEMAGICK_CXXFLAGS)
AC_SUBST(K3D_IMAGEMAGICK_LIBS)
AC_SUBST(K3D_IMAGEMAGICK_LDFLAGS)
AC_SUBST(K3D_IMAGEMAGICK_SUBDIR)

K3D_IMAGEMAGICK_CPPFLAGS=""
K3D_IMAGEMAGICK_CXXFLAGS=""
K3D_IMAGEMAGICK_LIBS=""
K3D_IMAGEMAGICK_LDFLAGS=""
K3D_IMAGEMAGICK_SUBDIR=""

AC_ARG_WITH(imagemagick, [  --with-imagemagick      test for ImageMagick Magick++ API [[yes]]],[],[withval=yes])

if test x$withval = xyes; then

	AC_MSG_CHECKING([for Magick++])
	if  Magick++-config --version >/dev/null 2>/dev/null; then
		AC_MSG_RESULT([found])
                K3D_IMAGEMAGICK_CPPFLAGS=`Magick++-config --cppflags`
                K3D_IMAGEMAGICK_CXXFLAGS=`Magick++-config --cxxflags`
                K3D_IMAGEMAGICK_LIBS=`Magick++-config --libs`
                K3D_IMAGEMAGICK_LDFLAGS=`Magick++-config --ldflags`
		K3D_IMAGEMAGICK_SUBDIR="imagemagick"
	else
		AC_MSG_ERROR([
It appears that you don't have an installation of the ImageMagick Magick++ API.
ImageMagick is a collection of programs that read and write a large number of 
bitmap file formats.  K-3D relies on ImageMagick in order to read and write
bitmap images for use as textures, so a working ImageMagick installation is 
highly recommended.  In addition, you need the ImageMagick development libraries
and/or packages, including Magick++, a C++ API for ImageMagick.

If you wish to bypass this error message, re-run configure with the 
--without-imagemagick option.  In this case you will not be able to load 
images for use as textures.])
	fi
fi

])

#####################################################
# K3D_WITH_LIBTIFF

AC_DEFUN([K3D_WITH_LIBTIFF], [
AC_SUBST(K3D_TIFF_SUBDIR)
AC_SUBST(K3D_TIFF_CFLAGS)
AC_SUBST(K3D_TIFF_LIBS)

AC_ARG_WITH(tiff, [  --with-tiff             build libtiff-based export plugin [[yes]]],[],[withval=yes])
if test x$withval != xno; then
	AC_CHECK_HEADER([tiff.h],
	[
		K3D_TIFF_CFLAGS=""
		K3D_TIFF_SUBDIR="tiff"
		K3D_TIFF_LIBS="-ltiff" 
	],
	[
		if $k3d_win32 && test -f $k3d_win32_prefix/include/tiff.h; then
			K3D_TIFF_SUBDIR="tiff"
			K3D_TIFF_CFLAGS="-I$k3d_win32_prefix/include"
			K3D_TIFF_LIBS="-L$k3d_win32_prefix/lib -ltiff" 
			AC_MSG_RESULT([tiff.h found in $k3d_win32_prefix/include])
		else
			AC_MSG_ERROR([couldn't find tiff.h ... if you don't require tiff support, re-run configure with the without-tiff option])
		fi
	])
fi
])

########################################################
# K3D_WITH_OPENEXR

AC_DEFUN([K3D_WITH_OPENEXR], [
AC_SUBST(K3D_OPENEXR_CFLAGS)
AC_SUBST(K3D_OPENEXR_LIBS)
AC_SUBST(K3D_OPENEXR_SUBDIR)
AC_ARG_WITH(openexr, [  --with-openexr          build OpenEXR plug-ins [[no]]],[],[withval=no])
if test x$withval != xno; then
	AC_MSG_CHECKING([for OpenEXR])
	if pkg-config --exists OpenEXR >/dev/null 2>/dev/null; then
		K3D_OPENEXR_VERSION=`pkg-config --modversion OpenEXR`
		K3D_OPENEXR_CFLAGS=`pkg-config --cflags OpenEXR`
		K3D_OPENEXR_LIBS=`pkg-config --libs OpenEXR`
		K3D_OPENEXR_SUBDIR="openexr"
		AC_MSG_RESULT([found version $K3D_OPENEXR_VERSION])
	else
		AC_MSG_ERROR([couldn't find OpenEXR library ... if you don't require OpenEXR support, re-run configure with the --without-openexr option])
	fi
fi
])

########################################################
# K3D_WITH_GTK - tests for an installed GTK+ library

AC_DEFUN([K3D_WITH_GTK], [
AC_SUBST(K3D_GLIB_CFLAGS)
AC_SUBST(K3D_GLIB_LIBS)
AC_SUBST(K3D_GTK_CFLAGS)
AC_SUBST(K3D_GTK_LIBS)
AC_MSG_CHECKING([for GTK+])

dnl AC_ARG_WITH(gtk2, [  --with-gtk2             use GTK2-based graphical user interface (experimental) [[no]]],[],[withval=no])
dnl if test x$withval != xno; then
dnl 
dnl 	if $k3d_win32; then
dnl 		AC_MSG_ERROR([gtk2 untested under Win32])
dnl 	else
dnl 		if [ ! pkg-config --exists glib-2.0 ]; then
dnl 			AC_MSG_ERROR([glib2 required but not found])
dnl 		fi
dnl 
dnl 		if [ ! pkg-config --exists gtk+-2.0 ]; then
dnl 			AC_MSG_ERROR([gtk2 required but not found])
dnl 		fi
dnl 
dnl 		K3D_GLIB_VERSION=`pkg-config --modversion glib-2.0`
dnl 		K3D_GLIB_CFLAGS=`pkg-config --cflags glib-2.0`
dnl 		K3D_GLIB_LIBS=`pkg-config --libs glib-2.0`
dnl 			
dnl 		K3D_GTK_VERSION=`pkg-config --modversion gtk+-2.0`
dnl 		K3D_GTK_CFLAGS=`pkg-config --cflags gtk+-2.0`
dnl 		K3D_GTK_LIBS=`pkg-config --libs gtk+-2.0`
dnl 
dnl 		AC_DEFINE([K3D_HAVE_GTK2], [1], [Define to 1 if you are building with GTK2, instead of GTK+ 1.2])
dnl 		AC_DEFINE([GTK_ENABLE_BROKEN], [1], [Define to 1 if you are building with GTK2, instead of GTK+ 1.2])
dnl 	fi
dnl 
dnl else

	if $k3d_win32; then
		K3D_GLIB_VERSION="glib-2.0"
		K3D_GTK_VERSION="gtk-2.0"
		K3D_GLIB_CFLAGS="-I$k3d_win32_prefix/include -I$k3d_win32_prefix/include/gtk -I$k3d_win32_prefix/include/gdk -I$k3d_win32_prefix/include/glib-2.0 -I$k3d_win32_prefix/lib/gtk+/include -I$k3d_win32_prefix/lib/glib-2.0/include"
		K3D_GLIB_LIBS="-L$k3d_win32_prefix/lib -lglib-2.0 -lgtk -lgdk -lgmodule-2.0"
	else
		if [ ! glib-config --version >/dev/null 2>/dev/null ]; then
			AC_MSG_ERROR([glib required but not found])
		fi

		if [ ! gtk-config --version >/dev/null 2>/dev/null ]; then
			AC_MSG_ERROR([gtk required but not found])
		fi

		K3D_GLIB_VERSION=`glib-config --version`
		K3D_GLIB_CFLAGS=`glib-config --cflags`
		K3D_GLIB_LIBS=`glib-config --libs`
		
		K3D_GTK_VERSION=`gtk-config --version`
		K3D_GTK_CFLAGS=`gtk-config --cflags`
		K3D_GTK_LIBS=`gtk-config --libs`
	fi

dnl fi

AC_MSG_RESULT([found version $K3D_GTK_VERSION])

])

########################################################
# K3D_CHECK_SIGC - tests for an installed libsigc++ library

AC_DEFUN([K3D_CHECK_SIGC], [
AC_SUBST(K3D_SIGC_CFLAGS)
AC_SUBST(K3D_SIGC_LIBS)

AC_MSG_CHECKING([for libsigc++])

if [pkg-config --exists sigc++-2.0]; then

	K3D_SIGC_VERSION=`pkg-config --modversion sigc++-2.0`
	K3D_SIGC_CFLAGS=`pkg-config --cflags sigc++-2.0`
	K3D_SIGC_CFLAGS="$K3D_SIGC_CFLAGS -DK3D_HAVE_SIGC_2_0"
	K3D_SIGC_LIBS=`pkg-config --libs sigc++-2.0`
	AC_MSG_RESULT([found version $K3D_SIGC_VERSION])

elif [sigc-config --version >/dev/null 2>/dev/null]; then

	K3D_SIGC_VERSION=`sigc-config --version`
	K3D_SIGC_CFLAGS=`sigc-config --cflags`
	K3D_SIGC_CFLAGS="$K3D_SIGC_CFLAGS -DK3D_HAVE_SIGC_1_0"
	K3D_SIGC_LIBS=`sigc-config --libs` 
	AC_MSG_RESULT([found version $K3D_SIGC_VERSION])

elif [pkg-config --exists sigc++-1.2]; then

	K3D_SIGC_VERSION=`pkg-config --modversion sigc++-1.2`
	K3D_SIGC_CFLAGS=`pkg-config --cflags sigc++-1.2`
	K3D_SIGC_CFLAGS="$K3D_SIGC_CFLAGS -DK3D_HAVE_SIGC_1_2"
	K3D_SIGC_LIBS=`pkg-config --libs sigc++-1.2`
	AC_MSG_RESULT([found version $K3D_SIGC_VERSION])

	if test "$K3D_SIGC_VERSION" = "1.2.0" || test "$K3D_SIGC_VERSION" = "1.2.1" || test "$K3D_SIGC_VERSION" = "1.2.2"; then
	
		AC_MSG_WARN([
Building K-3D with sigc++ 1.2 prior to version 1.2.3 - there are significant known issues
(segfaults) running K-3D built against these older versions of sigc++ 1.2.  Our strong
recommendation is that you either install sigc++ 1.0.4 (preferred) or upgrade to sigc++ >= 1.2.3.
		])

	else

		AC_MSG_WARN([
Building K-3D with sigc++ 1.2 - there is at least one known stability issue (segfault)
running K-3D built against sigc++ 1.2.  Our strong recommendation is that you install sigc++ 1.0.4,
which will not affect your existing sigc++ 1.2 installation.  Review Bug #939134 in the K-3D bug
database.
		])

	fi

else

	AC_MSG_ERROR([sigc++ required but not found ... recommend you install sigc++ 1.0.4 for use with K-3D])

fi

])

#####################################################
# K3D_HAPY_CONFIG

AC_DEFUN([HAPY_CHECK_SPN_STRING_COMPARE], [
AC_CACHE_CHECK(for non-standard std::string::compare profile,
	ac_cv_have_spn_string_compare, [
        AC_TRY_COMPILE([
                #include <string>
        ],[
                const string s1 = "abcd";
                const string s2 = "bc";
		return (s1.compare(s2, 1, s2.size()) == 0) ? 0 : 255;
        ],[
                ac_cv_have_spn_string_compare="yes";
        ],[
                ac_cv_have_spn_string_compare="no";
        ])
])
if test "x$ac_cv_have_spn_string_compare" = xyes; then
        AC_DEFINE(HAPY_HAVE_SPN_STRING_COMPARE, 1,
		[Define to 1 if you have non-standard std::string::compare profile])
fi
])

AC_DEFUN([HAPY_CHECK_NUMERIC_LIMITS], [
AC_CACHE_CHECK(for std::numeric_limits,
	ac_cv_have_numeric_limits, [
        AC_TRY_COMPILE([
                #include <limits>
		// try #including non-standard ones too?
        ],[
		return std::numeric_limits<unsigned long>::max() == 0;
        ],[
                ac_cv_have_numeric_limits="yes";
        ],[
                ac_cv_have_numeric_limits="no";
        ])
])
if test "x$ac_cv_have_numeric_limits" = xyes; then
        AC_DEFINE(HAPY_HAVE_NUMERIC_LIMITS, 1,
		[Define to 1 if you have std::numeric_limits template])
fi
])

AC_DEFUN([HAPY_CHECK_STD_ITERATOR_TYPE], [
AC_CACHE_CHECK(for std::iterator, ac_cv_have_std_iterator_type, [
	AC_TRY_COMPILE([
		#include <iterator>
		template <typename V, typename D>
		struct std_bidirectional_iterator:
			public std::iterator<std::bidirectional_iterator_tag, V, D> {
		};
	],[
		typedef std_bidirectional_iterator<int*,int> MyIterator;
		return 0;
	],[
		ac_cv_have_std_iterator_type="yes";
	],[
		ac_cv_have_std_iterator_type="no";
	])
])
if test "x$ac_cv_have_std_iterator_type" = xyes; then
        AC_DEFINE(HAPY_HAVE_STD_ITERATOR_TYPE, 1,
		[Define to 1 if you have std::iterator template])
fi
])

########################################################
# K3D_WITH_GTS

AC_DEFUN([K3D_WITH_GTS], [
AC_SUBST(K3D_GTS_SUBDIR)
AC_SUBST(K3D_GTS_CPPFLAGS)
AC_SUBST(K3D_GTS_LDFLAGS)
AC_ARG_WITH(gts, [  --with-gts              build gts-based mesh plug-ins [[no]]],[],[withval=no])
if test x$withval != xno; then
	AC_MSG_CHECKING([for gts])
	if gts-config --version >/dev/null 2>/dev/null; then
		K3D_GTS_SUBDIR=gts
		K3D_GTS_VERSION=`gts-config --version`
		K3D_GTS_CPPFLAGS=`gts-config --cflags`
		K3D_GTS_LDFLAGS=`gts-config --libs`
		AC_MSG_RESULT([found version $K3D_GTS_VERSION])
	else
		AC_MSG_ERROR([couldn't find gts library ... if you don't require gts support, re-run configure with the --without-gts option])
	fi
fi
])

