/* jstest: a joystick button test program
   Copyright (C) Sander Pronk, 1998
   
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <unistd.h>
#include <asm/io.h>

#include <time.h>

#define SLEEPVAL 10000
/* wait 10 microseconds */

#define PORT 0x201
/* The joystick IO port */
#define MASKBUT1 0x10
#define MASKBUT2 0x20
#define MASKBUT3 0x40
#define MASKBUT4 0x80
#define MASKALL 0xf0

int  ioperm(unsigned  long,  unsigned  long, int);
/* I've supplied the prototype manually, because different
   distributions seem to have this at different places */


int main(void)
{
    int last=-1;
    int new;
    int i;
    int none;


    if (ioperm(PORT,1,1)) /* get permission for joystick port */
    {
	perror("jstest: ioperm");
	fprintf(stderr,"This program needs to be run by root or to be set\n");
	fprintf(stderr,"suid ('chmod u+s jstest' as root)\n");
	exit(1);
    }
    if ( setuid(getuid()) || setgid(getgid()) )
    {
	perror("jstest: removing root permissions");
	exit(1);
    }
    
    printf("This program displays the pressed joystick buttons for jslaunch.\n\n");
    printf("If it doesn't react to the pressing of the joystick buttons\n");
    printf("check whether your joystick interface resides on a Plug & Play\n");
    printf("card, and if it does, see the README file on how to enable it\n\n");
    printf("Joystick Buttons pressed (use this in jslaunch -r):\n\n");
    while(1)
    {
	new=inb(PORT) & MASKALL;
	if (new != last )
	{
	    last=new;
	    none=1;
	    for(i=0;i<4;i++) /* construct the string */
	    {
		if (! (last & (1 << (4+i))))
		{
		    printf("%d",i+1);
		    none=0;
		}
	    }
	    if (none)
		printf("(none)");
	    printf("\n");
	}
	usleep(SLEEPVAL);
    }
}
