#include <jmp-config.h>

#include <stdlib.h>

#include <comparators.h>
#include <method.h>

#include <ui_gtk_code_usage_dump.h>

static int code_usage_dump_file_counter = -1;

static method** methodlist = NULL;
static int methods_count = 0;

static void dump_method_row (method* m, FILE* f) {
    cls* c = method_get_owner (m);
    
    fprintf (f, "\"%s\", \"%s\", %li, %u\n", 
	     cls_get_name (c),
	     method_get_method_jmpname (m),
	     method_get_calls (m),
	     method_get_entered (m)
    );
}

/** Count the number of methodods that have used any time. */
static void count_methods (void* data) {
    if ((method_get_calls ((method*)data) > 0L) || 
	(method_get_entered ((method*)data) > 0)) {
        methods_count++;
    }
}

/** Add a row to the array of data. */
static void add_methods_row (void* data) {
    if ((method_get_calls ((method*)data) > 0L) || 
	(method_get_entered ((method*)data) > 0)) {
        methodlist [methods_count++] = (method*)data;
    }
}

void write_code_usage_dump ()
{
    char filename[128];
    char status[128];

    FILE* f;
    hashtab* methods;
	
    snprintf (filename, 128, "jmp_code_usage_dump-%d.txt", ++code_usage_dump_file_counter);
    f = fopen (filename, "w");

    if (f == NULL) {
        set_status (_("code usage dumped failed to open file"));
        return;
    }

    methods = get_methods();    
	
    methods_count = 0;
    jmphash_for_each ((jmphash_iter_f)count_methods, methods);
    
    methodlist = malloc (methods_count * sizeof (method*));

    if (methods_count > 0) {
        int i;
        methods_count = 0;
        jmphash_for_each ((jmphash_iter_f)add_methods_row, methods);
        qsort (methodlist, methods_count, sizeof (method*), method_compr_class);

        for (i = 0; i < methods_count; i++) { 
            dump_method_row (methodlist[i], f);
        }
    }
    free (methodlist);

    fflush (f);
    fclose (f);    

    snprintf (status, 128, _("code usage dumped to %s"), filename);
    set_status (status);
}

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
