#include <jmp-config.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <jmp.h>
#include <hash.h>
#include <cls.h>
#include <comparators.h>
#include <stats_context.h>
#include <stats_personality.h>


static void end_func (stats_context_t *ctxt) {
    if (ctxt->p.class_usage.cls_total != NULL) {
	cls_free (ctxt->p.class_usage.cls_total);
	ctxt->p.class_usage.cls_total = NULL;
    }
}

static void configure_func (stats_context_t *ctxt) {
    ctxt->do_sort = 1;
    ctxt->do_total_row = 1;
    ctxt->resultlist_sizeone = sizeof(cls*);
}

static void calc_pre_func (stats_context_t *ctxt) {
    memset (&ctxt->p.class_usage.total[0], 0, sizeof(ctxt->p.class_usage.total[0]));
    memset (&ctxt->p.class_usage.total[1], 0, sizeof(ctxt->p.class_usage.total[1]));
}

static void calc_func (void *data, void *arg) {
    cls *c = (cls *)data;
    stats_context_t *ctxt = (stats_context_t *)arg;    

    /* fill in filtered class usage.. */
    if (cls_get_instances (c) != 0 && 
	cls_get_filtered (c)) {

	ctxt->p.class_usage.total[0].totalAlloced += c->usage.totalAlloced;
	ctxt->p.class_usage.total[0].totalInstances += c->usage.totalInstances;
	ctxt->p.class_usage.total[0].maximumInstances += c->usage.maximumInstances;
	ctxt->p.class_usage.total[0].totalGC += c->usage.totalGC;
	ctxt->p.class_usage.total[0].totalAllocLevel += c->usage.totalAllocLevel;

	if (ctxt->resultlist_offset >= ctxt->resultlist_size) {
	    void *nresultlist;
	    int nsize;

	    nsize = ctxt->resultlist_size + ctxt->resultlist_sizegrow;
	    nresultlist = realloc (ctxt->resultlist, nsize * ctxt->resultlist_sizeone);
	    /* TODO handle NULL here */
	    ctxt->resultlist = nresultlist;
	    ctxt->resultlist_size = nsize;
	}
	ctxt->resultlist[ctxt->resultlist_offset++] = c;
    }
    /* fill in heap usage. */
    ctxt->p.class_usage.total[1].totalAlloced += c->usage.totalAlloced;
    ctxt->p.class_usage.total[1].totalInstances += c->usage.totalInstances;
    ctxt->p.class_usage.total[1].maximumInstances += c->usage.maximumInstances;
    ctxt->p.class_usage.total[1].totalGC += c->usage.totalGC; 
    ctxt->p.class_usage.total[1].totalAllocLevel += c->usage.totalAllocLevel; 
}

static void calc_post_func (stats_context_t *ctxt) {
  if (ctxt->do_total_row) {
    if (ctxt->p.class_usage.cls_total == NULL)
	ctxt->p.class_usage.cls_total = cls_new (_("Total"), _("Total"), NULL, 0, 0, NULL, 0, NULL);
    ctxt->resultlist[0] = ctxt->p.class_usage.cls_total;
    {
        cls **classlist = (cls **)ctxt->resultlist;
        classlist[0]->usage = ctxt->p.class_usage.total[0];
        cls_set_modified (classlist[0], 1);
    }
  }
}

const struct stats_personality stats_personality_class_usage = {
  "class_usage",	/* label */
  end_func,		/* end_func */
  configure_func,	/* configure_func */
  calc_pre_func,	/* calc_pre_func */
  calc_func,		/* calc_func */
  calc_post_func,	/* calc_post_func */
  cls_compr_size,	/* compr_func */
};

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
