#include <jmp-config.h>
#include <jmp-debug.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <jmp.h>
#include <hash.h>
#include <cls.h>
#include <stats_context.h>


static void stats_context_prepare (stats_context_t *ctxt)
{
  if (ctxt->resultlist != NULL) {
    int threshold;
    int remainder;
    remainder = (ctxt->resultlist_count + ctxt->resultlist_sizegrow) % ctxt->resultlist_sizegrow;
    threshold = ctxt->resultlist_count - remainder;
    /* attempt to shrink it only if it seems worth it */
    if (ctxt->resultlist_count < threshold) {
      void *nresultlist;
      nresultlist = realloc(ctxt->resultlist, threshold * ctxt->resultlist_sizeone);
      /* TODO handle NULL here */
      ctxt->resultlist = nresultlist;
      ctxt->resultlist_size = threshold;
    }
  } else {
    ctxt->resultlist_size = ctxt->resultlist_sizegrow;
    ctxt->resultlist = malloc(ctxt->resultlist_size * ctxt->resultlist_sizeone);
  }
}

void stats_context_end (stats_context_t *ctxt)
{
  if (ctxt->end_func != NULL)
    (*ctxt->end_func)(ctxt);
  if (ctxt->resultlist != NULL) {
    free (ctxt->resultlist);
    ctxt->resultlist = NULL;
  }
  return;
}

int stats_context_init (stats_context_t *ctxt, const struct stats_personality *perso)
{
  memset (ctxt, 0, sizeof(*ctxt));
  ctxt->resultlist_sizegrow = 1024;

  if (perso != NULL) {
     ctxt->label		= perso->label;
     ctxt->end_func		= perso->end_func;
     ctxt->configure_func	= perso->configure_func;
     ctxt->calc_pre_func        = perso->calc_pre_func;
     ctxt->calc_func		= perso->calc_func;
     ctxt->calc_post_func	= perso->calc_post_func;
     ctxt->compr_func		= perso->compr_func;
  }

  if (ctxt->configure_func != NULL)
    (*ctxt->configure_func)(ctxt);

  return 0;
}

void stats_context_set_compr (stats_context_t *ctxt, int(*compr_func)(const void *, const void *))
{
  ctxt->compr_func = compr_func;
}

int (*stats_context_get_compr(stats_context_t *ctxt))(const void *, const void *)
{
  return ctxt->compr_func;
}

int stats_context_calc(stats_context_t *ctxt, hashtab* data)
{
  int resultlist_offset_first;

  ctxt->resultlist_offset = 0;
  if (ctxt->do_total_row)
      ctxt->resultlist_offset++;
  resultlist_offset_first = ctxt->resultlist_offset;
  stats_context_prepare (ctxt);	/* before resultlist_count is reset */
  ctxt->resultlist_count = 0;

  if (ctxt->calc_pre_func != NULL)
    (*ctxt->calc_pre_func)(ctxt);

{
#if defined(unix) && !defined(__CYGWIN32__)
TIMEVAL_TYPE tv_saved;
print_timestamp (&tv_saved, NULL, ctxt->label);
#endif
  /* calculate */
  jmphash_lock (data, MONITOR_UI);
  jmphash_for_each_with_arg ((jmphash_iter_fa)ctxt->calc_func, data, ctxt);
  jmphash_unlock (data, MONITOR_UI);
#if defined(unix) && !defined(__CYGWIN32__)
print_timestamp (&tv_saved, &tv_saved, ctxt->label);
#endif
}

  ctxt->resultlist_count = ctxt->resultlist_offset;	/* incl total (if any) */
  ctxt->resultlist_total = ctxt->resultlist_count;

  if (ctxt->do_sort && ctxt->compr_func != NULL) {
    int nele = ctxt->resultlist_count - resultlist_offset_first;
    qsort (&ctxt->resultlist[resultlist_offset_first], nele, ctxt->resultlist_sizeone, ctxt->compr_func); 
  }

  /* TODO: If we filter top xyz cutoff, then we need to recalc the totals and chop the data */

  if (ctxt->calc_post_func != NULL)
    (*ctxt->calc_post_func)(ctxt);

  return 0;
}

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
