#ifndef CLASS_WINDOW_H__
#define CLASS_WINDOW_H__

#include <stdio.h>

/** Build the window used for class tracing. 
 */
void setup_class_tracing ();

/** Update the data in the class tracing window.
 * @param classes the new data.
 */
void update_class_tree (hashtab* classes);

/** Dump the classes to the given file.
 */
void dump_classes (hashtab* classes, FILE* f);

/** Dispose the window used for class tracing. 
 */
void quit_class_window ();

/** Get number of visible rows. 
 */
int get_class_rows ();

/** Set the number of visible rows.
 */
void set_class_rows (int rows);

#endif /* CLASS_WINDOW_H__ */
