#ifndef TRANSLATE_H__
#define TRANSLATE_H__

/** The methods used to translate jvm strings to human readable 
 *  field types and method signatures.
 */

/** 
 * @param class_name the field type to translate.
 * @param buf the output buffer.
 * @return the length of the converted string.
 */
int translate_field_type (const char* class_name, char* buf);


/** 
 * @param name the name of the method to translate
 * @param signature the signature of the method we want to translate.
 * @param buf the output buffer.
 * @return the length of the converted string.
 */
int translate_method (const char* name, const char* signature, char* buf);

#endif /* TRANSLATE_H__ */

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
