/* $Id: debug.hh,v 1.9 2002/02/13 01:09:41 richard Exp $ -*- C++ -*-
  __   _
  |_) /|  Copyright (C) 1999-2002 Richard Atterer
  | \/|  <atterer@informatik.tu-muenchen.de>
   '` 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2. See
  the file COPYING for details.

  The Error class is just a convenient base class for all kinds of
  errors which result in a text error message for printing to the
  user.

  'Paranoid()' is only compiled in if DEBUG is defined.
  'Assert()' is always compiled in.

  General rule of thumb: 'Assert' is used to check things possibly
  passed from other modules, 'Paranoid' for consistency checks where
  only the current module changes the state. ('Module' = e.g. source
  file and accompanying header, but may be >1 source file if
  appropriate.)

*/

#ifndef DEBUG_HH
#define DEBUG_HH

#include <string>
namespace std { }
using namespace std;
//______________________________________________________________________

struct Error {
  explicit Error(const string& m) : message(m) { }
  explicit Error(const char* m) : message(m) { }
  string message;
};

/* Thrown to indicate: Don't report anything, but unwind stack and
   return specified value from main() */
struct Cleanup {
  explicit Cleanup(int r) : returnValue(r) { }
  int returnValue;
};
//______________________________________________________________________

// This prints an "Assertion failed" message
namespace Debug {
extern int assertFail(const char* assertion, const char* file,
                       unsigned int line);
extern int assertMessage(const char* assertion, const char* file,
                         unsigned int line);
}
#if DEBUG
#  define Paranoid(_expr) \
   ((void) ((_expr) ? 0 : \
            Debug::assertFail(#_expr, __FILE__, __LINE__)))
#else
#  define Paranoid(expr)
#endif

#define Assert(_expr) \
   ((void) ((_expr) ? 0 : \
            Debug::assertFail(#_expr, __FILE__, __LINE__)))
#define Message(_str) Debug::assertFail((_str), __FILE__, __LINE__)
//______________________________________________________________________

#endif
