/*************************************************************************
 * $Id: modules.inc,v 1.12 2001/04/13 01:16:54 dpotter Exp $
 *
 * modules.inc -- List of available modules
 *
 * Copyright (C) by Andreas Neuhaus <andy@fasta.fh-dortmund.de>
 *
 */

#ifndef __MODULES_INC__
#define __MODULES_INC__

#include "mod.h"


/*************************************************************************
 * MODULE INIT FUNCTION PROTOTYPES
 */
char *mod_mpg123_init (void);
char *mod_playlist_init (void);
char *mod_playlistlist_init (void);
char *mod_beep_init (void);
char *mod_mixer_init (void);
char *mod_env_init (void);
char *mod_timer_init (void);
char *mod_alarm_init (void);
char *mod_lirc_init (void);
char *mod_lcdproc_init (void);
char *mod_netctl_init (void);
char *mod_idle_init (void);
char *mod_autoshutdown_init (void);
char *mod_cd_init (void);
char *mod_save_init (void);
char *mod_debug_init (void);


/*************************************************************************
 * LIST OF MODULE INIT FUNCTIONS
 */
mod_initfunc_t mod_list_init[] = {

#ifdef MOD_MPG123
	mod_mpg123_init,
#endif

#ifdef MOD_PLAYLIST
	mod_playlist_init,
#endif

#ifdef MOD_PLAYLISTLIST
	mod_playlistlist_init,
#endif

#ifdef MOD_BEEP
	mod_beep_init,
#endif

#ifdef MOD_MIXER
	mod_mixer_init,
#endif

#ifdef MOD_ENV
	mod_env_init,
#endif

#ifdef MOD_TIMER
	mod_timer_init,
#endif

#ifdef MOD_ALARM
	mod_alarm_init,
#endif

#ifdef MOD_LIRC
	mod_lirc_init,
#endif

#ifdef MOD_LCDPROC
	mod_lcdproc_init,
#endif

#ifdef MOD_CD
	mod_cd_init,
#endif

#ifdef MOD_NETCTL
	mod_netctl_init,
#endif

#ifdef MOD_IDLE
	mod_idle_init,
#endif

#ifdef MOD_AUTOSHUTDOWN
	mod_autoshutdown_init,
#endif

#ifdef MOD_SAVE
	mod_save_init,
#endif

#ifdef MOD_DEBUG
	mod_debug_init,
#endif

	NULL
};


#endif /* __MODULES_INC__ */

/*************************************************************************
 * EOF
 */
