"""daemonize function from twisted.scripts._twistd_unix."""

#-----------------------------------------------------------------------------
# Copyright (c) Twisted Matrix Laboratories.
# See Twisted's LICENSE for details.
# http://twistedmatrix.com/
#-----------------------------------------------------------------------------

import os, errno

def daemonize():
    # See http://www.erlenstar.demon.co.uk/unix/faq_toc.html#TOC16
    if os.fork():   # launch child and...
        os._exit(0) # kill off parent
    os.setsid()
    if os.fork():   # launch child and...
        os._exit(0) # kill off parent again.
    null = os.open('/dev/null', os.O_RDWR)
    for i in range(3):
        try:
            os.dup2(null, i)
        except OSError, e:
            if e.errno != errno.EBADF:
                raise
    os.close(null)

