/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_GG)


#include "iggcommoneventobservers.h"


#include "icontrolmodule.h"
#include "ierror.h"
#include "imath.h"
#include "ipicker.h"
#include "iviewmodule.h"

#include "iggdialogeventrecorder.h"
#include "iggdialogparallelcontroller.h"
#include "iggdialogpickerwindow.h"
#include "iggdialogrenderingprogress.h"
#include "iggmainwindow.h"
#include "iggshell.h"
#include "iggwidget.h"
#include "iggwidgetprogressbar.h"


//
//  iggProgressEventObserver class
//
iggProgressEventObserver::iggProgressEventObserver(iViewModule *vm) : iProgressEventObserver(vm)
{
	mProgressBar = 0; 
}


void iggProgressEventObserver::ChildStarted()
{
	iggShell *s = iRequiredCast<iggShell>(INFO,this->GetViewModule()->GetControlModule()->GetShell());
	if(mProgressBar==0 && s!=0 && s->GetMainWindow()!=0 && s->GetMainWindow()->GetProgressBar()!=0) 
	{
		mProgressBar = s->GetMainWindow()->GetProgressBar();
	}
	if(mProgressBar != 0)
	{
		mProgressBar->Reset();
		mProgressBar->SetLabel(this->GetLabel());
	}
}


void iggProgressEventObserver::SetProgressBody(float f)
{
	if(mProgressBar != 0) mProgressBar->SetProgress(round(f*100.0));
}


void iggProgressEventObserver::ChildFinished()
{
	if(mProgressBar != 0)
	{
		mProgressBar->Reset();
		mProgressBar = 0;
	}
}


bool iggProgressEventObserver::CheckAbort()
{
	if(mProgressBar != 0) return mProgressBar->IsAborted(); else return false;
}


void iggProgressEventObserver::SetProgressBar(iggWidgetProgressBar *pb)
{
	mProgressBar = pb;
}


//
//  iggAbortRenderEventObserver class
//
bool iggAbortRenderEventObserver::CheckAbort()
{
	iggShell *s = iRequiredCast<iggShell>(INFO,this->GetViewModule()->GetControlModule()->GetShell());
	if(s!=0 && s->GetMainWindow()!=0 && s->GetMainWindow()->GetDialogRenderingProgress()!=0) 
	{
		s->GetMainWindow()->GetDialogRenderingProgress()->KeepWorking(); 
		return s->GetMainWindow()->GetDialogRenderingProgress()->IsCancelled();
	}
	else return false;
}


void iggAbortRenderEventObserver::Started()
{ 
	iggShell *s = iRequiredCast<iggShell>(INFO,this->GetViewModule()->GetControlModule()->GetShell());
	if(s!=0 && s->GetMainWindow()!=0 && s->GetMainWindow()->GetDialogRenderingProgress()!=0) 
	{
		s->GetMainWindow()->GetDialogRenderingProgress()->Start(this->IsInteractive()); 
	}
}


void iggAbortRenderEventObserver::Finished()
{ 
	iggShell *s = iRequiredCast<iggShell>(INFO,this->GetViewModule()->GetControlModule()->GetShell());
	if(s!=0 && s->GetMainWindow()!=0) 
	{
		if(s->GetMainWindow()->GetDialogRenderingProgress() != 0) s->GetMainWindow()->GetDialogRenderingProgress()->Finish();
		if(s->GetMainWindow()->GetDialogPerformanceMeter() != 0) s->GetMainWindow()->GetDialogPerformanceMeter()->UpdateDialog();
	}
}


void iggAbortRenderEventObserver::PostFinished()
{ 
	iggShell *s = iRequiredCast<iggShell>(INFO,this->GetViewModule()->GetControlModule()->GetShell());
	if(s!=0 && s->GetMainWindow()!=0 && s->GetMainWindow()->GetDialogPerformanceMeter()!=0) 
	{
		s->GetMainWindow()->GetDialogPerformanceMeter()->UpdateDialog();
	}
}


//
//  iggPickEventObserver class
//
void iggPickEventObserver::Started()
{
	iggShell *s = iRequiredCast<iggShell>(INFO,this->GetViewModule()->GetControlModule()->GetShell());
	if(s!=0 && s->GetMainWindow()!=0 && s->GetMainWindow()->GetDialogPickerWindow()!=0) 
	{
		s->GetMainWindow()->GetDialogPickerWindow()->CollectData(true);
		s->GetMainWindow()->GetDialogPickerWindow()->Show(true);
	}
}


void iggPickEventObserver::Finished()
{
	iggShell *s = iRequiredCast<iggShell>(INFO,this->GetViewModule()->GetControlModule()->GetShell());
	if(s!=0 && s->GetMainWindow()!=0 && s->GetMainWindow()->GetDialogPickerWindow()!=0) 
	{
		s->GetMainWindow()->GetDialogPickerWindow()->CollectData(false);
		s->GetMainWindow()->GetDialogPickerWindow()->DisplayData(this->GetViewModule()->GetPicker());
	}
}


//
//  iggRecordEventObserver class
//
void iggRecordEventObserver::UpdateInteraction()
{
	iggShell *s = iRequiredCast<iggShell>(INFO,this->GetViewModule()->GetControlModule()->GetShell());
	if(s!=0 && s->GetMainWindow()!=0 && s->GetMainWindow()->GetDialogEventRecorder()!=0) 
	{
		s->GetMainWindow()->GetDialogEventRecorder()->UpdateInteraction();
	}
}


//
//  iggParallelUpdateEventObserver class
//
void iggParallelUpdateEventObserver::UpdateInformation()
{
	iggShell *s = iRequiredCast<iggShell>(INFO,this->GetControlModule()->GetShell());
	if(s!=0 && s->GetMainWindow()!=0 && s->GetMainWindow()->GetDialogParallelController()!=0) 
	{
		s->GetMainWindow()->GetDialogParallelController()->UpdateDisplay();
	}
}


//
//  iggAnimatorEventObserver class
//
iggAnimatorEventObserver::iggAnimatorEventObserver(iViewModule *vm) : iAnimatorEventObserver(vm)
{
	mDependent = 0;
}


void iggAnimatorEventObserver::OnCameraPath(int /*step*/)
{
	if(mDependent != 0) mDependent->UpdateWidget();
}


void iggAnimatorEventObserver::AddDependent(iggWidget *w)
{
	mDependent = w;
}

#endif
