/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iviewfamily.h"


#include "idata.h"
#include "ierror.h"

#include "ifamilytemplate.h"


template<class Object, class ObjectParent>
iViewFamily<Object,ObjectParent>::iViewFamily(ObjectParent *parent) : iFamily<Object,ObjectParent>(parent)
{
	IERROR_ASSERT(this->mParent);
	this->mVis = false;
}


template<class Object, class ObjectParent>
bool iViewFamily<Object,ObjectParent>::DeleteMember(int i)
{
	if(this->iFamily<Object,ObjectParent>::DeleteMember(i)) return true;
	this->Show(false);
	return false;
}


template<class Object, class ObjectParent>
void iViewFamily<Object,ObjectParent>::Show(bool s)
{ 
	int j; 
	this->mVis = s;
	for(j=0; j<this->mMemlist.Size(); j++) this->mMemlist[j]->Show(s); 
}


template<class Object, class ObjectParent>
float iViewFamily<Object,ObjectParent>::GetMemorySize() const
{
	int j;
	float s = 0.0;
	for(j=0; j<this->mMemlist.Size(); j++) s += this->mMemlist[j]->GetMemorySize();
	return s;
}


template<class Object, class ObjectParent>
bool iViewFamily<Object,ObjectParent>::Copy(const iViewFamily<Object,ObjectParent> *p)
{
	Object* tmp;
	//
	//  Reset existing members
	//
	this->Reset();
	//
	// Add missing members
	//
	while(this->mMemlist.Size() < p->mMemlist.Size()) 
	{
		tmp = Object::New(this->mParent);
		if(tmp == 0) return false;
		this->mMemlist.Add(tmp);
	}
	//
	//  Remove extra members
	//
	while(p->mMemlist.Size() < this->mMemlist.Size())
	{
		this->mMemlist.RemoveLast()->Delete();
	}
	//
	//  Copy all members
	//
	int i;
	for(i=0; i<this->mMemlist.Size(); i++) this->mMemlist[i]->CopyState(p->mMemlist[i]);

	this->Show(p->mVis);
	return true;
}


template<class Object, class ObjectParent>
void iViewFamily<Object,ObjectParent>::Reset()
{
	int j;
	for(j=0; j<this->mMemlist.Size(); j++) this->mMemlist[j]->Reset();
	this->Show(false);
}


template<class Object, class ObjectParent>
void iViewFamily<Object,ObjectParent>::ShowClipPlane(bool s)
{
	int j;
	for(j=0; j<this->mMemlist.Size(); j++) this->mMemlist[j]->ShowClipPlane(s);
}


template<class Object, class ObjectParent>
void iViewFamily<Object,ObjectParent>::SyncWithData(const iDataSyncRequest &r)
{
	int j;
	for(j=0; j<this->mMemlist.Size(); j++) this->mMemlist[j]->SyncWithData(r);
}

