/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iextendableobject.h"


#include "idata.h"
#include "iextensionfactory.h"

//
//  Templates
//
#include "iarraytemplate.h"


//
//  Helper class
//
iObjectExtension::iObjectExtension(iExtendableObject *owner, const iString &name) : iObject(name), mName(name)
{
	mOwner = owner; IERROR_ASSERT(owner);
}


void iObjectExtension::ClearCache()
{
	this->iObject::ClearCache();
	mOwner->ClearCache();
}


void iObjectExtension::PackStateBody(iString &) const
{
}


void iObjectExtension::UnPackStateBody(const iString &)
{
	mUnPackedSomething = true;
}


//
//  Main class
//
iExtendableObject::iExtendableObject(const iString &name) : iObject(name)
{
}


iExtendableObject::~iExtendableObject()
{
	while(mExtensions.Size() > 0) mExtensions.RemoveLast()->Delete();
}


iObjectExtension* iExtendableObject::GetExtensionByName(const iString &name) const
{
	int i;
	for(i=0; i<mExtensions.Size(); i++) if(mExtensions[i]->Name() == name) return mExtensions[i];
	return 0;
}


iObjectExtension* iExtendableObject::GetExtensionByClassName(const iString &name) const
{
	int i;
	for(i=0; i<mExtensions.Size(); i++) if(mExtensions[i]->IsA(name.ToCharPointer())) return mExtensions[i];
	return 0;
}


void iExtendableObject::InstallExtension(iObjectExtension *object)
{
	IERROR_ASSERT(object);
	mExtensions.AddUnique(object);
}


void iExtendableObject::PackCompleteState(iString &s) const
{
	int i;
	iString s1;

	this->iObject::PackCompleteState(s);

	for(i=0; i<mExtensions.Size(); i++)
	{
		mExtensions[i]->PackCompleteState(s1);
		s += s1;
	}
}


void iExtendableObject::UnPackCompleteState(const iString &s)
{
	int i;

	this->iObject::UnPackCompleteState(s);

	for(i=0; i<mExtensions.Size(); i++) mExtensions[i]->UnPackCompleteState(s);
}


void iExtendableObject::PackStateBody(iString &s) const
{
	int i;
	iString s1;

	this->ExtendableObjectPackStateBody(s);

	for(i=0; i<mExtensions.Size(); i++)
	{
		mExtensions[i]->PackState(s1);
		s += s1;
	}
}


void iExtendableObject::UnPackStateBody(const iString &s)
{
	int i;

	this->ExtendableObjectUnPackStateBody(s);

	for(i=0; i<mExtensions.Size(); i++) mExtensions[i]->UnPackState(s);
}

