/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "icaptioninteractorstyle.h"


#include "icaption.h"
#include "imarker.h"
#include "imarkerfamily.h"
#include "iviewmodule.h"
#include "iviewobjectfamily.h"

#include <vtkActor2D.h>
#include <vtkCamera.h>
#include <vtkMath.h>
#include <vtkRenderer.h>
#include <vtkRenderWindowInteractor.h>

//
//  Templates (needed for some compilers)
//
#include "iarraytemplate.h"


iCaptionInteractorStyle* iCaptionInteractorStyle::New(iViewModule *vm)
{
	IERROR_ASSERT(vm);
	return new iCaptionInteractorStyle(vm);
}


iCaptionInteractorStyle::iCaptionInteractorStyle(iViewModule *vm) : mViewModule(vm)
{
	mInteractionCaption = 0;
}


iCaptionInteractorStyle::~iCaptionInteractorStyle()
{
}


void iCaptionInteractorStyle::FindPickedActor(int x, int y)
{
	int i;
	int *x1, *x2;

	if(CurrentRenderer == 0) return;
	
	for(i=0; i<=this->GetViewModule()->GetMarkerFamily()->GetMaxMemberIndex(); i++) if(this->GetViewModule()->GetMarkerFamily()->GetMember(i)->GetMarkerCaption()->GetVisibility() == 1)
	{
		x1 = this->GetViewModule()->GetMarkerFamily()->GetMember(i)->GetMarkerCaption()->GetPositionCoordinate()->GetComputedDisplayValue(this->CurrentRenderer);
		x2 = this->GetViewModule()->GetMarkerFamily()->GetMember(i)->GetMarkerCaption()->GetPosition2Coordinate()->GetComputedDisplayValue(this->CurrentRenderer);
		if(x>x1[0] && y>x1[1] && x<x2[0] && y<x2[1])
		{
			mInteractionCaption = this->GetViewModule()->GetMarkerFamily()->GetMember(i)->GetMarkerCaption();
			return;
		}
	}
	mInteractionCaption = 0;
}

//
//  Rotating - a copy of vtkInteractorStyleTrackballActor::Rotate() with 
//  no changes
//
void iCaptionInteractorStyle::Rotate()
{
	if(CurrentRenderer==0 || mInteractionCaption==0)
    {
		return;
    }
	
	vtkRenderWindowInteractor *rwi = this->Interactor;
	
	int *size = CurrentRenderer->GetSize();
	float dx = rwi->GetEventPosition()[0] - rwi->GetLastEventPosition()[0];
	float dy = rwi->GetEventPosition()[1] - rwi->GetLastEventPosition()[1];
	
	double *x = mInteractionCaption->GetPosition();
	mInteractionCaption->SetPosition(x[0]+dx/size[0],x[1]+dy/size[1]);
	
    rwi->Render();
}

//
// Need to overload this function too because it is not declared virtual in the parent class 
//
void iCaptionInteractorStyle::OnLeftButtonDown() 
{
	int x = Interactor->GetEventPosition()[0];
	int y = Interactor->GetEventPosition()[1];
	
	this->FindPokedRenderer(x, y);
	this->FindPickedActor(x, y);
	if(CurrentRenderer==0 || mInteractionCaption==0)
    {
		return;
    }
	
    this->StartRotate();
}


void iCaptionInteractorStyle::OnLeftButtonUp()
{
	vtkInteractorStyleTrackballActor::OnLeftButtonUp();
	//
	//  Quantize the position
	//
	double *x0, x[2];
	if(mInteractionCaption != 0)
	{
		int *size = CurrentRenderer->GetSize();
		x0 = mInteractionCaption->GetPosition();
		x[0] = 10.0*floor(0.1*x0[0]*size[0])/size[0];
		x[1] = 10.0*floor(0.1*x0[1]*size[1])/size[1];
		mInteractionCaption->SetPosition(x[0],x[1]);

		Interactor->Render();
	}
}

