/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iextensionbuilder.h"


#ifdef I_BUILD_EXTENSIONS_EXPLICITLY


#include "iconfigure.h"

//
//  ---------------  Core extensions ---------------------
//

//
//  HART extension
//
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
#include "hextension.h"
#endif
//
//  VTK extension
//
#if IEXTENSION_INCLUDED(IEXTENSION_VTK)
#include "vtkextension.h"
#endif
//
//  GADGET extension
//
#if IEXTENSION_INCLUDED(IEXTENSION_GADGET)
#include "gextension.h"
#endif
//
//  *************************************************************************
//  
//    DESCRIPTION:
//    Add the include to your core extension header here. The include 
//    needs to be wrapped around in #if/#endif clause.
//  
//  *************************************************************************
//


#if ISHELL_INCLUDED(ISHELL_GG) // ---------------  Generic GUI extensions ---------------------

//
//  HART extension
//
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
#include "hggextension.h"
#endif
//
//  VTK extension
//
#if IEXTENSION_INCLUDED(IEXTENSION_VTK)
#include "vtkggextension.h"
#endif
//
//  GADGET extension
//
#if IEXTENSION_INCLUDED(IEXTENSION_GADGET)
#include "gggextension.h"
#endif
//
//  *************************************************************************
//  
//    DESCRIPTION:
//    Add the include to your GUI shell extension header here. The include 
//    needs to be wrapped around in #if/#endif clause.
//  
//  *************************************************************************
//

#endif // ---------------  Generic GUI extensions ---------------------


void iExtensionBuilder::Build()
{
	//
	//  HART extension
	//
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
	hExtension::Build();
#if ISHELL_INCLUDED(ISHELL_GG)
	hggExtension::Build();
#endif
#endif
	//
	//  VTK extension
	//
#if IEXTENSION_INCLUDED(IEXTENSION_VTK)
	vtkExtension::Build();
#if ISHELL_INCLUDED(ISHELL_GG)
	vtkggExtension::Build();
#endif
#endif
	//
	//  GADGET extension
	//
#if IEXTENSION_INCLUDED(IEXTENSION_GADGET)
	gExtension::Build();
#if ISHELL_INCLUDED(ISHELL_GG)
	gggExtension::Build();
#endif
#endif
	//
	//  *************************************************************************
	//  
	//    DESCRIPTION:
	//    Add calls to Build function for your extension here. The calls 
	//    need to be wrapped around in #if/#endif clause.
	//  
	//  *************************************************************************
	//
}

#else

void iExtensionBuilder::Build()
{
}

#endif

