/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iqtextensionwindowsubject.h"


#include "ierror.h"
#include "iimagefactory.h"
#include "istring.h"

#include "iggabstractextension.h"
#include "iggextensionwindow.h"

#include "ibgframesubject.h"

#include "iqtassistant.h"
#include "iqtwindowhelper.h"

#ifdef IQT_3
#include <qevent.h>
#include <qlayout.h>
#include <qtabwidget.h>
#else
#include <QtGui/QGridLayout>
#include <QtGui/QMouseEvent>
#include <QtGui/QTabWidget>
#endif

//
//  Main class
//
iqtExtensionWindowSubject::iqtExtensionWindowSubject(iggExtensionWindow *ew, bool single) : 
#ifdef IQT_3
	QWidget(0,0,iqtAssistant::GetFlags(iqtAssistant::_Extension)), 
#else
	QWidget(0,iqtAssistant::GetFlags(iqtAssistant::_Extension)), 
#endif
	ibgExtensionWindowSubject(ew,single)
{
	mWindowHelper = new iqtWindowHelper(this,iImageFactory::FindIcon("genie1ext.png"),"IFrIT - Extension Window"); IERROR_ASSERT(mWindowHelper);

	if(single)
	{
		mBase = 0;
		mLayout = iqtAssistant::NewLayout(this,1);
		mLayout->setMargin(ibgFrameSubject::GetPaddingWidth()*2);
	}
	else
	{
		mBase = new QTabWidget(this);
		mLayout = iqtAssistant::NewLayout(this,1);
		mLayout->setMargin(0);
		mLayout->addWidget(mBase,0,0);
#ifdef IQT_3
		mBase->setTabPosition(QTabWidget::Bottom);
#else
		mBase->setTabPosition(QTabWidget::South);
#endif
	}
}


iqtExtensionWindowSubject::~iqtExtensionWindowSubject()
{
}


void iqtExtensionWindowSubject::AddExtension(iggAbstractExtension *ext)
{
	if(ext != 0)
	{
		QWidget *w = iqtAssistant::Convert(ext); IERROR_ASSERT(w);
#ifndef IQT_3
		iqtAssistant::SetParent(w,0);
#endif
		if(mBase == 0)
		{
#ifdef IQT_3
			iqtAssistant::SetParent(w,this);
#endif
			mLayout->addWidget(w,0,0);
		}
		else
		{
			QWidget *b = new QWidget;
			QGridLayout *l = iqtAssistant::NewLayout(b,1);
			l->setMargin(ibgFrameSubject::GetPaddingWidth()*2);
#ifdef IQT_3
			iqtAssistant::SetParent(b,mBase);
			iqtAssistant::SetParent(w,b);
#endif
			l->addWidget(w,0,0);
			mBase->addTab(b,iqtAssistant::ConvertToIcon(*ext->GetIcon()),iqtAssistant::Convert(ext->GetTitle()));
		}
		mLayout->invalidate();
	}
}


void iqtExtensionWindowSubject::SetPadding(bool s)
{
	if(mBase == 0)
	{
		if(s)
		{
			mLayout->setMargin(ibgFrameSubject::GetPaddingWidth()*2);
		}
		else
		{
			mLayout->setMargin(0);
		}
	}
}


//
//  Qt-specific
//
bool iqtExtensionWindowSubject::event(QEvent *e)
{
	if(e!=0 && e->spontaneous() && this->IsBlocked()) 
	{
		return false;
	}
	else
	{
		return QWidget::event(e);
	}
}


void iqtExtensionWindowSubject::closeEvent(QCloseEvent *e)
{
	e->ignore();
}
