/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iggwidgetmisc.h"


#include "iimagefactory.h"
#include "imath.h"

#include "iggframe.h"

#include "ibgwidgetareasubject.h"
#include "ibgwidgetbuttonsubject.h"
#include "ibgwidgetentrysubject.h"
#include "ibgwidgetselectionboxsubject.h"

#include "iggsubjectfactory.h"
#include "iggparameter.h"
using namespace iggParameter;


//
//  iggWidgetImageFlipper class
//
iggWidgetImageFlipper::iggWidgetImageFlipper(iggFrame *parent) : iggWidget(parent)
{
	mSubject = iggSubjectFactory::CreateWidgetMultiImageDisplayAreaSubject(this);
}


void iggWidgetImageFlipper::Advance()
{
	mSubject->Advance();
}


void iggWidgetImageFlipper::Reset()
{
	mSubject->ShowImage(0);
}


void iggWidgetImageFlipper::Start()
{
	mSubject->Start();
}


void iggWidgetImageFlipper::Abort()
{
	mSubject->Abort();
}


void iggWidgetImageFlipper::OnVoid1Body()
{
	mSubject->Advance();
}


void iggWidgetImageFlipper::UpdateWidgetBody()
{
}


//
//  iggWidgetLogoFlipper class
//
iggWidgetLogoFlipper::iggWidgetLogoFlipper(iggFrame *parent) : iggWidgetImageFlipper(parent)
{
	mSubject->AddImage(*iImageFactory::FindIcon("genie1_frame_000.png"),false);
	mSubject->AddImage(*iImageFactory::FindIcon("genie1_frame_001.png"),false);
	mSubject->AddImage(*iImageFactory::FindIcon("genie1_frame_002.png"),false);
	mSubject->AddImage(*iImageFactory::FindIcon("genie1_frame_003.png"),false);
	mSubject->AddImage(*iImageFactory::FindIcon("genie1_frame_004.png"),false);
	mSubject->AddImage(*iImageFactory::FindIcon("genie1_frame_005.png"),false);
	mSubject->AddImage(*iImageFactory::FindIcon("genie1_frame_006.png"),false);
	mSubject->AddImage(*iImageFactory::FindIcon("genie1_frame_007.png"),false);
	mSubject->AddImage(*iImageFactory::FindIcon("genie1_frame_008.png"),false);
	mSubject->AddImage(*iImageFactory::FindIcon("genie1_frame_009.png"),false);
	mSubject->AddImage(*iImageFactory::FindIcon("genie1_frame_010.png"),false);
	mSubject->AddImage(*iImageFactory::FindIcon("genie1_frame_011.png"),false);
	mSubject->AddImage(*iImageFactory::FindIcon("genie1_frame_012.png"),false);
	mSubject->AddImage(*iImageFactory::FindIcon("genie1_frame_013.png"),false);
	mSubject->AddImage(*iImageFactory::FindIcon("genie1_frame_014.png"),false);

	mNeedsBaloonHelp = false;
}


//
//  iggWidgetNumberDisplay class
//
iggWidgetNumberDisplay::iggWidgetNumberDisplay(const iString &title, iggFrame *parent) : iggWidget(parent)
{
	mSubject = iggSubjectFactory::CreateWidgetEntrySubject(this,false,6,title,0);
	mSubject->SetEditable(false);

	mNeedsBaloonHelp = false;

	this->Display(0);
}


void iggWidgetNumberDisplay::Display(double v, int prec)
{
	if(v != mSubject->GetValue())
	{
		if(prec>=0 && prec<20)
		{
			double f = pow10((float)prec);
			v = round(f*v)/f;
		}
		mSubject->SetValue(0,v);
	}
}


void iggWidgetNumberDisplay::UpdateWidgetBody()
{
}


//
//  iggWidgetTextDisplay class
//
iggWidgetTextDisplay::iggWidgetTextDisplay(const iString &title, iggFrame *parent) : iggWidget(parent)
{
	mSubject = iggSubjectFactory::CreateWidgetEntrySubject(this,false,0,title,0);
	mSubject->SetEditable(false);

	mNeedsBaloonHelp = false;

	this->Display("");
}


void iggWidgetTextDisplay::Display(const iString &text)
{
	if(text != mSubject->GetText()) mSubject->SetText(text);
}


void iggWidgetTextDisplay::UpdateWidgetBody()
{
}


//
//  iggWidgetSimpleRadioBox class
//
iggWidgetSimpleRadioBox::iggWidgetSimpleRadioBox(int cols, const iString &text, iggFrame *parent) : iggWidget(parent)
{
	mSubject = iggSubjectFactory::CreateWidgetRadioBoxSubject(this,cols,text);
}


void iggWidgetSimpleRadioBox::UpdateWidgetBody()
{
}


int iggWidgetSimpleRadioBox::GetValue() const
{
	return mSubject->GetValue();
}


void iggWidgetSimpleRadioBox::SetValue(int v)
{
	mSubject->SetValue(v);
}


void iggWidgetSimpleRadioBox::InsertItem(const iString &text, int index)
{
	mSubject->InsertItem(text,index);
	mSubject->SetValue(index>=0?index:0);
}


//
//  iggWidgetSimpleSpinBox class
//
iggWidgetSimpleSpinBox::iggWidgetSimpleSpinBox(int min, int max, int step, const iString &text, iggFrame *parent) : iggWidget(parent)
{
	mSubject = iggSubjectFactory::CreateWidgetSpinBoxSubject(this,min,max,text,step);
}


void iggWidgetSimpleSpinBox::UpdateWidgetBody()
{
}


void iggWidgetSimpleSpinBox::SetValue(int v)
{
	mSubject->SetValue(v);
}


int iggWidgetSimpleSpinBox::GetValue() const
{
	return mSubject->GetValue();
}


//
//  iggWidgetSimpleCheckBox class
//
iggWidgetSimpleCheckBox::iggWidgetSimpleCheckBox(const iString &title, iggFrame *parent) : iggWidget(parent)
{
	mSubject = iggSubjectFactory::CreateWidgetButtonSubject(this,_ButtonTypeCheckBox,title,1);
}


bool iggWidgetSimpleCheckBox::IsDown() const
{
	return mSubject->IsDown();
}


void iggWidgetSimpleCheckBox::UpdateWidgetBody()
{
}


void iggWidgetSimpleCheckBox::OnVoid1Body()
{
	this->OnChecked(mSubject->IsDown());
}

