/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iggconsole.h"


#include "ierror.h"

#include "iggmainwindow.h"
#include "iggshell.h"

#include "iggparameter.h"
using namespace iggParameter;


iggConsole::iggConsole(iShell *s) : iConsole(s)
{
	mErrorDestination = _Log;
}


//
//  Inheritable members
//
void iggConsole::OutputText(const iString &message) const
{
	iggShell *s = iPointerCast<iggShell,iShell>(this->GetShell());
	if(s!=0 && s->GetMainWindow()!=0)
	{
		if(s->GetMainWindow() != 0) s->GetMainWindow()->WriteToLog("",message);
	}
	else iConsole::OutputText(message);
}


void iggConsole::OutputError(const iString &message, const iString &file, int line) const
{
	iggShell *s = iPointerCast<iggShell,iShell>(this->GetShell());
	if(s!=0 && s->GetMainWindow()!=0)
	{
		switch(mErrorDestination) 
		{
		case _Log:	
			{ 
				s->GetMainWindow()->WriteToLog("Error",message,iColor(255,0,0)); 
				break; 
			}
		case _Window: 
			{
				s->GetMainWindow()->PopupWindow(message,_PopupWindowWarning);
				break; 
			}
		default:
			{
			}
		}
	}
	else iConsole::OutputError(message,file,line);
}


void iggConsole::OutputFatalError(const iString &message, const iString &file, int line) const
{
	iggShell *s = iPointerCast<iggShell,iShell>(this->GetShell());
	if(s!=0 && s->GetMainWindow()!=0)
	{
		s->GetMainWindow()->PopupWindow(iString(message)+"\n FILE: "+file+"\n LINE: "+iString::FromNumber(line),_PopupWindowError);
	}
	else iConsole::OutputFatalError(message,file,line);
}


void iggConsole::OutputCriticalInformation(const iString &message) const
{
	iggShell *s = iPointerCast<iggShell,iShell>(this->GetShell());
	if(s!=0 && s->GetMainWindow()!=0)
	{
		s->GetMainWindow()->PopupWindow(message,_PopupWindowMessage);
	}
	else iConsole::OutputCriticalInformation(message);
}

