/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IPARAMETER_H
#define IPARAMETER_H


namespace iParameter
{
	//
	// ColorBars parameters
	//
	const int _ColorBarsPrioritySurfaceExterior =	0; 
	const int _ColorBarsPriorityVolume =			1;
	const int _ColorBarsPriorityCrossSection =		2;
	const int _ColorBarsPrioritySurfaceInterior =	3;
	const int _ColorBarsPriorityField =				4;

	//
	// CommandInterpreter parameters
	//
	const int _CommandInterpreterTextTypeCode = 0;
	const int _CommandInterpreterTextTypeResult = 1;
	const int _CommandInterpreterTextTypeError = 2;

	//
	// ControlModule parameters
	//
	const int _CacheSize = 2;

	const int _ModuleTypeNew	= 0;
	const int _ModuleTypeCopy	= 1;
	const int _ModuleTypeClone	= 2;
	
	const int _ObjectTypeUndefined			= -1;
	const int _ObjectTypeControlModule		= -2;
	const int _ObjectTypeViewModule			= -3;
	const int _ObjectTypeAnimator			= -4;
	const int _ObjectTypeCamera				= -5;
	const int _ObjectTypeColorBars			= -6;
	const int _ObjectTypeDataReader			= -7;
	const int _ObjectTypeDataSubject		= -8;
	const int _ObjectTypeImageComposer		= -9;
	const int _ObjectTypeMarker				= -10;
	const int _ObjectTypeParticleGroup		= -11;
	const int _ObjectTypePicker				= -12;

	const int _ObjectTypeCrossSection		= 0;
	const int _ObjectTypeParticles			= 1;
	const int _ObjectTypeSurface			= 2;
	const int _ObjectTypeTensorField		= 3;
	const int _ObjectTypeVectorField		= 4;
	const int _ObjectTypeVolume				= 5;
	
	const int _ObjectModeMask		= 0x00F;
	const int _ObjectModeInvalid	= 0x0;
	const int _ObjectModeCurrent	= 0x1;
	const int _ObjectModeAll		= 0x2;
	
	const int _ModuleModeMask		= 0x0F0;
	const int _ModuleModeInvalid	= 0x00;
	const int _ModuleModeCurrent	= 0x10;
	const int _ModuleModeAll		= 0x20;
	const int _ModuleModeClones		= 0x30;
	
	const int _RenderModeMask		= 0xF00;
	const int _RenderModeInvalid	= 0x000;
	const int _RenderModeCurrent	= 0x100;
	const int _RenderModeAll		= 0x200;
	const int _RenderModeClones		= 0x300;
	const int _RenderModeAuto		= 0xF00;

	const int _EnvironmentBase				= 0;
	const int _EnvironmentData				= 1;
	const int _EnvironmentImage				= 2;
	const int _EnvironmentScript			= 3;
	const int _EnvironmentPalette			= 4;
	const int _EnvironmentScalarFieldData	= 5;
	const int _EnvironmentParticleSetData	= 6;
	const int _EnvironmentVectorFieldData	= 7;
	const int _EnvironmentTensorFieldData	= 8;

	//
	// DataConsumer parameters
	//
	const int _DataConsumerResetToGlobal = -1;
	const int _DataConsumerOptimizeForSpeed = 0;
	const int _DataConsumerOptimizeForMemory = 1;
	const int _DataConsumerOptimizeForQuality = 2;
	const int __NumDataConsumerOptimizationModes = 3;

	//
    // DataLimit parameters
	//
	const int _BoundaryConditionsPeriodic = 0;
	const int _BoundaryConditionsWall = 1;
	const int __NumBoundaryConditions = 2;

	const int _StretchLin = 0;
	const int _StretchLog = 1;

	//
	// Picker parameters
	//
	const int _PickMethodCell =			0;
	const int _PickMethodPoint =		1;
	const int _PickMethodObject =		2;

	//
	// PointGlyph parameters
	//
	const int _PointTypePoint =			0;
	const int _PointTypeSphere =		1;
	const int _PointTypeTetrahydron =	2;
	const int _PointTypeCube =			3;
	const int _PointTypeOctahedron =	4;
	const int _PointTypeIcosahedron =	5;
	const int _PointTypeDodecahedron =	6;
	const int _PointTypeCone =			7;
	const int _PointTypeCylinder =		8;
	const int _PointTypeArrow =			9;
	const int _PointTypeCluster =		10;
	const int _PointTypeGalaxy =		11;
	const int __NumPointTypes =			12;

	//
	// StreamLine parameters
	//
	const int _StreamLineDirUpStream = 0;
	const int _StreamLineDirDownStream = 1;
	const int _StreamLineDirForward = 2;
	const int _StreamLineDirBackward = 3;
	const int _StreamLineDirBothWays = 4;
	const int __NumStreamLineDirs = 5;

	//
	// SurfaceViewSubject parameters
	//
	const int _SurfaceMethodIsoSurface = 0;
	const int _SurfaceMethodSphere = 1;
	const int _SurfaceMethodPlane = 2;
	const int __NumSurfaceMethods = 2;

	//
	// Text parameters
	//
	const int _TextJustBottom = 0;
	const int _TextJustLeft = 0;
	const int _TextJustCenter = 1;
	const int _TextJustTop = 2;
	const int _TextJustRight = 2;
	const int __NumTextJusts = 3;
	
	const int _TextTypeBitmap = 0;
	const int _TextTypeVector = 1;
	const int __NumTextTypes = 2;

	//
	// VectorFieldViewSubject parameters
	//
	const int _VectorSourceDisk = 0;
	const int _VectorSourcePlane = 1;
	const int _VectorSourceSphere = 2;
	const int _VectorSourceMarker = 3;
	const int __NumVectorSources = 4;

	const int _VectorMethodGlyph = 0;
	const int _VectorMethodStreamLine = 1;
	const int _VectorMethodStreamTube = 2;
	const int _VectorMethodStreamBand = 3;
	const int __NumVectorMethods = 4;

	const int _VectorColorByMagnitude = -4;
	const int _VectorColorByVorticity = -3;
	const int _VectorColorByDivergence = -2;
	const int _VectorColorByNone = -1;

	//
	//  ViewModule parameters
	//
	const int _ImageFormatPNG =  0;
	const int _ImageFormatJPG =  1;
	const int _ImageFormatPNM =  2;
	const int _ImageFormatBMP =  3;
	const int _ImageFormatTIF =  4;
	const int _ImageFormatEPS =  5;
	const int __NumImageFormats = 6;
	
	const int _AnimationOutputImage =  0;
	const int _AnimationOutputMPEG2 =  1;
	const int _AnimationOutputAVI   =  2;
	const int __NumAnimationOutputs = 3;
	
	const int _ImageTypeSnapshot =       0;
	const int _ImageTypeAnimationFrame = 1;
	const int __NumImageTypes =           2;
	
	const int _InteractorStyleTrackball = 0;
	const int _InteractorStyleJoystick =  1;
	const int _InteractorStyleFlight =    2;
	const int _InteractorStyleKeyboard =  3;
	const int __NumInteractorStyles =      4;
	
	const int _BoundingBoxTypeDefault =  0;
	const int _BoundingBoxTypeClassic =  1;
	const int _BoundingBoxTypeHairThin = 2;
	const int _BoundingBoxTypeAxes =     3;
	const int __NumBoundingBoxTypes =     4;
	
	//
	//  ViewSubject parameters
	//
	const unsigned int _ViewSubjectAlwaysShaded =	1U;
	const unsigned int _ViewSubjectNoReplicating =	2U;
	const unsigned int _ViewSubjectNoColor =			4U;
	const unsigned int _ViewSubjectNoOpacity =		8U;
	const unsigned int _ViewSubjectNoPalette =		16U;

	//
	// VolumeViewSubject parameter;
	//
	const int _VolumeMethodRayCast = 0;
	const int _VolumeMethod2DTexture = 1;
	const int _VolumeMethod3DTexture = 2;
	const int _VolumeMethodVolumePro = 3;
	const int __NumVolumeMethods = 4;
};

#endif // IPARAMETER_H

