/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IMARKER_H
#define IMARKER_H


#include "isolidviewsubject.h"


class iCaption;
class iPointGlyph;


class iMarker : public iSolidViewSubject 
{
	
	friend class iControlModule;

public:
	
	IOBJECT_DECLARE_SELF(iMarker,iSolidViewSubject);

	static iMarker* New(iViewModule *vm);
	virtual ~iMarker();
	static const iObjectType& Type();
		
	IOBJECT_DECLARE_GETSET2(Type,int);
	//virtual void SetType(int m);
	//int GetType() const;
	
	IOBJECT_DECLARE_GETSET1(CaptionText,const iString&);
	//virtual void SetCaptionText(const iString &s);
	//inline iString GetCaptionText() const { return mCaptionText; }
		
	IOBJECT_DECLARE_GETSET1(InteractiveMove,bool);
	//virtual void SetInteractiveMove(bool s);
	//inline bool GetInteractiveMoveShow() const { return mInteractiveMove; }

	IOBJECT_DECLARE_GETSET2(Scaled,bool);
	//virtual void SetScaled(bool s);
	//bool GetScaled() const;

	IOBJECT_DECLARE_GETSET(CaptionPosition,mCapPos,const float*);
	//virtual void SetCaptionPosition(const float *x);
	//inline const float* GetCaptionPosition() const { return mCapPos; }

	IOBJECT_DECLARE_GET(ColorAutomatic,mColorAuto,bool);
	//inline bool isColorAutomatic() const { return mColorAuto; }

	virtual void SetTextColor(iColor c, bool withAuto = true);
	IOBJECT_DECLARE_GET(TextColor,mTextColor,iColor);
	//inline iColor GetTextColor() const { return mTextColor; }
	
	IOBJECT_DECLARE_GETSET1(Transform,const float*);
	//virtual void SetTransform(const float *x);
	//inline const float* GetTransform() const { return mTransform; }

	IOBJECT_DECLARE_GETSET_DISTANCE(Size,mSize);
	//virtual void SetSize(const iDistance &s);
	//inline const iDistance& GetSize() const { return mSize; }
	virtual void SetSize(double s);

	IOBJECT_DECLARE_GETSET_POSITION(Position,mPosition); 
	//virtual void SetPosition(const iPosition &p);
	//inline const iPosition& GetPosition() const { return mPosition; }

	const iString GetTypeAsString() const;
	static const iObjectKey& KeyTypeAsString();

	virtual void SetFontScale(int s);

	void AttachViewSubject(iViewSubject *);
	void DetachViewSubject(iViewSubject *);

	inline iPointGlyph* GetMarkerObject() const { return mObject; }
	inline iCaption* GetMarkerCaption() const { return mCaption; }

	void Move(const iPosition& p);
	void FinishMoving();

	virtual bool IsDataPresent() const { return true; }
	//
	//  Inherited members
	//
	ISOLIDVIEWSUBJECT_DECLARE_INHERITED_KEYS;
	ISOLIDVIEWSUBJECT_DECLARE_INHERITED_MEMBERS;

protected:
	
	iMarker(iViewModule *vm);
	virtual void ConfigureBody(){}

	virtual void FinishInitialization();

	//
	//  VTK stuff
	//
	iPointGlyph *mObject;
	iCaption *mCaption;

	iDistance mSize;
	float mCapPos[2], mTransform[6];
	iColor mTextColor;
	iString mCaptionText;
	bool mColorAuto, mInteractiveMove;

	iSearchableArray<iViewSubject*> mAttachedObjects;
};

#endif // IMARKER_H

