/* vim:tabstop=4:expandtab:shiftwidth=4
 * 
 * Idesk -- Database.cpp
 *
 * Copyright (c) 2002, Chris (nikon) (nikon@sc.rr.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *      Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *      
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *      
 *      Neither the name of the <ORGANIZATION> nor the names of its
 *      contributors may be used to endorse or promote products derived from
 *      this software without specific prior written permission.
 *
 * (See the included file COPYING / BSD )
 */

#include "Database.h"


Database::Database( const string & F ) {
    ifstream *DbFile = new ifstream( F.c_str() );
    string Buffer, Line, temp;
    Table *T;

    File = F;

    while( *DbFile ) {
        *DbFile >> Buffer;
        if( Buffer == "table" ) {

            getline( *DbFile, Line );
            Line = Line.substr( 1, Line.size()-1 );
            T = AddTable( Line );

            while( *DbFile ) {
                *DbFile >> Buffer;
                
                //end of table
                if( Buffer == "end" ) break;
                //array value
                else if (Buffer[Buffer.size()-1] == ':' &&
                         Buffer.size() >= 2 &&  //don't overstep array
                         Buffer[Buffer.size()-2] == ']')
                {
                    //grab the index contained in '[' and ']'
                    int lBIndex = Buffer.find('[', 0);
                    temp = Buffer.substr(lBIndex + 1,
                                         Buffer.size() - lBIndex - 3);
                    int index = atoi(temp.c_str());

                    //grab label as everything before the '['
                    Buffer = Buffer.substr(0, lBIndex);

                    getline( *DbFile, Line );
                    Line = Line.substr( 1, Line.size()-1 );

                    T->SetArray( Buffer, Line, index );
                }
                //regular value
                else if( Buffer[Buffer.size()-1] == ':' ) {
                    Buffer = Buffer.substr( 0, Buffer.size()-1 );
                    getline( *DbFile, Line );
                    Line = Line.substr( 1, Line.size()-1 );
                    T->Set( Buffer, Line );
                }
            }

        }
    }

}


Table* Database::AddTable( const string & Title ) {

    Table *T = new Table( Title );
    Tables.push_back( T );
    return T;
}


Table* Database::Query( const string & Title ) {
    for(unsigned int i=0; i<Tables.size(); i++ )
        if( Tables[i]->Title == Title ) return Tables[i];

    return NULL;
}


void Database::Write( ) {
    ofstream *DbFile = new ofstream( File.c_str() );

    for(unsigned int i=0; i<Tables.size(); i++ ) {
        (*DbFile) << "table " << Tables[i]->Title << endl;
        for(unsigned int a=0; a<Tables[i]->Label.size(); a++ ) {
            (*DbFile) << "  " << Tables[i]->Label[a] << ": " << Tables[i]->Value[a] << endl;
        }
        for (unsigned int b=0; b<Tables[i]->arrayLabels.size(); b++) 
            for (unsigned int c=0; c<Tables[i]->arrayValues[b].size(); c++) 
                (*DbFile) << "  " << Tables[i]->arrayLabels[b] << "["
                          << c << "]: " << Tables[i]->arrayValues[b][c] << endl;
        (*DbFile) << "end\n\n";
    }

    DbFile->close( );
}



Table::Table( const string & T ) { 
    Title = T;
} 


void Table::Set( const string & L, const string & V ) {
    if( Query(L) == "" ) {
        Label.push_back( L );
        Value.push_back( V );
    } else {
        for(unsigned int i=0; i<Label.size(); i++ )
            if( Label[i] == L ) Value[i] = V;
    }         
}             


string Table::Query( const string & L ) {
    for(unsigned int i=0; i<Label.size(); i++ )
        if( Label[i] == L ) return Value[i];

    return "";
}

void Table::SetArray( const string & L, const string & V, int index ) {
    //first time entered into table
    if( !ArrayExists(L) ) {
        int arrIndex = arrayLabels.size();  //this is the index of the next
        arrayLabels.push_back( L );         //element pushed onto the vector

        vector<string> tmpVec;
        arrayValues.push_back( tmpVec );    //push back an empty string vector
        
        //index doesn't fit into the size of the array
        if (index >= arrayValues[arrIndex].size())
            arrayValues[arrIndex].resize(index + 1, "");

        arrayValues[arrIndex][index] = V;
        
    } else {
        for(unsigned int i=0; i<arrayLabels.size(); i++ )
            if( arrayLabels[i] == L )
            {
                //index doesn't fit into the size of the array
                if (index >= arrayValues[i].size())
                    arrayValues[i].resize(index + 1, "");

                arrayValues[i][index] = V;
            }
    }         
}             


bool Table::ArrayExists( const string & L) {
    for(unsigned int i=0; i<arrayLabels.size(); i++ )
        if( arrayLabels[i] == L ) return true;

    return false;            
}

string Table::QueryArray( const string & L , int index) {
    for(unsigned int i=0; i<arrayLabels.size(); i++ )
        if( arrayLabels[i] == L ) return arrayValues[i][index];

    return "";            
}

vector<string> Table::QueryArray( const string & L) {
    for(unsigned int i=0; i<arrayLabels.size(); i++ )
        if( arrayLabels[i] == L ) return arrayValues[i];

    return vector<string>();            
}
