#NEXUS

BEGIN TAXA;
	DIMENSIONS NTAX = 20;
	TAXLABELS
		't8' 't9' 't6' 't7' 't4' 't5' 't2' 't3' 't1' 't14' 't15' 't16' 't17' 't10' 't11' 't12' 't13' 't20' 't18' 't19' ;
END;

BEGIN CHARACTERS;
	DIMENSIONS NCHAR = 190;
	FORMAT
		DATATYPE = PROTEIN
		GAP=-
		MISSING=?
	;

MATRIX
	't8"  NYNFTKRKDGAYGAVTQAEMTVYVGEAGFTIGDYINHCALSTIPSIRKVVENYFSDCAISTTGLKIRGAKEHTSNVTLHGTIPGQRGVAFIEAYPDTNDRMFIQFNRVPYVFVYAICYPTDVIAIEANRGRIIGCWTEDTGVNEGLNDKKEWTQKRTKCTIWSVDTRNEGVAIKYDTQWATAKPILLMMK
	't9"  NYEMTGVRDGEYGEATVNAMTVYVGAYFFEIQGGQNKCALSQLFFIRKVVTNYFAACEIQTIGLFIKGKTDKTTNVTLLRAISRHKGKMLLAVYPDENDATFIQFDRVKYIFHTAVIVPEDVVATRASAHSLILCGTENTGYNGGLNHKKQTNRRITKCLLWGVDAQTPNVAIKHDHQWTSQKNIPLVLK
	't6"  KYKIAINTVGVYGLKTMKGQCVSVGLLKFLIDNPQKLCQLETPRQISVVDETYFSDCKIQETGRPIPGSSEDTSQVTLKGTIVKQDGLVLTPTYPTLNDVEFIQYNKVRSVFLHAIVCPEDLRAFDLNTEQAIGCEKEDTGLNLGLGVKKEYDSMNTKCEAYNVNQRSEKGAVAHTTLWKVWKVIPIVMK
	't7"  DYNLTYVYDGEYGEATLDEMTVYVGSGTFLIEDVQNKCALSTLPHIRKVADNYFTDCAIQTSGLYIKGPREDTANVTLHGTIPGQQGVIFIESYPGVNDSAPIQFNRIPYLFVYAITAPTDLLAIQANFAAHIVCETEDTGMNVGLNDKKEQAQRRTKCLVWGVDTRNMGVAVKHETSWATKKSIPLIMK
	't4"  DYNLTYSYDGEYGEATLDEMTVYVGSGSFLISDVQNACALSTLAHIRKVVENYFSDCAIQTSGLYIRGPREDTANVTVHGTISGQQGVIFIESYPDVNDSVFIQFNRVPYVFVYAITLPTDILAIQANFAAHIVCWTEDTGMNVGLNDKKEWAQRRTKCQVWDVDTRNMGVAVKHDTTWATKKPIPLLMK
	't5"  KYNLTVTWDGEYSDTTQKEMIIYVGGAAFFITDSQNACALATLPPIRKVAERYFSDCAIQTSGAYIGASREDTSHVTLHGTIAGVSGVMFIDTYPDTNDSPFIQFHRVSYVFIYAIPIPDDALAIEVNLAAIITCWTEDTGANGGLNVKKEGPQRKTKCFMWEVEKRHHESALKHLRTWAQRKRIPLSKK
	't2"  NYQFLEMCDGEYGSVTKRVMTVYVGDIFFQITGEQNTCALSTLLVIRKVIEQYFSACAIQTLGLYIRGPREDTANVTLHRTIRGNRGIMFVEDYPDADDRNFIQFNRVMYIFAYAVSQPTDVLAVQANLHELIICWKKNTGFNVGLNDKKQYIEKRTKCKSWEVDTQNAGVAIKHDTQWTSEKPIPLALK
	't3"  NYDITRIWDGVYGETTQAEMIVYVGLTYFLITDQQNACALSTIPRIYKVPKRYFSDCKIQTDGAYIGALREETGHVTLHGTISGVQGVMFIDSYPDENDPSFIQFHKVPYVFIYAIPIPSDALAIEVNIAVVISCWTEDTGVNDGLNVKKEGPGRRTKCGIWGRDKRFTAAAINHTRTWKKKKPIPLQKK
	't1"  DYKFTQSDDGEYGATTRGEMTVYVGRPGFQILERQNFCGLSVSIAIRKVMENYFRDCAVQTRGLFMAGLKTHTSNVTLHGTIGMQGGTASLKKYPDVSDAGLIQFNLVPYVFVNAIPEPSDIFANGANTVWQLLCWTEDTGTNNGLNDKSDGSHKRTECNEWCIDTHGMVVGIKHASKWETDKFVPLKMK
	't14" KYGFTLHKDGVFGLQTKDHQTMYVGNTFFIIGAIQKFCKLDTTATIRTVGETYFSDCKIQTIGRAIDGLREQTPEVTLKGTIVSQQGIVLTEEYPELNDLHFIQFNKVSYVFVYAIKAPEDLEALDLNNADAIMCAKEDTGRNYGLGDKKDYNSVATKCAVYDVDQRMRSVAVKHYLLWKLEKVIPLFMK
	't15" NYKFTKTYDGEYGDATKEDMTVYVGAFGFLINNAQNYCALSTVSVIRTVGQNYFSDCAIQTTGLWINGFKEKTSNVTLKGTIWGQAGTAFTETYPEVNDRWFIQFNRVPYVFIRAIDAPDDLIALDANIAKIIYCWTEDTGTNLGLNDKKEYAHMRTKCRVYAVDERKQGVAIKHNTTWTIDKLIPLVMK
	't16" DYNLTYSYDGEYGEATLDEMTVYVGSGPFLIEDVQNACALSTLPHIRKVVENYFSDCAIQTSGLYIRGPREDTANVTLHGTIPGQQGVIFIESYPDVNDSVFIQFNRVPYVFVYAIMLPTDILAIQANFAAHIVCWTEDTGMNAGLNDKKEWAQRRTKCQVWDVDTRNMGVAVKHDTTWATKKPIPLLMK
	't17" AYEFDKGIDGENQAKTGRDMTVKVGDSDFVILGRQGVCALSSLMSIKKVVTSYFCACAIQTLGLYIRGVKQDTANVTLHNNIEGKRAIMFIEVYPDPTDDPSVSFSRVGYEFVIAIITPTDILAVQANMHQLISCCTENTGGNLGLNDKKQVIEKATKCGWGGVDIQKNGAAIRHARRWSFRQEVPLAPK
	't10" DYEFTAKYDGEYGAATQHEMTAYVGDALFKIDGRQNICGLSTVITIEKVLENYFKDCAVETQGLFMRGKKAHTSNVTLHSTISMQGGVAFIDKYPDVSDIRFPQYNRVQYVFVYAIPFPADVLAAKTNQGRKIICWTEDTGWNEGLNDKSDWTTKRTKCLVWIIDTRNMAAAIKHNDKWPTNKFIPFIIK
	't11" NYQFLHTRDGEYGSDTKKEMTVYVGDMFFQITGEQNTCALSTLLVIRKVIEQYFSACAVQTVGLYIKGPRDDTANVTLHRTISGQRGIMFIEAYPDANDRNFIQFDRVFYIFAYAVSRPTDVLAIQANFHELIICWTENTGFNIGLNDKKQYIKKTTKCKSWKVDTQNAGVAIKHDTQWTSQKPIPLQMK
	't12" NYVFLKTKDGEYGSDTKAEMTIYVGDVFFLISGKQNACALSTFLIIRKVIENYFSACASQTVGLYIRGPREETANVTLHRTISGQRGIMFIEAYADVNDKSFIQFNRVYYVFAYAVTNPTDVLALKANLHELIVCWTEDTGFNVGLNDKKGVIKKRTKCHIWSVDTQAAGVAIKHFTQWTLQKPIPLEMK
	't13" NYVFRKTRDGEYGSDTKAEMTIYVGDVSFLISGPQNACALSTLMIIRKVIENYFSACAIQTTGLYIGGGREETSNVTLHRTIAGQRGVMFIEAYADVNDKKFIQFNRVYYVFAYAVTDPTDVLAIKANEHELIVCWTEDTGLNVGLNDKKGVIKNRTKCHIWEVDSQAAGVAIKHFTQWTSKKPIPLEMK
	't20" TYSFMVTTDGAYKACTLIRTYVTVAKLVFFIGACQNDCILSTGFTIRNVASNFVTACGVNIKGSDITGRKTESAYVTLNRSIGGEKGYLIISYYMDIPDGGFLHFNQVLYFFTYAVSAPNDQLAPCVNVKVLILCDTEDTGLNGGLDDVIGTLHNQTKCTTWEVDNNVASVALKHQMPWAAFKSLPLPVT
	't18" NYQLTHTKDGEYGSDTKQEMTMYVGDLFFDIKGGQNTCALSTLFIIRKVHDQYFSACEIQTVGLYIRGARDKTANVTLHRAIKGQRGIMFIAGYPDENDRNFVQFNRVYYIFATAVKTPTDVLAVRANLHEMILCWTENTGWNAGLNDKKQYIKKRTKCSSVNVDTQNEGVSVKHDTQWVSQKPIPLTLK
	't19" NYNFTKRSDGEYGEATKQDMTGYVGDVGFSIADKQNYCALSTIPIIRKVEENYFSDCAIQTTGLYIRGAKDHTSNVTLHGTIAGQRGVAFIEEYPDVNDRVFIQFNRVPYVFVYAIAVPKDVIAIEANAKRLIVCWTEDTGANVGLNDKKEFTEKRTKCTIWSVDTRNEGVAIKHDTQWASEKPIPLMMR;
END;

BEGIN TREES;
	TREE tree = ((((t30:0.06128886105,((t46:0.05643295036,t67:0.04002395966):1.043417326,t97:0.6958460188):0.2649557619):0.006293993578,(((t44:0.003368254296,t84:0.008199588108):0.0533784077,t91:0.1044291171):0.2013125338,((t18:0.10550802,t17:0.0482739277):0.001411338786,(t58:0.02251044266,(t63:0.1168411716,t12:0.1164033587):0.06846848477):0.09161538966):0.0388488274):0.09064807729):0.05507304869,(((t71:0.02683306387,(t51:0.5740386912,t62:0.02209159976):0.01497015801):0.482023497,(((t5:0.2752470871,t66:0.2501176492):0.0521743043,((t95:0.007308479069,t22:0.6022031231):0.02848296875,t101:0.7061056009):0.001836935949):0.0001221302746,((t93:0.05083092496,t52:0.2160712202):0.01697310188,((t102:0.01082158297,t76:0.165966292):0.005205516437,t64:0.4832296414):0.01560801485):0.5717746509):0.4642109101):0.01040795752,(((((t103:0.01884871503,((t11:0.02748707255,t81:0.04641617769):8.263870822e-05,(t23:0.01549888274,t13:0.1102522311):0.01661339073):0.4330633582):0.1025723422,((t56:0.4472140296,t16:0.7991120944):0.3183020548,t39:0.007845066096):0.2764301943):0.05381094513,t37:0.0008020861176):0.239242797,((((t55:0.778468197,t100:0.02503234143):0.236457907,(t73:0.1398231296,t31:0.643977826):0.0005129893453):0.06633131192,t88:0.03243553065):0.02942688864,((t72:0.0005535571345,t38:0.1147076385):0.3399728315,t15:0.06582329439):0.1574418368):0.1010311592):0.1602652603,t7:0.137687442):0.4958280439):0.1286750993):0.06556727842,((((t8:0.007674722024,t94:0.9714182037):0.4069592365,t3:0.108701495):0.001684957879,(t20:0.1994333944,((t61:0.442678971,(t45:0.1018637423,(t2:0.04086669763,t6:0.003437251179):0.02679617221):0.2791636233):0.1735783363,t98:0.001063296716):0.06458293007):0.0007121864472):0.1246757375,((t42:0.8656193891,(((t74:0.06127408719,(t10:0.01759513444,t41:0.1092864811):0.08012800171):0.625150411,((((t1:0.5659729302,t59:0.01747911258):0.0004882752631,t78:0.4661104423):0.6578105785,((t83:1.164807369,((t50:0.2283634984,t99:0.009778392144):0.01621243869,t89:0.01383891957):0.003076485061):0.3535294813,t48:0.03625033067):0.009040826952):0.0005671825124,t34:0.004681006626):0.1004969324):0.01254124109,t25:0.220966534):0.05734308373):0.08460289499,((((((t75:0.08145381954,t77:0.5524964361):0.08083574726,t36:0.009966392659):0.01426628381,(t43:0.03784791855,(t47:0.1030796405,t68:0.86501697):0.002149320454):0.1038942478):4.949734823e-05,(t14:0.05599542683,(t40:0.07186896086,t65:0.0006343160513):0.0454494709):0.0330489629):0.3260031302,((t32:0.05329042532,t85:0.7207788066):0.001832810976,((t28:0.6722918675,t82:0.1931474979):0.134432572,((t69:0.6107655066,t9:0.2061540277):0.02450226246,t92:0.01006202265):0.03568312252):0.0009549465448):0.01835047912):0.0602516551,(((((t27:0.006340748925,(t96:0.03770839403,(t86:0.001826438123,t87:1.257438581):0.7102420208):0.02940181435):0.7317064175,t35:0.02135674737):0.06544050965,t60:0.5854702654):1.150403575,(((t54:0.02756702913,(t70:0.4383079104,t90:0.3628734939):1.988436196):0.003809037953,((t24:0.6101696443,t57:1.063792268):0.2516757552,t4:0.09059568285):0.311331975):0.02554446229,(t21:0.08017676247,t79:0.2587699644):0.0009845480288):0.06935659544):0.08688569421,((((t26:0.2027515752,t49:4.876143239e-06):0.02162421968,t19:0.0210271577):0.1673107233,t33:0.01031840313):0.001086499927,((t29:0.01015961064,t80:0.0129610141):0.008929938461,t53:0.06726909436):0.001682009408):0.000369231914):0.2953044464):0.7087512844):0.1814871951):0.1118680931);
END;

BEGIN HYPHY;

_tdsstring_ = "#t49\nSDVYKNAVYLQSDIGGFERFTRTGDEAVLYWDSCCHESPKLDTFKEQLTQ\nASQQTRQPKRGTESITKISEYTGIWWEDAVVATFPVLGSMAALTYEKSTG\nIPELKGPDHFSEVRFTVKAFAYVITGVWRGPATEVSYDVAVREVLYSNTA\nELTARQWLESGSVKSGNDLHIAKDLPRGKVQVIYNYLKNKGLRISEVKKS\nGSASVSTALKFEEPKSAELIESVGTILHT\n#t48\nSTVTKYLKYDKQDKGTFNTFSSVSSEAVLYKEICCHSLANLCAEAAKKRT\nRRKAAEHIAKGPLDIQKYSEYKGMHVTDPAIAKYSLLGSMKALPYGFSAD\nIDQTDDDNLAAPKTANEKGIGFTAPNTEPGPTVGVQLEQAIRHVMYSNTP\nEAPAEPVTTSQPPKQSGRLHMFKALRSTRVMIIYNTLKETKIPIKEFKRE\nASANVTTAAPFEEPKSAERLENVSLTGNV\n#t43\nSQVSDLFLLYKRNIEEFLDFEIVIGRAVLYIKNCCQMLSKLRVYDFLIRQ\nSLRQSTAVSSGTTLAHKISEHIGLLPMAREGAGVPALNSVGAVTYAISTG\nIGQLDRIDELTVATEFSVMDNAMIIGDSRGPTHPVAHDAASRELAYSNVA\nAGDALLPTPSERTKMRETLHLEKTLRPLCVEMIYNTLTSQDGPIEFVNKT\nGSADADANAAFEEPKSAEGRSGVGDVSDS\n#t42\nSKVYSPELFIQNDLGAFVRFAPTGDEQVLYYSQCCHYKTKLDSFAYNLRQ\nPSVQSRQLNTGNKKTKKLSEYDAIWWEDAILARMPCLGSMWALNYQKSTG\nIPPAKSSDKFSEMKLATRASNPVIVGVYRGPKFTVSVDMAVREVLYSNTA\nELSASTGMDSAGVKEGMNLHMQKDLNRNWVQVIYNYLKDVSVRIAPVKKE\nGSATVFTEVTFKEPKSAEISATVGAIANT\n#t41\nSTVTKYLEYDKHDKGSFNTFSPVASEAVLYKHMCCHRLANLCVKPGDKRF\nRRKAGEHLARGPFHIQKYSEYKGMHVTDPKILKWSLLGSMDALPYGFSAY\nIDQTDKGDIAAPKAVAEKGVGFTAANTTPGPTVGVPQERAIRKVLYSNTP\nEAPASYVTRSQPPKQSGTLHMFKALRSTVCMIIYNSLKETSLPIKEFKRE\nASARVTTAAPYDEPKSAERVENVSLVGNV\n#t40\nSNVKNTNGKPESKPESFWTFIVSVNEAVLYRMHCCDKGWKLSYVSQTLQL\nLLKQGLQYEKGCAAVKKLSEYDGSMWMDILNAPIPELGSVAADKYARSTG\nIQLKILLAALSSFNLEAKACNTVIPKNYLGPSYDVESESAVREVAPSNTA\nEVDAHIPEDSEGSKVTGNLHLQKSLVDYTAEVIWNTASKLFVRIDSLNKL\nGSHAVIAAPTFLEPKSAEIVPGVGAMLNY\n#t47\nSPVLDTVYFFQGNVGSFVKFTGLVTEAVLYTYECCHAKTKLAPLSHEFRQ\nVLQEDRQFSEGAEKVPKISEYIGIWWEDEMLSDQPALGSMIAVHYGKSTG\nIRTLKVEDGYSELTSVGKDFNSVIEGIPRGPGTDVSQDFAVREVLYSNTA\nELTAVKFLRSQGVKQDQQLHMQKELSRSLVQVIYNQLKDVMLRISDVKKD\nGSASVLAAKGFEEPKSAELAAAVGSTFST\n#t46\nSPVLDTSFFFQGNVGEFVKFTALHTEAVLYAYDCCHPKIKLYLLVYNFRQ\nVMQESRQLSEGAELVPKISEYIGIWWEDQILSDQPCLGSMPAVHYGKSTG\nIRSLNYDDEYSEVKSVAKDFNNIIEGIPRGPGQDVGQDFAVREVLYSNTA\nELTAAFWLRSQGVKQDHYLHMQKELSRHLVQVIYNSLKDIMLRISIVKKD\nGSASVLPAASFEEPKSAELAAAVGVILST\n#t45\nSKVYSPERFIQNDLGEFLRFGRTGDEQVLYFMECCHGKAKLASFVSNLRQ\nAEKQCRQLAAGSKFTRKLSEYDGIWWEDPTLEVMPCLGSMNAVFYQKSTG\nIPTLAGQETFSEIKYRVKAFRKVIMGVYRGPKFGVSFDMAVREVLYSNTA\nELSAPVVMDSKGVKEGMKLHMQKELNRNWVQVIYNYLKDINIRIAPLIKE\nGSATVLTENTFQEPKSAEVFATVGAIKGT\n#t44\nSYVKDTGELVEFNYEKFWSFTVSLATAELYRLICCPLGFKLYLHEFELKL\nAIKQMVKFVGGCYLVPKLSEYVGVFWMDGIDNKLPRLGSVKAIRYASSTG\nIEATVFRDNYSSIDYDGKHCDGVIATSLRGPGFDVRNECAVREVDPSNTA\nELKAHTHGESNGTKVLDGLHLQKSLGNSDAEVIYNYKAELNVRIDIENKR\nGSHQVLVAFSFLEPKSAEKLGKVGNVSNW\n#t13\nSSVKDVEKLEQSTPELFWSFDYDVGEAVLYRYKCCATSLKLETVAKLMLL\nVLKPCLPRATGCDRVKKISEYTGVVRMEAVGATRPPLGSVRAFHYAVNTG\nIDFYLRAPEYSSVTLMIKDRGKVFCQNVKGPGYDVGKDCAPRELVPSNTA\nENLAHALDVSDGTKTKTPLHLTKKLSNWYAEVIYNNRAEFYFQILFINTC\nGSYQVLAASCFLEPKSAESAFVVGDFMNV\n#t14\nSKVTKGKGIGQMGPGGFLQFVSTLDESVLYSKVCCHPVLNAGAFFFGERA\nGAEEGRHSVRGPHHLNKFSEFAGILVTDNILGWYPVLGSMKAVDYDFSDG\nIDFVTYRQSYSPAWNKVRKDSNTANLNFRGPSSEVPPDLAVRKVLFSNTP\nEPRAAGGVDSPDPKQFSALHMNKGLPQFGIMIIYNRLLAPASPINGMKAF\nGSSAVSTANWYLEPKAAEQVLLVSIPVNG\n#t15\nSHVGQRGHLIERELEIFVIFIGTNGEAVLYVVSCCEQTYKLSINEGDQYV\nDLNREQKKCNGCQPIVKVSEYLGILWMDLFAQGLPCLGSVKAEEYAKSTG\nIRENENVDPYSIFEMGLKSANLLLLGDTRGPGGDVKYNHAVREVAYNNQA\nESKAPHIASSGGSKVASALHMQKLLTNPIVYVIYNSLKQFAIRTSQVNKD\nASEHIVAAVEFAEPKSAELCAEIGNAANE\n#t16\nSHVSDNVALLELELEKFISFELTGDEEVLYCGDCCKKYGKLDVITSLLNF\nELKQCLALCAGCAAIDKISEYQGVLWMDSVSVDLPCLGSVHAIQYASSTG\nIRYSEESDSFSPFEFYLKACNQVILGDGRGPGVNVRLDCAVREVAYSNTA\nELKAKAQNGSGGTKVTQQLHMQKTLKSGKVEVIYNCLKQLLIPISKVNKL\nGSAEVKAADEFVEPKSAEIRGNVGNAEDP\n#t17\nSKVYSPELRVQTDLGGFVKFAPTGDEQVLYFLQCCHGKAKLDSFVANLRL\nATQQARQLTAGSKSTRKLSEYEGVWWEDAILAKMPCLGSMWALNYQESTG\nIPPLKSTDSFSEMKLSVKAFNPVITGAYRGPKYGVSFDMAVREVLYSNTA\nELSASAIMDSEGVKEGAGLHMQKDLNRDWVQVIYNYLKDIEIRIAPVKKE\nGSATVLTELVFKEPKSAEIFATVGAIANT\n#t10\nSQVEQGPALSKLELESFLAFEIALRKAVLYFGCCFETATKLKDIFGLVVI\nSLNFMTTVGAGSKMARKLSEHVGIIPMDFDGQYVPPLGSVLAVTYAVSSG\nISNLDLGDGLTVRYGYGVVDKKVNTGERRGPAAIVGQDDAAREIAYSNVA\nVGDALTLTVSGGDKMRQALHMLKALKPSKVEVIYPALTDELSPISIVNRL\nGSSDASAYESLVEPKSAEKKSSVGEKSDL\n#t11\nSSVSDGMPLLSVEAEKFILFDLTGEEAVLYNLDCAKRYKKLNVLVIILGI\nGLKQILAVCEGCAAIRKVSEYDGVLWMDVTQVYLPCLGSVKAVQYANSTG\nIRWSEHGHAFSPLELFPKTSNKVIVGPARGPGDNVQVDCAVRQVAHSNTA\nEVKAKSINDSGGTKAPEYLHMEKVLKSDSVEVIYNELKFTSRAIAKVNAL\nGSSFVKAAGKPPEPKSAEIINKVGNAKDD\n#t12\nSTVYNQGKYSQGEIGDFVRFTPTGDAHLLYLIKCCHIKHKLDSQNIHVRS\nAGQENRKEQKGARMVGKMSEYRGIWWEDELLNKFPCLGSMGALTYQTSTP\nISSLRGEDTFSDCDDSLKALAFVIVVIFKGPAHDVFYDEAVREVLYSNTA\nETGARQSLQSAGVKKGNFLHMFKVLTRPSVQIIYNLLKNVLLPISAVKKP\nASASACTAGNFEEPKSKEFMGAVGTVINP\n#t39\nSPVRDPALLLEDQTGPFWAFSLQSERAVLFEDICCKIGTQLDCVSRCQYY\nDVALSVSVKDGCSDVMKLSENRGVVNLDLMYERLPLLGSVGALNYAANTG\nIDLKLVADVYSKMKNGKETCDVAPDEARQGPGAGVAGEFAIRRAAPSNTA\nEVTANGLGSSGKTKTSLGLHLAKKLPQTEAESIFNYKCKMCARISFANTS\nGSHTVMVAPEFLEPESAELIDAVADKQNL\n#t36\nSVVDRMKLIEHIIAGGFLRFVVTFYEKVLFQYVCRENMENANQFLVAEQG\nAASEGLHFQNGPNGLTKFSEFNGVIVTDPILSGYPALGSMQAVEYDFSDG\nIDIMTRCQAYSPAWHKLRQLNLTAKLSGRGPSLVVERDNAVRKVLFSNTP\nEPCAQKVDVSPNPKQTSKLHMYKRLAQLKIMIIYNSMLEPAAPINMMKAL\nGSAPINSAKYYLETKAAEDILVVSVKLNR\n#t37\nSSVKDTKKLEQVTPEPFWSFDDSVNEAVLYMVSCCATGAKLVSVNELLLL\nALKQLIPEQTGCTRVGKISEYSGVTRIEVANTQGPVLGSVKAFHYAVNTG\nIDTVLRCEAYSSKWKDVKHCGRVFAKNVKGPGYQVQIESAPRELVPSNTA\nETLAYQGDKSDGTKIKTQLHLTKKLYNWFAEVIYNRQAQFDFQIRFANIC\nGSYQVLAATCFLEPKSAESAYNVADIANV\n#t34\nSNVKDAAVLNETAPEKFWAFVISIDEAVLYLPLCCDWGFKLQLVPPCLKL\nELKQCLKFMNGCSEEQKLSENAGTFWLDSLNDQLPRLGSVLAVHYAKSTG\nIDLSVHKDPYSSIDEDGKNCDGEITKNFQGPGDDVGGECAVREVRPSNTA\nEAKAKDKIGSEGTKVTESLHLPKVLVNSEAEVIYLWKAKMAVRIHMVNKI\nGSHQVMAAQRFLEPKSAEFLFAVGNTTNF\n#t35\nSNVKDAGKLSEDAPGKFWLFVLSIDEAVLFKAYCCDIGLKLRVVLLSGKF\nDLKQWVKFANGCSKVEKLSENCGVLWLDGLNDTLPILGSVQALHYADSTG\nIDLTLGEDEYSGVAWWGKATDGAPADTDQGPGKDVADECAVREVAPSNTA\nELKAKQSLGSGGTKVNNHLHLPKALVHSAAEVIFNNKAKMEVRIHCINII\nGSHQVFAAESFLEPESAEVLLVVGTTANW\n#t18\nSNVSDVSILFDFQLEKFVSFEFTGDQEVLYCTDCCKKYGKLPVVLQMFNF\nELKTCLKLSVGCADINKFSEYMGIIWMDIRSLNLPGLGSVLAIAYEFSTG\nIRYGETTDVFSKFSGQEKPCNGFILGDSRGPGQNVSFDVAFREVAYSNTA\nEGKAEKFNGSGGTKVTPQLHMRKSLMSEEVEVIYNMLKTLITPIIVVNKF\nRSAPVKDARPYNEPKSAEIHGNVGNAKDP\n#t33\nSTVGDVNALRDRVPERFWAFVLSVGEAVLYKSDCCDDGLHLPMVGQIMKL\nEVKQVLKFDQGCNSNNKLSEYEGTYWMDGLNGSLPQLGSVIAVQYALSTG\nIDYNISKDKHSSYTQNAKSCAGVIRENLRGPGEDVRTECAVREVAPSNTA\nESKAQKLDKSDGGKVIENLHLQKTLLSSMAEVIYNWKALLAVRIDMVNKV\nASHLVEAVDGFQESKSAELLYAVGHTVNF\n#t30\nSHVGQRGQLIERQLEMFVIFIGTNGEAVLYVVSCCEQTYKLSINEGDQYV\nDLKREQKDCNGCQPIVKVSEYLGILWMDMFAQGLPCLGSVKALEYAKSTG\nIRQNENVDPYSIFEVGLKPANLLLLGDVRGPGGDVKYNHAVREVAYNNQA\nESKAPPIASSGGSKVASALHMQKLLTNPIVYVIYNALKQFAIRTSQVNKD\nASEHIVAAVEFAEPKSAELCGEIGNAVNE\n#t31\nSHVSDNVALLELELEKFISFELTGDEEVLYCGDCCKKYGKLDVITSLLNF\nEIKQCLALCAGCAAIDKISEYQGVLWMDSVSVDLPCLGSVHAIQYASSTG\nIRYSEESDSFSPFEFFLKACNQVILGDGRGPGVNVRLDCAVREVAYSNTA\nELKAKAQNGSGGTKVTQQLHMQKTLKSGKVEVIYNCLKQLLIPISKVNKL\nGSAEVKAADEFVEPKSAEIRGNVGNAEDP\n#t38\nSKVYYPEIFIQNDRGAFVRFWGTGDEQVLYYAQCCYFKTKLDDFNNNLVQ\nPSIQTRLDNTGNKKTFKLSEYDAIWWEDALLVRMPCLGSMWALDYQKSTG\nIMPASAIDVFSEAKLAIRAFNPVIVGVLRGPYYTVTFDSAVREVLYSNTA\nELSASVIAESAGVKEGMQLHMNKELNRTWVQVISNSLKDVDVRIAPVKKK\nGSALVLTELTFKEPKSAEIFVTVGAIQNK\n#t50\nSSVRELAHLLESKAGAFDAFSLQAERAVLFENICCKVSTQLGCAKLCRYT\nEIALNASVEDGCSEVMKLSENRGVVSLDLMYERLPLLGSVGALNYLTNTG\nIDYKLVADVYSKIKSGSEKCDKAPDEARQGPGSGVSAEFAVRTAGPANTA\nEVTANGLGSSGKTKTSLGLHLAKKLPQSAAESIYNLKCKMPALIAYANTS\nGSHTAVVAMLFLEPESAELIDSVADKDNL\n#t51\nSHVSDNVMLLELELEKFILFELTGDEAVLYCGDCCKRYGKLDVVTALLNF\nELKQALALCAGCGSINKISEYDGVLWMDNVQVDLPCLGSVAAIQYAWSTG\nIRYSEKSDSFSPFEFYLKACNKVILGDGRGPGISVRFDCAVREVAYSNTA\nELKARPRNGSGGTKVTQLLHMQKTLKSGKVEVIYNCLKKLLRPISNVNKL\nGSAVVKAADEFVEPKSAEIRGNVGNAEDP\n#t52\nSRVKDSGLVRTYAPERFWSFYISLDEAVLYKQHCCDQGFKLWLWSQVMKL\nKLKQVLKHGDGCNHISKLSEYCGTYWMDALANALPSLGSVGAVQYTVSTG\nIDVAIDGDRYSSIRDLRKQWDGEIPTNFRGPGEEVKTECAVRTWAPSNTA\nEGKAHVANNSAGTKVIEELHLAKALANMPAEVIYNYKAQLTMRIDQVDKL\nGSHRVPSALAFLEPKSAELRFCVGDAENF\n#t53\nSKVYSPERFVQNDLGEFLRFARTGDEQVLYFMECCHGKAKLASFVPNIRQ\nAEQQCRQLSAGSKFTRKLSEYDGIWWEDPTLAKMPCLGSMNALNYQKSTG\nIPTLAAQDAFSEIKWSVKAFRKVIMGVYRGPKFGVTFDMAVREVLYSNTA\nELSASVVQDSEGVKEGMGLHMQKDLNRDWVQVIYNYLKDINIRIAPVKKE\nGSATVLTENTFKEPKSAEIFATVGAIAGT\n#t19\nSQVEQGHTLTKEDLESFLAFESTLRKAVLYFACCFDSEQKLKDVFGMLVI\nSLNFHTTVGAGSSKAQKVSEHVGIIPMDFDGEYVPPLGSVLAVTYAVSSG\nISSLDWCDALTVRYVYGVVDKKVNVGELRGPEAVVGIDEAAREIAYSNVA\nAGDALHTTISGGTKMHQELHMWKALTPKMVEVIYPKLTVQLSPISVVNRL\nGSSDAGAYGSLVEPKSAEKRDSVGEKYDL\n#t8\nSYVKDTGSLMEFHVEKFWTFVNSAITAELYLFSCCPWGYKLYLHRFRCSA\nSLKQIASYSGGCYTVPTLSEEVGVVKIDGWDDKLPRLGSVGALRYNLSTG\nIDVSVGLDQYSNKDADTKHMDYVIGATFRGPGHDVRVEWAVREVGPNNTA\nENKADPEGKSAGTKVLGILHLQKSLGMTSAEVIYNLKAELPTRIDVQNLR\nGSHQVLVALKTAEPKCAEEIGRVGNTHNE\n#t9\nSDVKDGSHLDQYSLEKFWSFYASLDEAVLYDDSCCDRGFKLLRWGFVNKS\nKLEQQLKEGDGCAILYKRSEYCGTYWMDLFGDCLPKLGSVKAVPYTLSTG\nIDVSASDDNCSSKDEQSKDWDAEITTRNRGPGKKVRPECAVRTWAPSNTA\nEGKADEVKGSEYTKVVESLHLSKALTNSLSEVIYNFKPQIATRIDMVDKH\nGSHQVLSADAFLEPKTAETRFCVGDKHNF\n#t6\nSYVKDTGELVEYNPEKFWTFTVSLATAELYWYICCPLGYKLYLHEFELKL\nAIKQAISFVGGCYVVPKLSEYVGVFWMDGIDNKLPRLGSVWALRYALSTG\nIDVSVARDNYSSIDYEVKHCDGVIATSLRGPGLDVRNECAVREVAPSNTA\nELKAHTQDESEGTKVLDGLHLQKSLGNSDAEVIYNYKAELNVRIDIENKR\nGSHQVLVAFSQLEPKSAEKLGKVGNVHNW\n#t32\nSAVHEPENYSPADLGAFMRFASTGDKQVLYDKRCGDAKSNLQFVYHRKRE\nLDHQLNQLASGLPVVPKLSEYSGIWWEDAVLYTQPCLGSMRAFGYQASAG\nIPSVEGTEGSSELGSEIGTFNVSVRGVLRGPQESVNNDTAVRKVLYSNTA\nELMADLGLDSEGIKEGISLHMQKDLFATLKKVIYNLLENLTSRIIGIETD\nGSATVATDFIFGEPKSAEMLVEVGAWSNT\n#t4\nSEVYDVNFFFKGDLGGFIKFTPLDTEAVLYKHECCEGKLKLQAFPVELRQ\nANQEIRQLSSGSKSVDKISEYLGIGWEDAFVAEMPGLGSMDAVKYQKSTG\nILDLKLEDSYSQLEIVKKDYNAVIEGIGRGPSEDVSEDIALREVLYSNTA\nELTAAAEFQSEGVKYGKYLHMQKELTRRTVQVIYNSLKDIYLRISGVKKN\nGSASVLTAVVFEEPKSAELVETVGSLANT\n#t5\nSEVTDAEMLRQQTPENFAAFEGELDEGVLYLFACCDKGDKLDILNVDIWL\nGLKQELPFVTGCTSVSKLSEYLGVPHMDGFDHFLPKLGSVYAIQYTRSTG\nIDYPLGVDDYSTITKEYKHAADVVNTNKRGPGFDVNPECAVREVAPSNTA\nEVKAYQADDSDGTKVLTLLHLQKALCNWNAEVIYNDEAELTIQIRFVNSL\nGSHQVLAAACFMEPKAAEFQYPVGSFNNY\n#t2\nSSVKDTEALRQATSEKFWSFAEEIDEAVLYQYHCCDDGSKLEIVPAEMLL\nALKQRLPLANGCNNVTKLSEYIGVVWMDGLNNSLPKLGSVWAIQYAISTG\nIDFSLDKDGYSSITTEAKKCGTVICANVRGPGTDVKEECAVREVAPSNTA\nEAKAYDLDDSDGTKVIVSLHLQKALSNWYAEVIYNWQAELNVQIRVVNTV\nGSHQVLAAECFLEPKSAEVQKPVGDVFNY\n#t3\nSNVKDNGTVAQYAPEKFWSFYISLDEAVLYKTHCCDQGFKLWLWGQVMKL\nKLEQVLKSGDGCSLVAKLSEYCGTYWMDALTDALPKLGSVGAVQYTLSTG\nIDVSIDSDMYSSIREERKKWDGEIATNFRGPGREVKTECAVRTWAPSNTA\nEGKAHVVNNSEMTKVIENLHLAKALVNSPAEVIYNFKAQLDMRIDMVDKL\nGSHQVLSALAFLEPKSAELRFCVGDADNF\n#t1\nSSVTDAEALRQETPEAFASFEGKVDEACLYFFQCCDHGDKLDIVQIAMWL\nTLKQDLPFVTGCTKVAKLSEYFGVPHMDGLDEFLPKLGSVYAIQYTRSTG\nIDYPLGKDAYSTLATEYKHCASVVYTNNRGPGFDVNPECAVREVAPSNTA\nEVKAYTLDESDGTKVLVVLHLQKALCNWNGEVIYNNEAELSVQIRFVNSL\nGSHQVLAALSFLEPKAAEVQYAVGSFNNY\n#t29\nSQVKNTGPLIETNPEEFWVFVKSAVTAELYLWICCPVGYKLYIYPPELLL\nNTKQGTEATGGCFVVRKLSEYLGLFKIDGRDSKLPSLGSVWAWSYALSTG\nIDMCVSRDFYSSIDNDVKHADMVIGTSLRGPGLNVIEEAAVREVAPSNTA\nESKADKDAKSQGTKVLGGLHLEKSLGESQQEVIYNPKAELETRIDYENKR\nGSHEVAVAWKQAEPKSAEDLGKVGDVANW\n#t28\nSSVKDTEALRQPTPEKFASFEEEIDEAVLYQYHCCDSGGKLEIVPAEMLL\nSLKQRLPFATGCNKVTKLSEYIGVVWMDGLNNSLPKLGSVWAIQYAISTG\nIDFNLNKDGYSSIMTEQKKCGTVICTNVRGPQTDVKKECAVREVAPSNTA\nEAKAYDLDDSDGTKVIVVLHLQKALSNWYAEVIYNWRAELSVQIRIVNTV\nGSHQVLAAECFLEPKSAEVQFPVGDTSNY\n#t7\nSKVYSPSRFVQNDLGEFVRFARTGDEQVLYFLECCHGKAKLESFVPNLRQ\nAEQQCRQLSAGSKFTRKLSEYDGIWWEDPTLLKMPCLGSMNALNYQKSTG\nIPTLKSQDAFSEIKYAVKAFRPVITGVYRGPKVGVSFDMAVREVLYSNTA\nELSAELVMESEGVKEGMGLHMSKDLNRDWVQVIYNYLRDINIRIAPVKKE\nGSATVLTENDYREPKSAEIFVTVGAIAGT\n#t21\nSNVKDAGQLQETAPEQFWAFVISIDEAVLFALFCCDFGLKLRMVLVCRKL\nELKQCVKFMNGCSNVEKLSENGGVFWLDGLNDSLPRLGSVSAIHYAESTG\nIDMSVDGDRYSGVDDDGKSCDGAIEANDQGPGEDVANECAVREVAPSNTA\nEVKAKDLIGSEGTKVTKALHLPKALVNSKAEVIFNWKAKMAVRIHVVNKV\nGSHQVLAASRFLEPESAELLLAVGNTNNF\n#t20\nSHVGQRGHLIERELEIFVIFLGTNGEAVLYVVSCCEQTYKLSINDGDQYV\nDLNREQKKCNGCQPIVKVSEYLGILWMDLFAQGLPCLGSVTAEEYAKSTG\nIRENKNVDPYSIFEMGQKSANLLLLGDHRGPGGDVKYNHAVREVAYNNQA\nESKAPHIASSGGSKVASALHMQKLLTDPIVYVIYNSLKQFAIRTSQVNKD\nASEHIVAAVEFAEPKSAELCAEIGNAANE\n#t23\nSTVYKSGFYDQGDLGGFVRFTPTGDEALLYATACCHAKHKLDSSDANLRS\nASQQYRKEKRGAKMVGKLSEYWGVWWEDDVLKSFPCLGSMSALTYLTSTG\nIPSLKAADKFSDCKQYSKAFACVIMGIRKGPAEEVFYDLAVREVLYSNTA\nEMTARAGLQSAGVKKGGLLHMHKVLTREVVQIIYNSLKDVNLRIAAVKKP\nASASVNTAFAFEEPKSKEFMKSVGTILND\n#t22\nSKVYSPELFIQSDLGQFYRFAPTGAEQVLYHRQCCHGKAKLDPFLANLRK\nANVQNRQIATGSKSTRKLSEYDAIWWEDAILAKMPCLGSMWALNYQTSTG\nIPPLKGRDHFSEMKASIRAFNPVIVGVFRGPKFTVSLDMAVREVLYSNTA\nELSARVVMKSEGVKEGMKLHMQKDLNREWVQVIYNYLKDVNNRIAAVKKE\nGSATVLTELTFKEPKSAEILATVGAITNS\n#t25\nSKVFSPKKFVQSDIGDFLRFGKTGKEQVLYWLECSHSSEKLDAFLEKLRA\nTEQQAKKLTAGSKYTRKLSEYNGIWWEDPTIAKMPCLGSMTAMNYQNSTG\nIPTLAARGVFSEIKFRLKAFRRVILGVKHGPKFGVPFDMAVREVLYSNTA\nELSAITAASSDGVKEGMFLHMQKDLKMDRVQVIYNFLKEINLRIPDIKKA\nGSATVLTEEVFKEPKSAEVFATVGAVKGN\n#t24\nSKVYGLHYFTQADLGEFVRFARTGAEQVLYVTECCHGKTKLDAFAWDMRQ\nADQQRGQHPDGQRFTGKLSEYGGVWYEDPPLSRMPCLGSMAALDYHKSTG\nIPVAKNCDVFSEIIGTVKALKPLIYGVGKGPKLGVSSDLAIREVLYSNTA\nELSASEVMSSEGVKEGIQLHAKKALGREWVQVIYNSLQSITLRIRNVKKE\nGSDTVLTEVRFKEPKSAEAFATVGAVDGS\n#t27\nSKVYYPELFIQNDRGAFVRFYQTGDEQVLYYAQCCAYKSKLEDFANNLVQ\nPSIQTRLDNTGNKKTFKLSEYDAIWWEDALLARMPCLGSMWALNYQKSTG\nITPASALDVFSEMKLAMRAFNPVIVGVLRGPKYTVSFDMAVREVLYSNTA\nELSASAVIESAGVKEGMQLHMKKELNRTWVQVIYNTLKDVDVRIAPVKRK\nGSALVLTEITFKEPKSAEIFLTVGAIKNT\n#t26\nSKVYSPELFIQEDLGAFVAFSPTGDEQVLYYQECFHAKAKLDSFLGTLRQ\nASVQSRQVFTGNKSTHKLSEYDAIWWEDCTLAKMPCLGSMWASNYQKSTG\nIPPLPGADQFSEMTLSLRAFNPVIVGVYRGPKLTVSFDMAVREVLYSNYA\nELSASATMDSKGVKEGMPLHMQKDLNRDQVQVIYNFLKDVDVRIATVKKE\nGSATVLTEVTFKEPKSAEVFATVGAIENV\n\n\n((((t30:0.06128886105((t46:0.05643295036t67:0.04002395966):1.043417326t97:0.6958460188):0.2649557619):0.006293993578(((t44:0.003368254296t84:0.008199588108):0.0533784077t91:0.1044291171):0.2013125338((t18:0.10550802t17:0.0482739277):0.001411338786(t58:0.02251044266(t63:0.1168411716t12:0.1164033587):0.06846848477):0.09161538966):0.0388488274):0.09064807729):0.05507304869(((t71:0.02683306387(t51:0.5740386912t62:0.02209159976):0.01497015801):0.482023497(((t5:0.2752470871t66:0.2501176492):0.0521743043((t95:0.007308479069t22:0.6022031231):0.02848296875t101:0.7061056009):0.001836935949):0.0001221302746((t93:0.05083092496t52:0.2160712202):0.01697310188((t102:0.01082158297t76:0.165966292):0.005205516437t64:0.4832296414):0.01560801485):0.5717746509):0.4642109101):0.01040795752(((((t103:0.01884871503((t11:0.02748707255t81:0.04641617769):8.263870822e-05(t23:0.01549888274t13:0.1102522311):0.01661339073):0.4330633582):0.1025723422((t56:0.4472140296t16:0.7991120944):0.3183020548t39:0.007845066096):0.2764301943):0.05381094513t37:0.0008020861176):0.239242797((((t55:0.778468197t100:0.02503234143):0.236457907(t73:0.1398231296t31:0.643977826):0.0005129893453):0.06633131192t88:0.03243553065):0.02942688864((t72:0.0005535571345t38:0.1147076385):0.3399728315t15:0.06582329439):0.1574418368):0.1010311592):0.1602652603t7:0.137687442):0.4958280439):0.1286750993):0.06556727842((((t8:0.007674722024t94:0.9714182037):0.4069592365t3:0.108701495):0.001684957879(t20:0.1994333944((t61:0.442678971(t45:0.1018637423(t2:0.04086669763t6:0.003437251179):0.02679617221):0.2791636233):0.1735783363t98:0.001063296716):0.06458293007):0.0007121864472):0.1246757375((t42:0.8656193891(((t74:0.06127408719(t10:0.01759513444t41:0.1092864811):0.08012800171):0.625150411((((t1:0.5659729302t59:0.01747911258):0.0004882752631t78:0.4661104423):0.6578105785((t83:1.164807369((t50:0.2283634984t99:0.009778392144):0.01621243869t89:0.01383891957):0.003076485061):0.3535294813t48:0.03625033067):0.009040826952):0.0005671825124t34:0.004681006626):0.1004969324):0.01254124109t25:0.220966534):0.05734308373):0.08460289499((((((t75:0.08145381954t77:0.5524964361):0.08083574726t36:0.009966392659):0.01426628381(t43:0.03784791855(t47:0.1030796405t68:0.86501697):0.002149320454):0.1038942478):4.949734823e-05(t14:0.05599542683(t40:0.07186896086t65:0.0006343160513):0.0454494709):0.0330489629):0.3260031302((t32:0.05329042532t85:0.7207788066):0.001832810976((t28:0.6722918675t82:0.1931474979):0.134432572((t69:0.6107655066t9:0.2061540277):0.02450226246t92:0.01006202265):0.03568312252):0.0009549465448):0.01835047912):0.0602516551(((((t27:0.006340748925(t96:0.03770839403(t86:0.001826438123t87:1.257438581):0.7102420208):0.02940181435):0.7317064175t35:0.02135674737):0.06544050965t60:0.5854702654):1.150403575(((t54:0.02756702913(t70:0.4383079104t90:0.3628734939):1.988436196):0.003809037953((t24:0.6101696443t57:1.063792268):0.2516757552t4:0.09059568285):0.311331975):0.02554446229(t21:0.08017676247t79:0.2587699644):0.0009845480288):0.06935659544):0.08688569421((((t26:0.2027515752t49:4.876143239e-06):0.02162421968t19:0.0210271577):0.1673107233t33:0.01031840313):0.001086499927((t29:0.01015961064t80:0.0129610141):0.008929938461t53:0.06726909436):0.001682009408):0.000369231914):0.2953044464):0.7087512844):0.1814871951):0.1118680931)";
DataSet protein_gtr.msa.1 = ReadFromString (_tdsstring_);
_tdsstring_=0;
_tdsstring_ = "#t89\nWLIDAGPFSKDNYGEFWPILRLKRAGSYVLTVQVVHYEKKAIDKSYQGMM\nQPGAESSGFLGLALGTHGGPEAAVYLAYGLANSTHGG\n#t88\nLLVEGGPFSQDGFGEFWPVDRLKNVGNGVLKVHVGSQSARVIGKTMKGIM\nENGMELGEKAFNAIGLHGFPEAGVVNCYGGERLTHTG\n#t87\nLLVDGGPFSQDGFGEFWPQDRLKNRGNVVLQMHVGNKATRVIGQTMKGIM\nDNGWELSEKAFNAIQLHGTPEAGVVNCYGGSRLTHGG\n#t86\nMLLDRGPFSKDGFGEFWPLSRLKRDGSAVLEFHVGNEETRSISITEKGIM\nTTGYELAPQAFVALVLHGEDEAGIHGGYGATKITHIG\n#t85\nMLLDKGPFSKDGFGEFWPLSRLKRNGSAVLEFHVGSEAKRVISLTEKGIM\nTTGYELNAQAFKALVLHGKDEAGVHGAYGATKITHVG\n#t84\nFLLEDGPFSRDMFGEFWPVGRLKRGGSYILEFHVDVVLTHPVIVTEPGIM\nGSGEELAAQPFKALGKHGARETGVPINYGAQEPAHRS\n#t83\nVLTDEGPYSKDGFGEFWKSARLKRHYSAVLEFSVVAKTAQLINLTLEGVM\nRSGRSLTAAAYNALQLHGEKEPGIPGDYGADDIAHLG\n#t82\nQLRDTGPFSKDGYGEFWPSSRLKRRGSLVLEFHVATEADQVIGLTEDGIM\nDTLHEQSAQAIVALELHAQPEAGVTGGYGATDITHDG\n#t81\nALLENGPFSRDGSGDFWPTCRLKRSGSGVLQFHVSNEAAEIISLTEKGIM\nGTGYELTTLELEALALHGEPEPGFKGRYGIAKFTHPG\n#t80\nLLGDGGPFSQDGFGEFWPAGRLKNQGHIVLQMHVGNQAARQIGKTIKGIM\nANGNEATEKAFNAINLHGSPEAGIVDCYGGPKFTHTG\n#t72\nQLMDLGPFSKDGFSEFWPGSREKRGGAFVLEFHVLDQATQHIGLSYEGIM\nNPTTELSASAFKALNLHGQPESGVKGPYGAKDLGHTG\n#t73\nMLLDKGPFSKDGFGEFWPLSRLKRNGSAVLEFHVGSQALRLISLTEKGIM\nTTGYELTAQAFKALVLHGEDEAGIHGAYGATKITHAG\n#t70\nALFKLGPFSRDGFGDFWPGCRLKRAGSAVLQFHVANEALRSISLTEKGIM\nETGYELTTPELKALRLHGEPEAGIKGSYGITKFTHLG\n#t71\nMLVSCGPYSNDGFGEFWKGSMLKKGFSGVLDFYVNSAVGTHIILTLTGIM\nAALISLGAIAFWELVLHGGQEAGIITGYGAERLPHHG\n#t76\nMLLDRGPFSADGFGEFWPHNRLKREGSGVLQFHVNNEAVRLIGSTEKGIM\nDNGYELTAQAFAAITLHGSPEAGITGTYGATKITHSG\n#t77\nQLMDLGPFSKDGFSEFWPGSREKRGGAFVLEFHVLDQATQHIGLSYEGIM\nNPTTELSASAFKALNLHGQPESGVKGPYGAKDLGHTG\n#t74\nMLWDAGPFSKDNFGEFWPGARLKRAGSAVLEFKVGNDATRLIPLTEKGTA\nDTGIELTAQALKALLLHGEPEAGITGGYGVTKITHEG\n#t75\nQLMDLGPFSKDGFSEFWPGSREKRGGAFVLEFHVLDQATQHIGLSYEGIM\nNPTTELSASAFKALNLHGQPESGVKGPYGAKDLGHTG\n#t78\nWLLEIGPFSKDNYGEFWPMLRLKRASSAVLTVQVIHYEAKGISKSYQGMM\nQPAGESSGFLGLALGSHGGPEAAVYIAYGLANSTHGG\n#t79\nMLPDQGPFSKEPFGEFWPSSKLKRAGSSVLALHVGNEALGIISMQEQGIA\nDVGYELNANALSALNIHGEPEAGISEEYGVKKATHLG\n#t98\nMLLDKGPFSKDGFGEFWPSTRLKRNGSAVLEFHVNNDSIRVISLTEKGIM\nDTGYELTAQAFKALYLHGEPEAGITGGYGATKITHLG\n#t99\nMLLDHGPFSADGFGEFWPHRRLKRIGAGVLQFHVENKSDRSIAYTKKGIM\nTPGYEELAQPFKAILFHLRPEAGIDQAYGADKITHEG\n#t94\nLLIDGGPFSEDGFGEFWPVDRLKNKGNCVLQMHVGVQAVREIAKTLKGIM\nENGWELSEKAFNAIGLHGSPEAGVVNCYGGPRLTHSG\n#t95\nMLVDKGPFSKDGFGEFWPVSRLKRHGSAVLEFHVGSEALRTISLTQKGIM\nETGYELTAQAFKALVLHGEDEAGIHGAYGATKITHLG\n#t96\nMLIDKGAFSKDGFGEFWPVSRLKRRGSAVLEFHVASEALRTISLTQKGIM\nETGYELTAQAFNALILHGEDEAGMNSAYGAAKITHLA\n#t97\nMLLDSGPFSKDGFGEFWPVSRLKRNGSAVLEFHVASEATRVISLTKKGIM\nTTGHELTAQAFKALILHGEDEAGIHGAYGAATISHVG\n#t90\nMLDNHGPDSKDGTGEFWPGMRLKKNRTWVLALHVHQLAYRYIAVTKPGIM\nQPGTELNVQPVFALRLHQTDEAGVSGAYRAKDVSHNG\n#t91\nMLLDVGPFSADGFGEFWPPRRLKREGSGVLQFHVQDKPNHDIGYTEKGIM\nQPGYESVAQPFKAIIFHASPEAAIPGPYGARKITHPG\n#t92\nMLLDDGAFSNDGFGEFWPLSRLKRDGSVVLEFEVPNELDRVIVYTVRGIM\nDTDYELTAQAFKALILHGEPEAGITGAYGATLITHIG\n#t93\nMLQSEGPYSSNGFGEFWKESMLKKWFSAVLDFYVDLATGVVIVLTLAGIM\nKWFRSNGALPFRELIVHKSQEAGITQAYGSDRLTHIG\n#t8\nMLLDKGPFSKDGFGEFWPISRLKRNGSAVLEFHVGSEALRVISLTEKGIM\nTTGYELTSQAFKALVLHGDDEAGIHGAYGATKITHVG\n#t9\nMLLEVGPFSADGFGEFWPQNRLKRDGSGVLQFHVTNKAEHLIGQTEKGIM\nDGGYELTAQSFKAITLHGKPEAGIAGQYGASKITHAG\n#t6\nMLIDGGPFSADGFGEFWPHRRLKRIGAVVLQFHVDNKSDRMIGITKKGIM\nTPGYEALAQPFKAILFHLRPEAGIDAAFGADKITHEG\n#t7\nMLVDDGPFSNDGFGEFWPLSRLKRDGSHVLEFEVPNETNKEITYTEMGIM\nATSYELTEQAFVALTLHGVPEAGITGAYGAAQITHVG\n#t4\nCLLDAGPFSRDGFGEFWPSSRLKRKGSSVLEFHVGNEVVRAIPLTEKGIA\nDTGYELTAQALKALLLHGDPEAGISGAYGVTKITHMG\n#t5\nMLADPGPYSKDGLGEFWKFKRLKRAFSSVLEFHVKSQSDRTISYTLKGIM\nSTGSSLTAMSFKALVLHGEKEAGIHGEYGAEKVTHVG\n#t2\nMLLDGGPFSKDGFGEFWPISRLKRTGSVVLEFHVNNCASQVIGPTEKGIM\nDTTHELSAQAFKALLLHGEPEAGTKGAYGATNITHIG\n#t3\nLLVDGGPFSQDGFGEFWPIDRLKNAGNVVLQMHVGNQAARPIGQTMKGIM\nENGWEASEKAFNAIGLHGSPEAGVVNCYGGPKLTHTG\n#t1\nMLLDRGPFSADGFGEFWPHNRLKRDGSGVLQFHVDNEAVRLIGSTEEGIM\nDNGYELEAQAFKAITLHGSPEAGITGTYGATKITHAG\n#t14\nPLIEIGPFSRDGSGDFWPSCRLKRIGSTVLQMHVANEAEKSISLTNKGIM\nETGFELTKLELKALAIHGGPEAGFNGAYGITAFTHLG\n#t15\nMLEDPGPYSKDGFGEFLKLKRLKRAFSNVLEFHVKSQSDRKISYTLTGIM\nSEGRSVTAISFKALLLHGDKEAGIHNEYGAEKVTHAG\n#t16\nLLSDSGPYSKDGFGEFWKQARLKRKFSKVLEFHVISKTERAIDQTLEGIM\nTAGSSLTGMAYKALKLHGEKEAGIRGNYGADEVAHLG\n#t17\nVLLDVGPFSKDGFGEFWPKSALKRSGNVVLKFHVGDQSVKIISLTENGIM\nQKGYELTSQAFAALVLHGEDEAGIHGPYGAKKITHKG\n#t10\nALIDLGPFSKDGYGEFWPHPKLKRDHAKVLEFPVINEVVRVIKLTKRGIA\nAGSYEVKAQAIKALPLHGETEGGIPGSYGAKSITHVG\n#t11\nLLRDIGPFSKDGFGEFWPNSRLKRGASRVLEFHVSNRQIQFIVLTDKGIM\nDIGLELTAATLKALALHGAPEAGIPMAYGVAKITHAG\n#t12\nMLADPGPYSKDGLGEFWKFKRLKRAFSSVLEFHVKSQSDRTISYTLKGIM\nSTGSSLTAMSFKALVLHGEKEAGIHGEYGAEKVTHVG\n#t13\nSLAEFGPFSRDGAGDFWPCCRLKRHGSSVLKFQVSKESLREISLTEKGIM\nETGYELTTLKLKALTLHGEPEAGFKAVYGVTKFTHTG\n#t18\nMLLDKGPFSKDGFGEFWPISRLKRNGSAVLEFHVGEEALRVISLTEKGIM\nTTGYELTAQAFKALVLHGEDEAGIHGGYGATKITHVG\n#t19\nALLDWGPFSKDGYGEFWPPDRLKRAGSSVLEFHVDNQALRAIKKTEKGIM\nEPGKELSAQTFKALELHGNAEAGINRLYGATKLSHIS\n#t29\nMLLDKGPFSKDGFGEFWPISRLKRNGSAVLEFHVGEEALRVISLTEKGIM\nTTGYELTAQAFKALVLHGEDEAAIHGGYGATKITHVG\n#t28\nMLLDHGPFSKDGFGEFWPVSRLKRTGSVVLEFHVNNEAAQVIGLTEKGIM\nDTTHELSAQAFKALSLHGEPEAGVTGAYGATNITHVG\n#t21\nFLLEYGPFSRDDFGEFWPVERLKRFGSYVLEFHVDVVLNHRIIVTDPGIM\nGTGTELAAQPFKALGTHGSPETGVPNGYGAQEPAHRS\n#t20\nQLRDLGPFSKDGYGEFWPDSRLKRRGSLVLGFHVATEADQVIGLTEDGIM\nDTLHEQSAQAIVALELHAQPEASVAGGYGATDITHDG\n#t23\nMLLDKGPFSADGFGEFWPHNRLKREGSAVLQFHVDNEAVRLIGSTEKGIM\nDNGYELTAQAFKAITLHGSPEAGITGTYGATKITHAG\n#t22\nMLLDDGAFSNDGFGEFWPISRLKRDGSVVLEFEVPNDLDRVIVYTVRGIM\nDTDYELTAQAFKALILHGEPEAGITGAYGATLITHIG\n#t25\nMLSDSGPYSKDGFGEFWKLARLKRRFSAVLEFHVESKTDRAISLTLEGIM\nSTGSSLTAMAFKALALHGEKEAGIRGHYGADKVTHVG\n#t24\nMLLDAGPFSKDGFGEFWPKSRLKRDGSAVLEFHVGNEVIRFISLTEKGIA\nDSQYELKAQALKALLLHGEPEAGITGDYGVTKITHLG\n#t27\nMLLELGPYSKDGFGEFWKLSRLKRCGSVVLEFHVKSEAKRVISLTEQGIM\nTTSTSLTAMAFKALALHGENEAGIHGQYGANKYTHRG\n#t26\nMLKDRGPFSADGFGEFWPHNQLKRAGSGVLQFHVNNKAQHTIGSTEKGIM\nTNGYESTAQAFKAILLHGSPEAGISGTYGATKITHAG\n#t49\nTLLDLGPFSRDDFGEFWPRQRLKRFADYVLEFHVEDEIADTITTTDPGIM\nDTGTELNAQPFPALCEHGKPEAGITDGYGADEVTHLG\n#t48\nELLDPGPFSKDGFGEFWPVSRLKRDKSEVLELNVGTEVMRFITLTTQGIA\nDIAYELTAEALKALTLHGIPEAGIIKGYGVTLLLHYG\n#t43\nILYTGGPYSSDGLGEFWKVTLLKEVGTYVLDFYVDWEENTIIVKTVPGIM\nAEVASLGALRFVELCIHGGQEAGIRHTYGRKRLAHWG\n#t42\nMLLDEGPFSKDGFGEFWPMSRLKRNGSAVLEFRVGSEAMRIISLSETGIM\nTTGYELTSQAFKALVLHGVAEAGTHEAYGATKETHAG\n#t41\nMLMNHGPFSKDGNGEFWPIMRLKKKRTWVLDFHVHQMTGRFISITKPGIM\nQTGSELSVQPVYALRLHAQDEAGIPGSYGAANVSHRG\n#t40\nMLLDRGPFSRDGFGEFWPHNRLKRDGSGVLQFHVNNKAKHTIGSTEKGIM\nDNGYESVAQAFSAILLHGSPEAGISGTYGATKITHTG\n#t47\nMLVDEGPFSNDGFGEFWPSSRLKRDGSTVLEFEVPNAIEGVISYTEMGIM\nDAGYELTMAAFKALPLHGEPEAGITGLYGATKITHIG\n#t46\nMLLELGPYSKDGFGEFWKFSRLKRCGSVVLEFHVKSEAARVIRLTEQGIM\nTKSSSLTAMAFKALVRHGENEAGIHGQYGANKYTHKG\n#t45\nMLLELGPYSKEGFGEFWKISRLKRAGSKVLEFHVKSEVHRGITMTSKGIM\nVKSSSLRAMKFTALVRHGKNEAGIQGYYGAKKFTHKG\n#t44\nLLRDIGPFSADGFGEFWPDSRLKRGASRVLEFHVSNRQIQFIVLTDKGIM\nDIGLELTAQTLKALAVHGAPEAGIPMAYGVAKITHEG\n#t38\nLLVDGGPFSQDGFGEFWPADRLKNRGNVVLQMHVGNQAVRFIGKTMKGIM\nENGVELSEKAFNAIGLHGSPEAGVVNCYGGPRLTHPG\n#t39\nMLRELGPYSKDGFGEFWKISRLKRCGPVVLEFHVRSEASRVIRLTQEGIM\nTTSHSLTAMAFKALAHHGENEAGIANKYGANAYTHGG\n#t36\nLLLDAGPFSKDGFGEFWPLARLKRDDSAVLEFHVGNEVIRFISLTEKGIA\nDTGYELGAIVLKALDQHGAPEAGIAGGYGVTKVTHLG\n#t37\nMLISCGDYSNDGFGEFWKRSMLGKGFSGVLDFYVGAAVGTHIVRTLTGIM\nAALVSLGAIAFMELVLHGGQEAGIITGYGAETIPHLG\n#t34\nMLVSCGPYSNDGFGEFWKGSMLKKGFSGVLDFYVNSAVGTHIILTLTGIM\nAALVSLGAIAFWELVLHGGQEAGIITGYGAERLPHHG\n#t35\nVLTDEGPYSKDGFGEFWKSARLKRNYSAVLEFSVVAKTAQLINLTLEGVM\nRSGRSLTAAAYNALQLHGEKEPGIPGDYGADDIAHLG\n#t32\nLLQDIGPFSKDGFGEFWPNSRLKRGASRVLEFHVSNRQIQFIVLTDKGIM\nEIGLELTAQTLKALALHGAPEAGIPMAYGVAKITHAG\n#t33\nMLLDEGPFSNDGFGEFWPLSRLKRDGSTVLEFEVPNELDRVIAYTEKGIM\nDTGYSLTAQAFKALALHGDPEAGITGAYGATQITHAG\n#t30\nALLEFGPFSRDGFGDFWPTCRLKRAGSAVLQFHVANEALRSISLTEKGIM\nETGYELTTLELKALRLHGEPEAGIKGSYGITKFTHLG\n#t31\nMLLKLGPYSKDGFGEFWKLSRLKRCGSAVLEFHVMSEANRIISLTVQGIM\nTTSTSLTAMAFKALSLHGENEAGIGGQYGANKYQHRG\n#t58\nMLLDKGPFSKDGFGEFWPISRLKRNGSAVLEFHVGSEALRVISLTEKGIM\nTTGYELTSQAFKALVLHGQDEAGIHGAYGATKITHVG\n#t59\nLLRDSGPFSADGFGEFWPNSRLKRKASRVLKFHVTNRELGLIIVTTAGIM\nEIGLELTAQTLKALGVHGSPEAGIPVAYGVEKITDDG\n#t50\nLLIDSGPFSKDGFGEFWPTSRLKRSASLVLEFHVANRKIRFIVLTEKGIM\nAVGLEVTAQTLKALLLHGAPEAGISVAYGVAKITHGG\n#t51\nMLLDRGPFSKDGFGEFWPLSRLKRDGSAVLEFHVGNEESRSISITEKGIM\nTTGYELAPQAFVALILHGEDEAGIHGGYGATKITHIG\n#t52\nMLLDNGPFSKDGFGEFWPVSRLKRTGSIVLEFHVNNLAGQVIGLTVKGIM\nDTTNELTAQAFKALALHGEPEAGVTGAYGATNITHAG\n#t53\nQLTEGGPFSKDGQGEFWPSTTLKRRGKEVLEFYVPSDSVNEIGITTGGIL\nPELRQAAAHTIGALIMHAGKELSVVKQYGAGGPAHFG\n#t54\nMLLDSGPFSKDGFGEFWPTSRLKRNGSAVLEFHVGNEVIRFISLTEKGIA\nDTGYELTTQALKALVLHGTPEAGITGSYGVTKITHLG\n#t55\nMLLQIGPFSEDAFGEFWPTTRLKRAGSEVLEFHVANDGVRSISLTEQGIM\nRTGYEITADPLKALALHGEPEAGIGQYYGVTERTHLG\n#t56\nMLLKTGPYSKDGFGEFWKLARLKRCGSAVLEFHVSSEASKIISTTVQGIL\nTTSMSLTAIAFKALTLHGKNEAGIGGQYGANKYQHRG\n#t57\nQLEEGGPFSKDGQGEFWPDTRLKRTGKEVLGFHVQTDPWNPIGVTTGGIM\nPELKQAAAHTIGALKLHAGKELSVIKKYGAGGPTHHG\n#t123\nMLKDEGPFSKEPSGEFWPASKLKRESSDVLSLHVSNEALGFISVQEQGIA\nDVGYELEGNALTALKIHSDPEAGISNDYGIKKATHMG\n#t122\nLLVDGGPFSQDGFGEFWPVDRLKNRGNVVLQMHVGNQAVRVIGKTMKGIM\nENGWELSEKAFNAIGLHGSPEAGVVNCYGGPRLTHTG\n#t121\nMLPDLGPFSKDPFGEFWPASKLKRAGSGVLALHVGNEASLIISITEKGIA\nDVGYELHASALSALVLHGSPEGGFKDGYGVKKATHLG\n#t120\nMLLDHGPFSADGFGEFWPHRRLKRIGAGVLQFHVETKSDRSIGYTKKGIM\nTPGYEALAQPFKAILFHLRPEAGIDQAYGADKITHEG\n#t69\nMLLRVGPFSEDGYGEFWPNTRLKRSGSTVLEFHVAHDGGRRIPLTEEGIM\nRQGAELFAQPLAALGLHGDTEAGVGKYYGVSERTHFG\n#t68\nMLLDKGPFSKDGFGEFWPISRLKRNGSAVLEFHVGSEALRVISLTEKGIM\nTTGYELTAQAFKALVLHGEDEAGIHGAYGATKITHVG\n#t65\nMLLDTGPFSRDDFGEFWPNQRLKRFGDAVLEFHVADPLDSNITTTEPGIM\nDTGGELAAQPFQALFSHGTPEAGITDSYGANEVTHKG\n#t64\nMLLEMGPFSADGFGEFWPQNRLKRDGSGVLQFHVTNKADHLIGQTEKGIM\nDNGYELTAQSFKAITLHGNPEAGIAGQYGATKITHAG\n#t67\nMLLDRGPFSKDGFGEFWPLSRLKRDGSAVLEFHVGNEESRKISITEKGIM\nTTGYELTPQAFVALILHGEDEAGIHGGYGATKITHIG\n#t66\nFLLEYGPFSRDDFGEFWPVGRLKRFGSYVLEFHVDVVLTHPVIVTEPGIM\nGSGQELAAQPFKALGTHGVRETGVPVNYGAQEPAHRS\n#t61\nALIEFGPFSRDGSGDFWPRCRLKRAGSNVLQFHVANEALRSISLTEKGIM\nETGYESTTLELKALNLHGEPEAGFKNGYGITKFTHLG\n#t60\nMLLDGGPFSKDGLGEFWPKDRLKRAGSKVLEFHVGSELEKYISLTERGIA\nDTGKELSAQALKALRLKGKPEAGITGGYGITKIIHLG\n#t63\nMLLDTGPFSRDDFGEFWPQQRLKRFGDGVLEFHVADPLDSNITTTEPGIM\nDTGGELAAGPFQALFSHGTPEAGIADSYGAHEVTHSG\n#t62\nMLLDAGPFSADGFGEFWPHRRLKREGSGVLQFHVQDKPEHDIGYTEKGIM\nTPGYESIATPFKAIWFHASPEAGIPEAYGANKITHPG\n#t116\nYLASLGPFSNDGFGEFWPTSRLKRLGSMVLEYEVTNAAQGIIDYTLMGIM\nEAGDELHMGIFAALKIHGEPEASIQGVYGATKIAHIG\n#t117\nTLLDIGPFSRDDFGEFWPKNRLKRFGDVVLIFHVEDDVPDNIEATDEGIM\nESGTELGAQPFPALCEHGQPEAGISDGYGADEVTHLG\n#t114\nMLLDAGPFSKDGFGEFWPLARLKRDGSAVLEFHVGNEVIRFISFTEKGIA\nDTGYELNAIALKALEQHGEPEAGIAGSYGVSKITHLG\n#t115\nALLEFGPFSRDGSGDFWPTCRLKRAGSCVLQFHVSNEAYRSISLTAKGIM\nETGYELTTLELKALGLHGEPEAGFKGRYGIIKFTHLG\n#t112\nLLRDYAPFSCDAFGEFWPHNRLKRYGGGVLQFHVNNSASHTIGSTEKGIM\nDNKFESLAEAFKAINLHGSPESGIAGNYGAFKITHTG\n#t113\nLLVEGGPFSQDGFGEFWPVDRLKNVGNTVLKVHVGSQSLRVINKTMTGIM\nEEGMELGEKAFNAIGLHGFPEAGVMNCYGGERLTHTG\n#t110\nLLSNYGPFSKDGFGEFWPLTRLKNTGSAVLEFHVASEATRDITLTKKGIM\nSTGHELTAQAFKALVLHGSDEAGIQGEYGAATISHIG\n#t111\nMLLQIGPFSEDGYGEFWPTTRLKRAGSAVLEFHVANDGVRAISLTEQGIM\nRTGYELTAQPLKALALHGEPEAGIGKYYGVKERTHLG\n#t118\nMLLELGPYSKDGFGEFWKLSRLKRCGSVVLEFHVKSEAKRVIRLTEQGIM\nTTSTSLTAMAFKALALHGENEAGIAGQYGANKYTHRG\n#t119\nMLLDRGPFSADGFGEFWPHNRLKREGSGVLQFHVNNEAVRLIGSTEKGIM\nDNGYELTAQAFKAITLHGSPEAGITGTYGATKITHAG\n#t101\nSLAEFGPFSRDGDGDFWPACRLKRHGSTVLKFQVSKESHRAISLTEKGIM\nATGYELTTLKLKALTLHAEPEAGFKVVYGVTKFTHTG\n#t100\nALEDAGPYSKDGFGEFLKLARLKRCFSEVLDFHVKSQSPREISYTLTGIM\nSDGSSVTALSFKALALHGEKEAGIHEYYGADKITHAG\n#t103\nSLSNSGPYSKDGFGEFWKMARLKRKFSAVLEFHVKSKSERTISFTLEGIM\nSTGSSLTAMAFKALDLHGEKEAGIHGEYGADKVTHVG\n#t102\nALIEFGPFSRDGSGDFWPTCRLKRAGSAVLEFHVANEALRLISLTEKGIM\nETGYELTTLELKALRLHGEPEAGFKRSYGITKFTHLG\n#t105\nFLLEQGPFSRDMFGEFWPMGRLKRGGSYILEFHVDVVLTHPVIVTEPGIM\nGSGEELAAQPFKALGKHGARETGVPVNYGAQEPAHRS\n#t104\nALLEFGPFSRDGSGDFWPTCRLKRAGSAVLQFHVANEALRSISLTEKGIM\nETGYELTTLELKALRLHGEPEAGFKGSYGITKFTHLG\n#t107\nMLLDAGPFSKDGFGEFWPTSRLKRAGSTVLEFHVDNEAIRVISLTEKGIM\nEPGEELTAQTFKALNLHGQPEAGITRLYGAVKLTHLS\n#t106\nMLLDEGPFSNDGFGEFWPLSRLKRDGSTVLEFEVPNELRRVISYTEKGIM\nDTGYELTAQAFKALALHGEPEAGITGAYGATQITHLG\n#t109\nMLLDLGPFSKDGFSEFWPDSRLKRNGSPVLEFHVGPEAYRFISLTEKGIA\nDTDYELTAAALKGLLLHGEPEAGITGGYGVTKITHLG\n#t108\nMLLDAGPFSKDGFGEFWPTSRLKRLGSSVLEFHVGNEAIRTISLTEKGIM\nDTGYELTAQALKALLLHGEPEAGITGGYGVTKITHLA\n\n\n((((t30:0.06128886105((t46:0.05643295036t67:0.04002395966):1.043417326t97:0.6958460188):0.2649557619):0.006293993578(((t44:0.003368254296t84:0.008199588108):0.0533784077t91:0.1044291171):0.2013125338((t18:0.10550802t17:0.0482739277):0.001411338786(t58:0.02251044266(t63:0.1168411716t12:0.1164033587):0.06846848477):0.09161538966):0.0388488274):0.09064807729):0.05507304869(((t71:0.02683306387(t51:0.5740386912t62:0.02209159976):0.01497015801):0.482023497(((t5:0.2752470871t66:0.2501176492):0.0521743043((t95:0.007308479069t22:0.6022031231):0.02848296875t101:0.7061056009):0.001836935949):0.0001221302746((t93:0.05083092496t52:0.2160712202):0.01697310188((t102:0.01082158297t76:0.165966292):0.005205516437t64:0.4832296414):0.01560801485):0.5717746509):0.4642109101):0.01040795752(((((t103:0.01884871503((t11:0.02748707255t81:0.04641617769):8.263870822e-05(t23:0.01549888274t13:0.1102522311):0.01661339073):0.4330633582):0.1025723422((t56:0.4472140296t16:0.7991120944):0.3183020548t39:0.007845066096):0.2764301943):0.05381094513t37:0.0008020861176):0.239242797((((t55:0.778468197t100:0.02503234143):0.236457907(t73:0.1398231296t31:0.643977826):0.0005129893453):0.06633131192t88:0.03243553065):0.02942688864((t72:0.0005535571345t38:0.1147076385):0.3399728315t15:0.06582329439):0.1574418368):0.1010311592):0.1602652603t7:0.137687442):0.4958280439):0.1286750993):0.06556727842((((t8:0.007674722024t94:0.9714182037):0.4069592365t3:0.108701495):0.001684957879(t20:0.1994333944((t61:0.442678971(t45:0.1018637423(t2:0.04086669763t6:0.003437251179):0.02679617221):0.2791636233):0.1735783363t98:0.001063296716):0.06458293007):0.0007121864472):0.1246757375((t42:0.8656193891(((t74:0.06127408719(t10:0.01759513444t41:0.1092864811):0.08012800171):0.625150411((((t1:0.5659729302t59:0.01747911258):0.0004882752631t78:0.4661104423):0.6578105785((t83:1.164807369((t50:0.2283634984t99:0.009778392144):0.01621243869t89:0.01383891957):0.003076485061):0.3535294813t48:0.03625033067):0.009040826952):0.0005671825124t34:0.004681006626):0.1004969324):0.01254124109t25:0.220966534):0.05734308373):0.08460289499((((((t75:0.08145381954t77:0.5524964361):0.08083574726t36:0.009966392659):0.01426628381(t43:0.03784791855(t47:0.1030796405t68:0.86501697):0.002149320454):0.1038942478):4.949734823e-05(t14:0.05599542683(t40:0.07186896086t65:0.0006343160513):0.0454494709):0.0330489629):0.3260031302((t32:0.05329042532t85:0.7207788066):0.001832810976((t28:0.6722918675t82:0.1931474979):0.134432572((t69:0.6107655066t9:0.2061540277):0.02450226246t92:0.01006202265):0.03568312252):0.0009549465448):0.01835047912):0.0602516551(((((t27:0.006340748925(t96:0.03770839403(t86:0.001826438123t87:1.257438581):0.7102420208):0.02940181435):0.7317064175t35:0.02135674737):0.06544050965t60:0.5854702654):1.150403575(((t54:0.02756702913(t70:0.4383079104t90:0.3628734939):1.988436196):0.003809037953((t24:0.6101696443t57:1.063792268):0.2516757552t4:0.09059568285):0.311331975):0.02554446229(t21:0.08017676247t79:0.2587699644):0.0009845480288):0.06935659544):0.08688569421((((t26:0.2027515752t49:4.876143239e-06):0.02162421968t19:0.0210271577):0.1673107233t33:0.01031840313):0.001086499927((t29:0.01015961064t80:0.0129610141):0.008929938461t53:0.06726909436):0.001682009408):0.000369231914):0.2953044464):0.7087512844):0.1814871951):0.1118680931)";
DataSet protein_gtr.msa.2 = ReadFromString (_tdsstring_);
_tdsstring_=0;
_tdsstring_ = "#t89\nSFIAKDWGFFVAVGRKVANSKAPVLVQETIARWRRNRPVFEDAVQKVGAF\nLDNYQIQSKVSLEGGPDVGIIGDMI\n#t88\nSMIAKDWDLAVAVGLKIANSEPPILLKQRVAHGFALFEVDEDTVSLSKAF\nLDPYQIQLDVGLAKSLDVAIIATQI\n#t87\nSMPAEDWDLVVAVGRKVAGSKAPILYLHTIAHGGLDGLVTEHTVQVADDL\nPDKYTAQMNVGLAGRADVVIIGSKG\n#t86\nSMIAKDWDAVVAVGRKVLNSAPPILLVQPVAHANPCWSVVEDTVILKEAF\nIDRYQHQLDVGLAGDSDVSIIGTRV\n#t85\nSYFAKDWGFVVAVGRKVANSKAPILVKESIARWCPHQDVKEDAVVKKRKI\nLDEYQVQSKVNLEGNSDVGIIGDML\n#t84\nSFVAKDWGFVVAVGRKVANSKAPVLTQETIARWKRRLNVQEDAVSKNGAF\nLDNYQVQSPVNLEGEADVGIIGDMI\n#t83\nSFIAKSWMFLVAVGRKVANSKAPVLVRETIARWERKFPVNEDSVNKAGAF\nLDNYQIQSKVDLEGGPDVGIIGDMI\n#t82\nSMIAKDWDLKVAVGRKVANSEPPILLRQPVAHGYPKWSVNEDTVVLQDTF\nMDKYQNQLNVGLAGALDVSIIGTQV\n#t81\nSMLAVDWNLKVAVGRKIANKQVPILLRTIIAHSVADIYVTEDSVAVRAAT\nLDRIQIQISVALSGNCDVGIIGTKV\n#t80\nSMIPREWDLEVAVERKTANSKPPILGTEPVAHGGPPGSVGEDNVSLKSKL\nSDKYQIQMVVPLSSALDVGIIGDKI\n#t72\nSFIAKDWGFLVAVGRKVANSKAPVLVYEDIARWNREVPVYQDAVSRAGPF\nEDSYPLQSKVDLEGGSDVCIIASKI\n#t73\nSMQADEWDFDVAVGRKVVNSKAPILVTDGVAHEWKGLSVKEESVHLKSDD\nIDSYNLQTKVALSRFMDVGVVGTKI\n#t70\nSMIAKDWNLKVAVGRKIANKQVPILLREIIAHNAADLYVAEDSVAVRDAT\nLDKIQIQISVALSGPCDVAIIGTKV\n#t71\nSMIAEEWDLEVAVGRKVANSKPPILLKEPVAHGGPTLTVREDTVSLKTAF\nIDKYQLQMVVPLSGVWDVGIIGTMI\n#t76\nSIIATDWDLKVAVGRKVANSTAPILLREPVAHGWPELAVHEDTVPLSEKF\nVDKYSLQMTVGLSGFLDVGIIGTMI\n#t77\nSMIAEDWDFKVAVGRKVANKKAPILLRRTVAHGAHSVKVGDDTVPLKNAL\nYDKYQLQKTVGLSGLSDVGIIGTKI\n#t74\nSMIAEDWDLKVAVGRKVSNSRAPILLAEPVAHGSPSAPVTEDTVPLKGAA\nIDKYQLQMTVGLSGSLDVGIIGTMI\n#t75\nSFVAKDWGFVVAVGRKVANSKAPVLTQEMIARWKRRLDVQEDAVSKAGAF\nLDNYQVQAKVNLEGQPDVGIIGDMI\n#t78\nSMIAEDWDLKVAVGRKISNSRKPILLAEPVAHGYPTGQVTEDTVPLKLPA\nIDKYKLQMTVGLFGGKDVGIIGTMI\n#t79\nSIIATDWDTEVAVGRKVVNSTEPILLREPVAHGWPKLSVQEDTVPLKEKL\nVDNYIIQMTVGLYGFLDVGIIGTSI\n#t98\nSMIATDWDLKVAVHRKVAHSTVPILLREELAHDKPEKPVSEDTVELLEKY\nIDQYSLQMTVGLNGKLDVAIICTMI\n#t99\nSFVAKDWGFVVAVGRKVANSKAPVLTQETIARWKPRLNVQEDAVAKAGAF\nIDNYQIQSKVNLEGEPDVGIIGDMI\n#t94\nSMIANDWDLKVAVGRKVANSDPPILAEQVIAHGSVTERVKEDAVVLKQGM\nHDKYDKQLDVGLAGIWDVSIIGTQV\n#t95\nSMQADEWDFDVAVGRKVVNSREPILVTRRVAHEWKGRCVAEEQVHLHAEA\nSDAYNLQAKVVLSKYRDVGVVGRKV\n#t96\nSMIAKDWNLKVAVGRKIANKQVPILLREIIAHNAADLYVAEDSVAVRDAT\nLDKIQIQISVALSGPCDVAIIGTKV\n#t97\nSMIADDWDMKVAVGRKVANSKAPILLREPVAHGFPTLPVTEDTVPLKDAF\nVDKYKQQMTVGLSGPLDVGIIGTMI\n#t90\nSMIAEDWDLKVAVGRKVANSKAPILLRETTAHGAHTLPVTEDTVALKDNV\nIDKLQLQMTVGLSGPLDVGIIGTKI\n#t91\nSVIAAEWDLTVAVSEKVDNSEAPILIEKTAAHGGAARRVIEEVVHTADQY\nADPYQMQMTVTLSGQEDVGIIATKI\n#t92\nSMIADEWDQKVAVGRKIANSKSSILMGEPVAYCHGQISVVEETVPLKDAP\nIDKYRDQMVVFLSGPVDVGIIGTMI\n#t93\nSMIAKDWDLKVAVGRKVANSEPPILLKQPVAHGFPCWPVNEDTVVLKEAF\nMDKYQNQLDVGLAGTLDVSIIGTQV\n#t8\nSFQADEWDFDVAVGKKPMNSREPILVTKGEAHEWKDVAVQEENVHLHADD\nSDAYNLNAKVALSRLLEVGVVGSKL\n#t9\nSFFAKDWGFVVAVGRKVANSKAPVLVQETIARWCPRLNVQEDAVVKKGAF\nLDEYQVQSKVNLEGSPDVGIIGDML\n#t6\nSMIAGDWDLKVAVGRKISNSRAPILLAEPVAHGSPSGEVTEDTVPLKGAA\nIDKYQLQMTVGLFGAKDVGIIGTMI\n#t7\nSMIAEDWDLKVAVGRKVSNSRAPILLAEHVAHGSPSGPVVEDTVPLKRAA\nIDKYQLQMTVGLSGSLDVGIIGTMI\n#t4\nSFVAKDWGFVVAVGRKVANSKAPVLTQEMIARWKRRLDVQEDAVSKAGAF\nLDNYQVQAKVNLEGQPDVGIIGDMI\n#t5\nSFVAKDWGFVVAVGRKVANSKAPVLTQETIARWKPRLNVQEDAVAKAGAF\nLDNYQVQSKVNLEGEPDVGIIGDMI\n#t2\nSMIAEDWDLEVAVGRKVANSKAPILLRETTAHGAHTIPVNEDTVALKDNV\nLDELQLQMTVVLSGPLDVGIIGTKI\n#t3\nSMIAEDWDLKVAVGRKVANKKAPILLPEILAHGAHTLHVEEDSVALKDAV\nVDKLQLQMSVALSGALDVGIIGTKI\n#t1\nSMIATDWNLRVAVGRKIANKQVPILLNPLIAHNAAEQYVAEDAVAVRNAT\nVDRLQIQISVALSGDAGVAIIGTKV\n#t14\nSFIAKSWGFLVAVGRKVANSAAPVLVRVTIARWRYDFPVKEDAVNKAAAF\nIDHYQIQSKVDLEGAPDVSIIGDML\n#t15\nSMIAKDWDLKVAVGRKVANSEPPILLRQPVAHGYPKWSVNEDTVVLKEAF\nMDKYQNQLDVGLAGTLDVSIIGTQV\n#t16\nSMQADEWDFDVAVGRKVVNSREPILVTQGVAHEWKGLAVKEENVHLHKDD\nSDAYNLQTKVALSRFMDVGVVGTKI\n#t17\nSMIAEEWDLDVAVGRKVANSKPPILRTEDVAHGSPKLNVGEDTVSLKSSL\nIDRYQIQMVVPLGGTHDVGIIGTKI\n#t10\nSMTAKDWDLDVAVGRKVENSEPPILLQQPVAHGFITWVVGEDTVVLKEVL\nVDQYQQQLDVGLARTGDVSIIGTQV\n#t11\nSIIATDWDTKVAVGRKVINSTEPILLRASVAHGWPQPKVSEDTVPLRENL\nVDTYILQMTVGLYGFLDVGIIGTSI\n#t12\nSMIAKDWDLKVAVGRKVANSEPPILLKQPVAHGFPCWTVKEDTVVLKESF\nMDKYQNQLDVGLAGTLDVKIIGTQV\n#t13\nSMIAKDWDLKVAVGRKVANSEPPILLKQPVAHGLPRWTVNEDTVVLKEAF\nMDKYQKQLDVGLAGTLDVSIIGTQV\n#t18\nSMIAKDWDQKVAVGRKVANSEPPILLKQPVAHGFTKWVVNEDTVVLKEAF\nMDKYQSQLDVGLAGKLDVSIIGTQV\n#t19\nSFIAKDWGFVVAVGRKVANSKAPVLVQETIARWKRNMPVQEDAVNKAGAF\nLDNYQIQSKVDLEGGPDVGIIGDMI\n#t29\nSFIAKDWGFVVAVGRKVANSKAPVLVQETIARWKRNMPVQEDAVNKAGAF\nLDNYQIQSKVDLEGGPDVGIIGDMI\n#t28\nSMIAEDWDLDVAVARKVRNSKPPILRTTEVAHGGPEMNVGEPTVRVKSTL\nVDEYSAQMVVPLGGAQDVGIIGTKI\n#t21\nSMIAEDWDLEVAVGRKVANSKAPILLRDTTAHGAHTIPVNEDTVALKDNV\nLDELQLQMTVVLSGPLDVGIIGTKI\n#t20\nSMIAKDWKLEVAVGRKITNKKVTILLRDMIAHYAYGIFVAESSVAVAPPA\nLDKIWVQIKVALSGRSDVAIIGTKL\n#t23\nSMQADEWDFDVAVGRKVVNSREPILITQGVAHEWRGLAVKEENVHLHADD\nFDAYNLQTKVALSRFMDVGVVGTKI\n#t22\nSMPAEDWDMWVAVGRKVAGSKAPILILHTIAHGGADARVDEHLVQFADSL\nPDRYTVQMDVDLSGTADVVIIGSKG\n#t25\nSFVAKDWGFVVAVGRKVANSKAPVLTQEMIARWKRRLDVQEDAVSKAGAF\nLDNYQVQAKVNLEGQPDVGIIGDMI\n#t24\nSMIATDWDLKVAVGRKVANSTVPILLREQVAHGRAKLQVGEDTVPLSEKF\nVDKYDLQMTVGLSGTLDVAIICTMI\n#t27\nSMPPEDWDLKVAVGRKVVNSKAPILLQEEVAHGKTLKPVRESTVSLTDAS\nQDNYQVQMTVQLSGKIDVVIIGTKI\n#t26\nSMIAEDWDLQVAVGRKVANKKAPILLRKTVAHGAETKSVDEDSVSLKDAV\nIDKLQLQMSVALSGPLDVGIIGTKI\n#t49\nSMPAEDWDLVVAVGRKVAGSKAPILYLHSIAHGGPAGKVKEHTVQLWDGI\nADEYKVQMNVGLSGSGDVIIIGSKG\n#t48\nSMQADEWDFDVAVGRKVVNSREPILVTQGVAHEWKGLAVKEENVHLHADD\nFDAYNLQTKVALSRFMDVGVVGTKI\n#t43\nSMPAEDWDLVVAVGRKVAGSKAPILYLHAIAHGGPAGTVNEHTVQLADGI\nSDKYKVQMNVGLSGQADVVIIGSKG\n#t42\nSMIAEDWDLEVAVGRKVANSKPPILLKEPVAHGGPFLMVTEDTVSLKTAL\nIDKYQIQMVVPLSGKYSVGIIGTMI\n#t41\nSFVAKHWGLVVAVGRKLGNSKAPVLTREAIARFRNKDRVSEDAVVKDGSI\nDDGYKIQAKVHLEGDQDVGIIGDMY\n#t40\nSFFAKDWGFVVAVGRKVANSKAPVLVQEAIARWCPRLNVQEDAVVKKGAF\nLDEYQVQSKVNLEGDSDVGIIGDML\n#t47\nSMIAEDWDLKVAVGRKISNSRKPILLADPVAHGYPGGQVPEDTVPLKLKA\nIDKYKLQMTVNLFGAEDVGIIGTMI\n#t46\nSMIAEDWDLSVAVGNKVANSQAPILLGQTTAHGGPEKIVSEDTVPLKDVD\nSDQYQIQMTVALSGPIDVGIIATKI\n#t45\nSFVAKNWGFLVAVGRKVANSKAPVLQSAVLARRKAFIRVTENAVLKRTSF\nEDGYKPQSKVDLEKLHDVGIIGDMV\n#t44\nSMIAKDWDLDVAVGRKVANSEPPILLQRPVAHGFVLWTVGEDTVVLKEAF\nMDKYQQQLDVGLARTEDVSIIGTQV\n#t38\nSFVAKDWGFVVAVSRKVANSKAPVLQQETIARYARGTDVEEDAVLQAAAS\nLDNYKIQSKVNLGGFPDVGIIGDMV\n#t39\nSFVAKDWGFLVAVGRKVANSKAPVLQIAVLARRDALIRVTENAVLKRASF\nIDGYKPQSKVDLEKLVDVGIIGDMV\n#t36\nSMIAEDWDLKVAVGRKVANSKPPILLKEPVAHGVPRLPVTEDTVPLRDAF\nVDKYQLQMTVGLSGTLDVGIIGTMI\n#t37\nSMIARDWNLNVAVGKKIANKPVPILLRESIAHSTVELHVVEDSVAVRDAA\nVDRIQIQISVSLLGPCDVAIIGTKV\n#t34\nSMIAKVWDLAVAVDLKAANSWPPILRSKGQAHPSAPIFVAEDTAILAESY\nPDPYRLQCDVGLAATNDAAIIATQA\n#t35\nSMIAEDWDLKVAVGRKVANKKAPILLPEIVAHGAQTLHVAEDSVALKDAV\nIDKLQLQMSVALSGPLDVGIIGTKI\n#t32\nSAIGEDRSLDVAVGRKGKNSEPPILQIWDVAQGGTVLEVVEPTTILGKKV\nFDGYGSQLVVALGGTHDVGLIGTKV\n#t33\nSMIASDWDLKVAVGRKVFDSDPPILAERAIAHGPTIYAVKEDAVILPQGQ\nHDKYEKQLDVGLTGPNDVSIIGTQV\n#t30\nSMIAKDWDPIVAVGQKVSVKKDPILLPKTVAQGDQVYPVTEDSVPLLEPA\nVDGLQIQIKVALSGELDVGIIGTKI\n#t31\nSMIAEEWDLEVAVGRKVANSKPPILQKEPVAHGGSTLTVREDTVSLMTAF\nIDKYQLQMVVPLSGVWDVGIIGTMI\n#t58\nSMQADEWDFDVAVGRKVVNSREPILVTRRVAHEWKSLAVAEEQVHLHAEA\nSDAYNLQAKVVLSKYMDVGVVGTKI\n#t59\nSMQADEWDFDVAVGRKVVNSREPILVTRRVAHEWKGRCVAEEQVHLHAEA\nSDAYNLQAKVVLSKYRDVGVVGRKI\n#t50\nSMIAEDWDLKVAVGRKQANSKPPILLKEAVAHGIPTLPVTEDCVALKDAL\nSDRYQLQMKVRLSGALDVGIIGTMI\n#t51\nSMIAEDWDLKVAVGRKVAVKKDPILLPETVAHGLQTLHVTEDSVPMSEAA\nVDGLQLQMKVALSGHVDVGIIGTKI\n#t52\nSIIASDWDITVAVGRKVANSTAPILLRDKVAHGYPELRVNEDTVPLSNEF\nKDKYTLQTTVGLSGFFDVGIIGTMI\n#t53\nSFVAKDWGFVVAVGRKVANSKAPVLTQETIARWNPRIDVKEDAVGKVGAF\nLDNYQVQSKVNLEGQLEVGIIGDMI\n#t54\nSFVAKDWGFLVAVERKVANSKAPVLQIAVLARRNALMRVTENAVLKRASF\nIDGYKPQSKVDLEKLVDVGIIGDMV\n#t55\nSIIATDWDTKVAVGRKVINSTEPILLREPVAHGWPQLSVQEDTVPLREKL\nVDKYILQMTVGLYGFLDVGIIGTSI\n#t56\nSMIATDWDLSVAVHRKVANSTVPILLREKLAHGTPEYTVGEETVQLLDTY\nLDKYSLQMTVMLSGKADVAIICTMI\n#t57\nSMIAKDWDLKVAVGRKVANSEPPILLKQPVAHGLPRWTVNEDTVVLKEAF\nADKYQKQLDVGLSGDLDVKIIGTQV\n#t69\nSMIAEDWDLKVAVGRKVVVKKDPILLPETVAYGLQTQHVTEDSVPLSEGA\nVDGLQLQMKVALSGHVDVGIIGTKI\n#t68\nSMIPEEWDLEVAVGRKVANSKPPILLKEPVAHGGPKLTVGEDTVSLKSKL\nVDKYQVQMVVPLSGDWDVGIIGTKI\n#t65\nSMIAKDWNLKVAVGRKIANKQVPILMREIIAHNAVAFYVVEDSVAVRELT\nLDHIQIQINVELSGPCDVAIIGTKV\n#t64\nSIIAIDWDLEVAVGRKVANATAPILLRDPVAHGAPAFAVNEDTVPLVDKF\nVDSISLQMSVHLSGYLDVGIIGSMI\n#t67\nSVIAEDWDLKVAVKRKVANSKAPILLRETVAHGAHTEPVTEDTVPLKDAV\nVDSYNLQMTVGLDGSLDVGIIGTKI\n#t66\nSMIATDWDLKVAVHRKVAHSTVPILLREQLAHNKPNKVVSEDTVELLEKY\nIDQYSLQMTVGLNGKVDVAIICTMI\n#t61\nSMIAKDWDLKVAVGRKVANSEPPILLKQPVAHGFPCWTVNEDTVVLKEAF\nMDKYQNQLDVGLAGTLDVSIIGTQV\n#t60\nSMIAEDWDLKVAVGRKVANSKPPILLKEPVAHGVPRLPVTEDTVRVKDAF\nVDKYQLQMTVGLSGTLDVGIIGTMI\n#t63\nSMQADEWDFDVAVNRKVVNSREPILVTQGVAHEWKGLAVREEGVQLHADD\nADAYNMQTKVALARYIDVGVVGTKI\n#t62\nSMPPEDWDLKVAVGRKVINSKAPILLQEQVAHGGTIKPVRESTVSLTDAS\nQDNYQVQMTVQLSGKVDVVIIGTKI\n#t116\nSMQADEWDHDVAVGRKVVNSKAPILVTDGVAHQTKGLPVIEESVHLKSQD\nIDSYNLQTKVALSRFMDVGVVGTKI\n#t114\nSIIATDWDLKVAVGRKVANSTAPILLREPVAHGWPELAVHEDTVPLSEKF\nVDKYSLQMTVGLSGMLDVGIIGTMI\n#t115\nSMQADEWDFDVAVGRKVVNSKAPILVTDGVAHEWKGLSVKEESVHLKSDD\nIDSYNLQTKVALSRFMDVGVVGTKI\n#t112\nSMIAKDWDLKVAVGRKVANSEPPILLKQPVAHGFPRWTVNEDTVVLKEAF\nMDKYQNQLDVGLAGTLDVSIIGTQV\n#t113\nSFVAKDWGLVVAVGRKLANSKAPVLTRESIARFHGEIQVQEDAVLKEGGF\nSDNYQVQAKVRLEGEEDVGIIGDMI\n#t110\nSMIAEEWDLDVAVGRKVANSKPPILRTEDVAHGGPKLNVGEDTVSLKSSL\nIDRYQIQMVVPLGGTYDVGIIGTKI\n#t111\nSFNAKDWGFVVAVGRKVANSAAPVLVQETIARWKRDKPVQEDAVNKAHAF\nLDNYHIQSKVDLEGGPDVGIIGDMI\n#t101\nSMPAEDWDLKVAVGTKVASSKAPILYRHAIAHGGTSGQVEESTWPLEDLA\nADKYQVQMTVGLSGSADVVIIGSKN\n#t100\nSMIKEDWDLKVAVGRKVANSKPPILLKEPVAHGVPRLGVTEDTVPLKDAF\nVDKYQLQMTVGLSGTLDVGIIGTMI\n#t103\nSMIAEDWDLEVAVGRKVANSKAPILLRETTAHGAHTIAVNEDTVALKDNV\nLDELQLQMTVVLSGPLDVGIIGTKI\n#t102\nSIIATDWDTKVAVGRKVINSTEPILLREPVAHGWPQLRVKEDTVPLREKL\nVDDYALQMTVGLYGFFDVGIIGTSI\n#t105\nSMIAKDWNLKVAVGRKIANKQVPILLREVIAHNAADLYVAEDSVAVRETT\nLDKIQIQISVALSGPCDVAIIGTKV\n#t104\nSIIATDWDTKVAVGRKVANSTAPILLREPVAHGWSELAVHEDTVPLREKF\nVDKYIMQMTVGLHGFLDVGIIGTMI\n#t107\nSMIAEDWDLKVAVGKKISNSRAPILLAEPVAHGSPEGQVPEDTVPLKETA\nMDKYQLQMTVGLFGAEDVGIIGTMI\n#t106\nSFIAKDWGFFVAVGRKVANSKAPVLVQETIARWRRIRPVFEDAVQKVGAF\nIDKYQIQSKVSLEGVVDVGIIGDMI\n#t109\nSMIARDWNLNVAVGKKIANKPVPILLRESIAHSTVELHVVEDSVAVRDAA\nVDRIQIQISVSLLGPCDVAIIGTKV\n#t108\nSMIAEDWDLKVAVGRKVANSKAPILLRETVAHGANTLPVTEDTVPLKDAV\nIDKYQLQMTVGLSGPLDVGIIGTKI\n\n\n((((t30:0.06128886105((t46:0.05643295036t67:0.04002395966):1.043417326t97:0.6958460188):0.2649557619):0.006293993578(((t44:0.003368254296t84:0.008199588108):0.0533784077t91:0.1044291171):0.2013125338((t18:0.10550802t17:0.0482739277):0.001411338786(t58:0.02251044266(t63:0.1168411716t12:0.1164033587):0.06846848477):0.09161538966):0.0388488274):0.09064807729):0.05507304869(((t71:0.02683306387(t51:0.5740386912t62:0.02209159976):0.01497015801):0.482023497(((t5:0.2752470871t66:0.2501176492):0.0521743043((t95:0.007308479069t22:0.6022031231):0.02848296875t101:0.7061056009):0.001836935949):0.0001221302746((t93:0.05083092496t52:0.2160712202):0.01697310188((t102:0.01082158297t76:0.165966292):0.005205516437t64:0.4832296414):0.01560801485):0.5717746509):0.4642109101):0.01040795752(((((t103:0.01884871503((t11:0.02748707255t81:0.04641617769):8.263870822e-05(t23:0.01549888274t13:0.1102522311):0.01661339073):0.4330633582):0.1025723422((t56:0.4472140296t16:0.7991120944):0.3183020548t39:0.007845066096):0.2764301943):0.05381094513t37:0.0008020861176):0.239242797((((t55:0.778468197t100:0.02503234143):0.236457907(t73:0.1398231296t31:0.643977826):0.0005129893453):0.06633131192t88:0.03243553065):0.02942688864((t72:0.0005535571345t38:0.1147076385):0.3399728315t15:0.06582329439):0.1574418368):0.1010311592):0.1602652603t7:0.137687442):0.4958280439):0.1286750993):0.06556727842((((t8:0.007674722024t94:0.9714182037):0.4069592365t3:0.108701495):0.001684957879(t20:0.1994333944((t61:0.442678971(t45:0.1018637423(t2:0.04086669763t6:0.003437251179):0.02679617221):0.2791636233):0.1735783363t98:0.001063296716):0.06458293007):0.0007121864472):0.1246757375((t42:0.8656193891(((t74:0.06127408719(t10:0.01759513444t41:0.1092864811):0.08012800171):0.625150411((((t1:0.5659729302t59:0.01747911258):0.0004882752631t78:0.4661104423):0.6578105785((t83:1.164807369((t50:0.2283634984t99:0.009778392144):0.01621243869t89:0.01383891957):0.003076485061):0.3535294813t48:0.03625033067):0.009040826952):0.0005671825124t34:0.004681006626):0.1004969324):0.01254124109t25:0.220966534):0.05734308373):0.08460289499((((((t75:0.08145381954t77:0.5524964361):0.08083574726t36:0.009966392659):0.01426628381(t43:0.03784791855(t47:0.1030796405t68:0.86501697):0.002149320454):0.1038942478):4.949734823e-05(t14:0.05599542683(t40:0.07186896086t65:0.0006343160513):0.0454494709):0.0330489629):0.3260031302((t32:0.05329042532t85:0.7207788066):0.001832810976((t28:0.6722918675t82:0.1931474979):0.134432572((t69:0.6107655066t9:0.2061540277):0.02450226246t92:0.01006202265):0.03568312252):0.0009549465448):0.01835047912):0.0602516551(((((t27:0.006340748925(t96:0.03770839403(t86:0.001826438123t87:1.257438581):0.7102420208):0.02940181435):0.7317064175t35:0.02135674737):0.06544050965t60:0.5854702654):1.150403575(((t54:0.02756702913(t70:0.4383079104t90:0.3628734939):1.988436196):0.003809037953((t24:0.6101696443t57:1.063792268):0.2516757552t4:0.09059568285):0.311331975):0.02554446229(t21:0.08017676247t79:0.2587699644):0.0009845480288):0.06935659544):0.08688569421((((t26:0.2027515752t49:4.876143239e-06):0.02162421968t19:0.0210271577):0.1673107233t33:0.01031840313):0.001086499927((t29:0.01015961064t80:0.0129610141):0.008929938461t53:0.06726909436):0.001682009408):0.000369231914):0.2953044464):0.7087512844):0.1814871951):0.1118680931)";
DataSet protein_gtr.msa.3 = ReadFromString (_tdsstring_);
_tdsstring_=0;
_tdsstring_ = "#t89\nCEISLSKKFGLSDTQTLSVRAAFVGSVPAVSKTVGSLDANDGGGDLVDKP\nALDYLIHITVAHRRTEGLEKFKQDSKLGFNRPNMH\n#t88\nSNISISPAYEVSLPKAVSCESEFDAAVPPISKSKGLLTANDGGGTLPDKP\nSDDGLVHITVIHRCREGLAYFKKAPKRGYNRKQSH\n#t87\nSGSNYSTGYAYHISVYRSRYEPFRTDVVEVSKFLGPLTATSGGGKLRDKA\nEKDIIGHKSVPHRIREGDPLVYSDSKDGPNSAFVH\n#t86\nSETNKSSGYCSHGDDALSKFAPFETRVPEVSKLIGALTATSGGGILADKS\nETDLIGHKYVAHRREEGDAVVYQDSKDGPNSTKKH\n#t85\nSDIAGSPNYDTHMPQGYSVVTLFCTAVPAISKVEGDLEPAHGKGALLDKT\nSKFRLVHSRIAHRNAEGLWKFKNESKLGLNRVRKH\n#t84\nSEISASPSYVAHRPRLASVVTGFTAAVPPISKALGVLDANDGGGQLIDKP\nSMDALVHIVVSHRRFEGLVRVVQDSKLGYNRPTSH\n#t83\nCVISLSKKFGEGEEHKLSVEAAFAATVGTASKTVGALNATDGGSMLLDKL\nALDKLIHKAVKHRATEGLDQLPQDAKLGYNEPFMH\n#t82\nSDIAKSKSYGEDSPKTYSVTARFPTSVPAISKLQGPLEATGGKGDLWDKT\nSVDPLIHITVKHRRAEGLGLFEQDSKLGLNRLKSH\n#t81\nSHISLSSKYPNNQDKTLSCASSFDAGVPPISKSLGALDANDGGGALFDKS\nSDDGLPHSNALHRAIEGLAYFANASKSGYNRDYSH\n#t80\nSDINRSPGYRLHTPEKHSVYALFPTYVPEISKVVGLLTATGGGGDLADKT\nSIDTLIHCTVSHRRAEGLFSFERDSKLGLNKLTKH\n#t72\nSSISISPAYDISISKALSCLSAFETMVPPISKMKGALSANDGGGVLPDKP\nSMDSLIHSTVPHRCREGLKWFSRAPKRGVNAKQSH\n#t73\nSNISISPAYEISILGLISCASDFDAAVPPISKRKGLLTANDGGGTLPDKP\nSDDGLVHITVMHRCREGLAYFKKAPKRGYNRKQSH\n#t70\nPSINMSLGYQTKKKGTESLFKEFINNVYEISKGNGLLAATAGGGDLSDKT\nSVDLLVHCLIGHRWEEGMKMLYQESKTGVNRVGKH\n#t71\nSDISLSPSYAYNAPGGVSVIAQFDASVPPISKDLGLLDAQAGGGKLLDKP\nSADKLVHSTVAHRRGEGLAKFRQDSKAGYDRPKSH\n#t76\nSDVSQSPSYASDKPAAVSVSAQFNAGVPPMSKVKGRLDANDGGEMLFDKD\nSQDPLIHMGISHRRDEGLDAFRKDPKLGYSQKTSH\n#t77\nSDISESAKYELAGHKEMSAAAGFATGVPALYKARGVLKATKGKDEVTDKE\nSVDVIVHFAVCHRRNEGLDGLLEDSKIGIDRLRRH\n#t74\nSEISLSKRFGPSSPQAFSVRAYFSATVPAISKTAGALDANNGGGSLKDKP\nALDVLLHNQVAHRRKEGLGRFFDDSKLGFDRLGSH\n#t75\nSEISQSPKYQVAPPKEYSVAAAFPTGVPALYKLRGLLEATGGKNDVSDKT\nSVDNLIHIMVTHRRLEGLGSFLQDSKLGIDRLKQH\n#t78\nSAIAGSKAFGASPKSISSVKAEFATPVPAISKAVGCLDANNGGAELSDKA\nALDFLGHIKVAHRYNEGLPRAKTDSKLGFNPSTAH\n#t79\nSDINRSPGYRFHGPEEHSVYAHFTTYVEEISKIVGLLTATGGGGELIDKT\nSKDSLVHCFVRHRRSEGLFSFHRDSKLGLNKLQKH\n#t98\nSEISLSPSYTFNGPQALSVLAVFPAVVPPISKAAGLLDANSGGGQLIDKP\nSADYLVHISVSHRRIEGLVRFNSDSKLGFNRPSSH\n#t99\nCEISLSKKFGLSDKQTLSVRAAFVGSVPSVSKTVGSLDADDGGGDLIDKP\nALDYLIHITVAHRRTEGLEKFKQDSKLGFNRPNMH\n#t94\nPEISLSPTYDSGTPQGISVYAMFYAAVPAISKEAGGLAADLGGGNLPDKS\nSQDELGHIPELHREGEGLNRFDDASKLGFNRPSSY\n#t95\nSDIALSPSYSPNQPKGMSSIASFNAAVPPISKVAGWLDANDGGDLLVDKP\nSKDDLVHLTISHRRMEGLERFRQDSKLGYSREKSH\n#t96\nSDINKSPGYCVHGTAKASKYANFNTEVPEISKCTGLLTATSGGGILADKA\nEADEIGHCYVRHRRDEGDEAIYQDSKDGPNNTQKH\n#t97\nSSVSLSPSYKSNPPNNCSILAPFDAAVPPISRVFGSLDANDGGGDLEDKP\nSLDPLMHLRMNHRKEEGLIKFEKDSKFGLNHGVSH\n#t90\nPSINLSLGFLLKNQGNESFMKVFSHIVYEVSKAVGILTATIGGGVLADKT\nASDYLVHLLVGHRWSEGLKALYRESKTGINRLEKH\n#t91\nSEISASPSYVAHLPQLSSVVTGFQAAVPPISKSLGVLDANDGGGTLLDKP\nSTDPLEHIVVSHRRLEGLVRFEQDSKLGYNRPSSH\n#t92\nSDIARSPSYRVHTPQTYSVGARFPTSVPAISKVQGLLEATGGKGELWDKT\nSIDSLIHITVTHRRVEGLGTFKQDSKLGLNRLKKH\n#t93\nSDISQSPSYASNKPARGSVRAQFQAAVPPMSKAGGTLDANDGGEVLYDKD\nSQDDLIHMGIDHRREEGLDAFRQDPKLGYSQKTSH\n#t8\nSEISLSPSYDLNSPQAISVLAIFPAVVPAISKAAGLLDANRGGGSLLDKS\nSEDHLVHICVVHREIEGLTRFKDDSKLGFNRPSSY\n#t9\nSDIARSPSYRIHPPSSYSVGADFPTSVPAISKVQGLLEATGGKGALWDKT\nSIDSLIHITESHRRVEGLGSFKQDSKLGLNRLVKH\n#t6\nSEISLSPAYQFAIEQILSVLAMFSAVVPPISKAKGLLDANAGGGWLVDKD\nARDYLVHIILYHRQPEGLLRFTSDSKTGFNRPPSH\n#t7\nSNISISPAYDANLPKKVSCVAMFNAAVPPISKALGLLDANDGGGKLLDKP\nSDDGLVHTTVLHRCNEGLAYFKSASKTGYNWKHSH\n#t4\nSDINRSPGYREYAPQRHSVHAEFPTFVEDVSKLVGLLTATGGGGVLEDKK\nSIDTGIHCFVRHRRNEGLFEFERNSKLGLNNLEKH\n#t5\nSDISISPSYQPNLPKSMSVIATFYAVVPPISKINGWLDAKPGGDFLVDKP\nSKDDLVHLAISHRKVEGLERFREDSKIGYSREKSH\n#t2\nSEISLSPAYQFAIEQILSVLAMFSAVVPPISKAKGLLDANAGGGWLVDKD\nARDYLVHILLYHRQPEGLLRFTSDSKTGFNRPPSH\n#t3\nSEISLSPSYGFDEPQAISVMAVFPAVVPPISKAAGLLDANSGGGQLIDKP\nSADYLIHIGVGHRRVEGLVRFKSDSKLGFNRPSSH\n#t1\nSAIASSNVFGPSCATLASVNMAFSGPVPAISKALGWLDANNGGAALIDKA\nALDMLAHIVIGHRKSEGLGRFATDSKLGFNRSIAH\n#t14\nSDISRSPKYKTAEPKQYSVAAGFPTGVPALYKLQGLLEATGGKGELTDKS\nSVDNLIHQLVTHRRLEGLGSFVQDSKLGIDRLKKH\n#t15\nSSISISPAYDTSIPKDVSCISDFDTAVPPISKSKGALTANDGGGTLPDKP\nSDDGLVHSTVIHRCREGLTWFEKAPKRGANAKQSH\n#t16\nSNLSLSPPYSTDTLYGLSCASEFETTVPPVSKNLGVLDANDGGGDLNDKV\nSLDVMLHVANPHRCPEELAYFGDCSKLGYNRADFH\n#t17\nSEVSLSPSYEVNKPKKMSVVTGFQAAVPPISKALGVLDANDGGGQLIDKP\nSMDALVHICVSHRRLEGLVRFEQDSKLGYNRPTSH\n#t10\nSEISLSKRFGGSAPQTFSVLAEFSATVPAISKTVGALDANNGGGSLSDKP\nALDILLHNEVAHRRVEGLGRFFQDSKLGFNRHKSH\n#t11\nSHISLSSKYPNNQDKTLSCASSFDAGVPPISKSLGALDANDGGGALYDKS\nSGDGLPHSNALHRAIEGLAYFASASKSGYNRDYSH\n#t12\nSEVSLSPSYKVNAPESESVLTAFQAAVPPISKALGVLDANNGGGSLADKP\nSKDALVHICVSHRRAEGLSRFETDSKLGYNRPLSH\n#t13\nSHISLSSKYPNQPDKTLSCHSDFDADVPPISKSLGALDAVDGGGALFDKS\nSGDGLPHSNALHRALEGLAIFANASKSGSNRDYSH\n#t18\nSEVSLSPSYEVNKPKRMSVVTGFQAAVPPISKALGVLDANDGGGKLIDKP\nSMDALVHICVSHRRLEGLYRFEQDSKLGYNRPTSH\n#t19\nSDINRSPGYRSHTPEKYSVYALFPTYVPEISKVVGLLTATGGGGDLADKL\nSIDTLIHCTVSHRRIEGLYSFKRDSKLGLNKLEKH\n#t29\nSDINRSPGYRLHTPEKHSVYALFPTYVPEISKVVGLLTATGGGGDLADKT\nSIDTLIHCTVSHRRAEGLFSFERDSKLGLNKLTKH\n#t28\nSDIAKSQSYPPDRPSTLSVTAAFPTSVPAISKVQGQLDAKGGKGELRDKT\nSDDDLIHMLVTHRRPEGLGGFEQDSKFGLQRFKAH\n#t21\nSDINRSPGYFLHTPEKHSVVAHFPTYVEEISKVIGLLTATGGGGELEDKT\nSVDTLVHCYVRHRRNEGLFSFERDSKLGLNKLEKH\n#t20\nSEISLSPSYGLNDPQALSVLAKFTAVVPPISKAAGFLDANSGGGQLVDKP\nSADYLVHISVSHRRIEGLVRFQSDSKLGFNRPVSH\n#t23\nSHISLSSKYPNNQDKTMSCASSFDADVPPISKSLGALDANDGGGALFDKS\nSGDGLPHSNALHRAIEGLAYFANASKSGYNRDYSH\n#t22\nSDIAISPSYGPNQGQGLSSLAPFAAAVPPISKVSGYLDANDGGDILVDKP\nSNDALVHLSISHRRFEGLERFEQDSKLGYSRERSH\n#t25\nSEISLSRSFDFSTPQLLSVQAAFKAAVPAISKTVGCLDANDGGGELVDKP\nAVDYLVHITVSHRVVEGLGRFMQDSKLGFNRPKSH\n#t24\nSDINRSLGYYPYYPTPKSVSAYFPTIVEKVSKRVGLLTATDGGGLLGDKK\nSIDEGLHLFVKHRLSEGLFHFGKNSKVGLNNLEKH\n#t27\nSDINKSPGYCVHGTATASKFAKFNTDVPEISKCTGLLTATSGGGILEDKA\nSADEIGHCYVRHRRDEGDAAIYQDSKDGPNNTQKH\n#t26\nSDINRSPGYSSNTPDDVSVLAHFPTYVPEISKVVGLLTATGGGGDLGDKL\nSNDDLIHCSVSHRRVEGLFSFKRDSKKGINKLPKH\n#t49\nSDINRSPGYRSHTPEKYSVYALFPTYVPEISKVVGLLTATGGGGDLADKL\nSIDSLIHCTVSHRRVEGLFSFKRDSKLGLNKLEKH\n#t48\nSEISLSKSFGFSKKQTLSVKAAFAGAVPAISKTVGCLDANNGGGDLIDKP\nAFDYLVHISVAHRRIEGLGRFKQDSKLGFNRPKAH\n#t43\nSDISRSPKYRLSPPKAYSVPAAFPTGVPALYKLQGLLDATGGKGQLSDKT\nSVDNLIHIAVTHRHIEGLGSFVQDSKLGIDRLRNH\n#t42\nSKISFSKSFGTYLGQLVSVSPLFKAGVPAISKGAGLLDANLGGGTLLDKK\nSLDKLVHTAVSHRRAEGLGQFAQDSKFGFSKPASH\n#t41\nSEISLSKRFGGSAPQVFSVLASFSATVPAISKTVGALDANNGGGSLSDKP\nALDVLMHNEVAHRGLEGLGWFFQDSKLGFNRHRSH\n#t40\nSDISRSPKYKTAEPRQYSVQAGFPTGVPALYKLQGLLEATGGKKQLADKT\nSVDNLIHVLVTHRRLEGLGSAVQDSKLGIDRLKKH\n#t47\nSDISRSPKYALADPKEYSVRAAFPTGVPALYKLQGLLSATGGKGQLSDKT\nSVDNLIHIAVTHRHIEGLGAFVQDSKLGIDRLANH\n#t46\nSPISLSFAYKFGVPKDFSVQGTFIAPVPPISKSSGFLDANHGGGDLPDRL\nSLDSLEHFKVSHRDSEGLVNFGKDSKIGYKRYISH\n#t45\nSEISLSPSYKYEIEQILSVAALFSAVVPPISKAKGLLDANSGGGWLVDKD\nARDYLVHILLYHRQNEGLLEFTSDSKTGFNRPPSH\n#t44\nSEISASPSYVAHRPRLASVVTGFTAAVPPISKALGVLDANDGGGQLIDKP\nSMDALVHIVVSHRRFEGLVRVVQDSKLGYNRPTSH\n#t38\nSSISISPAYDVSAVKALSCLSAFKTMVPPISKMKGALSANDGGGVLSDKP\nSMDSLIHSTVPHRCREGLSWFRRAPKRGTNAKQSH\n#t39\nSNISLSPPYEDDLPYHISCQSKFSAAVPPISKNLGMLDANDGGGPLVDKP\nSSDGLLHLSTAHRCREELAYFKNASKRGYNRAPSH\n#t36\nSDISRSPKYRVAPPKHYSVAAYFPTGVPALYKLQGLLEACGGKGELLDKT\nSVDNLIHIAVTHRRLEGLGSFVQDSKLGIDRLKKH\n#t37\nSNISISPAYDDNIPKNVSCASQFEAAVPPISKSLGLLDANDGGGKLQDKP\nSSDGLLHLTAAHRCREGLAYFKNASKRGYNRKPSH\n#t34\nSEISLSKSFGFSKKQTLSVVAAFAGAVPAISKTVGCLDANNGGGDLIDKP\nAVDYLVHITVAHRRIEGLGRFKQDSKLGFNRPKAH\n#t35\nSDINKSPGYWIHGMKQQSVSANFEPKVPEISKCQGLLTATGGGGALKDKA\nSTDDLSHCYVRHRRREGLFAITQDSKHGPNNIDKH\n#t32\nSDIARSPSYRVHRPQTYSVGAHFPTSVPAISKVQGLLEATGGKGDLWDKT\nSIDSLIHITVTHRRVEGLGSFQQDSKLGLNRLKKH\n#t33\nSDINRSPGYRLHTPEKHSVYALFPTYVPEISKVVGLLTATGGGGDLADKT\nSIDTLIHCTVSHRRAEGLFSFERDSKLGLNKLEKH\n#t30\nSEISLSPSYEAKRPKKMSVVAGFQAAVKPISKALGLLDANDGGGQLIDKP\nSMDALVHIIVSHRRVEGLVRFKQDSKLGYNRPTSH\n#t31\nSKVSISVAYNFSTEKTVSCWSDFAAAVPPISKGKGLLAANDGGGDLNDKN\nSEDGLVHLTVIHRCSEGLDYFEKAPKRGYSNKQSH\n#t58\nSEVSLSPSYEVNKPKSMSVLTSFQAAVTPISKALGVLDANDGGGRLLDKP\nSIDALLHICVSHRRMEGLVRFETDSKLGYNRPLSH\n#t59\nSAIASSKAFGRSDKSLASVKAIFAAPVPAISKAVGCLDANNGGAELIDKA\nALDFLAHITVAHRHTEGLGRFKTDSKLGFNRSVAH\n#t50\nCEISRSKKFGISEKQHLSVDASFVGAVPSVSKTVGSLNADDGGGDLMDKP\nAEDYLIHITVFHKQTEGLDKFKQDSKLGFNRPEMH\n#t51\nSDISLSPSYGFNIPGAISVIDQFEASVPPISKSLGILKAQAGGGKIYDKP\nANDKLVHCTVAHRRHEGLAKFGQDSKAGYDRPKSH\n#t52\nSDISQSPSYVGARPAPMSVKHQFRAAVPPMSKAAGRLDANDGGEVLYDKD\nSEDDIVHMGINHRGEEGLEAFRQDPKAGYSQTTSH\n#t53\nSDINRSPGYKLHTPEEHSVYALFPTSVPEISKVVGLLTATGGGGELEDKT\nSIDTLVHCTVSHRRAEGLFSFERDSKLGLNKLEKH\n#t54\nSDINRSPGYRLHTPEEHSVYAQFPTYVEEVSKVIGLLTATGGGGKLEDKK\nSVDTLVHCYVRHRRSEGLFSFERDSKLGLNKLEKH\n#t55\nASISISPAYMYQQLAQNSCHSSFVAGVPPISKSQGLQTANDGGGSLIDKP\nSTDHLIHIMVMHRCAEGVLSFPKVPKRGYTRQEGH\n#t56\nSGISLSPTYFQNPMLFISCPSAFKTSVLPISKTLGMLDANDGGGDLLDKA\nSVDCMVHLSTMHRCGEELAYSAEASKRGYNRAINH\n#t57\nSSINKSLGYSHYFHDTQSLSAKFPTYVQNVSKRAGQLTAAVGGGTLIDKK\nSIDTGIHLMAHHRPLEGLLKFSRESKIGLKNLRKH\n#t69\nSDIARSPSYEIRSERPYSVDATFPANVPAISKTKGELQATGGKGILIDKT\nSEDQLIHIVVTHRRVEGLGSFKQDSKLGLNRLHKH\n#t68\nSDISRSPRYSLAVPQEYSVPGGFATGVPALYKFQGLLDASGGKGDLSDKT\nHMDQLIHVAVQHRYFEGLGVFIQDSKLGVDRYGDH\n#t65\nSDISRSPKYKTAEPKQYSVAAGFPTGVPALYKLQGLLEATGGKKELTDKT\nSVDNLIHVLVTHRRLEGLGSSVQDSKLGIDRLKKH\n#t64\nSDISQSPTYQRDSPSRLSVEARFNAGVPPMSKVTGRLDANPGGEMLVDKD\nSSDNLIHMEISHRREEGLDAFRQDPKVGYSQKKSH\n#t67\nSPIALSFAYKFGIPKDFSVTGSFIAPVPPISKSSGFLDANHGGGDLPDRL\nSLDSLDHFTVSHRDSEGLVNFAKDSKIGYKRYISH\n#t66\nSDISLSWSYEPELPKSMSVVATFNARVPPISKVAGWLDANDGADVLLDKP\nSNDEVVHLTISHRRMEGLERFRQDSKLGYSREKSH\n#t61\nSEISLSPAYDFNAPDSLSVDAVFEAKVAPISKAAGLLEANAGGGFLTDKP\nSGDYLYHIVVRHRRAEGLLKFASDSKLGFNRPPSH\n#t60\nSEVNHSPGYWVNKLQAESVLAYFDPQVPEISKCEGQLSATKGGGSLKDKA\nSTDELSHCVIHHRRDEGLFIITHDSKHGPNVVKKH\n#t63\nSEVSLSPSYEINAPKSESVLTVFQAAVPPISKALGILDANDGGGSLRDKP\nSIDGLVHICVSHRRAEGLVRFETDSKLGYNRPLTH\n#t62\nSDISLSPSYAYNAPGGVSVIAQFDASVPPISKDLGLLDAQAGGGTLLDKP\nSADKLVHSTVAHRRKEGLAKFRQDSKAGYDRPKSH\n#t101\nSDIPLSPSYAGTFPHFMSVPAEFNVSVPPISKYVGWLDANDGGDELQDKP\nSGDELIHRSSAHRRSEGLDRFRVDSKCGYSKKQSH\n#t100\nSNISISPAYDASIMKLCSCESKFVAAVPPISKSKGLLNANDGGGVLKDKP\nSDDGLIHITVMHRCREGVVYFQKAPKRGYNRRHSH\n#t103\nSNISLSPAYVKNIPKTVSCASEFGAAVPPISKSLGMLDANDGGGILQDKP\nSSDGLQHLTASHRVKEGLAYFKNASKRGYNRAPSH\n#t102\nSDISQSPSYASDKPAGMSVRAQFNAGVPPMSKVAGRLDANDGGEVLIDKD\nSQDPLIHMGINHRREEGLDAFRQDPKLGYSQKTSH\n\n\n((((t30:0.06128886105((t46:0.05643295036t67:0.04002395966):1.043417326t97:0.6958460188):0.2649557619):0.006293993578(((t44:0.003368254296t84:0.008199588108):0.0533784077t91:0.1044291171):0.2013125338((t18:0.10550802t17:0.0482739277):0.001411338786(t58:0.02251044266(t63:0.1168411716t12:0.1164033587):0.06846848477):0.09161538966):0.0388488274):0.09064807729):0.05507304869(((t71:0.02683306387(t51:0.5740386912t62:0.02209159976):0.01497015801):0.482023497(((t5:0.2752470871t66:0.2501176492):0.0521743043((t95:0.007308479069t22:0.6022031231):0.02848296875t101:0.7061056009):0.001836935949):0.0001221302746((t93:0.05083092496t52:0.2160712202):0.01697310188((t102:0.01082158297t76:0.165966292):0.005205516437t64:0.4832296414):0.01560801485):0.5717746509):0.4642109101):0.01040795752(((((t103:0.01884871503((t11:0.02748707255t81:0.04641617769):8.263870822e-05(t23:0.01549888274t13:0.1102522311):0.01661339073):0.4330633582):0.1025723422((t56:0.4472140296t16:0.7991120944):0.3183020548t39:0.007845066096):0.2764301943):0.05381094513t37:0.0008020861176):0.239242797((((t55:0.778468197t100:0.02503234143):0.236457907(t73:0.1398231296t31:0.643977826):0.0005129893453):0.06633131192t88:0.03243553065):0.02942688864((t72:0.0005535571345t38:0.1147076385):0.3399728315t15:0.06582329439):0.1574418368):0.1010311592):0.1602652603t7:0.137687442):0.4958280439):0.1286750993):0.06556727842((((t8:0.007674722024t94:0.9714182037):0.4069592365t3:0.108701495):0.001684957879(t20:0.1994333944((t61:0.442678971(t45:0.1018637423(t2:0.04086669763t6:0.003437251179):0.02679617221):0.2791636233):0.1735783363t98:0.001063296716):0.06458293007):0.0007121864472):0.1246757375((t42:0.8656193891(((t74:0.06127408719(t10:0.01759513444t41:0.1092864811):0.08012800171):0.625150411((((t1:0.5659729302t59:0.01747911258):0.0004882752631t78:0.4661104423):0.6578105785((t83:1.164807369((t50:0.2283634984t99:0.009778392144):0.01621243869t89:0.01383891957):0.003076485061):0.3535294813t48:0.03625033067):0.009040826952):0.0005671825124t34:0.004681006626):0.1004969324):0.01254124109t25:0.220966534):0.05734308373):0.08460289499((((((t75:0.08145381954t77:0.5524964361):0.08083574726t36:0.009966392659):0.01426628381(t43:0.03784791855(t47:0.1030796405t68:0.86501697):0.002149320454):0.1038942478):4.949734823e-05(t14:0.05599542683(t40:0.07186896086t65:0.0006343160513):0.0454494709):0.0330489629):0.3260031302((t32:0.05329042532t85:0.7207788066):0.001832810976((t28:0.6722918675t82:0.1931474979):0.134432572((t69:0.6107655066t9:0.2061540277):0.02450226246t92:0.01006202265):0.03568312252):0.0009549465448):0.01835047912):0.0602516551(((((t27:0.006340748925(t96:0.03770839403(t86:0.001826438123t87:1.257438581):0.7102420208):0.02940181435):0.7317064175t35:0.02135674737):0.06544050965t60:0.5854702654):1.150403575(((t54:0.02756702913(t70:0.4383079104t90:0.3628734939):1.988436196):0.003809037953((t24:0.6101696443t57:1.063792268):0.2516757552t4:0.09059568285):0.311331975):0.02554446229(t21:0.08017676247t79:0.2587699644):0.0009845480288):0.06935659544):0.08688569421((((t26:0.2027515752t49:4.876143239e-06):0.02162421968t19:0.0210271577):0.1673107233t33:0.01031840313):0.001086499927((t29:0.01015961064t80:0.0129610141):0.008929938461t53:0.06726909436):0.001682009408):0.000369231914):0.2953044464):0.7087512844):0.1814871951):0.1118680931)";
DataSet protein_gtr.msa.4 = ReadFromString (_tdsstring_);
_tdsstring_=0;

global tdIyVulQ.user.theta_KM=1;
global tdIyVulQ.user.theta_KL=1;
global tdIyVulQ.user.theta_IY=1;
global tdIyVulQ.user.theta_KN=1;
global tdIyVulQ.user.theta_KQ=1;
global tdIyVulQ.user.theta_KP=1;
global tdIyVulQ.user.theta_IW=1;
global tdIyVulQ.user.theta_IR=1;
global tdIyVulQ.user.theta_IQ=1;
global tdIyVulQ.user.theta_IS=1;
global tdIyVulQ.user.theta_IV=1;
global tdIyVulQ.user.theta_IT=1;
global tdIyVulQ.user.theta_KR=1;
global tdIyVulQ.user.theta_LP=1;
global tdIyVulQ.user.theta_LN=1;
global tdIyVulQ.user.theta_LQ=1;
global tdIyVulQ.user.theta_LS=1;
global tdIyVulQ.user.theta_LR=1;
global tdIyVulQ.user.theta_LM=1;
global tdIyVulQ.user.theta_KT=1;
global tdIyVulQ.user.theta_KS=1;
global tdIyVulQ.user.theta_KV=1;
global tdIyVulQ.user.theta_KY=1;
global tdIyVulQ.user.theta_KW=1;
global tdIyVulQ.user.theta_IP=1;
global tdIyVulQ.user.theta_HK=1;
global tdIyVulQ.user.theta_HI=1;
global tdIyVulQ.user.theta_HL=1;
global tdIyVulQ.user.theta_HN=1;
global tdIyVulQ.user.theta_HM=1;
global tdIyVulQ.user.theta_GY=1;
global tdIyVulQ.user.theta_GS=1;
global tdIyVulQ.user.theta_GR=1;
global tdIyVulQ.user.theta_GT=1;
global tdIyVulQ.user.theta_GW=1;
global tdIyVulQ.user.theta_GV=1;
global tdIyVulQ.user.theta_HP=1;
global tdIyVulQ.user.theta_IK=1;
global tdIyVulQ.user.theta_HY=1;
global tdIyVulQ.user.theta_IL=1;
global tdIyVulQ.user.theta_IN=1;
global tdIyVulQ.user.theta_IM=1;
global tdIyVulQ.user.theta_HW=1;
global tdIyVulQ.user.theta_HR=1;
global tdIyVulQ.user.theta_HQ=1;
global tdIyVulQ.user.theta_HS=1;
global tdIyVulQ.user.theta_HV=1;
global tdIyVulQ.user.theta_HT=1;
global tdIyVulQ.user.theta_LT=1;
global tdIyVulQ.user.theta_QY=1;
global tdIyVulQ.user.theta_QW=1;
global tdIyVulQ.user.theta_QV=1;
global tdIyVulQ.user.theta_RS=1;
global tdIyVulQ.user.theta_RV=1;
global tdIyVulQ.user.theta_RT=1;
global tdIyVulQ.user.theta_QT=1;
global tdIyVulQ.user.theta_PW=1;
global tdIyVulQ.user.theta_PV=1;
global tdIyVulQ.user.theta_PY=1;
global tdIyVulQ.user.theta_QS=1;
global tdIyVulQ.user.theta_QR=1;
global tdIyVulQ.user.theta_RW=1;
global tdIyVulQ.user.theta_TY=1;
global tdIyVulQ.user.theta_TW=1;
global tdIyVulQ.user.theta_VW=1;
global tdIyVulQ.user.theta_WY=1;
global tdIyVulQ.user.theta_VY=1;
global tdIyVulQ.user.theta_TV=1;
global tdIyVulQ.user.theta_ST=1;
global tdIyVulQ.user.theta_RY=1;
global tdIyVulQ.user.theta_SV=1;
global tdIyVulQ.user.theta_SY=1;
global tdIyVulQ.user.theta_SW=1;
global tdIyVulQ.user.theta_PT=1;
global tdIyVulQ.user.theta_MS=1;
global tdIyVulQ.user.theta_MR=1;
global tdIyVulQ.user.theta_MT=1;
global tdIyVulQ.user.theta_MW=1;
global tdIyVulQ.user.theta_MV=1;
global tdIyVulQ.user.theta_MQ=1;
global tdIyVulQ.user.theta_LW=1;
global tdIyVulQ.user.theta_LV=1;
global tdIyVulQ.user.theta_LY=1;
global tdIyVulQ.user.theta_MP=1;
global tdIyVulQ.user.theta_MN=1;
global tdIyVulQ.user.theta_MY=1;
global tdIyVulQ.user.theta_NY=1;
global tdIyVulQ.user.theta_NW=1;
global tdIyVulQ.user.theta_PQ=1;
global tdIyVulQ.user.theta_PS=1;
global tdIyVulQ.user.theta_PR=1;
global tdIyVulQ.user.theta_NV=1;
global tdIyVulQ.user.theta_NQ=1;
global tdIyVulQ.user.theta_NP=1;
global tdIyVulQ.user.theta_NR=1;
global tdIyVulQ.user.theta_NT=1;
global tdIyVulQ.user.theta_NS=1;
global tdIyVulQ.user.theta_GQ=1;
global tdIyVulQ.user.theta_CN=1;
global tdIyVulQ.user.theta_CM=1;
global tdIyVulQ.user.theta_CP=1;
global tdIyVulQ.user.theta_CR=1;
global tdIyVulQ.user.theta_CQ=1;
global tdIyVulQ.user.theta_CL=1;
global tdIyVulQ.user.theta_CH=1;
global tdIyVulQ.user.theta_CG=1;
global tdIyVulQ.user.theta_CI=1;
global tdIyVulQ.user.theta_CK=1;
global tdIyVulQ.user.theta_CS=1;
global tdIyVulQ.user.theta_DG=1;
global tdIyVulQ.user.theta_DF=1;
global tdIyVulQ.user.theta_DH=1;
global tdIyVulQ.user.theta_DK=1;
global tdIyVulQ.user.theta_DI=1;
global tdIyVulQ.user.theta_DE=1;
global tdIyVulQ.user.theta_CV=1;
global tdIyVulQ.user.theta_CT=1;
global tdIyVulQ.user.theta_CW=1;
global tdIyVulQ.user.theta_CY=1;
global tdIyVulQ.user.theta_CF=1;
global tdIyVulQ.user.theta_AI=1;
global tdIyVulQ.user.theta_AH=1;
global tdIyVulQ.user.theta_AK=1;
global tdIyVulQ.user.theta_AM=1;
global tdIyVulQ.user.theta_AL=1;
global tdIyVulQ.user.theta_AG=1;
global tdIyVulQ.user.theta_AD=1;
global tdIyVulQ.user.theta_AC=1;
global tdIyVulQ.user.theta_AE=1;
global tdIyVulQ.user.theta_AF=1;
global tdIyVulQ.user.theta_AN=1;
global tdIyVulQ.user.theta_AW=1;
global tdIyVulQ.user.theta_AV=1;
global tdIyVulQ.user.theta_AY=1;
global tdIyVulQ.user.theta_CE=1;
global tdIyVulQ.user.theta_CD=1;
global tdIyVulQ.user.theta_AT=1;
global tdIyVulQ.user.theta_AQ=1;
global tdIyVulQ.user.theta_AP=1;
global tdIyVulQ.user.theta_AR=1;
global tdIyVulQ.user.theta_AS=1;
global tdIyVulQ.user.theta_DL=1;
global tdIyVulQ.user.theta_FP=1;
global tdIyVulQ.user.theta_FN=1;
global tdIyVulQ.user.theta_FQ=1;
global tdIyVulQ.user.theta_FS=1;
global tdIyVulQ.user.theta_FR=1;
global tdIyVulQ.user.theta_FM=1;
global tdIyVulQ.user.theta_FI=1;
global tdIyVulQ.user.theta_FH=1;
global tdIyVulQ.user.theta_FK=1;
global tdIyVulQ.user.theta_FL=1;
global tdIyVulQ.user.theta_FT=1;
global tdIyVulQ.user.theta_GL=1;
global tdIyVulQ.user.theta_GK=1;
global tdIyVulQ.user.theta_GM=1;
global tdIyVulQ.user.theta_GP=1;
global tdIyVulQ.user.theta_GN=1;
global tdIyVulQ.user.theta_GI=1;
global tdIyVulQ.user.theta_FW=1;
global tdIyVulQ.user.theta_FV=1;
global tdIyVulQ.user.theta_FY=1;
global tdIyVulQ.user.theta_GH=1;
global tdIyVulQ.user.theta_FG=1;
global tdIyVulQ.user.theta_DT=1;
global tdIyVulQ.user.theta_DS=1;
global tdIyVulQ.user.theta_DV=1;
global tdIyVulQ.user.theta_DY=1;
global tdIyVulQ.user.theta_DW=1;
global tdIyVulQ.user.theta_DM=1;
global tdIyVulQ.user.theta_DQ=1;
global tdIyVulQ.user.theta_DR=1;
global tdIyVulQ.user.theta_DP=1;
global tdIyVulQ.user.theta_DN=1;
global tdIyVulQ.user.theta_EF=1;
global tdIyVulQ.user.theta_EW=1;
global tdIyVulQ.user.theta_EY=1;
global tdIyVulQ.user.theta_EV=1;
global tdIyVulQ.user.theta_ES=1;
global tdIyVulQ.user.theta_ET=1;
global tdIyVulQ.user.theta_ER=1;
global tdIyVulQ.user.theta_EK=1;
global tdIyVulQ.user.theta_EL=1;
global tdIyVulQ.user.theta_EI=1;
global tdIyVulQ.user.theta_EM=1;
global tdIyVulQ.user.theta_EN=1;
global tdIyVulQ.user.theta_EH=1;
global tdIyVulQ.user.theta_EG=1;
global tdIyVulQ.user.theta_EP=1;
global tdIyVulQ.user.theta_EQ=1;
global protein_gtr.gtr_scaler_2=0.3303138829063855;
global protein_gtr.gtr_scaler_3=0.3303138829063855;
global protein_gtr.gtr_scaler_4=0.3303138829063854;
global protein_gtr.gtr_scaler_1=0.3303138829063855;
global protein_gtr.gtr_scaler_0=0.3303138829063855;
tdIyVulQ.user_Q={20,20};
tdIyVulQ.user_Q[0][1]:=tdIyVulQ.user.theta_AC*t;
tdIyVulQ.user_Q[0][2]:=tdIyVulQ.user.theta_AD*t;
tdIyVulQ.user_Q[0][3]:=tdIyVulQ.user.theta_AE*t;
tdIyVulQ.user_Q[0][4]:=tdIyVulQ.user.theta_AF*t;
tdIyVulQ.user_Q[0][5]:=tdIyVulQ.user.theta_AG*t;
tdIyVulQ.user_Q[0][6]:=tdIyVulQ.user.theta_AH*t;
tdIyVulQ.user_Q[0][7]:=tdIyVulQ.user.theta_AI*t;
tdIyVulQ.user_Q[0][8]:=tdIyVulQ.user.theta_AK*t;
tdIyVulQ.user_Q[0][9]:=tdIyVulQ.user.theta_AL*t;
tdIyVulQ.user_Q[0][10]:=tdIyVulQ.user.theta_AM*t;
tdIyVulQ.user_Q[0][11]:=tdIyVulQ.user.theta_AN*t;
tdIyVulQ.user_Q[0][12]:=tdIyVulQ.user.theta_AP*t;
tdIyVulQ.user_Q[0][13]:=tdIyVulQ.user.theta_AQ*t;
tdIyVulQ.user_Q[0][14]:=tdIyVulQ.user.theta_AR*t;
tdIyVulQ.user_Q[0][15]:=tdIyVulQ.user.theta_AS*t;
tdIyVulQ.user_Q[0][16]:=tdIyVulQ.user.theta_AT*t;
tdIyVulQ.user_Q[0][17]:=tdIyVulQ.user.theta_AV*t;
tdIyVulQ.user_Q[0][18]:=tdIyVulQ.user.theta_AW*t;
tdIyVulQ.user_Q[0][19]:=tdIyVulQ.user.theta_AY*t;
tdIyVulQ.user_Q[1][0]:=tdIyVulQ.user.theta_AC*t;
tdIyVulQ.user_Q[1][2]:=tdIyVulQ.user.theta_CD*t;
tdIyVulQ.user_Q[1][3]:=tdIyVulQ.user.theta_CE*t;
tdIyVulQ.user_Q[1][4]:=tdIyVulQ.user.theta_CF*t;
tdIyVulQ.user_Q[1][5]:=tdIyVulQ.user.theta_CG*t;
tdIyVulQ.user_Q[1][6]:=tdIyVulQ.user.theta_CH*t;
tdIyVulQ.user_Q[1][7]:=tdIyVulQ.user.theta_CI*t;
tdIyVulQ.user_Q[1][8]:=tdIyVulQ.user.theta_CK*t;
tdIyVulQ.user_Q[1][9]:=tdIyVulQ.user.theta_CL*t;
tdIyVulQ.user_Q[1][10]:=tdIyVulQ.user.theta_CM*t;
tdIyVulQ.user_Q[1][11]:=tdIyVulQ.user.theta_CN*t;
tdIyVulQ.user_Q[1][12]:=tdIyVulQ.user.theta_CP*t;
tdIyVulQ.user_Q[1][13]:=tdIyVulQ.user.theta_CQ*t;
tdIyVulQ.user_Q[1][14]:=tdIyVulQ.user.theta_CR*t;
tdIyVulQ.user_Q[1][15]:=tdIyVulQ.user.theta_CS*t;
tdIyVulQ.user_Q[1][16]:=tdIyVulQ.user.theta_CT*t;
tdIyVulQ.user_Q[1][17]:=tdIyVulQ.user.theta_CV*t;
tdIyVulQ.user_Q[1][18]:=tdIyVulQ.user.theta_CW*t;
tdIyVulQ.user_Q[1][19]:=tdIyVulQ.user.theta_CY*t;
tdIyVulQ.user_Q[2][0]:=tdIyVulQ.user.theta_AD*t;
tdIyVulQ.user_Q[2][1]:=tdIyVulQ.user.theta_CD*t;
tdIyVulQ.user_Q[2][3]:=tdIyVulQ.user.theta_DE*t;
tdIyVulQ.user_Q[2][4]:=tdIyVulQ.user.theta_DF*t;
tdIyVulQ.user_Q[2][5]:=tdIyVulQ.user.theta_DG*t;
tdIyVulQ.user_Q[2][6]:=tdIyVulQ.user.theta_DH*t;
tdIyVulQ.user_Q[2][7]:=tdIyVulQ.user.theta_DI*t;
tdIyVulQ.user_Q[2][8]:=tdIyVulQ.user.theta_DK*t;
tdIyVulQ.user_Q[2][9]:=tdIyVulQ.user.theta_DL*t;
tdIyVulQ.user_Q[2][10]:=tdIyVulQ.user.theta_DM*t;
tdIyVulQ.user_Q[2][11]:=tdIyVulQ.user.theta_DN*t;
tdIyVulQ.user_Q[2][12]:=tdIyVulQ.user.theta_DP*t;
tdIyVulQ.user_Q[2][13]:=tdIyVulQ.user.theta_DQ*t;
tdIyVulQ.user_Q[2][14]:=tdIyVulQ.user.theta_DR*t;
tdIyVulQ.user_Q[2][15]:=tdIyVulQ.user.theta_DS*t;
tdIyVulQ.user_Q[2][16]:=tdIyVulQ.user.theta_DT*t;
tdIyVulQ.user_Q[2][17]:=tdIyVulQ.user.theta_DV*t;
tdIyVulQ.user_Q[2][18]:=tdIyVulQ.user.theta_DW*t;
tdIyVulQ.user_Q[2][19]:=tdIyVulQ.user.theta_DY*t;
tdIyVulQ.user_Q[3][0]:=tdIyVulQ.user.theta_AE*t;
tdIyVulQ.user_Q[3][1]:=tdIyVulQ.user.theta_CE*t;
tdIyVulQ.user_Q[3][2]:=tdIyVulQ.user.theta_DE*t;
tdIyVulQ.user_Q[3][4]:=tdIyVulQ.user.theta_EF*t;
tdIyVulQ.user_Q[3][5]:=tdIyVulQ.user.theta_EG*t;
tdIyVulQ.user_Q[3][6]:=tdIyVulQ.user.theta_EH*t;
tdIyVulQ.user_Q[3][7]:=tdIyVulQ.user.theta_EI*t;
tdIyVulQ.user_Q[3][8]:=tdIyVulQ.user.theta_EK*t;
tdIyVulQ.user_Q[3][9]:=tdIyVulQ.user.theta_EL*t;
tdIyVulQ.user_Q[3][10]:=tdIyVulQ.user.theta_EM*t;
tdIyVulQ.user_Q[3][11]:=tdIyVulQ.user.theta_EN*t;
tdIyVulQ.user_Q[3][12]:=tdIyVulQ.user.theta_EP*t;
tdIyVulQ.user_Q[3][13]:=tdIyVulQ.user.theta_EQ*t;
tdIyVulQ.user_Q[3][14]:=tdIyVulQ.user.theta_ER*t;
tdIyVulQ.user_Q[3][15]:=tdIyVulQ.user.theta_ES*t;
tdIyVulQ.user_Q[3][16]:=tdIyVulQ.user.theta_ET*t;
tdIyVulQ.user_Q[3][17]:=tdIyVulQ.user.theta_EV*t;
tdIyVulQ.user_Q[3][18]:=tdIyVulQ.user.theta_EW*t;
tdIyVulQ.user_Q[3][19]:=tdIyVulQ.user.theta_EY*t;
tdIyVulQ.user_Q[4][0]:=tdIyVulQ.user.theta_AF*t;
tdIyVulQ.user_Q[4][1]:=tdIyVulQ.user.theta_CF*t;
tdIyVulQ.user_Q[4][2]:=tdIyVulQ.user.theta_DF*t;
tdIyVulQ.user_Q[4][3]:=tdIyVulQ.user.theta_EF*t;
tdIyVulQ.user_Q[4][5]:=tdIyVulQ.user.theta_FG*t;
tdIyVulQ.user_Q[4][6]:=tdIyVulQ.user.theta_FH*t;
tdIyVulQ.user_Q[4][7]:=tdIyVulQ.user.theta_FI*t;
tdIyVulQ.user_Q[4][8]:=tdIyVulQ.user.theta_FK*t;
tdIyVulQ.user_Q[4][9]:=tdIyVulQ.user.theta_FL*t;
tdIyVulQ.user_Q[4][10]:=tdIyVulQ.user.theta_FM*t;
tdIyVulQ.user_Q[4][11]:=tdIyVulQ.user.theta_FN*t;
tdIyVulQ.user_Q[4][12]:=tdIyVulQ.user.theta_FP*t;
tdIyVulQ.user_Q[4][13]:=tdIyVulQ.user.theta_FQ*t;
tdIyVulQ.user_Q[4][14]:=tdIyVulQ.user.theta_FR*t;
tdIyVulQ.user_Q[4][15]:=tdIyVulQ.user.theta_FS*t;
tdIyVulQ.user_Q[4][16]:=tdIyVulQ.user.theta_FT*t;
tdIyVulQ.user_Q[4][17]:=tdIyVulQ.user.theta_FV*t;
tdIyVulQ.user_Q[4][18]:=tdIyVulQ.user.theta_FW*t;
tdIyVulQ.user_Q[4][19]:=tdIyVulQ.user.theta_FY*t;
tdIyVulQ.user_Q[5][0]:=tdIyVulQ.user.theta_AG*t;
tdIyVulQ.user_Q[5][1]:=tdIyVulQ.user.theta_CG*t;
tdIyVulQ.user_Q[5][2]:=tdIyVulQ.user.theta_DG*t;
tdIyVulQ.user_Q[5][3]:=tdIyVulQ.user.theta_EG*t;
tdIyVulQ.user_Q[5][4]:=tdIyVulQ.user.theta_FG*t;
tdIyVulQ.user_Q[5][6]:=tdIyVulQ.user.theta_GH*t;
tdIyVulQ.user_Q[5][7]:=tdIyVulQ.user.theta_GI*t;
tdIyVulQ.user_Q[5][8]:=tdIyVulQ.user.theta_GK*t;
tdIyVulQ.user_Q[5][9]:=tdIyVulQ.user.theta_GL*t;
tdIyVulQ.user_Q[5][10]:=tdIyVulQ.user.theta_GM*t;
tdIyVulQ.user_Q[5][11]:=tdIyVulQ.user.theta_GN*t;
tdIyVulQ.user_Q[5][12]:=tdIyVulQ.user.theta_GP*t;
tdIyVulQ.user_Q[5][13]:=tdIyVulQ.user.theta_GQ*t;
tdIyVulQ.user_Q[5][14]:=tdIyVulQ.user.theta_GR*t;
tdIyVulQ.user_Q[5][15]:=tdIyVulQ.user.theta_GS*t;
tdIyVulQ.user_Q[5][16]:=tdIyVulQ.user.theta_GT*t;
tdIyVulQ.user_Q[5][17]:=tdIyVulQ.user.theta_GV*t;
tdIyVulQ.user_Q[5][18]:=tdIyVulQ.user.theta_GW*t;
tdIyVulQ.user_Q[5][19]:=tdIyVulQ.user.theta_GY*t;
tdIyVulQ.user_Q[6][0]:=tdIyVulQ.user.theta_AH*t;
tdIyVulQ.user_Q[6][1]:=tdIyVulQ.user.theta_CH*t;
tdIyVulQ.user_Q[6][2]:=tdIyVulQ.user.theta_DH*t;
tdIyVulQ.user_Q[6][3]:=tdIyVulQ.user.theta_EH*t;
tdIyVulQ.user_Q[6][4]:=tdIyVulQ.user.theta_FH*t;
tdIyVulQ.user_Q[6][5]:=tdIyVulQ.user.theta_GH*t;
tdIyVulQ.user_Q[6][7]:=tdIyVulQ.user.theta_HI*t;
tdIyVulQ.user_Q[6][8]:=tdIyVulQ.user.theta_HK*t;
tdIyVulQ.user_Q[6][9]:=tdIyVulQ.user.theta_HL*t;
tdIyVulQ.user_Q[6][10]:=tdIyVulQ.user.theta_HM*t;
tdIyVulQ.user_Q[6][11]:=tdIyVulQ.user.theta_HN*t;
tdIyVulQ.user_Q[6][12]:=tdIyVulQ.user.theta_HP*t;
tdIyVulQ.user_Q[6][13]:=tdIyVulQ.user.theta_HQ*t;
tdIyVulQ.user_Q[6][14]:=tdIyVulQ.user.theta_HR*t;
tdIyVulQ.user_Q[6][15]:=tdIyVulQ.user.theta_HS*t;
tdIyVulQ.user_Q[6][16]:=tdIyVulQ.user.theta_HT*t;
tdIyVulQ.user_Q[6][17]:=tdIyVulQ.user.theta_HV*t;
tdIyVulQ.user_Q[6][18]:=tdIyVulQ.user.theta_HW*t;
tdIyVulQ.user_Q[6][19]:=tdIyVulQ.user.theta_HY*t;
tdIyVulQ.user_Q[7][0]:=tdIyVulQ.user.theta_AI*t;
tdIyVulQ.user_Q[7][1]:=tdIyVulQ.user.theta_CI*t;
tdIyVulQ.user_Q[7][2]:=tdIyVulQ.user.theta_DI*t;
tdIyVulQ.user_Q[7][3]:=tdIyVulQ.user.theta_EI*t;
tdIyVulQ.user_Q[7][4]:=tdIyVulQ.user.theta_FI*t;
tdIyVulQ.user_Q[7][5]:=tdIyVulQ.user.theta_GI*t;
tdIyVulQ.user_Q[7][6]:=tdIyVulQ.user.theta_HI*t;
tdIyVulQ.user_Q[7][8]:=tdIyVulQ.user.theta_IK*t;
tdIyVulQ.user_Q[7][9]:=tdIyVulQ.user.theta_IL*t;
tdIyVulQ.user_Q[7][10]:=tdIyVulQ.user.theta_IM*t;
tdIyVulQ.user_Q[7][11]:=tdIyVulQ.user.theta_IN*t;
tdIyVulQ.user_Q[7][12]:=tdIyVulQ.user.theta_IP*t;
tdIyVulQ.user_Q[7][13]:=tdIyVulQ.user.theta_IQ*t;
tdIyVulQ.user_Q[7][14]:=tdIyVulQ.user.theta_IR*t;
tdIyVulQ.user_Q[7][15]:=tdIyVulQ.user.theta_IS*t;
tdIyVulQ.user_Q[7][16]:=tdIyVulQ.user.theta_IT*t;
tdIyVulQ.user_Q[7][17]:=tdIyVulQ.user.theta_IV*t;
tdIyVulQ.user_Q[7][18]:=tdIyVulQ.user.theta_IW*t;
tdIyVulQ.user_Q[7][19]:=tdIyVulQ.user.theta_IY*t;
tdIyVulQ.user_Q[8][0]:=tdIyVulQ.user.theta_AK*t;
tdIyVulQ.user_Q[8][1]:=tdIyVulQ.user.theta_CK*t;
tdIyVulQ.user_Q[8][2]:=tdIyVulQ.user.theta_DK*t;
tdIyVulQ.user_Q[8][3]:=tdIyVulQ.user.theta_EK*t;
tdIyVulQ.user_Q[8][4]:=tdIyVulQ.user.theta_FK*t;
tdIyVulQ.user_Q[8][5]:=tdIyVulQ.user.theta_GK*t;
tdIyVulQ.user_Q[8][6]:=tdIyVulQ.user.theta_HK*t;
tdIyVulQ.user_Q[8][7]:=tdIyVulQ.user.theta_IK*t;
tdIyVulQ.user_Q[8][9]:=tdIyVulQ.user.theta_KL*t;
tdIyVulQ.user_Q[8][10]:=tdIyVulQ.user.theta_KM*t;
tdIyVulQ.user_Q[8][11]:=tdIyVulQ.user.theta_KN*t;
tdIyVulQ.user_Q[8][12]:=tdIyVulQ.user.theta_KP*t;
tdIyVulQ.user_Q[8][13]:=tdIyVulQ.user.theta_KQ*t;
tdIyVulQ.user_Q[8][14]:=tdIyVulQ.user.theta_KR*t;
tdIyVulQ.user_Q[8][15]:=tdIyVulQ.user.theta_KS*t;
tdIyVulQ.user_Q[8][16]:=tdIyVulQ.user.theta_KT*t;
tdIyVulQ.user_Q[8][17]:=tdIyVulQ.user.theta_KV*t;
tdIyVulQ.user_Q[8][18]:=tdIyVulQ.user.theta_KW*t;
tdIyVulQ.user_Q[8][19]:=tdIyVulQ.user.theta_KY*t;
tdIyVulQ.user_Q[9][0]:=tdIyVulQ.user.theta_AL*t;
tdIyVulQ.user_Q[9][1]:=tdIyVulQ.user.theta_CL*t;
tdIyVulQ.user_Q[9][2]:=tdIyVulQ.user.theta_DL*t;
tdIyVulQ.user_Q[9][3]:=tdIyVulQ.user.theta_EL*t;
tdIyVulQ.user_Q[9][4]:=tdIyVulQ.user.theta_FL*t;
tdIyVulQ.user_Q[9][5]:=tdIyVulQ.user.theta_GL*t;
tdIyVulQ.user_Q[9][6]:=tdIyVulQ.user.theta_HL*t;
tdIyVulQ.user_Q[9][7]:=tdIyVulQ.user.theta_IL*t;
tdIyVulQ.user_Q[9][8]:=tdIyVulQ.user.theta_KL*t;
tdIyVulQ.user_Q[9][10]:=tdIyVulQ.user.theta_LM*t;
tdIyVulQ.user_Q[9][11]:=tdIyVulQ.user.theta_LN*t;
tdIyVulQ.user_Q[9][12]:=tdIyVulQ.user.theta_LP*t;
tdIyVulQ.user_Q[9][13]:=tdIyVulQ.user.theta_LQ*t;
tdIyVulQ.user_Q[9][14]:=tdIyVulQ.user.theta_LR*t;
tdIyVulQ.user_Q[9][15]:=tdIyVulQ.user.theta_LS*t;
tdIyVulQ.user_Q[9][16]:=tdIyVulQ.user.theta_LT*t;
tdIyVulQ.user_Q[9][17]:=tdIyVulQ.user.theta_LV*t;
tdIyVulQ.user_Q[9][18]:=tdIyVulQ.user.theta_LW*t;
tdIyVulQ.user_Q[9][19]:=tdIyVulQ.user.theta_LY*t;
tdIyVulQ.user_Q[10][0]:=tdIyVulQ.user.theta_AM*t;
tdIyVulQ.user_Q[10][1]:=tdIyVulQ.user.theta_CM*t;
tdIyVulQ.user_Q[10][2]:=tdIyVulQ.user.theta_DM*t;
tdIyVulQ.user_Q[10][3]:=tdIyVulQ.user.theta_EM*t;
tdIyVulQ.user_Q[10][4]:=tdIyVulQ.user.theta_FM*t;
tdIyVulQ.user_Q[10][5]:=tdIyVulQ.user.theta_GM*t;
tdIyVulQ.user_Q[10][6]:=tdIyVulQ.user.theta_HM*t;
tdIyVulQ.user_Q[10][7]:=tdIyVulQ.user.theta_IM*t;
tdIyVulQ.user_Q[10][8]:=tdIyVulQ.user.theta_KM*t;
tdIyVulQ.user_Q[10][9]:=tdIyVulQ.user.theta_LM*t;
tdIyVulQ.user_Q[10][11]:=tdIyVulQ.user.theta_MN*t;
tdIyVulQ.user_Q[10][12]:=tdIyVulQ.user.theta_MP*t;
tdIyVulQ.user_Q[10][13]:=tdIyVulQ.user.theta_MQ*t;
tdIyVulQ.user_Q[10][14]:=tdIyVulQ.user.theta_MR*t;
tdIyVulQ.user_Q[10][15]:=tdIyVulQ.user.theta_MS*t;
tdIyVulQ.user_Q[10][16]:=tdIyVulQ.user.theta_MT*t;
tdIyVulQ.user_Q[10][17]:=tdIyVulQ.user.theta_MV*t;
tdIyVulQ.user_Q[10][18]:=tdIyVulQ.user.theta_MW*t;
tdIyVulQ.user_Q[10][19]:=tdIyVulQ.user.theta_MY*t;
tdIyVulQ.user_Q[11][0]:=tdIyVulQ.user.theta_AN*t;
tdIyVulQ.user_Q[11][1]:=tdIyVulQ.user.theta_CN*t;
tdIyVulQ.user_Q[11][2]:=tdIyVulQ.user.theta_DN*t;
tdIyVulQ.user_Q[11][3]:=tdIyVulQ.user.theta_EN*t;
tdIyVulQ.user_Q[11][4]:=tdIyVulQ.user.theta_FN*t;
tdIyVulQ.user_Q[11][5]:=tdIyVulQ.user.theta_GN*t;
tdIyVulQ.user_Q[11][6]:=tdIyVulQ.user.theta_HN*t;
tdIyVulQ.user_Q[11][7]:=tdIyVulQ.user.theta_IN*t;
tdIyVulQ.user_Q[11][8]:=tdIyVulQ.user.theta_KN*t;
tdIyVulQ.user_Q[11][9]:=tdIyVulQ.user.theta_LN*t;
tdIyVulQ.user_Q[11][10]:=tdIyVulQ.user.theta_MN*t;
tdIyVulQ.user_Q[11][12]:=tdIyVulQ.user.theta_NP*t;
tdIyVulQ.user_Q[11][13]:=tdIyVulQ.user.theta_NQ*t;
tdIyVulQ.user_Q[11][14]:=tdIyVulQ.user.theta_NR*t;
tdIyVulQ.user_Q[11][15]:=tdIyVulQ.user.theta_NS*t;
tdIyVulQ.user_Q[11][16]:=tdIyVulQ.user.theta_NT*t;
tdIyVulQ.user_Q[11][17]:=tdIyVulQ.user.theta_NV*t;
tdIyVulQ.user_Q[11][18]:=tdIyVulQ.user.theta_NW*t;
tdIyVulQ.user_Q[11][19]:=tdIyVulQ.user.theta_NY*t;
tdIyVulQ.user_Q[12][0]:=tdIyVulQ.user.theta_AP*t;
tdIyVulQ.user_Q[12][1]:=tdIyVulQ.user.theta_CP*t;
tdIyVulQ.user_Q[12][2]:=tdIyVulQ.user.theta_DP*t;
tdIyVulQ.user_Q[12][3]:=tdIyVulQ.user.theta_EP*t;
tdIyVulQ.user_Q[12][4]:=tdIyVulQ.user.theta_FP*t;
tdIyVulQ.user_Q[12][5]:=tdIyVulQ.user.theta_GP*t;
tdIyVulQ.user_Q[12][6]:=tdIyVulQ.user.theta_HP*t;
tdIyVulQ.user_Q[12][7]:=tdIyVulQ.user.theta_IP*t;
tdIyVulQ.user_Q[12][8]:=tdIyVulQ.user.theta_KP*t;
tdIyVulQ.user_Q[12][9]:=tdIyVulQ.user.theta_LP*t;
tdIyVulQ.user_Q[12][10]:=tdIyVulQ.user.theta_MP*t;
tdIyVulQ.user_Q[12][11]:=tdIyVulQ.user.theta_NP*t;
tdIyVulQ.user_Q[12][13]:=tdIyVulQ.user.theta_PQ*t;
tdIyVulQ.user_Q[12][14]:=tdIyVulQ.user.theta_PR*t;
tdIyVulQ.user_Q[12][15]:=tdIyVulQ.user.theta_PS*t;
tdIyVulQ.user_Q[12][16]:=tdIyVulQ.user.theta_PT*t;
tdIyVulQ.user_Q[12][17]:=tdIyVulQ.user.theta_PV*t;
tdIyVulQ.user_Q[12][18]:=tdIyVulQ.user.theta_PW*t;
tdIyVulQ.user_Q[12][19]:=tdIyVulQ.user.theta_PY*t;
tdIyVulQ.user_Q[13][0]:=tdIyVulQ.user.theta_AQ*t;
tdIyVulQ.user_Q[13][1]:=tdIyVulQ.user.theta_CQ*t;
tdIyVulQ.user_Q[13][2]:=tdIyVulQ.user.theta_DQ*t;
tdIyVulQ.user_Q[13][3]:=tdIyVulQ.user.theta_EQ*t;
tdIyVulQ.user_Q[13][4]:=tdIyVulQ.user.theta_FQ*t;
tdIyVulQ.user_Q[13][5]:=tdIyVulQ.user.theta_GQ*t;
tdIyVulQ.user_Q[13][6]:=tdIyVulQ.user.theta_HQ*t;
tdIyVulQ.user_Q[13][7]:=tdIyVulQ.user.theta_IQ*t;
tdIyVulQ.user_Q[13][8]:=tdIyVulQ.user.theta_KQ*t;
tdIyVulQ.user_Q[13][9]:=tdIyVulQ.user.theta_LQ*t;
tdIyVulQ.user_Q[13][10]:=tdIyVulQ.user.theta_MQ*t;
tdIyVulQ.user_Q[13][11]:=tdIyVulQ.user.theta_NQ*t;
tdIyVulQ.user_Q[13][12]:=tdIyVulQ.user.theta_PQ*t;
tdIyVulQ.user_Q[13][14]:=tdIyVulQ.user.theta_QR*t;
tdIyVulQ.user_Q[13][15]:=tdIyVulQ.user.theta_QS*t;
tdIyVulQ.user_Q[13][16]:=tdIyVulQ.user.theta_QT*t;
tdIyVulQ.user_Q[13][17]:=tdIyVulQ.user.theta_QV*t;
tdIyVulQ.user_Q[13][18]:=tdIyVulQ.user.theta_QW*t;
tdIyVulQ.user_Q[13][19]:=tdIyVulQ.user.theta_QY*t;
tdIyVulQ.user_Q[14][0]:=tdIyVulQ.user.theta_AR*t;
tdIyVulQ.user_Q[14][1]:=tdIyVulQ.user.theta_CR*t;
tdIyVulQ.user_Q[14][2]:=tdIyVulQ.user.theta_DR*t;
tdIyVulQ.user_Q[14][3]:=tdIyVulQ.user.theta_ER*t;
tdIyVulQ.user_Q[14][4]:=tdIyVulQ.user.theta_FR*t;
tdIyVulQ.user_Q[14][5]:=tdIyVulQ.user.theta_GR*t;
tdIyVulQ.user_Q[14][6]:=tdIyVulQ.user.theta_HR*t;
tdIyVulQ.user_Q[14][7]:=tdIyVulQ.user.theta_IR*t;
tdIyVulQ.user_Q[14][8]:=tdIyVulQ.user.theta_KR*t;
tdIyVulQ.user_Q[14][9]:=tdIyVulQ.user.theta_LR*t;
tdIyVulQ.user_Q[14][10]:=tdIyVulQ.user.theta_MR*t;
tdIyVulQ.user_Q[14][11]:=tdIyVulQ.user.theta_NR*t;
tdIyVulQ.user_Q[14][12]:=tdIyVulQ.user.theta_PR*t;
tdIyVulQ.user_Q[14][13]:=tdIyVulQ.user.theta_QR*t;
tdIyVulQ.user_Q[14][15]:=tdIyVulQ.user.theta_RS*t;
tdIyVulQ.user_Q[14][16]:=tdIyVulQ.user.theta_RT*t;
tdIyVulQ.user_Q[14][17]:=tdIyVulQ.user.theta_RV*t;
tdIyVulQ.user_Q[14][18]:=tdIyVulQ.user.theta_RW*t;
tdIyVulQ.user_Q[14][19]:=tdIyVulQ.user.theta_RY*t;
tdIyVulQ.user_Q[15][0]:=tdIyVulQ.user.theta_AS*t;
tdIyVulQ.user_Q[15][1]:=tdIyVulQ.user.theta_CS*t;
tdIyVulQ.user_Q[15][2]:=tdIyVulQ.user.theta_DS*t;
tdIyVulQ.user_Q[15][3]:=tdIyVulQ.user.theta_ES*t;
tdIyVulQ.user_Q[15][4]:=tdIyVulQ.user.theta_FS*t;
tdIyVulQ.user_Q[15][5]:=tdIyVulQ.user.theta_GS*t;
tdIyVulQ.user_Q[15][6]:=tdIyVulQ.user.theta_HS*t;
tdIyVulQ.user_Q[15][7]:=tdIyVulQ.user.theta_IS*t;
tdIyVulQ.user_Q[15][8]:=tdIyVulQ.user.theta_KS*t;
tdIyVulQ.user_Q[15][9]:=tdIyVulQ.user.theta_LS*t;
tdIyVulQ.user_Q[15][10]:=tdIyVulQ.user.theta_MS*t;
tdIyVulQ.user_Q[15][11]:=tdIyVulQ.user.theta_NS*t;
tdIyVulQ.user_Q[15][12]:=tdIyVulQ.user.theta_PS*t;
tdIyVulQ.user_Q[15][13]:=tdIyVulQ.user.theta_QS*t;
tdIyVulQ.user_Q[15][14]:=tdIyVulQ.user.theta_RS*t;
tdIyVulQ.user_Q[15][16]:=tdIyVulQ.user.theta_ST*t;
tdIyVulQ.user_Q[15][17]:=tdIyVulQ.user.theta_SV*t;
tdIyVulQ.user_Q[15][18]:=tdIyVulQ.user.theta_SW*t;
tdIyVulQ.user_Q[15][19]:=tdIyVulQ.user.theta_SY*t;
tdIyVulQ.user_Q[16][0]:=tdIyVulQ.user.theta_AT*t;
tdIyVulQ.user_Q[16][1]:=tdIyVulQ.user.theta_CT*t;
tdIyVulQ.user_Q[16][2]:=tdIyVulQ.user.theta_DT*t;
tdIyVulQ.user_Q[16][3]:=tdIyVulQ.user.theta_ET*t;
tdIyVulQ.user_Q[16][4]:=tdIyVulQ.user.theta_FT*t;
tdIyVulQ.user_Q[16][5]:=tdIyVulQ.user.theta_GT*t;
tdIyVulQ.user_Q[16][6]:=tdIyVulQ.user.theta_HT*t;
tdIyVulQ.user_Q[16][7]:=tdIyVulQ.user.theta_IT*t;
tdIyVulQ.user_Q[16][8]:=tdIyVulQ.user.theta_KT*t;
tdIyVulQ.user_Q[16][9]:=tdIyVulQ.user.theta_LT*t;
tdIyVulQ.user_Q[16][10]:=tdIyVulQ.user.theta_MT*t;
tdIyVulQ.user_Q[16][11]:=tdIyVulQ.user.theta_NT*t;
tdIyVulQ.user_Q[16][12]:=tdIyVulQ.user.theta_PT*t;
tdIyVulQ.user_Q[16][13]:=tdIyVulQ.user.theta_QT*t;
tdIyVulQ.user_Q[16][14]:=tdIyVulQ.user.theta_RT*t;
tdIyVulQ.user_Q[16][15]:=tdIyVulQ.user.theta_ST*t;
tdIyVulQ.user_Q[16][17]:=tdIyVulQ.user.theta_TV*t;
tdIyVulQ.user_Q[16][18]:=tdIyVulQ.user.theta_TW*t;
tdIyVulQ.user_Q[16][19]:=tdIyVulQ.user.theta_TY*t;
tdIyVulQ.user_Q[17][0]:=tdIyVulQ.user.theta_AV*t;
tdIyVulQ.user_Q[17][1]:=tdIyVulQ.user.theta_CV*t;
tdIyVulQ.user_Q[17][2]:=tdIyVulQ.user.theta_DV*t;
tdIyVulQ.user_Q[17][3]:=tdIyVulQ.user.theta_EV*t;
tdIyVulQ.user_Q[17][4]:=tdIyVulQ.user.theta_FV*t;
tdIyVulQ.user_Q[17][5]:=tdIyVulQ.user.theta_GV*t;
tdIyVulQ.user_Q[17][6]:=tdIyVulQ.user.theta_HV*t;
tdIyVulQ.user_Q[17][7]:=tdIyVulQ.user.theta_IV*t;
tdIyVulQ.user_Q[17][8]:=tdIyVulQ.user.theta_KV*t;
tdIyVulQ.user_Q[17][9]:=tdIyVulQ.user.theta_LV*t;
tdIyVulQ.user_Q[17][10]:=tdIyVulQ.user.theta_MV*t;
tdIyVulQ.user_Q[17][11]:=tdIyVulQ.user.theta_NV*t;
tdIyVulQ.user_Q[17][12]:=tdIyVulQ.user.theta_PV*t;
tdIyVulQ.user_Q[17][13]:=tdIyVulQ.user.theta_QV*t;
tdIyVulQ.user_Q[17][14]:=tdIyVulQ.user.theta_RV*t;
tdIyVulQ.user_Q[17][15]:=tdIyVulQ.user.theta_SV*t;
tdIyVulQ.user_Q[17][16]:=tdIyVulQ.user.theta_TV*t;
tdIyVulQ.user_Q[17][18]:=tdIyVulQ.user.theta_VW*t;
tdIyVulQ.user_Q[17][19]:=tdIyVulQ.user.theta_VY*t;
tdIyVulQ.user_Q[18][0]:=tdIyVulQ.user.theta_AW*t;
tdIyVulQ.user_Q[18][1]:=tdIyVulQ.user.theta_CW*t;
tdIyVulQ.user_Q[18][2]:=tdIyVulQ.user.theta_DW*t;
tdIyVulQ.user_Q[18][3]:=tdIyVulQ.user.theta_EW*t;
tdIyVulQ.user_Q[18][4]:=tdIyVulQ.user.theta_FW*t;
tdIyVulQ.user_Q[18][5]:=tdIyVulQ.user.theta_GW*t;
tdIyVulQ.user_Q[18][6]:=tdIyVulQ.user.theta_HW*t;
tdIyVulQ.user_Q[18][7]:=tdIyVulQ.user.theta_IW*t;
tdIyVulQ.user_Q[18][8]:=tdIyVulQ.user.theta_KW*t;
tdIyVulQ.user_Q[18][9]:=tdIyVulQ.user.theta_LW*t;
tdIyVulQ.user_Q[18][10]:=tdIyVulQ.user.theta_MW*t;
tdIyVulQ.user_Q[18][11]:=tdIyVulQ.user.theta_NW*t;
tdIyVulQ.user_Q[18][12]:=tdIyVulQ.user.theta_PW*t;
tdIyVulQ.user_Q[18][13]:=tdIyVulQ.user.theta_QW*t;
tdIyVulQ.user_Q[18][14]:=tdIyVulQ.user.theta_RW*t;
tdIyVulQ.user_Q[18][15]:=tdIyVulQ.user.theta_SW*t;
tdIyVulQ.user_Q[18][16]:=tdIyVulQ.user.theta_TW*t;
tdIyVulQ.user_Q[18][17]:=tdIyVulQ.user.theta_VW*t;
tdIyVulQ.user_Q[18][19]:=tdIyVulQ.user.theta_WY*t;
tdIyVulQ.user_Q[19][0]:=tdIyVulQ.user.theta_AY*t;
tdIyVulQ.user_Q[19][1]:=tdIyVulQ.user.theta_CY*t;
tdIyVulQ.user_Q[19][2]:=tdIyVulQ.user.theta_DY*t;
tdIyVulQ.user_Q[19][3]:=tdIyVulQ.user.theta_EY*t;
tdIyVulQ.user_Q[19][4]:=tdIyVulQ.user.theta_FY*t;
tdIyVulQ.user_Q[19][5]:=tdIyVulQ.user.theta_GY*t;
tdIyVulQ.user_Q[19][6]:=tdIyVulQ.user.theta_HY*t;
tdIyVulQ.user_Q[19][7]:=tdIyVulQ.user.theta_IY*t;
tdIyVulQ.user_Q[19][8]:=tdIyVulQ.user.theta_KY*t;
tdIyVulQ.user_Q[19][9]:=tdIyVulQ.user.theta_LY*t;
tdIyVulQ.user_Q[19][10]:=tdIyVulQ.user.theta_MY*t;
tdIyVulQ.user_Q[19][11]:=tdIyVulQ.user.theta_NY*t;
tdIyVulQ.user_Q[19][12]:=tdIyVulQ.user.theta_PY*t;
tdIyVulQ.user_Q[19][13]:=tdIyVulQ.user.theta_QY*t;
tdIyVulQ.user_Q[19][14]:=tdIyVulQ.user.theta_RY*t;
tdIyVulQ.user_Q[19][15]:=tdIyVulQ.user.theta_SY*t;
tdIyVulQ.user_Q[19][16]:=tdIyVulQ.user.theta_TY*t;
tdIyVulQ.user_Q[19][17]:=tdIyVulQ.user.theta_VY*t;
tdIyVulQ.user_Q[19][18]:=tdIyVulQ.user.theta_WY*t;


tdIyVulQ.user_pi={
{0.08380014968362326}
{0.01111287505953326}
{0.05778695030957295}
{0.05878484113124532}
{0.03832807928696165}
{0.09139772753044702}
{0.02850792642823124}
{0.05526954391853582}
{0.06937609144308621}
{0.08894835914997845}
{0.01911868096976845}
{0.03406436395799787}
{0.04209284920508925}
{0.03091193613498741}
{0.03957544281405212}
{0.07529539836255188}
{0.05168620869525775}
{0.08164561268228517}
{0.0124282765971923}
{0.02986868663960266}
};
Model tdIyVulQ.user=(tdIyVulQ.user_Q,tdIyVulQ.user_pi);
TRY_NUMERIC_SEQUENCE_MATCH=0;
ACCEPT_ROOTED_TREES=0;

UseModel (tdIyVulQ.user);
Tree tdIyVulQ.tree_0=(((t5,t3)Node3,((t16,t7)Node7,t4)Node6)Node2,((((t11,t2)Node14,(t9,t18)Node17)Node13,((t12,t20)Node21,t13)Node20)Node12,t17)Node11,(((t6,t14)Node28,t15)Node27,((t8,t19)Node33,(t10,t1)Node36)Node32)Node26);

UseModel (tdIyVulQ.user);
Tree tdIyVulQ.tree_1=((((t30,(t20,t15)Node6)Node4,((((t19,t10)Node12,t43)Node11,((t16,(t31,t18)Node19)Node17,(t51,t11)Node22)Node16)Node10,(t33,(((t40,(t52,(t9,t3)Node33)Node31)Node29,(t34,((t35,(t50,t39)Node41)Node39,t21)Node38)Node36)Node28,(((((t5,t1)Node49,t28)Node48,t2)Node47,(t37,t13)Node54)Node46,(t44,((t29,t8)Node60,t6)Node59)Node57)Node45)Node27)Node25)Node9)Node3,(t4,(t47,t46)Node66)Node64)Node2,(((t12,t23)Node71,((t41,t48)Node75,(t14,t36)Node78)Node74)Node70,t49)Node69,(((t42,(t38,t27)Node86)Node84,(t26,t22)Node89)Node83,(t17,(((t24,t7)Node96,(t53,(t25,t45)Node101)Node99)Node95,t32)Node94)Node92)Node82);

UseModel (tdIyVulQ.user);
Tree tdIyVulQ.tree_2=((((((((t22,t92)Node8,t106)Node7,(t33,((t47,t116)Node15,t7)Node14)Node12)Node6,((t107,t19)Node20,(((((t31,t56)Node27,t27)Node26,(t39,(t118,(t46,t45)Node35)Node33)Node31)Node25,((((t37,t34)Node41,(t71,(t43,t93)Node46)Node44)Node40,((t15,t100)Node50,(t12,t5)Node53)Node49)Node39,(((t16,(t83,t35)Node60)Node58,t25)Node57,t103)Node56)Node38)Node24,(((((t110,(t90,t41)Node71)Node69,t97)Node68,((((t42,(t8,t17)Node80)Node78,t58)Node77,(t29,t18)Node84)Node76,(t96,t95)Node87)Node75)Node67,(t85,t73)Node90)Node66,((t67,(t86,t51)Node96)Node94,t68)Node93)Node65)Node23)Node19)Node5,((((((t122,(t3,t80)Node107)Node105,(t88,t113)Node110)Node104,(t38,t94)Node113)Node103,t87)Node102,((t9,t64)Node118,((((t99,t6)Node124,t120)Node123,(t62,t91)Node128)Node122,((t26,t40)Node132,t112)Node131)Node121)Node117)Node101,(((t1,t23)Node138,t76)Node137,t119)Node136)Node100)Node4,(((t77,(t72,t75)Node147)Node145,(t2,t52)Node150)Node144,(t28,(t82,(t20,(t53,t57)Node159)Node157)Node155)Node153)Node143)Node3,(((((t102,t104)Node166,t61)Node165,(t14,(((t101,t13)Node174,t115)Node173,t81)Node172)Node170)Node164,(t30,t70)Node179)Node163,(((t108,((t50,((t59,t44)Node190,(t11,t32)Node193)Node189)Node187,(t78,t89)Node196)Node186)Node184,(t55,(t111,t69)Node201)Node199)Node183,((((t121,(t123,t79)Node209)Node207,t74)Node206,t109)Node205,(((t54,t24)Node216,t60)Node215,(((t114,t36)Node222,t48)Node221,(t10,t4)Node226)Node220)Node214)Node204)Node182)Node162)Node2,t98,((t21,((t84,t105)Node234,t66)Node233)Node231,((t49,t117)Node239,(t65,t63)Node242)Node238)Node230);

UseModel (tdIyVulQ.user);
Tree tdIyVulQ.tree_3=((((t18,((t88,t34)Node7,(t10,t44)Node10)Node6)Node4,(((t13,t57)Node15,(t33,t94)Node18)Node14,(((t15,t82)Node23,t112)Node22,((t12,(t61,t86)Node30)Node28,t93)Node27)Node21)Node13)Node3,((((t71,t31)Node37,t42)Node36,((t80,t68)Node42,(((t32,t28)Node47,t17)Node46,t110)Node45)Node41)Node35,(((t100,t60)Node54,t36)Node53,t50)Node52)Node34)Node2,((((((t72,(t19,t111)Node66)Node64,t29)Node63,(t14,t83)Node70)Node62,(((((t99,t53)Node77,(t5,(t9,(t40,t85)Node84)Node82)Node80)Node76,((t25,t75)Node88,t4)Node87)Node75,((t38,((t45,t39)Node96,t54)Node95)Node93,(t113,t41)Node100)Node92)Node74,t84)Node73)Node61,(t89,t106)Node104)Node60,(((t92,t97)Node109,((t7,t74)Node113,((t6,(t78,t47)Node119)Node117,t107)Node116)Node112)Node108,(((((((t48,t23)Node129,(t8,t16)Node132)Node128,((t58,(t95,t59)Node138)Node136,t63)Node135)Node127,(t116,t73)Node142)Node126,t115)Node125,((t101,((t43,t49)Node150,(t22,t87)Node153)Node149)Node147,(t27,t62)Node156)Node146)Node124,(((((t3,t35)Node163,(t26,(((t37,t109)Node170,(t65,(t20,t105)Node175)Node173)Node169,(t70,(t96,(t81,t1)Node182)Node180)Node178)Node168)Node166)Node162,(t69,(t30,t51)Node187)Node185)Node161,(((t103,t2)Node192,t21)Node191,t90)Node190)Node160,((t108,(t77,t67)Node200)Node198,(t91,t46)Node203)Node197)Node159)Node123)Node107)Node59,((((t52,((t55,((t102,t79)Node215,t11)Node214)Node212,t104)Node211)Node209,(t64,t76)Node220)Node208,t114)Node207,(t24,(t56,(t98,t66)Node228)Node226)Node224)Node206);

UseModel (tdIyVulQ.user);
Tree tdIyVulQ.tree_4=(((t30,((t46,t67)Node6,t97)Node5)Node3,(((t44,t84)Node12,t91)Node11,((t18,t17)Node17,(t58,(t63,t12)Node22)Node20)Node16)Node10)Node2,(((t71,(t51,t62)Node29)Node27,(((t5,t66)Node34,((t95,t22)Node38,t101)Node37)Node33,((t93,t52)Node43,((t102,t76)Node47,t64)Node46)Node42)Node32)Node26,(((((t103,((t11,t81)Node58,(t23,t13)Node61)Node57)Node55,((t56,t16)Node65,t39)Node64)Node54,t37)Node53,((((t55,t100)Node73,(t73,t31)Node76)Node72,t88)Node71,((t72,t38)Node81,t15)Node80)Node70)Node52,t7)Node51)Node25,((((t8,t94)Node89,t3)Node88,(t20,((t61,(t45,(t2,t6)Node100)Node98)Node96,t98)Node95)Node93)Node87,((t42,(((t74,(t10,t41)Node111)Node109,((((t1,t59)Node117,t78)Node116,((t83,((t50,t99)Node125,t89)Node124)Node122,t48)Node121)Node115,t34)Node114)Node108,t25)Node107)Node105,((((((t75,t77)Node137,t36)Node136,(t43,(t47,t68)Node143)Node141)Node135,(t14,(t40,t65)Node148)Node146)Node134,((t32,t85)Node152,((t28,t82)Node156,((t69,t9)Node160,t92)Node159)Node155)Node151)Node133,(((((t27,(t96,(t86,t87)Node172)Node170)Node168,t35)Node167,t60)Node166,(((t54,(t70,t90)Node181)Node179,((t24,t57)Node185,t4)Node184)Node178,(t21,t79)Node189)Node177)Node165,((((t26,t49)Node195,t19)Node194,t33)Node193,((t29,t80)Node201,t53)Node200)Node192)Node164)Node132)Node104)Node86);

tdIyVulQ.tree_0.t5.t:=protein_gtr.gtr_scaler_0*0.1823219025945176;
tdIyVulQ.tree_0.t3.t:=protein_gtr.gtr_scaler_0*0.2255742536754176;
tdIyVulQ.tree_0.Node3.t:=protein_gtr.gtr_scaler_0*0.2581560459368029;
tdIyVulQ.tree_0.t16.t:=protein_gtr.gtr_scaler_0*0.01508398670164415;
tdIyVulQ.tree_0.t7.t:=protein_gtr.gtr_scaler_0*0.1233352391831005;
tdIyVulQ.tree_0.Node7.t:=protein_gtr.gtr_scaler_0*0.01130996178844901;
tdIyVulQ.tree_0.t4.t:=protein_gtr.gtr_scaler_0*0.01074274053203225;
tdIyVulQ.tree_0.Node6.t:=protein_gtr.gtr_scaler_0*0.107711494219844;
tdIyVulQ.tree_0.Node2.t:=protein_gtr.gtr_scaler_0*0.0641027146502353;
tdIyVulQ.tree_0.t11.t:=protein_gtr.gtr_scaler_0*0.05440159383546402;
tdIyVulQ.tree_0.t2.t:=protein_gtr.gtr_scaler_0*0.118657456982401;
tdIyVulQ.tree_0.Node14.t:=protein_gtr.gtr_scaler_0*0.01358891483048738;
tdIyVulQ.tree_0.t9.t:=protein_gtr.gtr_scaler_0*0.4599545588833228;
tdIyVulQ.tree_0.t18.t:=protein_gtr.gtr_scaler_0*0.09324219693572693;
tdIyVulQ.tree_0.Node17.t:=protein_gtr.gtr_scaler_0*0.1345158599525771;
tdIyVulQ.tree_0.Node13.t:=protein_gtr.gtr_scaler_0*0.08951127434587171;
tdIyVulQ.tree_0.t12.t:=protein_gtr.gtr_scaler_0*0.03534804001768583;
tdIyVulQ.tree_0.t20.t:=protein_gtr.gtr_scaler_0*1.032767001558182;
tdIyVulQ.tree_0.Node21.t:=0;
tdIyVulQ.tree_0.t13.t:=protein_gtr.gtr_scaler_0*0.09176535147071566;
tdIyVulQ.tree_0.Node20.t:=protein_gtr.gtr_scaler_0*0.07730696694292477;
tdIyVulQ.tree_0.Node12.t:=protein_gtr.gtr_scaler_0*0.06292183330966129;
tdIyVulQ.tree_0.t17.t:=protein_gtr.gtr_scaler_0*0.5871786550424334;
tdIyVulQ.tree_0.Node11.t:=protein_gtr.gtr_scaler_0*0.1518687983005199;
tdIyVulQ.tree_0.t6.t:=protein_gtr.gtr_scaler_0*0.4521774027960913;
tdIyVulQ.tree_0.t14.t:=protein_gtr.gtr_scaler_0*0.2432050382368341;
tdIyVulQ.tree_0.Node28.t:=protein_gtr.gtr_scaler_0*0.404863256090249;
tdIyVulQ.tree_0.t15.t:=protein_gtr.gtr_scaler_0*0.08640247407712569;
tdIyVulQ.tree_0.Node27.t:=protein_gtr.gtr_scaler_0*0.2835067037523428;
tdIyVulQ.tree_0.t8.t:=protein_gtr.gtr_scaler_0*0.1536781985252393;
tdIyVulQ.tree_0.t19.t:=protein_gtr.gtr_scaler_0*0.09994328275993372;
tdIyVulQ.tree_0.Node33.t:=protein_gtr.gtr_scaler_0*0.02735488814256505;
tdIyVulQ.tree_0.t10.t:=protein_gtr.gtr_scaler_0*0.2404362165690326;
tdIyVulQ.tree_0.t1.t:=protein_gtr.gtr_scaler_0*0.3659391614356844;
tdIyVulQ.tree_0.Node36.t:=protein_gtr.gtr_scaler_0*0.2559963988501608;
tdIyVulQ.tree_0.Node32.t:=protein_gtr.gtr_scaler_0*0.02973313039731926;
tdIyVulQ.tree_0.Node26.t:=protein_gtr.gtr_scaler_0*0.07665046679831045;
tdIyVulQ.tree_1.t30.t:=protein_gtr.gtr_scaler_1*0.03361419492638832;
tdIyVulQ.tree_1.t20.t:=protein_gtr.gtr_scaler_1*0.03010150474988168;
tdIyVulQ.tree_1.t15.t:=0;
tdIyVulQ.tree_1.Node6.t:=protein_gtr.gtr_scaler_1*0.03308740537089702;
tdIyVulQ.tree_1.Node4.t:=protein_gtr.gtr_scaler_1*0.4964648678791438;
tdIyVulQ.tree_1.t19.t:=protein_gtr.gtr_scaler_1*0.1832924985228757;
tdIyVulQ.tree_1.t10.t:=protein_gtr.gtr_scaler_1*0.09014836479154831;
tdIyVulQ.tree_1.Node12.t:=protein_gtr.gtr_scaler_1*0.3911781478177687;
tdIyVulQ.tree_1.t43.t:=protein_gtr.gtr_scaler_1*0.4262534599248687;
tdIyVulQ.tree_1.Node11.t:=protein_gtr.gtr_scaler_1*0.5844359157791355;
tdIyVulQ.tree_1.t16.t:=0;
tdIyVulQ.tree_1.t31.t:=protein_gtr.gtr_scaler_1*0.008662923331155084;
tdIyVulQ.tree_1.t18.t:=protein_gtr.gtr_scaler_1*0.4927112047524243;
tdIyVulQ.tree_1.Node19.t:=0;
tdIyVulQ.tree_1.Node17.t:=protein_gtr.gtr_scaler_1*0.0371226543263166;
tdIyVulQ.tree_1.t51.t:=protein_gtr.gtr_scaler_1*0.05252665722593797;
tdIyVulQ.tree_1.t11.t:=protein_gtr.gtr_scaler_1*0.4885190140520694;
tdIyVulQ.tree_1.Node22.t:=protein_gtr.gtr_scaler_1*0.04440434381084106;
tdIyVulQ.tree_1.Node16.t:=protein_gtr.gtr_scaler_1*0.1659957888058601;
tdIyVulQ.tree_1.Node10.t:=protein_gtr.gtr_scaler_1*0.1422047031101179;
tdIyVulQ.tree_1.t33.t:=protein_gtr.gtr_scaler_1*0.3000693879657467;
tdIyVulQ.tree_1.t40.t:=protein_gtr.gtr_scaler_1*0.5729494926952512;
tdIyVulQ.tree_1.t52.t:=protein_gtr.gtr_scaler_1*0.1341362758370208;
tdIyVulQ.tree_1.t9.t:=protein_gtr.gtr_scaler_1*0.4095090155608082;
tdIyVulQ.tree_1.t3.t:=protein_gtr.gtr_scaler_1*0.01124407013477081;
tdIyVulQ.tree_1.Node33.t:=protein_gtr.gtr_scaler_1*0.0478759206245602;
tdIyVulQ.tree_1.Node31.t:=protein_gtr.gtr_scaler_1*0.2735091274324336;
tdIyVulQ.tree_1.Node29.t:=protein_gtr.gtr_scaler_1*0.01246998832191582;
tdIyVulQ.tree_1.t34.t:=protein_gtr.gtr_scaler_1*0.1430642259180261;
tdIyVulQ.tree_1.t35.t:=protein_gtr.gtr_scaler_1*0.2124358062203493;
tdIyVulQ.tree_1.t50.t:=protein_gtr.gtr_scaler_1*0.2255237093157554;
tdIyVulQ.tree_1.t39.t:=protein_gtr.gtr_scaler_1*0.05724226629612609;
tdIyVulQ.tree_1.Node41.t:=protein_gtr.gtr_scaler_1*0.7342919400875119;
tdIyVulQ.tree_1.Node39.t:=protein_gtr.gtr_scaler_1*0.1417535132041204;
tdIyVulQ.tree_1.t21.t:=protein_gtr.gtr_scaler_1*0.04423255970706242;
tdIyVulQ.tree_1.Node38.t:=protein_gtr.gtr_scaler_1*0.1341889088667573;
tdIyVulQ.tree_1.Node36.t:=protein_gtr.gtr_scaler_1*0.1970613637476041;
tdIyVulQ.tree_1.Node28.t:=0;
tdIyVulQ.tree_1.t5.t:=protein_gtr.gtr_scaler_1*0.1542425718098929;
tdIyVulQ.tree_1.t1.t:=protein_gtr.gtr_scaler_1*0.090960544719314;
tdIyVulQ.tree_1.Node49.t:=protein_gtr.gtr_scaler_1*0.3111908954251038;
tdIyVulQ.tree_1.t28.t:=protein_gtr.gtr_scaler_1*0.02942166838454076;
tdIyVulQ.tree_1.Node48.t:=protein_gtr.gtr_scaler_1*0.03107006980341035;
tdIyVulQ.tree_1.t2.t:=protein_gtr.gtr_scaler_1*0.05054767138352799;
tdIyVulQ.tree_1.Node47.t:=protein_gtr.gtr_scaler_1*0.007058313757381175;
tdIyVulQ.tree_1.t37.t:=protein_gtr.gtr_scaler_1*0.2968244556604112;
tdIyVulQ.tree_1.t13.t:=protein_gtr.gtr_scaler_1*0.1911072935309189;
tdIyVulQ.tree_1.Node54.t:=protein_gtr.gtr_scaler_1*0.4134124424178779;
tdIyVulQ.tree_1.Node46.t:=protein_gtr.gtr_scaler_1*0.2478843196480524;
tdIyVulQ.tree_1.t44.t:=protein_gtr.gtr_scaler_1*0.08498882618926697;
tdIyVulQ.tree_1.t29.t:=protein_gtr.gtr_scaler_1*0.2767792229988453;
tdIyVulQ.tree_1.t8.t:=protein_gtr.gtr_scaler_1*0.3482542803306491;
tdIyVulQ.tree_1.Node60.t:=protein_gtr.gtr_scaler_1*0.173483319862311;
tdIyVulQ.tree_1.t6.t:=0;
tdIyVulQ.tree_1.Node59.t:=protein_gtr.gtr_scaler_1*0.04017827049363094;
tdIyVulQ.tree_1.Node57.t:=protein_gtr.gtr_scaler_1*0.3382326493581094;
tdIyVulQ.tree_1.Node45.t:=protein_gtr.gtr_scaler_1*0.1039058653000819;
tdIyVulQ.tree_1.Node27.t:=protein_gtr.gtr_scaler_1*0.0702091716516936;
tdIyVulQ.tree_1.Node25.t:=protein_gtr.gtr_scaler_1*0.4497776838051228;
tdIyVulQ.tree_1.Node9.t:=protein_gtr.gtr_scaler_1*0.06059666235871244;
tdIyVulQ.tree_1.Node3.t:=protein_gtr.gtr_scaler_1*0.5382466012051382;
tdIyVulQ.tree_1.t4.t:=protein_gtr.gtr_scaler_1*0.2157052852652052;
tdIyVulQ.tree_1.t47.t:=protein_gtr.gtr_scaler_1*0.1496196016086944;
tdIyVulQ.tree_1.t46.t:=protein_gtr.gtr_scaler_1*0.1169152040177968;
tdIyVulQ.tree_1.Node66.t:=protein_gtr.gtr_scaler_1*0.2518773983600936;
tdIyVulQ.tree_1.Node64.t:=protein_gtr.gtr_scaler_1*0.1264614789549762;
tdIyVulQ.tree_1.Node2.t:=protein_gtr.gtr_scaler_1*0.06471594960117436;
tdIyVulQ.tree_1.t12.t:=protein_gtr.gtr_scaler_1*0.3420825579716035;
tdIyVulQ.tree_1.t23.t:=protein_gtr.gtr_scaler_1*0.09686729173245846;
tdIyVulQ.tree_1.Node71.t:=protein_gtr.gtr_scaler_1*0.2236874634145853;
tdIyVulQ.tree_1.t41.t:=protein_gtr.gtr_scaler_1*0.1357612804907838;
tdIyVulQ.tree_1.t48.t:=protein_gtr.gtr_scaler_1*0.1375063440856893;
tdIyVulQ.tree_1.Node75.t:=protein_gtr.gtr_scaler_1*0.5340102779670627;
tdIyVulQ.tree_1.t14.t:=protein_gtr.gtr_scaler_1*0.2954821956401958;
tdIyVulQ.tree_1.t36.t:=protein_gtr.gtr_scaler_1*0.4061151035812682;
tdIyVulQ.tree_1.Node78.t:=protein_gtr.gtr_scaler_1*0.4605754530955829;
tdIyVulQ.tree_1.Node74.t:=protein_gtr.gtr_scaler_1*0.5471502878254146;
tdIyVulQ.tree_1.Node70.t:=protein_gtr.gtr_scaler_1*0.02630274010359353;
tdIyVulQ.tree_1.t49.t:=protein_gtr.gtr_scaler_1*0.3025027668142148;
tdIyVulQ.tree_1.Node69.t:=protein_gtr.gtr_scaler_1*0.1073426087206776;
tdIyVulQ.tree_1.t42.t:=protein_gtr.gtr_scaler_1*0.04610420027668592;
tdIyVulQ.tree_1.t38.t:=protein_gtr.gtr_scaler_1*0.1017971423309842;
tdIyVulQ.tree_1.t27.t:=protein_gtr.gtr_scaler_1*0.03158974613630749;
tdIyVulQ.tree_1.Node86.t:=protein_gtr.gtr_scaler_1*0.160502431247967;
tdIyVulQ.tree_1.Node84.t:=protein_gtr.gtr_scaler_1*0.06702668153060072;
tdIyVulQ.tree_1.t26.t:=protein_gtr.gtr_scaler_1*0.1465470779005794;
tdIyVulQ.tree_1.t22.t:=protein_gtr.gtr_scaler_1*0.130746442862395;
tdIyVulQ.tree_1.Node89.t:=protein_gtr.gtr_scaler_1*0.01002644407902653;
tdIyVulQ.tree_1.Node83.t:=protein_gtr.gtr_scaler_1*0.05876462535436387;
tdIyVulQ.tree_1.t17.t:=protein_gtr.gtr_scaler_1*0.07946577074401891;
tdIyVulQ.tree_1.t24.t:=protein_gtr.gtr_scaler_1*0.4201556985088959;
tdIyVulQ.tree_1.t7.t:=protein_gtr.gtr_scaler_1*0.06469946729974145;
tdIyVulQ.tree_1.Node96.t:=0;
tdIyVulQ.tree_1.t53.t:=protein_gtr.gtr_scaler_1*0.0179083003736526;
tdIyVulQ.tree_1.t25.t:=protein_gtr.gtr_scaler_1*0.3156023966702221;
tdIyVulQ.tree_1.t45.t:=protein_gtr.gtr_scaler_1*0.08358990267084712;
tdIyVulQ.tree_1.Node101.t:=protein_gtr.gtr_scaler_1*0.02322627485451875;
tdIyVulQ.tree_1.Node99.t:=protein_gtr.gtr_scaler_1*0.02747681294325375;
tdIyVulQ.tree_1.Node95.t:=protein_gtr.gtr_scaler_1*0.07679492432025042;
tdIyVulQ.tree_1.t32.t:=protein_gtr.gtr_scaler_1*0.7648192772066225;
tdIyVulQ.tree_1.Node94.t:=protein_gtr.gtr_scaler_1*0.02313368603515169;
tdIyVulQ.tree_1.Node92.t:=protein_gtr.gtr_scaler_1*0.01530227706235878;
tdIyVulQ.tree_1.Node82.t:=protein_gtr.gtr_scaler_1*0.2465246110058374;
tdIyVulQ.tree_2.t22.t:=protein_gtr.gtr_scaler_2*0.0240322010990713;
tdIyVulQ.tree_2.t92.t:=0;
tdIyVulQ.tree_2.Node8.t:=protein_gtr.gtr_scaler_2*0.1308791618019106;
tdIyVulQ.tree_2.t106.t:=protein_gtr.gtr_scaler_2*0.02346076647084401;
tdIyVulQ.tree_2.Node7.t:=0;
tdIyVulQ.tree_2.t33.t:=protein_gtr.gtr_scaler_2*0.05078622786066318;
tdIyVulQ.tree_2.t47.t:=0;
tdIyVulQ.tree_2.t116.t:=protein_gtr.gtr_scaler_2*0.413248399250741;
tdIyVulQ.tree_2.Node15.t:=protein_gtr.gtr_scaler_2*0.1438054974034469;
tdIyVulQ.tree_2.t7.t:=protein_gtr.gtr_scaler_2*0.1864504929813101;
tdIyVulQ.tree_2.Node14.t:=protein_gtr.gtr_scaler_2*0.03761672127186752;
tdIyVulQ.tree_2.Node12.t:=0;
tdIyVulQ.tree_2.Node6.t:=protein_gtr.gtr_scaler_2*0.1617514948818246;
tdIyVulQ.tree_2.t107.t:=protein_gtr.gtr_scaler_2*0.02440937404336094;
tdIyVulQ.tree_2.t19.t:=protein_gtr.gtr_scaler_2*0.2583567688723601;
tdIyVulQ.tree_2.Node20.t:=protein_gtr.gtr_scaler_2*0.195051178987639;
tdIyVulQ.tree_2.t31.t:=0;
tdIyVulQ.tree_2.t56.t:=protein_gtr.gtr_scaler_2*0.1385728666305137;
tdIyVulQ.tree_2.Node27.t:=protein_gtr.gtr_scaler_2*0.1109116680610404;
tdIyVulQ.tree_2.t27.t:=0;
tdIyVulQ.tree_2.Node26.t:=0;
tdIyVulQ.tree_2.t39.t:=protein_gtr.gtr_scaler_2*0.1797580613065172;
tdIyVulQ.tree_2.t118.t:=protein_gtr.gtr_scaler_2*0.01025031862978109;
tdIyVulQ.tree_2.t46.t:=0;
tdIyVulQ.tree_2.t45.t:=protein_gtr.gtr_scaler_2*0.2803075097878239;
tdIyVulQ.tree_2.Node35.t:=protein_gtr.gtr_scaler_2*0.08618767883269525;
tdIyVulQ.tree_2.Node33.t:=0;
tdIyVulQ.tree_2.Node31.t:=protein_gtr.gtr_scaler_2*0.01330516428937998;
tdIyVulQ.tree_2.Node25.t:=protein_gtr.gtr_scaler_2*0.1246879259921833;
tdIyVulQ.tree_2.t37.t:=protein_gtr.gtr_scaler_2*0.1626196747969986;
tdIyVulQ.tree_2.t34.t:=0;
tdIyVulQ.tree_2.Node41.t:=0;
tdIyVulQ.tree_2.t71.t:=protein_gtr.gtr_scaler_2*0.01232173713480346;
tdIyVulQ.tree_2.t43.t:=protein_gtr.gtr_scaler_2*0.5393494829713368;
tdIyVulQ.tree_2.t93.t:=protein_gtr.gtr_scaler_2*0.3186660853456111;
tdIyVulQ.tree_2.Node46.t:=protein_gtr.gtr_scaler_2*0.2842356105255905;
tdIyVulQ.tree_2.Node44.t:=0;
tdIyVulQ.tree_2.Node40.t:=protein_gtr.gtr_scaler_2*0.7022825156107438;
tdIyVulQ.tree_2.t15.t:=protein_gtr.gtr_scaler_2*0.04880115060861263;
tdIyVulQ.tree_2.t100.t:=protein_gtr.gtr_scaler_2*0.1869874191998585;
tdIyVulQ.tree_2.Node50.t:=protein_gtr.gtr_scaler_2*0.1202256797804006;
tdIyVulQ.tree_2.t12.t:=0;
tdIyVulQ.tree_2.t5.t:=0;
tdIyVulQ.tree_2.Node53.t:=protein_gtr.gtr_scaler_2*0.02947199090644826;
tdIyVulQ.tree_2.Node49.t:=protein_gtr.gtr_scaler_2*0.08178121694352899;
tdIyVulQ.tree_2.Node39.t:=protein_gtr.gtr_scaler_2*0.02643420228221519;
tdIyVulQ.tree_2.t16.t:=protein_gtr.gtr_scaler_2*0.08127667112264274;
tdIyVulQ.tree_2.t83.t:=protein_gtr.gtr_scaler_2*0.01182238661003045;
tdIyVulQ.tree_2.t35.t:=0;
tdIyVulQ.tree_2.Node60.t:=protein_gtr.gtr_scaler_2*0.3316149676062701;
tdIyVulQ.tree_2.Node58.t:=protein_gtr.gtr_scaler_2*0.1351857683742148;
tdIyVulQ.tree_2.t25.t:=protein_gtr.gtr_scaler_2*0.02438587926680484;
tdIyVulQ.tree_2.Node57.t:=protein_gtr.gtr_scaler_2*0.05684596572845337;
tdIyVulQ.tree_2.t103.t:=protein_gtr.gtr_scaler_2*0.06824885259541652;
tdIyVulQ.tree_2.Node56.t:=protein_gtr.gtr_scaler_2*0.04233454519732153;
tdIyVulQ.tree_2.Node38.t:=protein_gtr.gtr_scaler_2*0.1689690029906607;
tdIyVulQ.tree_2.Node24.t:=protein_gtr.gtr_scaler_2*0.1681662351572967;
tdIyVulQ.tree_2.t110.t:=protein_gtr.gtr_scaler_2*0.1693308805759468;
tdIyVulQ.tree_2.t90.t:=protein_gtr.gtr_scaler_2*0.3462105859282983;
tdIyVulQ.tree_2.t41.t:=protein_gtr.gtr_scaler_2*0.04757703699199172;
tdIyVulQ.tree_2.Node71.t:=protein_gtr.gtr_scaler_2*0.5123512181169948;
tdIyVulQ.tree_2.Node69.t:=protein_gtr.gtr_scaler_2*0.04028195591475504;
tdIyVulQ.tree_2.t97.t:=protein_gtr.gtr_scaler_2*0.01086498580485657;
tdIyVulQ.tree_2.Node68.t:=protein_gtr.gtr_scaler_2*0.1151319819451985;
tdIyVulQ.tree_2.t42.t:=protein_gtr.gtr_scaler_2*0.169370494184715;
tdIyVulQ.tree_2.t8.t:=protein_gtr.gtr_scaler_2*0.01181493432480252;
tdIyVulQ.tree_2.t17.t:=protein_gtr.gtr_scaler_2*0.2978509087283206;
tdIyVulQ.tree_2.Node80.t:=0;
tdIyVulQ.tree_2.Node78.t:=0;
tdIyVulQ.tree_2.t58.t:=protein_gtr.gtr_scaler_2*0.01176994579832166;
tdIyVulQ.tree_2.Node77.t:=protein_gtr.gtr_scaler_2*0.01200780606707519;
tdIyVulQ.tree_2.t29.t:=protein_gtr.gtr_scaler_2*0.01197184636287156;
tdIyVulQ.tree_2.t18.t:=0;
tdIyVulQ.tree_2.Node84.t:=protein_gtr.gtr_scaler_2*0.02434462224595542;
tdIyVulQ.tree_2.Node76.t:=0;
tdIyVulQ.tree_2.t96.t:=protein_gtr.gtr_scaler_2*0.1349688822640424;
tdIyVulQ.tree_2.t95.t:=0;
tdIyVulQ.tree_2.Node87.t:=protein_gtr.gtr_scaler_2*0.08693774904948857;
tdIyVulQ.tree_2.Node75.t:=0;
tdIyVulQ.tree_2.Node67.t:=0;
tdIyVulQ.tree_2.t85.t:=protein_gtr.gtr_scaler_2*0.04972602963975246;
tdIyVulQ.tree_2.t73.t:=protein_gtr.gtr_scaler_2*0.03682357439152747;
tdIyVulQ.tree_2.Node90.t:=protein_gtr.gtr_scaler_2*0.01162821907016463;
tdIyVulQ.tree_2.Node66.t:=0;
tdIyVulQ.tree_2.t67.t:=0;
tdIyVulQ.tree_2.t86.t:=protein_gtr.gtr_scaler_2*0.02402969468801668;
tdIyVulQ.tree_2.t51.t:=0;
tdIyVulQ.tree_2.Node96.t:=protein_gtr.gtr_scaler_2*0.02433825321175694;
tdIyVulQ.tree_2.Node94.t:=protein_gtr.gtr_scaler_2*0.1694095849848518;
tdIyVulQ.tree_2.t68.t:=0;
tdIyVulQ.tree_2.Node93.t:=0;
tdIyVulQ.tree_2.Node65.t:=protein_gtr.gtr_scaler_2*0.02350804723352068;
tdIyVulQ.tree_2.Node23.t:=protein_gtr.gtr_scaler_2*0.08496330437310193;
tdIyVulQ.tree_2.Node19.t:=0;
tdIyVulQ.tree_2.Node5.t:=0;
tdIyVulQ.tree_2.t122.t:=0;
tdIyVulQ.tree_2.t3.t:=protein_gtr.gtr_scaler_2*0.03441171805278623;
tdIyVulQ.tree_2.t80.t:=protein_gtr.gtr_scaler_2*0.2000874053725226;
tdIyVulQ.tree_2.Node107.t:=protein_gtr.gtr_scaler_2*0.05790484679953771;
tdIyVulQ.tree_2.Node105.t:=0;
tdIyVulQ.tree_2.t88.t:=protein_gtr.gtr_scaler_2*0.01135259590183389;
tdIyVulQ.tree_2.t113.t:=protein_gtr.gtr_scaler_2*0.07131565244798868;
tdIyVulQ.tree_2.Node110.t:=protein_gtr.gtr_scaler_2*0.1544820075056958;
tdIyVulQ.tree_2.Node104.t:=protein_gtr.gtr_scaler_2*0.001098726999091462;
tdIyVulQ.tree_2.t38.t:=protein_gtr.gtr_scaler_2*0.04982213748966378;
tdIyVulQ.tree_2.t94.t:=protein_gtr.gtr_scaler_2*0.1146819370842992;
tdIyVulQ.tree_2.Node113.t:=0;
tdIyVulQ.tree_2.Node103.t:=protein_gtr.gtr_scaler_2*0.07512764698263276;
tdIyVulQ.tree_2.t87.t:=protein_gtr.gtr_scaler_2*0.04653777495445645;
tdIyVulQ.tree_2.Node102.t:=protein_gtr.gtr_scaler_2*0.4720611336840362;
tdIyVulQ.tree_2.t9.t:=protein_gtr.gtr_scaler_2*0.0511904155497989;
tdIyVulQ.tree_2.t64.t:=protein_gtr.gtr_scaler_2*0.009475363587418148;
tdIyVulQ.tree_2.Node118.t:=protein_gtr.gtr_scaler_2*0.1221746670164664;
tdIyVulQ.tree_2.t99.t:=protein_gtr.gtr_scaler_2*0.02436327428946994;
tdIyVulQ.tree_2.t6.t:=protein_gtr.gtr_scaler_2*0.1049315678709562;
tdIyVulQ.tree_2.Node124.t:=0;
tdIyVulQ.tree_2.t120.t:=protein_gtr.gtr_scaler_2*0.01227372252923938;
tdIyVulQ.tree_2.Node123.t:=protein_gtr.gtr_scaler_2*0.213834011002804;
tdIyVulQ.tree_2.t62.t:=protein_gtr.gtr_scaler_2*0.04242890379117156;
tdIyVulQ.tree_2.t91.t:=protein_gtr.gtr_scaler_2*0.1163411231863977;
tdIyVulQ.tree_2.Node128.t:=protein_gtr.gtr_scaler_2*0.05804185787283101;
tdIyVulQ.tree_2.Node122.t:=protein_gtr.gtr_scaler_2*0.2205004464617504;
tdIyVulQ.tree_2.t26.t:=protein_gtr.gtr_scaler_2*0.06257498628562773;
tdIyVulQ.tree_2.t40.t:=protein_gtr.gtr_scaler_2*0.06182090025995934;
tdIyVulQ.tree_2.Node132.t:=0;
tdIyVulQ.tree_2.t112.t:=protein_gtr.gtr_scaler_2*0.2808012531372626;
tdIyVulQ.tree_2.Node131.t:=0;
tdIyVulQ.tree_2.Node121.t:=protein_gtr.gtr_scaler_2*0.05061622391405158;
tdIyVulQ.tree_2.Node117.t:=protein_gtr.gtr_scaler_2*0.04328002761356133;
tdIyVulQ.tree_2.Node101.t:=protein_gtr.gtr_scaler_2*0.007110454770560926;
tdIyVulQ.tree_2.t1.t:=protein_gtr.gtr_scaler_2*0.03658756315477123;
tdIyVulQ.tree_2.t23.t:=protein_gtr.gtr_scaler_2*0.02403410910901289;
tdIyVulQ.tree_2.Node138.t:=protein_gtr.gtr_scaler_2*0.01170984760551726;
tdIyVulQ.tree_2.t76.t:=protein_gtr.gtr_scaler_2*0.0238673155267594;
tdIyVulQ.tree_2.Node137.t:=0;
tdIyVulQ.tree_2.t119.t:=0;
tdIyVulQ.tree_2.Node136.t:=0;
tdIyVulQ.tree_2.Node100.t:=protein_gtr.gtr_scaler_2*0.2272904795140065;
tdIyVulQ.tree_2.Node4.t:=0;
tdIyVulQ.tree_2.t77.t:=0;
tdIyVulQ.tree_2.t72.t:=0;
tdIyVulQ.tree_2.t75.t:=0;
tdIyVulQ.tree_2.Node147.t:=0;
tdIyVulQ.tree_2.Node145.t:=protein_gtr.gtr_scaler_2*0.5104470910199755;
tdIyVulQ.tree_2.t2.t:=protein_gtr.gtr_scaler_2*0.1097848397168844;
tdIyVulQ.tree_2.t52.t:=protein_gtr.gtr_scaler_2*0.08937359913051958;
tdIyVulQ.tree_2.Node150.t:=protein_gtr.gtr_scaler_2*0.01240193193972456;
tdIyVulQ.tree_2.Node144.t:=0;
tdIyVulQ.tree_2.t28.t:=protein_gtr.gtr_scaler_2*0.01495818758804554;
tdIyVulQ.tree_2.t82.t:=0;
tdIyVulQ.tree_2.t20.t:=protein_gtr.gtr_scaler_2*0.005539179196620374;
tdIyVulQ.tree_2.t53.t:=protein_gtr.gtr_scaler_2*0.2441067186168613;
tdIyVulQ.tree_2.t57.t:=protein_gtr.gtr_scaler_2*0.04260822700214934;
tdIyVulQ.tree_2.Node159.t:=protein_gtr.gtr_scaler_2*0.6900712499638608;
tdIyVulQ.tree_2.Node157.t:=protein_gtr.gtr_scaler_2*0.05650250420457651;
tdIyVulQ.tree_2.Node155.t:=protein_gtr.gtr_scaler_2*0.3144654916389423;
tdIyVulQ.tree_2.Node153.t:=0;
tdIyVulQ.tree_2.Node143.t:=protein_gtr.gtr_scaler_2*0.1612444588810712;
tdIyVulQ.tree_2.Node3.t:=protein_gtr.gtr_scaler_2*0.03319665911235095;
tdIyVulQ.tree_2.t102.t:=protein_gtr.gtr_scaler_2*0.04990948399972581;
tdIyVulQ.tree_2.t104.t:=0;
tdIyVulQ.tree_2.Node166.t:=0;
tdIyVulQ.tree_2.t61.t:=protein_gtr.gtr_scaler_2*0.09236140207454621;
tdIyVulQ.tree_2.Node165.t:=0;
tdIyVulQ.tree_2.t14.t:=protein_gtr.gtr_scaler_2*0.2428333712388459;
tdIyVulQ.tree_2.t101.t:=protein_gtr.gtr_scaler_2*0.09147910924809741;
tdIyVulQ.tree_2.t13.t:=protein_gtr.gtr_scaler_2*0.01156099713900184;
tdIyVulQ.tree_2.Node174.t:=protein_gtr.gtr_scaler_2*0.2320514623039914;
tdIyVulQ.tree_2.t115.t:=protein_gtr.gtr_scaler_2*0.06336640838686117;
tdIyVulQ.tree_2.Node173.t:=0;
tdIyVulQ.tree_2.t81.t:=protein_gtr.gtr_scaler_2*0.1552031234164887;
tdIyVulQ.tree_2.Node172.t:=protein_gtr.gtr_scaler_2*0.02491149900706113;
tdIyVulQ.tree_2.Node170.t:=protein_gtr.gtr_scaler_2*0.01580316173161208;
tdIyVulQ.tree_2.Node164.t:=protein_gtr.gtr_scaler_2*0.02473080694087004;
tdIyVulQ.tree_2.t30.t:=0;
tdIyVulQ.tree_2.t70.t:=protein_gtr.gtr_scaler_2*0.06401539812192308;
tdIyVulQ.tree_2.Node179.t:=0;
tdIyVulQ.tree_2.Node163.t:=protein_gtr.gtr_scaler_2*0.2544018298581826;
tdIyVulQ.tree_2.t108.t:=protein_gtr.gtr_scaler_2*0.05010701498007464;
tdIyVulQ.tree_2.t50.t:=protein_gtr.gtr_scaler_2*0.05830330164193997;
tdIyVulQ.tree_2.t59.t:=protein_gtr.gtr_scaler_2*0.2657924520342434;
tdIyVulQ.tree_2.t44.t:=protein_gtr.gtr_scaler_2*0.01071895741835851;
tdIyVulQ.tree_2.Node190.t:=protein_gtr.gtr_scaler_2*0.03791308369554553;
tdIyVulQ.tree_2.t11.t:=protein_gtr.gtr_scaler_2*0.01218223059975143;
tdIyVulQ.tree_2.t32.t:=protein_gtr.gtr_scaler_2*0.02353712347355857;
tdIyVulQ.tree_2.Node193.t:=0;
tdIyVulQ.tree_2.Node189.t:=protein_gtr.gtr_scaler_2*0.1695320391052517;
tdIyVulQ.tree_2.Node187.t:=protein_gtr.gtr_scaler_2*0.08290888786966238;
tdIyVulQ.tree_2.t78.t:=protein_gtr.gtr_scaler_2*0.157269927951411;
tdIyVulQ.tree_2.t89.t:=protein_gtr.gtr_scaler_2*0.03254505497377928;
tdIyVulQ.tree_2.Node196.t:=protein_gtr.gtr_scaler_2*0.8356024475323842;
tdIyVulQ.tree_2.Node186.t:=protein_gtr.gtr_scaler_2*0.1875161480906476;
tdIyVulQ.tree_2.Node184.t:=0;
tdIyVulQ.tree_2.t55.t:=protein_gtr.gtr_scaler_2*0.06715687154270307;
tdIyVulQ.tree_2.t111.t:=protein_gtr.gtr_scaler_2*0.01377536728000883;
tdIyVulQ.tree_2.t69.t:=protein_gtr.gtr_scaler_2*0.2880887746489226;
tdIyVulQ.tree_2.Node201.t:=protein_gtr.gtr_scaler_2*0.0201645906288841;
tdIyVulQ.tree_2.Node199.t:=protein_gtr.gtr_scaler_2*0.2692518569230725;
tdIyVulQ.tree_2.Node183.t:=0;
tdIyVulQ.tree_2.t121.t:=protein_gtr.gtr_scaler_2*0.1497074193632861;
tdIyVulQ.tree_2.t123.t:=protein_gtr.gtr_scaler_2*0.2781046300627829;
tdIyVulQ.tree_2.t79.t:=0;
tdIyVulQ.tree_2.Node209.t:=protein_gtr.gtr_scaler_2*0.1398192900847583;
tdIyVulQ.tree_2.Node207.t:=protein_gtr.gtr_scaler_2*0.2744270309675584;
tdIyVulQ.tree_2.t74.t:=protein_gtr.gtr_scaler_2*0.1650619453893664;
tdIyVulQ.tree_2.Node206.t:=0;
tdIyVulQ.tree_2.t109.t:=protein_gtr.gtr_scaler_2*0.141877348500271;
tdIyVulQ.tree_2.Node205.t:=0;
tdIyVulQ.tree_2.t54.t:=protein_gtr.gtr_scaler_2*0.07568555928658849;
tdIyVulQ.tree_2.t24.t:=protein_gtr.gtr_scaler_2*0.06285035348359183;
tdIyVulQ.tree_2.Node216.t:=0;
tdIyVulQ.tree_2.t60.t:=protein_gtr.gtr_scaler_2*0.2763572097114413;
tdIyVulQ.tree_2.Node215.t:=0;
tdIyVulQ.tree_2.t114.t:=protein_gtr.gtr_scaler_2*0.04057315146848443;
tdIyVulQ.tree_2.t36.t:=protein_gtr.gtr_scaler_2*0.08709092587008052;
tdIyVulQ.tree_2.Node222.t:=protein_gtr.gtr_scaler_2*0.09577630290326161;
tdIyVulQ.tree_2.t48.t:=protein_gtr.gtr_scaler_2*0.3593424508924356;
tdIyVulQ.tree_2.Node221.t:=0;
tdIyVulQ.tree_2.t10.t:=protein_gtr.gtr_scaler_2*0.5080829113852376;
tdIyVulQ.tree_2.t4.t:=protein_gtr.gtr_scaler_2*0.1039432787905303;
tdIyVulQ.tree_2.Node226.t:=protein_gtr.gtr_scaler_2*0.05994452903097854;
tdIyVulQ.tree_2.Node220.t:=0;
tdIyVulQ.tree_2.Node214.t:=protein_gtr.gtr_scaler_2*0.02520535938073321;
tdIyVulQ.tree_2.Node204.t:=protein_gtr.gtr_scaler_2*0.02125235066179877;
tdIyVulQ.tree_2.Node182.t:=0;
tdIyVulQ.tree_2.Node162.t:=protein_gtr.gtr_scaler_2*0.08825867258609335;
tdIyVulQ.tree_2.Node2.t:=0;
tdIyVulQ.tree_2.t98.t:=protein_gtr.gtr_scaler_2*0.05835365568367889;
tdIyVulQ.tree_2.t21.t:=0;
tdIyVulQ.tree_2.t84.t:=protein_gtr.gtr_scaler_2*0.01699723381817307;
tdIyVulQ.tree_2.t105.t:=protein_gtr.gtr_scaler_2*0.02182270102858773;
tdIyVulQ.tree_2.Node234.t:=protein_gtr.gtr_scaler_2*0.08716149991192146;
tdIyVulQ.tree_2.t66.t:=protein_gtr.gtr_scaler_2*0.007076281275017028;
tdIyVulQ.tree_2.Node233.t:=protein_gtr.gtr_scaler_2*0.15117817521965;
tdIyVulQ.tree_2.Node231.t:=protein_gtr.gtr_scaler_2*0.3907305374251471;
tdIyVulQ.tree_2.t49.t:=protein_gtr.gtr_scaler_2*0.0617169640730871;
tdIyVulQ.tree_2.t117.t:=protein_gtr.gtr_scaler_2*0.1962985309766361;
tdIyVulQ.tree_2.Node239.t:=protein_gtr.gtr_scaler_2*0.1572884320551134;
tdIyVulQ.tree_2.t65.t:=0;
tdIyVulQ.tree_2.t63.t:=protein_gtr.gtr_scaler_2*0.07629653351216677;
tdIyVulQ.tree_2.Node242.t:=protein_gtr.gtr_scaler_2*0.1408659800989532;
tdIyVulQ.tree_2.Node238.t:=protein_gtr.gtr_scaler_2*0.06216646146435748;
tdIyVulQ.tree_2.Node230.t:=protein_gtr.gtr_scaler_2*0.385538106110945;
tdIyVulQ.tree_3.t18.t:=protein_gtr.gtr_scaler_3*0.07841152733187631;
tdIyVulQ.tree_3.t88.t:=protein_gtr.gtr_scaler_3*0.08787037329789701;
tdIyVulQ.tree_3.t34.t:=protein_gtr.gtr_scaler_3*0.5164764919212835;
tdIyVulQ.tree_3.Node7.t:=protein_gtr.gtr_scaler_3*0.1976989299497103;
tdIyVulQ.tree_3.t10.t:=protein_gtr.gtr_scaler_3*0.1432737039153923;
tdIyVulQ.tree_3.t44.t:=protein_gtr.gtr_scaler_3*0.0141553701284463;
tdIyVulQ.tree_3.Node10.t:=protein_gtr.gtr_scaler_3*0.07712024560137268;
tdIyVulQ.tree_3.Node6.t:=protein_gtr.gtr_scaler_3*0.04802227994938266;
tdIyVulQ.tree_3.Node4.t:=protein_gtr.gtr_scaler_3*0.004456813107649479;
tdIyVulQ.tree_3.t13.t:=0;
tdIyVulQ.tree_3.t57.t:=protein_gtr.gtr_scaler_3*0.05594860349955197;
tdIyVulQ.tree_3.Node15.t:=0;
tdIyVulQ.tree_3.t33.t:=protein_gtr.gtr_scaler_3*0.2134757438160942;
tdIyVulQ.tree_3.t94.t:=protein_gtr.gtr_scaler_3*0.07314957429091973;
tdIyVulQ.tree_3.Node18.t:=protein_gtr.gtr_scaler_3*0.2880483310377303;
tdIyVulQ.tree_3.Node14.t:=protein_gtr.gtr_scaler_3*0.02654131896942932;
tdIyVulQ.tree_3.t15.t:=0;
tdIyVulQ.tree_3.t82.t:=protein_gtr.gtr_scaler_3*0.06704300940524599;
tdIyVulQ.tree_3.Node23.t:=protein_gtr.gtr_scaler_3*0.05313094222305519;
tdIyVulQ.tree_3.t112.t:=0;
tdIyVulQ.tree_3.Node22.t:=0;
tdIyVulQ.tree_3.t12.t:=protein_gtr.gtr_scaler_3*0.04073191836794351;
tdIyVulQ.tree_3.t61.t:=0;
tdIyVulQ.tree_3.t86.t:=protein_gtr.gtr_scaler_3*0.2618547282576742;
tdIyVulQ.tree_3.Node30.t:=0;
tdIyVulQ.tree_3.Node28.t:=0;
tdIyVulQ.tree_3.t93.t:=protein_gtr.gtr_scaler_3*0.01339719802591953;
tdIyVulQ.tree_3.Node27.t:=protein_gtr.gtr_scaler_3*0.0132481845463066;
tdIyVulQ.tree_3.Node21.t:=0;
tdIyVulQ.tree_3.Node13.t:=0;
tdIyVulQ.tree_3.Node3.t:=protein_gtr.gtr_scaler_3*0.2854177551700065;
tdIyVulQ.tree_3.t71.t:=0;
tdIyVulQ.tree_3.t31.t:=protein_gtr.gtr_scaler_3*0.04018571886045592;
tdIyVulQ.tree_3.Node37.t:=protein_gtr.gtr_scaler_3*0.04056232333310907;
tdIyVulQ.tree_3.t42.t:=protein_gtr.gtr_scaler_3*0.1001893918138814;
tdIyVulQ.tree_3.Node36.t:=0;
tdIyVulQ.tree_3.t80.t:=protein_gtr.gtr_scaler_3*0.228271531178749;
tdIyVulQ.tree_3.t68.t:=protein_gtr.gtr_scaler_3*0.0276635485384474;
tdIyVulQ.tree_3.Node42.t:=protein_gtr.gtr_scaler_3*0.04008956434628563;
tdIyVulQ.tree_3.t32.t:=protein_gtr.gtr_scaler_3*0.5573157574046462;
tdIyVulQ.tree_3.t28.t:=protein_gtr.gtr_scaler_3*0.1624548559353254;
tdIyVulQ.tree_3.Node47.t:=protein_gtr.gtr_scaler_3*0.1085955371402191;
tdIyVulQ.tree_3.t17.t:=protein_gtr.gtr_scaler_3*0.01322972312605426;
tdIyVulQ.tree_3.Node46.t:=protein_gtr.gtr_scaler_3*0.01317713736460453;
tdIyVulQ.tree_3.t110.t:=0;
tdIyVulQ.tree_3.Node45.t:=protein_gtr.gtr_scaler_3*0.1250699387367603;
tdIyVulQ.tree_3.Node41.t:=protein_gtr.gtr_scaler_3*0.08754459783458304;
tdIyVulQ.tree_3.Node35.t:=protein_gtr.gtr_scaler_3*0.1474292533736248;
tdIyVulQ.tree_3.t100.t:=protein_gtr.gtr_scaler_3*0.02763075952823017;
tdIyVulQ.tree_3.t60.t:=protein_gtr.gtr_scaler_3*0.0272275435882008;
tdIyVulQ.tree_3.Node54.t:=0;
tdIyVulQ.tree_3.t36.t:=protein_gtr.gtr_scaler_3*0.0134998121190471;
tdIyVulQ.tree_3.Node53.t:=protein_gtr.gtr_scaler_3*0.02110974068573666;
tdIyVulQ.tree_3.t50.t:=protein_gtr.gtr_scaler_3*0.1640955726515186;
tdIyVulQ.tree_3.Node52.t:=protein_gtr.gtr_scaler_3*0.006116921046427381;
tdIyVulQ.tree_3.Node34.t:=0;
tdIyVulQ.tree_3.Node2.t:=protein_gtr.gtr_scaler_3*0.03550651955850562;
tdIyVulQ.tree_3.t72.t:=protein_gtr.gtr_scaler_3*0.3340144552586687;
tdIyVulQ.tree_3.t19.t:=0;
tdIyVulQ.tree_3.t111.t:=protein_gtr.gtr_scaler_3*0.08246057761609933;
tdIyVulQ.tree_3.Node66.t:=0;
tdIyVulQ.tree_3.Node64.t:=0;
tdIyVulQ.tree_3.t29.t:=0;
tdIyVulQ.tree_3.Node63.t:=0;
tdIyVulQ.tree_3.t14.t:=protein_gtr.gtr_scaler_3*0.1672607335593993;
tdIyVulQ.tree_3.t83.t:=protein_gtr.gtr_scaler_3*0.06148166473466526;
tdIyVulQ.tree_3.Node70.t:=protein_gtr.gtr_scaler_3*0.06859705206983446;
tdIyVulQ.tree_3.Node62.t:=protein_gtr.gtr_scaler_3*0.006607428120566834;
tdIyVulQ.tree_3.t99.t:=protein_gtr.gtr_scaler_3*0.02604452439345305;
tdIyVulQ.tree_3.t53.t:=protein_gtr.gtr_scaler_3*0.122172087356993;
tdIyVulQ.tree_3.Node77.t:=0;
tdIyVulQ.tree_3.t5.t:=0;
tdIyVulQ.tree_3.t9.t:=protein_gtr.gtr_scaler_3*0.01013859172504228;
tdIyVulQ.tree_3.t40.t:=0;
tdIyVulQ.tree_3.t85.t:=protein_gtr.gtr_scaler_3*0.1690969238391048;
tdIyVulQ.tree_3.Node84.t:=protein_gtr.gtr_scaler_3*0.03192397169186014;
tdIyVulQ.tree_3.Node82.t:=protein_gtr.gtr_scaler_3*0.116173970713774;
tdIyVulQ.tree_3.Node80.t:=0;
tdIyVulQ.tree_3.Node76.t:=protein_gtr.gtr_scaler_3*0.02643529069431807;
tdIyVulQ.tree_3.t25.t:=0;
tdIyVulQ.tree_3.t75.t:=0;
tdIyVulQ.tree_3.Node88.t:=0;
tdIyVulQ.tree_3.t4.t:=0;
tdIyVulQ.tree_3.Node87.t:=protein_gtr.gtr_scaler_3*0.05238793499872167;
tdIyVulQ.tree_3.Node75.t:=0;
tdIyVulQ.tree_3.t38.t:=protein_gtr.gtr_scaler_3*0.1513147915940243;
tdIyVulQ.tree_3.t45.t:=protein_gtr.gtr_scaler_3*0.09937142997996026;
tdIyVulQ.tree_3.t39.t:=protein_gtr.gtr_scaler_3*0.01128287920805532;
tdIyVulQ.tree_3.Node96.t:=0;
tdIyVulQ.tree_3.t54.t:=protein_gtr.gtr_scaler_3*0.03082271864788898;
tdIyVulQ.tree_3.Node95.t:=protein_gtr.gtr_scaler_3*0.3526599609290459;
tdIyVulQ.tree_3.Node93.t:=protein_gtr.gtr_scaler_3*0.08283503621891126;
tdIyVulQ.tree_3.t113.t:=protein_gtr.gtr_scaler_3*0.04056539816792356;
tdIyVulQ.tree_3.t41.t:=protein_gtr.gtr_scaler_3*0.3076563454713374;
tdIyVulQ.tree_3.Node100.t:=protein_gtr.gtr_scaler_3*0.2073677806550862;
tdIyVulQ.tree_3.Node92.t:=protein_gtr.gtr_scaler_3*0.03318397393026245;
tdIyVulQ.tree_3.Node74.t:=0;
tdIyVulQ.tree_3.t84.t:=protein_gtr.gtr_scaler_3*0.04068055631543592;
tdIyVulQ.tree_3.Node73.t:=protein_gtr.gtr_scaler_3*0.1219370071471785;
tdIyVulQ.tree_3.Node61.t:=0;
tdIyVulQ.tree_3.t89.t:=0;
tdIyVulQ.tree_3.t106.t:=protein_gtr.gtr_scaler_3*0.06898058005665743;
tdIyVulQ.tree_3.Node104.t:=protein_gtr.gtr_scaler_3*0.09898776398002966;
tdIyVulQ.tree_3.Node60.t:=protein_gtr.gtr_scaler_3*0.6077963926807547;
tdIyVulQ.tree_3.t92.t:=protein_gtr.gtr_scaler_3*0.3682432536266437;
tdIyVulQ.tree_3.t97.t:=protein_gtr.gtr_scaler_3*0.005977632502209994;
tdIyVulQ.tree_3.Node109.t:=protein_gtr.gtr_scaler_3*0.08018777744613449;
tdIyVulQ.tree_3.t7.t:=protein_gtr.gtr_scaler_3*0.04247325790306054;
tdIyVulQ.tree_3.t74.t:=protein_gtr.gtr_scaler_3*0.01117613032695838;
tdIyVulQ.tree_3.Node113.t:=0;
tdIyVulQ.tree_3.t6.t:=protein_gtr.gtr_scaler_3*0.02739455500724421;
tdIyVulQ.tree_3.t78.t:=protein_gtr.gtr_scaler_3*0.03046973961574686;
tdIyVulQ.tree_3.t47.t:=protein_gtr.gtr_scaler_3*0.08168737941510254;
tdIyVulQ.tree_3.Node119.t:=protein_gtr.gtr_scaler_3*0.07104973867034405;
tdIyVulQ.tree_3.Node117.t:=0;
tdIyVulQ.tree_3.t107.t:=protein_gtr.gtr_scaler_3*0.09754579899938598;
tdIyVulQ.tree_3.Node116.t:=protein_gtr.gtr_scaler_3*0.07110041310548744;
tdIyVulQ.tree_3.Node112.t:=protein_gtr.gtr_scaler_3*0.1215640702890464;
tdIyVulQ.tree_3.Node108.t:=0;
tdIyVulQ.tree_3.t48.t:=0;
tdIyVulQ.tree_3.t23.t:=protein_gtr.gtr_scaler_3*0.02605715095119725;
tdIyVulQ.tree_3.Node129.t:=protein_gtr.gtr_scaler_3*0.01299549775683196;
tdIyVulQ.tree_3.t8.t:=protein_gtr.gtr_scaler_3*0.2331198329265265;
tdIyVulQ.tree_3.t16.t:=protein_gtr.gtr_scaler_3*0.0129777530027241;
tdIyVulQ.tree_3.Node132.t:=0;
tdIyVulQ.tree_3.Node128.t:=0;
tdIyVulQ.tree_3.t58.t:=protein_gtr.gtr_scaler_3*0.01218255087714925;
tdIyVulQ.tree_3.t95.t:=protein_gtr.gtr_scaler_3*0.01295472292212657;
tdIyVulQ.tree_3.t59.t:=0;
tdIyVulQ.tree_3.Node138.t:=protein_gtr.gtr_scaler_3*0.05455593636094189;
tdIyVulQ.tree_3.Node136.t:=protein_gtr.gtr_scaler_3*0.127094165307942;
tdIyVulQ.tree_3.t63.t:=protein_gtr.gtr_scaler_3*0.1088666843170715;
tdIyVulQ.tree_3.Node135.t:=protein_gtr.gtr_scaler_3*0.01235989822472528;
tdIyVulQ.tree_3.Node127.t:=protein_gtr.gtr_scaler_3*0.1270773015938225;
tdIyVulQ.tree_3.t116.t:=protein_gtr.gtr_scaler_3*0.08377151983039385;
tdIyVulQ.tree_3.t73.t:=0;
tdIyVulQ.tree_3.Node142.t:=0;
tdIyVulQ.tree_3.Node126.t:=0;
tdIyVulQ.tree_3.t115.t:=0;
tdIyVulQ.tree_3.Node125.t:=protein_gtr.gtr_scaler_3*0.5705113497270774;
tdIyVulQ.tree_3.t101.t:=protein_gtr.gtr_scaler_3*0.07921780045875149;
tdIyVulQ.tree_3.t43.t:=protein_gtr.gtr_scaler_3*0.04434297421200795;
tdIyVulQ.tree_3.t49.t:=protein_gtr.gtr_scaler_3*0.08832669969650354;
tdIyVulQ.tree_3.Node150.t:=0;
tdIyVulQ.tree_3.t22.t:=protein_gtr.gtr_scaler_3*0.1909944333725763;
tdIyVulQ.tree_3.t87.t:=protein_gtr.gtr_scaler_3*0.1008392907863205;
tdIyVulQ.tree_3.Node153.t:=protein_gtr.gtr_scaler_3*0.1075679273834403;
tdIyVulQ.tree_3.Node149.t:=protein_gtr.gtr_scaler_3*0.214058556148398;
tdIyVulQ.tree_3.Node147.t:=protein_gtr.gtr_scaler_3*0.1777027599889634;
tdIyVulQ.tree_3.t27.t:=protein_gtr.gtr_scaler_3*0.04645719053009333;
tdIyVulQ.tree_3.t62.t:=protein_gtr.gtr_scaler_3*0.01826526308249864;
tdIyVulQ.tree_3.Node156.t:=protein_gtr.gtr_scaler_3*0.1963146173059301;
tdIyVulQ.tree_3.Node146.t:=protein_gtr.gtr_scaler_3*0.1428795443287675;
tdIyVulQ.tree_3.Node124.t:=protein_gtr.gtr_scaler_3*0.04826684035339578;
tdIyVulQ.tree_3.t3.t:=protein_gtr.gtr_scaler_3*0.0665773971035433;
tdIyVulQ.tree_3.t35.t:=0;
tdIyVulQ.tree_3.Node163.t:=protein_gtr.gtr_scaler_3*0.02290573148546585;
tdIyVulQ.tree_3.t26.t:=protein_gtr.gtr_scaler_3*0.1001354487473593;
tdIyVulQ.tree_3.t37.t:=0;
tdIyVulQ.tree_3.t109.t:=0;
tdIyVulQ.tree_3.Node170.t:=protein_gtr.gtr_scaler_3*0.2243583835268849;
tdIyVulQ.tree_3.t65.t:=protein_gtr.gtr_scaler_3*0.1214348472430046;
tdIyVulQ.tree_3.t20.t:=protein_gtr.gtr_scaler_3*0.3602659652802991;
tdIyVulQ.tree_3.t105.t:=protein_gtr.gtr_scaler_3*0.02207830234471859;
tdIyVulQ.tree_3.Node175.t:=0;
tdIyVulQ.tree_3.Node173.t:=protein_gtr.gtr_scaler_3*0.01606998957615089;
tdIyVulQ.tree_3.Node169.t:=0;
tdIyVulQ.tree_3.t70.t:=0;
tdIyVulQ.tree_3.t96.t:=0;
tdIyVulQ.tree_3.t81.t:=protein_gtr.gtr_scaler_3*0.1265159541584379;
tdIyVulQ.tree_3.t1.t:=protein_gtr.gtr_scaler_3*0.1782700932832822;
tdIyVulQ.tree_3.Node182.t:=protein_gtr.gtr_scaler_3*0.03931719337692996;
tdIyVulQ.tree_3.Node180.t:=0;
tdIyVulQ.tree_3.Node178.t:=0;
tdIyVulQ.tree_3.Node168.t:=protein_gtr.gtr_scaler_3*0.3061828430526713;
tdIyVulQ.tree_3.Node166.t:=0;
tdIyVulQ.tree_3.Node162.t:=protein_gtr.gtr_scaler_3*0.02266165491496961;
tdIyVulQ.tree_3.t69.t:=protein_gtr.gtr_scaler_3*0.0542146334002119;
tdIyVulQ.tree_3.t30.t:=protein_gtr.gtr_scaler_3*0.2686618100336416;
tdIyVulQ.tree_3.t51.t:=protein_gtr.gtr_scaler_3*0.01287350659122077;
tdIyVulQ.tree_3.Node187.t:=0;
tdIyVulQ.tree_3.Node185.t:=protein_gtr.gtr_scaler_3*0.1936713828146205;
tdIyVulQ.tree_3.Node161.t:=protein_gtr.gtr_scaler_3*0.07953494570179152;
tdIyVulQ.tree_3.t103.t:=protein_gtr.gtr_scaler_3*0.01290032767384658;
tdIyVulQ.tree_3.t2.t:=0;
tdIyVulQ.tree_3.Node192.t:=0;
tdIyVulQ.tree_3.t21.t:=protein_gtr.gtr_scaler_3*0.01292726739322042;
tdIyVulQ.tree_3.Node191.t:=protein_gtr.gtr_scaler_3*0.08173655420242849;
tdIyVulQ.tree_3.t90.t:=0;
tdIyVulQ.tree_3.Node190.t:=protein_gtr.gtr_scaler_3*0.03068611876101913;
tdIyVulQ.tree_3.Node160.t:=protein_gtr.gtr_scaler_3*0.023903925064487;
tdIyVulQ.tree_3.t108.t:=protein_gtr.gtr_scaler_3*0.0133499349255835;
tdIyVulQ.tree_3.t77.t:=protein_gtr.gtr_scaler_3*0.2180072245998575;
tdIyVulQ.tree_3.t67.t:=protein_gtr.gtr_scaler_3*0.115941533466632;
tdIyVulQ.tree_3.Node200.t:=0;
tdIyVulQ.tree_3.Node198.t:=0;
tdIyVulQ.tree_3.t91.t:=protein_gtr.gtr_scaler_3*0.481812991724014;
tdIyVulQ.tree_3.t46.t:=protein_gtr.gtr_scaler_3*0.08376501397073233;
tdIyVulQ.tree_3.Node203.t:=protein_gtr.gtr_scaler_3*0.2648513678585326;
tdIyVulQ.tree_3.Node197.t:=0;
tdIyVulQ.tree_3.Node159.t:=protein_gtr.gtr_scaler_3*0.02442832047905166;
tdIyVulQ.tree_3.Node123.t:=protein_gtr.gtr_scaler_3*0.05464253550792676;
tdIyVulQ.tree_3.Node107.t:=0;
tdIyVulQ.tree_3.Node59.t:=protein_gtr.gtr_scaler_3*0.01640311514939281;
tdIyVulQ.tree_3.t52.t:=protein_gtr.gtr_scaler_3*0.2111209749908625;
tdIyVulQ.tree_3.t55.t:=0;
tdIyVulQ.tree_3.t102.t:=protein_gtr.gtr_scaler_3*0.07250351067140434;
tdIyVulQ.tree_3.t79.t:=protein_gtr.gtr_scaler_3*0.07385129049085808;
tdIyVulQ.tree_3.Node215.t:=0;
tdIyVulQ.tree_3.t11.t:=protein_gtr.gtr_scaler_3*0.09894152986969572;
tdIyVulQ.tree_3.Node214.t:=protein_gtr.gtr_scaler_3*0.00850458979648557;
tdIyVulQ.tree_3.Node212.t:=protein_gtr.gtr_scaler_3*0.1167194372372123;
tdIyVulQ.tree_3.t104.t:=protein_gtr.gtr_scaler_3*0.02969194630954217;
tdIyVulQ.tree_3.Node211.t:=protein_gtr.gtr_scaler_3*0.05804545894099818;
tdIyVulQ.tree_3.Node209.t:=0;
tdIyVulQ.tree_3.t64.t:=protein_gtr.gtr_scaler_3*0.2489394640607236;
tdIyVulQ.tree_3.t76.t:=0;
tdIyVulQ.tree_3.Node220.t:=0;
tdIyVulQ.tree_3.Node208.t:=protein_gtr.gtr_scaler_3*0.01347207254343233;
tdIyVulQ.tree_3.t114.t:=0;
tdIyVulQ.tree_3.Node207.t:=protein_gtr.gtr_scaler_3*0.05732074061520459;
tdIyVulQ.tree_3.t24.t:=protein_gtr.gtr_scaler_3*0.05838951620945241;
tdIyVulQ.tree_3.t56.t:=protein_gtr.gtr_scaler_3*0.1664204640282904;
tdIyVulQ.tree_3.t98.t:=protein_gtr.gtr_scaler_3*0.01738506635357605;
tdIyVulQ.tree_3.t66.t:=protein_gtr.gtr_scaler_3*0.05003606065291009;
tdIyVulQ.tree_3.Node228.t:=protein_gtr.gtr_scaler_3*0.09527787454691826;
tdIyVulQ.tree_3.Node226.t:=protein_gtr.gtr_scaler_3*0.1174759727866874;
tdIyVulQ.tree_3.Node224.t:=protein_gtr.gtr_scaler_3*0.07556247656432011;
tdIyVulQ.tree_3.Node206.t:=protein_gtr.gtr_scaler_3*0.1407751417945748;
tdIyVulQ.tree_4.t30.t:=protein_gtr.gtr_scaler_4*0.03383150377632908;
tdIyVulQ.tree_4.t46.t:=protein_gtr.gtr_scaler_4*0.03770148316225656;
tdIyVulQ.tree_4.t67.t:=protein_gtr.gtr_scaler_4*0.04998873838980424;
tdIyVulQ.tree_4.Node6.t:=protein_gtr.gtr_scaler_4*0.4754751160055503;
tdIyVulQ.tree_4.t97.t:=protein_gtr.gtr_scaler_4*0.351840572401155;
tdIyVulQ.tree_4.Node5.t:=protein_gtr.gtr_scaler_4*0.2609748673570052;
tdIyVulQ.tree_4.Node3.t:=0;
tdIyVulQ.tree_4.t44.t:=0;
tdIyVulQ.tree_4.t84.t:=0;
tdIyVulQ.tree_4.Node12.t:=protein_gtr.gtr_scaler_4*0.05958895042197479;
tdIyVulQ.tree_4.t91.t:=protein_gtr.gtr_scaler_4*0.1213652503181326;
tdIyVulQ.tree_4.Node11.t:=protein_gtr.gtr_scaler_4*0.07457010047603728;
tdIyVulQ.tree_4.t18.t:=protein_gtr.gtr_scaler_4*0.0356873907047266;
tdIyVulQ.tree_4.t17.t:=0;
tdIyVulQ.tree_4.Node17.t:=0;
tdIyVulQ.tree_4.t58.t:=protein_gtr.gtr_scaler_4*0.03666192336062998;
tdIyVulQ.tree_4.t63.t:=protein_gtr.gtr_scaler_4*0.06615095764629488;
tdIyVulQ.tree_4.t12.t:=protein_gtr.gtr_scaler_4*0.07412730371009746;
tdIyVulQ.tree_4.Node22.t:=protein_gtr.gtr_scaler_4*0.06646688894279673;
tdIyVulQ.tree_4.Node20.t:=protein_gtr.gtr_scaler_4*0.1065409341108556;
tdIyVulQ.tree_4.Node16.t:=protein_gtr.gtr_scaler_4*0.04441102802758146;
tdIyVulQ.tree_4.Node10.t:=protein_gtr.gtr_scaler_4*0.05486946200884523;
tdIyVulQ.tree_4.Node2.t:=protein_gtr.gtr_scaler_4*0.04745096106148314;
tdIyVulQ.tree_4.t71.t:=protein_gtr.gtr_scaler_4*0.0115543358933301;
tdIyVulQ.tree_4.t51.t:=protein_gtr.gtr_scaler_4*0.2399570357318247;
tdIyVulQ.tree_4.t62.t:=protein_gtr.gtr_scaler_4*0.01303852061747717;
tdIyVulQ.tree_4.Node29.t:=0;
tdIyVulQ.tree_4.Node27.t:=protein_gtr.gtr_scaler_4*0.2599377002907908;
tdIyVulQ.tree_4.t5.t:=protein_gtr.gtr_scaler_4*0.1888221021774398;
tdIyVulQ.tree_4.t66.t:=protein_gtr.gtr_scaler_4*0.1133546647365389;
tdIyVulQ.tree_4.Node34.t:=0;
tdIyVulQ.tree_4.t95.t:=0;
tdIyVulQ.tree_4.t22.t:=protein_gtr.gtr_scaler_4*0.2260968410132613;
tdIyVulQ.tree_4.Node38.t:=protein_gtr.gtr_scaler_4*0.09183241046082234;
tdIyVulQ.tree_4.t101.t:=protein_gtr.gtr_scaler_4*0.4395091983522161;
tdIyVulQ.tree_4.Node37.t:=0;
tdIyVulQ.tree_4.Node33.t:=protein_gtr.gtr_scaler_4*0.06207150583950249;
tdIyVulQ.tree_4.t93.t:=protein_gtr.gtr_scaler_4*0.05527947767157874;
tdIyVulQ.tree_4.t52.t:=protein_gtr.gtr_scaler_4*0.1899546071109121;
tdIyVulQ.tree_4.Node43.t:=protein_gtr.gtr_scaler_4*0.0310881788617489;
tdIyVulQ.tree_4.t102.t:=0;
tdIyVulQ.tree_4.t76.t:=protein_gtr.gtr_scaler_4*0.1220955024251828;
tdIyVulQ.tree_4.Node47.t:=protein_gtr.gtr_scaler_4*0.02584529238894158;
tdIyVulQ.tree_4.t64.t:=protein_gtr.gtr_scaler_4*0.2347029398121869;
tdIyVulQ.tree_4.Node46.t:=protein_gtr.gtr_scaler_4*0.02337129140721099;
tdIyVulQ.tree_4.Node42.t:=protein_gtr.gtr_scaler_4*0.2976882304232334;
tdIyVulQ.tree_4.Node32.t:=protein_gtr.gtr_scaler_4*0.1775216114455959;
tdIyVulQ.tree_4.Node26.t:=protein_gtr.gtr_scaler_4*0.02152285661956217;
tdIyVulQ.tree_4.t103.t:=protein_gtr.gtr_scaler_4*0.06459610439532724;
tdIyVulQ.tree_4.t11.t:=protein_gtr.gtr_scaler_4*0.02340771452830154;
tdIyVulQ.tree_4.t81.t:=protein_gtr.gtr_scaler_4*0.01170576933460404;
tdIyVulQ.tree_4.Node58.t:=0;
tdIyVulQ.tree_4.t23.t:=protein_gtr.gtr_scaler_4*0.01108097952984223;
tdIyVulQ.tree_4.t13.t:=protein_gtr.gtr_scaler_4*0.1035152937011802;
tdIyVulQ.tree_4.Node61.t:=protein_gtr.gtr_scaler_4*0.01220294279118897;
tdIyVulQ.tree_4.Node57.t:=protein_gtr.gtr_scaler_4*0.3883661472003643;
tdIyVulQ.tree_4.Node55.t:=protein_gtr.gtr_scaler_4*0.06576247031515495;
tdIyVulQ.tree_4.t56.t:=protein_gtr.gtr_scaler_4*0.3454596112788819;
tdIyVulQ.tree_4.t16.t:=protein_gtr.gtr_scaler_4*0.3181301535916191;
tdIyVulQ.tree_4.Node65.t:=protein_gtr.gtr_scaler_4*0.1817427615073705;
tdIyVulQ.tree_4.t39.t:=protein_gtr.gtr_scaler_4*0.06183942314249945;
tdIyVulQ.tree_4.Node64.t:=protein_gtr.gtr_scaler_4*0.1477197467037832;
tdIyVulQ.tree_4.Node54.t:=protein_gtr.gtr_scaler_4*0.05501283056564608;
tdIyVulQ.tree_4.t37.t:=0;
tdIyVulQ.tree_4.Node53.t:=protein_gtr.gtr_scaler_4*0.1245471699332892;
tdIyVulQ.tree_4.t55.t:=protein_gtr.gtr_scaler_4*0.4555362506787597;
tdIyVulQ.tree_4.t100.t:=protein_gtr.gtr_scaler_4*0.08517918299800774;
tdIyVulQ.tree_4.Node73.t:=protein_gtr.gtr_scaler_4*0.1115480683861957;
tdIyVulQ.tree_4.t73.t:=protein_gtr.gtr_scaler_4*0.0724854255875987;
tdIyVulQ.tree_4.t31.t:=protein_gtr.gtr_scaler_4*0.3534154473004857;
tdIyVulQ.tree_4.Node76.t:=0;
tdIyVulQ.tree_4.Node72.t:=protein_gtr.gtr_scaler_4*0.03855501982693008;
tdIyVulQ.tree_4.t88.t:=protein_gtr.gtr_scaler_4*0.0283172112781654;
tdIyVulQ.tree_4.Node71.t:=protein_gtr.gtr_scaler_4*0.0085377122666373;
tdIyVulQ.tree_4.t72.t:=protein_gtr.gtr_scaler_4*0.02332346478392958;
tdIyVulQ.tree_4.t38.t:=protein_gtr.gtr_scaler_4*0.08350679457391344;
tdIyVulQ.tree_4.Node81.t:=protein_gtr.gtr_scaler_4*0.2283906972337345;
tdIyVulQ.tree_4.t15.t:=protein_gtr.gtr_scaler_4*0.03644199273484523;
tdIyVulQ.tree_4.Node80.t:=protein_gtr.gtr_scaler_4*0.1358377033083818;
tdIyVulQ.tree_4.Node70.t:=protein_gtr.gtr_scaler_4*0.1537891971515958;
tdIyVulQ.tree_4.Node52.t:=protein_gtr.gtr_scaler_4*0.08633059038955355;
tdIyVulQ.tree_4.t7.t:=protein_gtr.gtr_scaler_4*0.08920355479191407;
tdIyVulQ.tree_4.Node51.t:=protein_gtr.gtr_scaler_4*0.2412720174996573;
tdIyVulQ.tree_4.Node25.t:=protein_gtr.gtr_scaler_4*0.1035920421166154;
tdIyVulQ.tree_4.t8.t:=0;
tdIyVulQ.tree_4.t94.t:=protein_gtr.gtr_scaler_4*0.4325754519285677;
tdIyVulQ.tree_4.Node89.t:=protein_gtr.gtr_scaler_4*0.2281381648218723;
tdIyVulQ.tree_4.t3.t:=protein_gtr.gtr_scaler_4*0.08189780369272527;
tdIyVulQ.tree_4.Node88.t:=protein_gtr.gtr_scaler_4*0.01237032521849113;
tdIyVulQ.tree_4.t20.t:=protein_gtr.gtr_scaler_4*0.1018752235571848;
tdIyVulQ.tree_4.t61.t:=protein_gtr.gtr_scaler_4*0.2074344805654149;
tdIyVulQ.tree_4.t45.t:=protein_gtr.gtr_scaler_4*0.1154129976984173;
tdIyVulQ.tree_4.t2.t:=0;
tdIyVulQ.tree_4.t6.t:=protein_gtr.gtr_scaler_4*0.01194729835768351;
tdIyVulQ.tree_4.Node100.t:=protein_gtr.gtr_scaler_4*0.002002053886344891;
tdIyVulQ.tree_4.Node98.t:=protein_gtr.gtr_scaler_4*0.2718580457864183;
tdIyVulQ.tree_4.Node96.t:=protein_gtr.gtr_scaler_4*0.1442277356183833;
tdIyVulQ.tree_4.t98.t:=protein_gtr.gtr_scaler_4*0.03357443573412574;
tdIyVulQ.tree_4.Node95.t:=protein_gtr.gtr_scaler_4*0.004098580638531697;
tdIyVulQ.tree_4.Node93.t:=0;
tdIyVulQ.tree_4.Node87.t:=protein_gtr.gtr_scaler_4*0.1299665208730917;
tdIyVulQ.tree_4.t42.t:=protein_gtr.gtr_scaler_4*0.4693934231345639;
tdIyVulQ.tree_4.t74.t:=protein_gtr.gtr_scaler_4*0.1810191743613577;
tdIyVulQ.tree_4.t10.t:=protein_gtr.gtr_scaler_4*0.01447558523480118;
tdIyVulQ.tree_4.t41.t:=protein_gtr.gtr_scaler_4*0.08470596046389356;
tdIyVulQ.tree_4.Node111.t:=0;
tdIyVulQ.tree_4.Node109.t:=protein_gtr.gtr_scaler_4*0.249944351713657;
tdIyVulQ.tree_4.t1.t:=protein_gtr.gtr_scaler_4*0.2776676461954883;
tdIyVulQ.tree_4.t59.t:=protein_gtr.gtr_scaler_4*0.03431678116629261;
tdIyVulQ.tree_4.Node117.t:=0;
tdIyVulQ.tree_4.t78.t:=protein_gtr.gtr_scaler_4*0.2053625212725108;
tdIyVulQ.tree_4.Node116.t:=protein_gtr.gtr_scaler_4*0.3123885158076709;
tdIyVulQ.tree_4.t83.t:=protein_gtr.gtr_scaler_4*0.558678639904593;
tdIyVulQ.tree_4.t50.t:=protein_gtr.gtr_scaler_4*0.203188413935472;
tdIyVulQ.tree_4.t99.t:=0;
tdIyVulQ.tree_4.Node125.t:=protein_gtr.gtr_scaler_4*0.02299408248042409;
tdIyVulQ.tree_4.t89.t:=protein_gtr.gtr_scaler_4*0.02466999634850454;
tdIyVulQ.tree_4.Node124.t:=protein_gtr.gtr_scaler_4*0.005194799962742842;
tdIyVulQ.tree_4.Node122.t:=protein_gtr.gtr_scaler_4*0.2114244151602562;
tdIyVulQ.tree_4.t48.t:=protein_gtr.gtr_scaler_4*0.02205178003100423;
tdIyVulQ.tree_4.Node121.t:=0;
tdIyVulQ.tree_4.Node115.t:=protein_gtr.gtr_scaler_4*0.02291487886768442;
tdIyVulQ.tree_4.t34.t:=0;
tdIyVulQ.tree_4.Node114.t:=protein_gtr.gtr_scaler_4*0.07805823100641857;
tdIyVulQ.tree_4.Node108.t:=protein_gtr.gtr_scaler_4*0.03558899670559516;
tdIyVulQ.tree_4.t25.t:=protein_gtr.gtr_scaler_4*0.0969888360560619;
tdIyVulQ.tree_4.Node107.t:=protein_gtr.gtr_scaler_4*0.05192598371986601;
tdIyVulQ.tree_4.Node105.t:=protein_gtr.gtr_scaler_4*0.0487237234074758;
tdIyVulQ.tree_4.t75.t:=protein_gtr.gtr_scaler_4*0.04069555894060423;
tdIyVulQ.tree_4.t77.t:=protein_gtr.gtr_scaler_4*0.4638446158399847;
tdIyVulQ.tree_4.Node137.t:=protein_gtr.gtr_scaler_4*0.09014588902191162;
tdIyVulQ.tree_4.t36.t:=protein_gtr.gtr_scaler_4*0.05121424042446595;
tdIyVulQ.tree_4.Node136.t:=0;
tdIyVulQ.tree_4.t43.t:=protein_gtr.gtr_scaler_4*0.02812257382796365;
tdIyVulQ.tree_4.t47.t:=protein_gtr.gtr_scaler_4*0.04964182558419433;
tdIyVulQ.tree_4.t68.t:=protein_gtr.gtr_scaler_4*0.3330376944948484;
tdIyVulQ.tree_4.Node143.t:=protein_gtr.gtr_scaler_4*0.02997195030129784;
tdIyVulQ.tree_4.Node141.t:=protein_gtr.gtr_scaler_4*0.10071423539825;
tdIyVulQ.tree_4.Node135.t:=0;
tdIyVulQ.tree_4.t14.t:=protein_gtr.gtr_scaler_4*0.02409182190452206;
tdIyVulQ.tree_4.t40.t:=protein_gtr.gtr_scaler_4*0.06080854299229711;
tdIyVulQ.tree_4.t65.t:=0;
tdIyVulQ.tree_4.Node148.t:=protein_gtr.gtr_scaler_4*0.02617831986636965;
tdIyVulQ.tree_4.Node146.t:=protein_gtr.gtr_scaler_4*0.09468584482701949;
tdIyVulQ.tree_4.Node134.t:=protein_gtr.gtr_scaler_4*0.2336171807531424;
tdIyVulQ.tree_4.t32.t:=protein_gtr.gtr_scaler_4*0.0471557898765653;
tdIyVulQ.tree_4.t85.t:=protein_gtr.gtr_scaler_4*0.5854597270501386;
tdIyVulQ.tree_4.Node152.t:=0;
tdIyVulQ.tree_4.t28.t:=protein_gtr.gtr_scaler_4*0.2844024367863739;
tdIyVulQ.tree_4.t82.t:=protein_gtr.gtr_scaler_4*0.1015068588194842;
tdIyVulQ.tree_4.Node156.t:=protein_gtr.gtr_scaler_4*0.1519338109785756;
tdIyVulQ.tree_4.t69.t:=protein_gtr.gtr_scaler_4*0.289697339098282;
tdIyVulQ.tree_4.t9.t:=protein_gtr.gtr_scaler_4*0.08911603016963686;
tdIyVulQ.tree_4.Node160.t:=protein_gtr.gtr_scaler_4*0.0320009752965054;
tdIyVulQ.tree_4.t92.t:=protein_gtr.gtr_scaler_4*0.01446428552795609;
tdIyVulQ.tree_4.Node159.t:=0;
tdIyVulQ.tree_4.Node155.t:=0;
tdIyVulQ.tree_4.Node151.t:=protein_gtr.gtr_scaler_4*0.04347008131110992;
tdIyVulQ.tree_4.Node133.t:=protein_gtr.gtr_scaler_4*0.05511313416370323;
tdIyVulQ.tree_4.t27.t:=protein_gtr.gtr_scaler_4*0.04185570192861403;
tdIyVulQ.tree_4.t96.t:=protein_gtr.gtr_scaler_4*0.01928232926298481;
tdIyVulQ.tree_4.t86.t:=protein_gtr.gtr_scaler_4*0.09576333385175459;
tdIyVulQ.tree_4.t87.t:=protein_gtr.gtr_scaler_4*0.5654700385659596;
tdIyVulQ.tree_4.Node172.t:=protein_gtr.gtr_scaler_4*0.3154888150992269;
tdIyVulQ.tree_4.Node170.t:=protein_gtr.gtr_scaler_4*0.02362862219524926;
tdIyVulQ.tree_4.Node168.t:=protein_gtr.gtr_scaler_4*0.3290675838284985;
tdIyVulQ.tree_4.t35.t:=protein_gtr.gtr_scaler_4*0.09487226559153979;
tdIyVulQ.tree_4.Node167.t:=0;
tdIyVulQ.tree_4.t60.t:=protein_gtr.gtr_scaler_4*0.3696723375752601;
tdIyVulQ.tree_4.Node166.t:=protein_gtr.gtr_scaler_4*0.4551558389345678;
tdIyVulQ.tree_4.t54.t:=protein_gtr.gtr_scaler_4*0.0337818365301868;
tdIyVulQ.tree_4.t70.t:=protein_gtr.gtr_scaler_4*0.2974708685024188;
tdIyVulQ.tree_4.t90.t:=protein_gtr.gtr_scaler_4*0.242117441256281;
tdIyVulQ.tree_4.Node181.t:=protein_gtr.gtr_scaler_4*0.6190352613244055;
tdIyVulQ.tree_4.Node179.t:=0;
tdIyVulQ.tree_4.t24.t:=protein_gtr.gtr_scaler_4*0.2225730374084711;
tdIyVulQ.tree_4.t57.t:=protein_gtr.gtr_scaler_4*0.4435202633452954;
tdIyVulQ.tree_4.Node185.t:=protein_gtr.gtr_scaler_4*0.1893223600369998;
tdIyVulQ.tree_4.t4.t:=protein_gtr.gtr_scaler_4*0.03781759044922141;
tdIyVulQ.tree_4.Node184.t:=protein_gtr.gtr_scaler_4*0.2334318577839149;
tdIyVulQ.tree_4.Node178.t:=protein_gtr.gtr_scaler_4*0.0357376522064508;
tdIyVulQ.tree_4.t21.t:=protein_gtr.gtr_scaler_4*0.04466924010119974;
tdIyVulQ.tree_4.t79.t:=protein_gtr.gtr_scaler_4*0.1558739400562828;
tdIyVulQ.tree_4.Node189.t:=0;
tdIyVulQ.tree_4.Node177.t:=protein_gtr.gtr_scaler_4*0.02339703138280119;
tdIyVulQ.tree_4.Node165.t:=protein_gtr.gtr_scaler_4*0.08728829188357241;
tdIyVulQ.tree_4.t26.t:=protein_gtr.gtr_scaler_4*0.1925312919157318;
tdIyVulQ.tree_4.t49.t:=0;
tdIyVulQ.tree_4.Node195.t:=protein_gtr.gtr_scaler_4*0.01261954908064902;
tdIyVulQ.tree_4.t19.t:=protein_gtr.gtr_scaler_4*0.02379165389031009;
tdIyVulQ.tree_4.Node194.t:=protein_gtr.gtr_scaler_4*0.06348685093231561;
tdIyVulQ.tree_4.t33.t:=0;
tdIyVulQ.tree_4.Node193.t:=0;
tdIyVulQ.tree_4.t29.t:=0;
tdIyVulQ.tree_4.t80.t:=0;
tdIyVulQ.tree_4.Node201.t:=protein_gtr.gtr_scaler_4*0.01217582028014286;
tdIyVulQ.tree_4.t53.t:=protein_gtr.gtr_scaler_4*0.0737485316911362;
tdIyVulQ.tree_4.Node200.t:=0;
tdIyVulQ.tree_4.Node192.t:=protein_gtr.gtr_scaler_4*0.01074262987811615;
tdIyVulQ.tree_4.Node164.t:=protein_gtr.gtr_scaler_4*0.2836145676977676;
tdIyVulQ.tree_4.Node132.t:=protein_gtr.gtr_scaler_4*0.324728261035991;
tdIyVulQ.tree_4.Node104.t:=protein_gtr.gtr_scaler_4*0.0640420375419114;
tdIyVulQ.tree_4.Node86.t:=protein_gtr.gtr_scaler_4*0.1390584753376696;
DataSet protein_gtr.msa.0 = ReadDataFile(USE_NEXUS_FILE_DATA);
DataSetFilter tdIyVulQ.nuc_data_0 = CreateFilter(protein_gtr.msa.0,1,"0-189","5,7,11,3,4,14,6,1,18,15,17,16,12,2,9,10,0,19,13,8");
DataSetFilter tdIyVulQ.nuc_data_1 = CreateFilter(protein_gtr.msa.1,1,"0-228","25,46,12,32,15,2,13,26,23,29,16,24,5,30,34,40,21,22,28,18,45,38,41,43,39,20,10,9,42,33,35,37,6,7,17,47,4,1,11,19,0,3,27,51,52,48,14,50,44,31,49,8,36");
DataSetFilter tdIyVulQ.nuc_data_2 = CreateFilter(protein_gtr.msa.2,1,"0-86","54,28,120,76,65,103,33,119,48,78,87,57,70,111,66,67,72,73,13,61,29,40,114,45,35,41,6,74,55,115,109,26,63,25,62,30,42,79,49,47,24,23,4,11,97,3,82,94,90,37,9,1,108,69,22,2,31,96,21,32,92,102,27,58,64,107,38,53,14,112,15,10,17,36,83,50,7,52,84,88,116,118,99,39,113,46,106,8,77,12,122,81,80,68,44,75,18,0,86,110,93,91,89,19,16,121,85,56,100,105,71,60,43,34,20,51,5,117,98,59,104,95,101");
DataSetFilter tdIyVulQ.nuc_data_3 = CreateFilter(protein_gtr.msa.3,1,"0-74","47,1,73,43,68,46,88,76,22,40,7,102,45,95,3,29,13,78,62,9,90,75,50,42,104,107,96,71,81,10,48,105,49,39,6,21,84,35,31,64,4,55,17,34,69,67,70,85,103,63,5,0,113,28,25,33,16,32,18,65,112,60,53,30,41,79,23,80,97,99,11,101,106,61,59,54,2,57,98,37,74,58,72,114,91,52,110,12,24,8,38,89,77,82,108,36,51,26,115,15,93,27,66,83,86,109,19,44,111,92,14,100,56,87,20,94");
DataSetFilter tdIyVulQ.nuc_data_4 = CreateFilter(protein_gtr.msa.4,1,"0-84","77,66,93,25,68,5,27,47,42,79,97,45,13,82,98,35,94,23,54,99,29,83,102,14,92,101,44,8,53,46,87,41,70,72,86,100,11,78,1,10,69,40,33,30,22,37,52,95,67,36,32,20,62,16,43,63,38,80,18,6,81,21,0,60,73,55,17,15,71,61,65,90,39,64,91,75,4,50,7,89,31,28,57,24,3,2,74,96,85,12,26,56,88,34,51,19,58,59,48,76,49,9,84");
ASSUME_REVERSIBLE_MODELS=0;
LikelihoodFunction tdIyVulQ.likelihoodFunction = (tdIyVulQ.nuc_data_0,tdIyVulQ.tree_0,tdIyVulQ.nuc_data_1,tdIyVulQ.tree_1,tdIyVulQ.nuc_data_2,tdIyVulQ.tree_2,tdIyVulQ.nuc_data_3,tdIyVulQ.tree_3,tdIyVulQ.nuc_data_4,tdIyVulQ.tree_4);PRESERVE_SLAVE_NODE_STATE = TRUE; MPI_NEXUS_FILE_RETURN = "None";

/* test preamble */

	_testDescription 		= "Fit REV (amino-acid models) with constrained branch lengths";
	_expectedLL 			= -44401.9198;
	ExecuteAFile ("../Shared/TestInstrumentation.bf");
	startTestTimer (_testDescription);

/* end test preamble */

OPTIMIZATION_PRECISION = 0.001;
OPTIMIZATION_METHOD    = 0;
VERBOSITY_LEVEL        = 1;

Optimize (res, tdIyVulQ.likelihoodFunction);

fprintf (stdout, "Log(L) = ", res[1][0], "\n", tdIyVulQ.likelihoodFunction, "\n");

/* test epilogue */
	timeMatrix = endTestTimer 				  (_testDescription);
	if (logTestResult    (Abs (res[1][0] - _expectedLL) < 2*OPTIMIZATION_PRECISION))
	{
		return timeMatrix;
	}
	return 0;
/* end test epilogue */

END;
