#NEXUS

BEGIN TAXA;
	DIMENSIONS NTAX = 8;
	TAXLABELS
		'B_FR_83_HXB2_ACC_K03455' 'B_US_83_RF_ACC_M17451' 'B_US_86_JRFL_ACC_U63632' 'B_US_90_WEAU160_ACC_U21135' 'D_CD_83_ELI_ACC_K03454' 'D_CD_83_NDK_ACC_M27323' 'D_CD_84_84ZR085_ACC_U88822' 'D_UG_94_94UG114_ACC_U88824';
END;

BEGIN CHARACTERS;
	DIMENSIONS NCHAR = 1320;
	FORMAT
		DATATYPE = DNA
		GAP=-
		MISSING=?
	;

MATRIX
	'B_FR_83_HXB2_ACC_K03455'     CCCATTAGCCCTATTGAGACTGTACCAGTAAAATTAAAGCCAGGAATGGATGGCCCAAAAGTTAAACAATGGCCATTGACAGAAGAAAAAATAAAAGCATTAGTAGAAATTTGTACAGAGATGGAAAAGGAAGGGAAAATTTCAAAAATTGGGCCTGAAAATCCATACAATACTCCAGTATTTGCCATAAAGAAAAAAGACAGTACTAAATGGAGAAAATTAGTAGATTTCAGAGAACTTAATAAGAGAACTCAAGACTTCTGGGAAGTTCAATTAGGAATACCACATCCCGCAGGGTTAAAAAAGAAAAAATCAGTAACAGTACTGGATGTGGGTGATGCATATTTTTCAGTTCCCTTAGATGAAGACTTCAGGAAGTATACTGCATTTACCATACCTAGTATAAACAATGAGACACCAGGGATTAGATATCAGTACAATGTGCTTCCACAGGGATGGAAAGGATCACCAGCAATATTCCAAAGTAGCATGACAAAAATCTTAGAGCCTTTTAGAAAACAAAATCCAGACATAGTTATCTATCAATACATGGATGATTTGTATGTAGGATCTGACTTAGAAATAGGGCAGCATAGAACAAAAATAGAGGAGCTGAGACAACATCTGTTGAGGTGGGGACTTACCACACCAGACAAAAAACATCAGAAAGAACCTCCATTCCTTTGGATGGGTTATGAACTCCATCCTGATAAATGGACAGTACAGCCTATAGTGCTGCCAGAAAAAGACAGCTGGACTGTCAATGACATACAGAAGTTAGTGGGGAAATTGAATTGGGCAAGTCAGATTTACCCAGGGATTAAAGTAAGGCAATTATGTAAACTCCTTAGAGGAACCAAAGCACTAACAGAAGTAATACCACTAACAGAAGAAGCAGAGCTAGAACTGGCAGAAAACAGAGAGATTCTAAAAGAACCAGTACATGGAGTGTATTATGACCCATCAAAAGACTTAATAGCAGAAATACAGAAGCAGGGGCAAGGCCAATGGACATATCAAATTTATCAAGAGCCATTTAAAAATCTGAAAACAGGAAAATATGCAAGAATGAGGGGTGCCCACACTAATGATGTAAAACAATTAACAGAGGCAGTGCAAAAAATAACCACAGAAAGCATAGTAATATGGGGAAAGACTCCTAAATTTAAACTGCCCATACAAAAGGAAACATGGGAAACATGGTGGACAGAGTATTGGCAAGCCACCTGGATTCCTGAGTGGGAGTTTGTTAATACCCCTCCCTTAGTGAAATTATGGTACCAGTTAGAGAAAGAACCCATAGTAGGAGCAGAAACCTTC
	'B_US_83_RF_ACC_M17451'       CCCATTAGTCCTATTGAAACTGTACCAGTAAAATTAAAGCCAGGAATGGATGGCCCAAAAGTTAAACAATGGCCATTGACAGAGGAAAAAATAAAAGCATTGGTAGAAATTTGTACAGAAATGGAAAAGGAAGGAAAAATTTCCAAAATTGGGCCTGAAAATCCATACAATACTCCAGTATTTGCCATAAAGAAAAAAGACAGTACTAAATGGAGAAAATTAGTAGATTTCAGAGAACTTAATAAGAGAACTCAAGACTTCTGGGAAGTTCAGTTAGGAATACCACATCCTGCAGGGTTAAAAAAGAAGAAATCAGTAACAGTATTGGATGTGGGTGATGCATATTTTTCAGTTCCCTTAGATAAAGAGTTCAGGAAGTATACTGCATTTACCATACCTAGTATAAACAATGAAACACCACGGATTAGATATCAGTACAATGTGCTTCCACAAGGGTGGAAAGGATCACCAGCAATATTCCAAAGTAGTATGACAAAAATCTTAGAGCCTTTTAAAAAACAAAATCCAGAAATAGTTATCTATCAATACATGGATGATTTGTATGTAGGATCTGATTTAGAAATAGGGCAGCATAGAATAAAAATAGAGGAACTGAGAGAACATCTGTTAAAGTGGGGGTTTACCACACCGGACAAGAAACATCAGAAAGAACCTCCATTTCTTTGGATGGGTTATGAACTCCATCCTGATAAATGGACAGTACAGCCTATAGTGCTGCCAGAAAAAGACAGCTGGACTGTCAATGACATACAGAAGTTAGTGGGAAAATTGAATTGGGCAAGTCAGATTTATGCAGGGATTAAAGTAAAGCAATTATGTAAACTCCTTAGGGGAACCAAAGCACTAACAGAAGTAGTACAACTAACAAAAGAAGCAGAGCTAGAACTGGCAGAAAATAGGGAGATTCTAAAAGAACCAGTACATGGAGTGTATTATGACCCATCAAAAGACTTAATAGCAGAAATACAGAAGCAGGGGCAAGGCCAATGGACATACCAAATTTATCAAGAGCCATTTAAAAACCTGAAAACAGGAAAGTATGCAAGAATGAGGGGTGCCCACACTAATGATGTAAAACAATTAACAGAGGCAGTACAAAAAGTAGCCACAGAAAGCATAGTAATATGGGGAAAGACTCCTAAATTTAAACTACCCATACAAAAAGAAACATGGGAGGCATGGTGGACAGAGTATTGGCAAGCCACCTGGATTCCTGAGTGGGAGTTTGTCAATACCCCTCCCTTAGTAAAATTGTGGTACCAGTTAGAAAAAGAACCCATAATAGGAGCAGAAACTTTC
	'B_US_86_JRFL_ACC_U63632'     CCCATTAGTCCTATTGAAACTGTACCAGTAAAATTAAAGCCAGGAATGGATGGCCCAAAAGTCAAACAATGGCCATTGACAGAAGAAAAAATAAAAGCATTAGTAGAAATTTGTACAGAAATGGAAAAGGAAGGGAAAATTTCAAAAATTGGGCCTGAAAATCCATACAATACTCCAGTATTTGCCATAAAGAAAAAGGACAGTACTAAATGGAGAAAATTAGTAGATTTCAGAGAACTTAATAAGAAAACTCAAGACTTCTGGGAAGTTCAATTAGGAATACCACATCCCGCAGGGTTAAAAAAGAGAAAATCAGTAACAGTACTGGATGTGGGTGATGCATATTTTTCAGTTCCCTTAGATAAAGACTTCAGGAAATATACTGCATTTACCATACCTAGTATAAACAATGAGACACCAGGGATTAGGTATCAGTACAATGTGCTTCCGCAGGGATGGAAAGGATCACCAGCAATATTCCAAAGTAGCATGACAAAAATCTTAGAGCCTTTTAGAAAACAAAATCCAGACATAATTATCTATCAATACATGGATGATTTGTATGTAGGATCTGACTTAGAGATAGGGCAGCATAGAGCAAAAATAGAGGAATTGAGACAACATCTGTTGAGGTGGGGGTTTACCACACCAGACAAAAAACATCAGAAAGAACCTCCATTCCTTTGGATGGGTTATGAACTCCATCCTGACAAATGGACAGTACAGCCTATAGTGCTGCCAGAAAAAGACAGCTGGACTGTCAATGACATACAGAAGTTAGTGGGAAAATTAAATTGGGCAAGTCAGATTTACGCAGGGATTAAAGTAAAGCAATTATGTAAACTCCTTAGGGGAACCAAAGCACTAACAGAAGTAATACCACTAACAGAAGAAGCAGAGCTAGAACTGGCAGAAAACAGGGAGATTCTAAAAGAGCCAGTACATGGAGTGTATTATGACCCATCAAAAGACTTAATAGCAGAACTACAGAAGCAGGGGCAAGGCCAATGGACATATCAAATTTATCAAGAGCCATTTAAAATTCTGAAAACAGGAAAATATGCAAGAACGAGGGGTGCCCACACTAATGATGTAAAACAATTAACAGAGGCAGTGCAAAAAATAGCCAATGAAAGCATAGTAATATGGGGAAAGATTCCTAAATTTAAATTACCCATACAAAAAGAAACATGGGAAACATGGTGGACAGAGTATTGGCAAGCCACCTGGATTCCTGAGTGGGAGTTTGTCAATACCCCTCCCTTAGTGAAATTATGGTACCAGTTAGAGAAAGAACCCATAGTAGGAGCAGAAACTTTC
	'B_US_90_WEAU160_ACC_U21135'  CCCATTAGTCCTATTGAAACTGTACCAGTAAAATTAAAGCCAGGAATGGATGGCCCAAAAGTTAAACAATGGCCATTGACAGAAGAGAAAATAAAAGCATTAGTAGAAATTTGTACAGAAATGGAAAAGGAAGGAAAAATTTCAAAAATTGGGCCTGAAAATCCATATAATACTCCAGTATTTGCCATAAAGAAAAAAGACAGTACTAAATGGAGAAAATTAGTAGATTTCAGAGAACTTAATAAGAGAACTCAAGACTTCTGGGAAGTTCAATTAGGAATACCACATCCTTCAGGGTTAAAAAAGAAAAAATCAGTAACAGTACTGGATGTGGGTGATGCATATTTTTCAGTACCCTTAGATGAAGACTTCAGGAAGTACACTGCATTTACCATACCTAGTATAAACAATGAAACACCAGGGATTAGATATCAGTACAATGTGCTTCCACAGGGATGGAAAGGATCACCAGCAATATTCCAAAGTAGCATGACAAAAATATTAGAGCCTTTTAGAAAACAAAATCCAGACATAGTTATCTATCAATACATGGATGATTTGTATGTAGGATCTGACTTAGAAATAGGGCAGCATAGAACAAAAATAGAGGAGCTGAGACAACATCTGTTGAGGTGGGGATTTACCACACCAGACAAAAAACATCAAAAAGACCCTCCATTCCTTTGGATGGGTTATGAACTCCATCCTGATAAATGGACAGTACAGCCTATAAAGCTGCCAGAAAAAGAAAGTTGGACTGTCAATGACATACAGAAGTTAGTGGGAAAATTGAATTGGGCAAGTCAGATTTACGCAGGGATTAAAGTAAAGCAACTATGTAAACTCCTTAGGGGGACCAAAGCACTAACAGAAATAATACCAATAACAGAAGAAGCAGAGCTAGAGCTGGCAGAAAACAGGGAAATTCTAAAAGAACCGGTACATGGAGTGTATTATGACCCATCAAAAGACTTAATAGCAGAGCTACAGAAGCAGGGGCAAGGCCAATGGACATATCAGATTTATCAAGAGCCATTTAAAAATCTGAAAACAGGAAAGTATGCAAGAGTGAGGGGTGCCCACACTAATGATGTAAAACAATTAACAGAGGCAGTGCAGAAAATAACCACAGAAAGCATAGTAATATGGGGAAAGACTCCTAAATTTAAACTACCCATACAAAAAGAAACATGGGAAACATGGTGGACAGAGTATTGGCAAGCCACCTGGATTCCTGAGTGGGAGTTTGTCAATACCCCTCCCTTAGTGAAATTATGGTATCAGTTAGAGAAAGAACCCATAGTAGGAGCAGAAACTTTC
	'D_CD_83_ELI_ACC_K03454'      CCAATTAGTCCTATTGAAACTGTACCAGTAAAATTAAAGCCAGGAATGGATGGCCCAAAAGTTAAACAATGGCCATTGACAGAAGAAAAAATAAAAGCATTAACAGAAATTTGTACAGATATGGAAAAGGAAGGAAAAATTTCAAGAATTGGGCCTGAAAATCCATACAATACTCCAATATTTGCCATAAAGAAAAAAGACAGTACCAAGTGGAGAAAATTAGTAGATTTCAGAGAACTTAATAAGAGAACTCAAGATTTCTGGGAAGTTCAATTAGGAATACCGCATCCTGCAGGGCTGAAAAAGAAAAAATCAGTAACAGTACTGGATGTGGGTGATGCATATTTTTCAGTTCCCTTAGATGAAGATTTTAGGAAATATACCGCCTTTACCATATCTAGTATAAACAATGAGACACCAGGGATTAGATATCAGTACAATGTGCTTCCACAGGGATGGAAAGGATCACCGGCAATATTCCAAAGTAGCATGACAAAAATCTTAGAGCCCTTTAGAAAACAAAATCCAGAAATGGTTATCTATCAATACATGGATGATTTGTATGTAGGATCTGACTTAGAAATAGGGCAGCATAGGACAAAAATAGAGAAATTAAGAGAACATCTATTGAGGTGGGGATTTACCAGACCAGATAAAAAACATCAGAAAGAACCCCCATTTCTTTGGATGGGTTATGAACTCCATCCTGATAAATGGACAGTACAGTCTATAAAACTGCCAGAAAAGGAGAGCTGGACTGTCAATGATATACAGAACTTAGTGGAGAGATTAAACTGGGCAAGCCAGATTTATCCAGGAATTAAAGTAAGACAATTATGTAAACTCCTTAGGGGAACCAAAGCACTAACAGAAGTAATACCACTAACAGAAGAAGCAGAATTAGAACTGGCAGAAAACAGGGAAATTTTAAAAGAACCAGTACATGGAGTGTATTATGACCCATCAAAAGACTTAATAGCAGAAATACAGAAACAAGGGCACGGCCAATGGACATACCAAATTTATCAAGAACCATTTAAAAATCTGAAAACAGGAAAGTATGCAAGAATGAGGGGTGCCCACACTAATGATGTAAAGCAATTAGCAGAGGCAGTGCAAAGAATATCCACAGAAAGCATAGTGATATGGGGAAGGACTCCTAAATTTAGACTACCCATACAAAAGGAAACATGGGAAACATGGTGGGCAGAGTATTGGCAAGCCACTTGGATTCCTGAGTGGGAATTTGTCAATACCCCTCCTTTAGTAAAATTATGGTACCAGTTAGAGAAGGAACCCATAATAGGAGCAGAAACTTTC
	'D_CD_83_NDK_ACC_M27323'      CCAATTAGTCCTATTGAAACTGTACCAGTAAAATTAAAGCCAGGAATGGATGGCCCAAAAGTTAAACAATGGCCATTGACAGAAGAAAAAATAAAAGCATTAACAGAAATTTGTACAGAAATGGAAAAGGAAGGAAAAATTTCAAGAATTGGGCCTGAAAATCCATATAATACTCCAATATTTGCCATAAAGAAAAAAGACAGTACCAAGTGGAGAAAATTAGTAGATTTCAGAGAACTTAATAAGAGAACTCAAGATTTCTGGGAGGTTCAATTAGGAATACCGCATCCTGCAGGGCTGAAAAAGAAAAAATCAGTAACAGTACTGGATGTGGGTGATGCATATTTCTCAGTTCCCTTAGATGAAGATTTTAGGAAATATACCGCATTTACCATACCTAGTATAAACAATGAGACACCAGGGATTAGATATCAGTACAATGTGCTCCCACAGGGATGGAAAGGATCACCGGCAATATTCCAAAGTAGCATGACAAAAATCTTAGAGCCCTTTAGAAAACAAAATCCAGAAATAGTTATCTATCAATACATGGATGATTTGTATGTAGGATCTGACTTAGAAATAGGGCAGCATAGAACAAAAATAGAGGAATTAAGAGAACATCTATTGAGGTGGGGATTTACCACACCAGATAAAAAACATCAGAAAGAACCTCCATTTCTTTGGATGGGTTATGAACTCCATCCTGATAAATGGACAGTACAGCCTATAAACCTGCCAGAAAAAGAAAGCTGGACTGTCAATGATATACAGAAGTTAGTGGGGAAATTAAACTGGGCAAGCCAGATTTATGCAGGAATTAAAGTAAAGCAATTATGTAAACTCCTTAGGGGAACCAAAGCACTAACAGAAGTAGTACCACTAACAGAAGAAGCAGAATTAGAACTGGCAGAAAACAGGGAAATTCTAAAAGAACCAGTACATGGAGTGTATTATGACCCATCAAAAGACTTAATAGCAGAACTACAGAAACAAGGGGACGGCCAATGGACATACCAAATTTATCAAGAACCATTTAAAAATCTAAAAACAGGAAAGTATGCAAGAACGAGGGGTGCCCACACTAATGATGTAAAACAATTAACAGAGGCAGTGCAAAAAATAGCCACAGAAAGCATAGTGATATGGGGAAAGACTCCTAAATTTAAACTACCCATACAAAAGGAAACATGGGAAACATGGTGGATAGAGTATTGGCAAGCCACCTGGATTCCTGAGTGGGAATTTGTCAATACCCCTCCTTTAGTAAAATTATGGTACCAGTTAGAGAAGGAACCCATAATAGGAGCAGAAACTTTC
	'D_CD_84_84ZR085_ACC_U88822'  CCAATTAGTCCTATTGAAACTGTACCAGTAAAATTAAAGCCAGGAATGGATGGCCCAAAAGTTAAACAATGGCCGTTGACAGAAGAAAAAATAAAAGCATTAACAGAAATTTGTACAGATATGGAAAAGGAAGGAAAAATTTCAAGAATTGGGCCTGAAAATCCATACAATACTCCAATATTTGCCATAAAGAAAAAAGACAGTACTAAGTGGAGAAAATTAGTAGATTTCAGAGAACTTAATAAGAGAACTCAAGACTTCTGGGAAGTTCAATTAGGGATACCACATCCTGCAGGATTAAAGAAGAAAAAGTCAATAACAGTACTGGATGTGGGCGATGCATATTTTTCAATTCCCTTATGTGAAGACTTTAGGAAGTACACTGCATTTACCATACCTAGTATAAACAATGAGACACCAGGGATTAGATATCAGTACAATGTACTTCCACAGGGATGGAAAGGATCACCAGCAATATTCCAAAGTAGCATGATAAAAATCTTAGAGCCCTTTAGAAAACAAAATCCAGAAGTAGTTATCTATCAATACATGGATGATTTGTATGTAGGATCTGATTTAGAAATAGGACAGCATAGAGCAAAAATAGAGAAATTAAGAGAACATCTGTTGAGGTGGGGGCTTACCACACCAGACAAAAAACATCAGAAAGAACCTCCATTTCTTTGGATGGGTTATGAACTCCATCCTGATAAGTGGACAGTACAGTCTATAACACTGCCAGAGAAAGAAAGCTGGACTGTCAATGATATACAGAAGTTAGTGGGAAAATTAAATTGGGCAAGCCAGATTTATCCAGGAATTAAAGTAAAGCAATTATGTAAACTCCTTAGGGGAACCAAGGCACTAACAGAGGTAATACCACTAACAGAAGAAGCAGAATTAGAACTGGCAGAAAACAGGGAGATTCTAAAGGAACCAATGCATGGAGTGTATTATGACCCATCAAAAGACTTAATAGCAGAATTACAGAAACAAGGGCAAGGTCAATGGACATATCAAATTTATCAAGAACCATTTAAAAATCTGAAAACAGGAAAGTATGCAAGAATGAGGGGTGCCCACACTAATGATGTAAAACAGTTAACAGAGGCAGTGCAAAAAATAGCCATAGAAAGCATAGTGATATGGGGAAAGACTCCTAAATTTAGACTACCCATACAAAAGGAAACATGGGAAACATGGTGGATAGACTATTGGCAAGCCACCTGGATTCCTGAGTGGGAATTTGTCAATACCCCTCCTTTAGTAAAATTATGGTACCAGTTAGAGAAGGAACCCATAATAGGAGCAGAAACTTTC
	'D_UG_94_94UG114_ACC_U88824'  CCAATTAGTCCTATTGAAACTGTACCAGTAAAATTAAAGCCAGGGATGGATGGCCCAAAAGTTAAACAATGGCCGTTGACAGAAGAAAAAATAAAAGCACTAATAGAAATTTGTTCAGAACTAGAAAAGGAAGGAAAAATTTCAAAAATTGGGCCTGAAAACCCATACAATACTCCAATATTTGCCATAAAGAAAAAAGACAGTACTAAGTGGAGAAAATTAGTAGATTTCAGAGAACTTAATAAGAGAACTCAAGACTTTTGGGAAGTTCAACTAGGAATACCACATCCTGCAGGGCTAAAAAAGAAAAAATCAGTAACAGTACTGGATGTGGGTGACGCATATTTTTCAGTTCCCTTACATGAAGACTTTAGAAAATATACCGCATTCACCATACCTAGTACAAACAATGAGACACCAGGAATTAGATATCAGTACAATGTGCTTCCACAAGGATGGAAAGGATCACCAGCAATATTCCAAAGTAGCATGACAAAAATCTTAGAACCTTTTAGAAAACAAAATCCAGAAATGATTATCTATCAATACATGGATGATTTGTATGTAGGATCTGACTTAGAAATAGGGCAGCATAGAATAAAAATAGAGGAATTAAGGGGACACCTCTTGAAGTGGGGATTTACCACACCAGACAAAAAGTATCAGAAAGAACCCCCATTTCTTTGGATGGGTTATGAACTCCATCCTGATAAGTGGACAGTACAGCCTATACATCTGCCAGAAAAGGAAAGCTGGACTGTCAATGATATACAGAAGTTAGTGGGAAAATTAAATTGGGCAAGCCAGATTTATCCAGGAATTAAAGTAAGACAATTATGCAAATGCCTTAGGGGAGCCAAAGCACTGACAGAAGTAATACCACTGACAGCAGAAGCAGAATTAGAACTGGCAGAAAACAGGGAAATACTAAAAGAACCAGTACATGGAGCGTATTATGACCCATCAAAAGACTTAATAGCAGAAATACAGAAACAAGGGCAAGATCAATGGACATATCAAATATATCAAGAACAATATAAAAATCTGAAAACAGGAAAGTATGCGAAAATGAGGGGTACCCACACTAATGATGTAAAACAATTAACAGAGGCAGTGCAGAAAATAGCCCAAGAATGTATAGTAATATGGGGAAAGACTCCTAAATTTAGACTACCCATACAAAAGGAAACATGGGAAACATGGTGGACAGAGTATTGGCAGGCCACCTGGATTCCTGAGTGGGAGTATGTCAACACCCCTCCTTTAGTTAAATTATGGTATCAGTTAGAGAAGGAACCCATAGTAGGAGCAGAAACTTTC;
END;

BEGIN TREES;
	TREE tree = ((((D_CD_83_ELI_ACC_K03454,D_CD_83_NDK_ACC_M27323),D_UG_94_94UG114_ACC_U88824),D_CD_84_84ZR085_ACC_U88822),B_US_83_RF_ACC_M17451,((B_FR_83_HXB2_ACC_K03455,B_US_86_JRFL_ACC_U63632),B_US_90_WEAU160_ACC_U21135));
END;

BEGIN HYPHY;

/* test preamble */

	_testDescription 		= " fit the MG94x012232 model to an HIV-1 RT (p51) alignment with 8 sequences and 430 codons";
	_expectedLL 			= -3189.516375;
	ExecuteAFile ("../Shared/TestInstrumentation.bf");
	startTestTimer (_testDescription);

/* end test preamble */

OPTIMIZATION_PRECISION = 0.001;
VERBOSITY_LEVEL        = -1;

//LF_SMOOTHING_SCALER = 0.001;

global AT=1;
global CT=1;
global R=1;
global AC=1;
global CG:=AT;
global GT:=AT;

global CT=1.176334358800697;
global R=0.2312658755546703;
global AT=0.1219371068878096;
global AC=0.239867475616316;
global CG:=AT;
global GT:=AT;
MG94custom={61,61};
MG94custom[0][1]:=synRate*R*AC*0.1076704545454545;
MG94custom[0][2]:=synRate*0.19375;
MG94custom[0][3]:=synRate*R*AT*0.2204545454545455;
MG94custom[0][4]:=synRate*R*AC*0.2014204545454545;
MG94custom[0][8]:=synRate*R*0.1505681818181818;
MG94custom[0][12]:=synRate*R*AT*0.2616477272727273;
MG94custom[0][16]:=synRate*R*AC*0.1897727272727273;
MG94custom[0][32]:=synRate*R*0.284375;
MG94custom[1][0]:=synRate*R*AC*0.478125;
MG94custom[1][2]:=synRate*R*CG*0.19375;
MG94custom[1][3]:=synRate*CT*0.2204545454545455;
MG94custom[1][5]:=synRate*R*AC*0.2014204545454545;
MG94custom[1][9]:=synRate*R*0.1505681818181818;
MG94custom[1][13]:=synRate*R*AT*0.2616477272727273;
MG94custom[1][17]:=synRate*R*AC*0.1897727272727273;
MG94custom[1][33]:=synRate*R*0.284375;
MG94custom[1][48]:=synRate*R*AT*0.1769886363636364;
MG94custom[2][0]:=synRate*0.478125;
MG94custom[2][1]:=synRate*R*CG*0.1076704545454545;
MG94custom[2][3]:=synRate*R*GT*0.2204545454545455;
MG94custom[2][6]:=synRate*R*AC*0.2014204545454545;
MG94custom[2][10]:=synRate*R*0.1505681818181818;
MG94custom[2][14]:=synRate*R*AT*0.2616477272727273;
MG94custom[2][18]:=synRate*R*AC*0.1897727272727273;
MG94custom[2][34]:=synRate*R*0.284375;
MG94custom[3][0]:=synRate*R*AT*0.478125;
MG94custom[3][1]:=synRate*CT*0.1076704545454545;
MG94custom[3][2]:=synRate*R*GT*0.19375;
MG94custom[3][7]:=synRate*R*AC*0.2014204545454545;
MG94custom[3][11]:=synRate*R*0.1505681818181818;
MG94custom[3][15]:=synRate*R*AT*0.2616477272727273;
MG94custom[3][19]:=synRate*R*AC*0.1897727272727273;
MG94custom[3][35]:=synRate*R*0.284375;
MG94custom[3][49]:=synRate*R*AT*0.1769886363636364;
MG94custom[4][0]:=synRate*R*AC*0.3863636363636364;
MG94custom[4][5]:=synRate*AC*0.1076704545454545;
MG94custom[4][6]:=synRate*0.19375;
MG94custom[4][7]:=synRate*AT*0.2204545454545455;
MG94custom[4][8]:=synRate*R*CG*0.1505681818181818;
MG94custom[4][12]:=synRate*R*CT*0.2616477272727273;
MG94custom[4][20]:=synRate*R*AC*0.1897727272727273;
MG94custom[4][36]:=synRate*R*0.284375;
MG94custom[4][50]:=synRate*R*AT*0.1769886363636364;
MG94custom[5][1]:=synRate*R*AC*0.3863636363636364;
MG94custom[5][4]:=synRate*AC*0.478125;
MG94custom[5][6]:=synRate*CG*0.19375;
MG94custom[5][7]:=synRate*CT*0.2204545454545455;
MG94custom[5][9]:=synRate*R*CG*0.1505681818181818;
MG94custom[5][13]:=synRate*R*CT*0.2616477272727273;
MG94custom[5][21]:=synRate*R*AC*0.1897727272727273;
MG94custom[5][37]:=synRate*R*0.284375;
MG94custom[5][51]:=synRate*R*AT*0.1769886363636364;
MG94custom[6][2]:=synRate*R*AC*0.3863636363636364;
MG94custom[6][4]:=synRate*0.478125;
MG94custom[6][5]:=synRate*CG*0.1076704545454545;
MG94custom[6][7]:=synRate*GT*0.2204545454545455;
MG94custom[6][10]:=synRate*R*CG*0.1505681818181818;
MG94custom[6][14]:=synRate*R*CT*0.2616477272727273;
MG94custom[6][22]:=synRate*R*AC*0.1897727272727273;
MG94custom[6][38]:=synRate*R*0.284375;
MG94custom[6][52]:=synRate*R*AT*0.1769886363636364;
MG94custom[7][3]:=synRate*R*AC*0.3863636363636364;
MG94custom[7][4]:=synRate*AT*0.478125;
MG94custom[7][5]:=synRate*CT*0.1076704545454545;
MG94custom[7][6]:=synRate*GT*0.19375;
MG94custom[7][11]:=synRate*R*CG*0.1505681818181818;
MG94custom[7][15]:=synRate*R*CT*0.2616477272727273;
MG94custom[7][23]:=synRate*R*AC*0.1897727272727273;
MG94custom[7][39]:=synRate*R*0.284375;
MG94custom[7][53]:=synRate*R*AT*0.1769886363636364;
MG94custom[8][0]:=synRate*R*0.3863636363636364;
MG94custom[8][4]:=synRate*R*CG*0.2014204545454545;
MG94custom[8][9]:=synRate*R*AC*0.1076704545454545;
MG94custom[8][10]:=synRate*0.19375;
MG94custom[8][11]:=synRate*R*AT*0.2204545454545455;
MG94custom[8][12]:=synRate*R*GT*0.2616477272727273;
MG94custom[8][24]:=synRate*AC*0.1897727272727273;
MG94custom[8][40]:=synRate*R*0.284375;
MG94custom[9][1]:=synRate*R*0.3863636363636364;
MG94custom[9][5]:=synRate*R*CG*0.2014204545454545;
MG94custom[9][8]:=synRate*R*AC*0.478125;
MG94custom[9][10]:=synRate*R*CG*0.19375;
MG94custom[9][11]:=synRate*CT*0.2204545454545455;
MG94custom[9][13]:=synRate*R*GT*0.2616477272727273;
MG94custom[9][25]:=synRate*R*AC*0.1897727272727273;
MG94custom[9][41]:=synRate*R*0.284375;
MG94custom[9][54]:=synRate*R*AT*0.1769886363636364;
MG94custom[10][2]:=synRate*R*0.3863636363636364;
MG94custom[10][6]:=synRate*R*CG*0.2014204545454545;
MG94custom[10][8]:=synRate*0.478125;
MG94custom[10][9]:=synRate*R*CG*0.1076704545454545;
MG94custom[10][11]:=synRate*R*GT*0.2204545454545455;
MG94custom[10][14]:=synRate*R*GT*0.2616477272727273;
MG94custom[10][26]:=synRate*AC*0.1897727272727273;
MG94custom[10][42]:=synRate*R*0.284375;
MG94custom[10][55]:=synRate*R*AT*0.1769886363636364;
MG94custom[11][3]:=synRate*R*0.3863636363636364;
MG94custom[11][7]:=synRate*R*CG*0.2014204545454545;
MG94custom[11][8]:=synRate*R*AT*0.478125;
MG94custom[11][9]:=synRate*CT*0.1076704545454545;
MG94custom[11][10]:=synRate*R*GT*0.19375;
MG94custom[11][15]:=synRate*R*GT*0.2616477272727273;
MG94custom[11][27]:=synRate*R*AC*0.1897727272727273;
MG94custom[11][43]:=synRate*R*0.284375;
MG94custom[11][56]:=synRate*R*AT*0.1769886363636364;
MG94custom[12][0]:=synRate*R*AT*0.3863636363636364;
MG94custom[12][4]:=synRate*R*CT*0.2014204545454545;
MG94custom[12][8]:=synRate*R*GT*0.1505681818181818;
MG94custom[12][13]:=synRate*AC*0.1076704545454545;
MG94custom[12][14]:=synRate*R*0.19375;
MG94custom[12][15]:=synRate*AT*0.2204545454545455;
MG94custom[12][28]:=synRate*R*AC*0.1897727272727273;
MG94custom[12][44]:=synRate*R*0.284375;
MG94custom[12][57]:=synRate*R*AT*0.1769886363636364;
MG94custom[13][1]:=synRate*R*AT*0.3863636363636364;
MG94custom[13][5]:=synRate*R*CT*0.2014204545454545;
MG94custom[13][9]:=synRate*R*GT*0.1505681818181818;
MG94custom[13][12]:=synRate*AC*0.478125;
MG94custom[13][14]:=synRate*R*CG*0.19375;
MG94custom[13][15]:=synRate*CT*0.2204545454545455;
MG94custom[13][29]:=synRate*R*AC*0.1897727272727273;
MG94custom[13][45]:=synRate*R*0.284375;
MG94custom[13][58]:=synRate*R*AT*0.1769886363636364;
MG94custom[14][2]:=synRate*R*AT*0.3863636363636364;
MG94custom[14][6]:=synRate*R*CT*0.2014204545454545;
MG94custom[14][10]:=synRate*R*GT*0.1505681818181818;
MG94custom[14][12]:=synRate*R*0.478125;
MG94custom[14][13]:=synRate*R*CG*0.1076704545454545;
MG94custom[14][15]:=synRate*R*GT*0.2204545454545455;
MG94custom[14][30]:=synRate*R*AC*0.1897727272727273;
MG94custom[14][46]:=synRate*R*0.284375;
MG94custom[14][59]:=synRate*R*AT*0.1769886363636364;
MG94custom[15][3]:=synRate*R*AT*0.3863636363636364;
MG94custom[15][7]:=synRate*R*CT*0.2014204545454545;
MG94custom[15][11]:=synRate*R*GT*0.1505681818181818;
MG94custom[15][12]:=synRate*AT*0.478125;
MG94custom[15][13]:=synRate*CT*0.1076704545454545;
MG94custom[15][14]:=synRate*R*GT*0.19375;
MG94custom[15][31]:=synRate*R*AC*0.1897727272727273;
MG94custom[15][47]:=synRate*R*0.284375;
MG94custom[15][60]:=synRate*R*AT*0.1769886363636364;
MG94custom[16][0]:=synRate*R*AC*0.3488636363636364;
MG94custom[16][17]:=synRate*R*AC*0.1076704545454545;
MG94custom[16][18]:=synRate*0.19375;
MG94custom[16][19]:=synRate*R*AT*0.2204545454545455;
MG94custom[16][20]:=synRate*R*AC*0.2014204545454545;
MG94custom[16][24]:=synRate*R*0.1505681818181818;
MG94custom[16][28]:=synRate*R*AT*0.2616477272727273;
MG94custom[16][32]:=synRate*R*CG*0.284375;
MG94custom[17][1]:=synRate*R*AC*0.3488636363636364;
MG94custom[17][16]:=synRate*R*AC*0.478125;
MG94custom[17][18]:=synRate*R*CG*0.19375;
MG94custom[17][19]:=synRate*CT*0.2204545454545455;
MG94custom[17][21]:=synRate*R*AC*0.2014204545454545;
MG94custom[17][25]:=synRate*R*0.1505681818181818;
MG94custom[17][29]:=synRate*R*AT*0.2616477272727273;
MG94custom[17][33]:=synRate*R*CG*0.284375;
MG94custom[17][48]:=synRate*R*CT*0.1769886363636364;
MG94custom[18][2]:=synRate*R*AC*0.3488636363636364;
MG94custom[18][16]:=synRate*0.478125;
MG94custom[18][17]:=synRate*R*CG*0.1076704545454545;
MG94custom[18][19]:=synRate*R*GT*0.2204545454545455;
MG94custom[18][22]:=synRate*R*AC*0.2014204545454545;
MG94custom[18][26]:=synRate*R*0.1505681818181818;
MG94custom[18][30]:=synRate*R*AT*0.2616477272727273;
MG94custom[18][34]:=synRate*R*CG*0.284375;
MG94custom[19][3]:=synRate*R*AC*0.3488636363636364;
MG94custom[19][16]:=synRate*R*AT*0.478125;
MG94custom[19][17]:=synRate*CT*0.1076704545454545;
MG94custom[19][18]:=synRate*R*GT*0.19375;
MG94custom[19][23]:=synRate*R*AC*0.2014204545454545;
MG94custom[19][27]:=synRate*R*0.1505681818181818;
MG94custom[19][31]:=synRate*R*AT*0.2616477272727273;
MG94custom[19][35]:=synRate*R*CG*0.284375;
MG94custom[19][49]:=synRate*R*CT*0.1769886363636364;
MG94custom[20][4]:=synRate*R*AC*0.3488636363636364;
MG94custom[20][16]:=synRate*R*AC*0.3863636363636364;
MG94custom[20][21]:=synRate*AC*0.1076704545454545;
MG94custom[20][22]:=synRate*0.19375;
MG94custom[20][23]:=synRate*AT*0.2204545454545455;
MG94custom[20][24]:=synRate*R*CG*0.1505681818181818;
MG94custom[20][28]:=synRate*R*CT*0.2616477272727273;
MG94custom[20][36]:=synRate*R*CG*0.284375;
MG94custom[20][50]:=synRate*R*CT*0.1769886363636364;
MG94custom[21][5]:=synRate*R*AC*0.3488636363636364;
MG94custom[21][17]:=synRate*R*AC*0.3863636363636364;
MG94custom[21][20]:=synRate*AC*0.478125;
MG94custom[21][22]:=synRate*CG*0.19375;
MG94custom[21][23]:=synRate*CT*0.2204545454545455;
MG94custom[21][25]:=synRate*R*CG*0.1505681818181818;
MG94custom[21][29]:=synRate*R*CT*0.2616477272727273;
MG94custom[21][37]:=synRate*R*CG*0.284375;
MG94custom[21][51]:=synRate*R*CT*0.1769886363636364;
MG94custom[22][6]:=synRate*R*AC*0.3488636363636364;
MG94custom[22][18]:=synRate*R*AC*0.3863636363636364;
MG94custom[22][20]:=synRate*0.478125;
MG94custom[22][21]:=synRate*CG*0.1076704545454545;
MG94custom[22][23]:=synRate*GT*0.2204545454545455;
MG94custom[22][26]:=synRate*R*CG*0.1505681818181818;
MG94custom[22][30]:=synRate*R*CT*0.2616477272727273;
MG94custom[22][38]:=synRate*R*CG*0.284375;
MG94custom[22][52]:=synRate*R*CT*0.1769886363636364;
MG94custom[23][7]:=synRate*R*AC*0.3488636363636364;
MG94custom[23][19]:=synRate*R*AC*0.3863636363636364;
MG94custom[23][20]:=synRate*AT*0.478125;
MG94custom[23][21]:=synRate*CT*0.1076704545454545;
MG94custom[23][22]:=synRate*GT*0.19375;
MG94custom[23][27]:=synRate*R*CG*0.1505681818181818;
MG94custom[23][31]:=synRate*R*CT*0.2616477272727273;
MG94custom[23][39]:=synRate*R*CG*0.284375;
MG94custom[23][53]:=synRate*R*CT*0.1769886363636364;
MG94custom[24][8]:=synRate*AC*0.3488636363636364;
MG94custom[24][16]:=synRate*R*0.3863636363636364;
MG94custom[24][20]:=synRate*R*CG*0.2014204545454545;
MG94custom[24][25]:=synRate*AC*0.1076704545454545;
MG94custom[24][26]:=synRate*0.19375;
MG94custom[24][27]:=synRate*AT*0.2204545454545455;
MG94custom[24][28]:=synRate*R*GT*0.2616477272727273;
MG94custom[24][40]:=synRate*R*CG*0.284375;
MG94custom[25][9]:=synRate*R*AC*0.3488636363636364;
MG94custom[25][17]:=synRate*R*0.3863636363636364;
MG94custom[25][21]:=synRate*R*CG*0.2014204545454545;
MG94custom[25][24]:=synRate*AC*0.478125;
MG94custom[25][26]:=synRate*CG*0.19375;
MG94custom[25][27]:=synRate*CT*0.2204545454545455;
MG94custom[25][29]:=synRate*R*GT*0.2616477272727273;
MG94custom[25][41]:=synRate*R*CG*0.284375;
MG94custom[25][54]:=synRate*R*CT*0.1769886363636364;
MG94custom[26][10]:=synRate*AC*0.3488636363636364;
MG94custom[26][18]:=synRate*R*0.3863636363636364;
MG94custom[26][22]:=synRate*R*CG*0.2014204545454545;
MG94custom[26][24]:=synRate*0.478125;
MG94custom[26][25]:=synRate*CG*0.1076704545454545;
MG94custom[26][27]:=synRate*GT*0.2204545454545455;
MG94custom[26][30]:=synRate*R*GT*0.2616477272727273;
MG94custom[26][42]:=synRate*R*CG*0.284375;
MG94custom[26][55]:=synRate*R*CT*0.1769886363636364;
MG94custom[27][11]:=synRate*R*AC*0.3488636363636364;
MG94custom[27][19]:=synRate*R*0.3863636363636364;
MG94custom[27][23]:=synRate*R*CG*0.2014204545454545;
MG94custom[27][24]:=synRate*AT*0.478125;
MG94custom[27][25]:=synRate*CT*0.1076704545454545;
MG94custom[27][26]:=synRate*GT*0.19375;
MG94custom[27][31]:=synRate*R*GT*0.2616477272727273;
MG94custom[27][43]:=synRate*R*CG*0.284375;
MG94custom[27][56]:=synRate*R*CT*0.1769886363636364;
MG94custom[28][12]:=synRate*R*AC*0.3488636363636364;
MG94custom[28][16]:=synRate*R*AT*0.3863636363636364;
MG94custom[28][20]:=synRate*R*CT*0.2014204545454545;
MG94custom[28][24]:=synRate*R*GT*0.1505681818181818;
MG94custom[28][29]:=synRate*AC*0.1076704545454545;
MG94custom[28][30]:=synRate*0.19375;
MG94custom[28][31]:=synRate*AT*0.2204545454545455;
MG94custom[28][44]:=synRate*R*CG*0.284375;
MG94custom[28][57]:=synRate*CT*0.1769886363636364;
MG94custom[29][13]:=synRate*R*AC*0.3488636363636364;
MG94custom[29][17]:=synRate*R*AT*0.3863636363636364;
MG94custom[29][21]:=synRate*R*CT*0.2014204545454545;
MG94custom[29][25]:=synRate*R*GT*0.1505681818181818;
MG94custom[29][28]:=synRate*AC*0.478125;
MG94custom[29][30]:=synRate*CG*0.19375;
MG94custom[29][31]:=synRate*CT*0.2204545454545455;
MG94custom[29][45]:=synRate*R*CG*0.284375;
MG94custom[29][58]:=synRate*R*CT*0.1769886363636364;
MG94custom[30][14]:=synRate*R*AC*0.3488636363636364;
MG94custom[30][18]:=synRate*R*AT*0.3863636363636364;
MG94custom[30][22]:=synRate*R*CT*0.2014204545454545;
MG94custom[30][26]:=synRate*R*GT*0.1505681818181818;
MG94custom[30][28]:=synRate*0.478125;
MG94custom[30][29]:=synRate*CG*0.1076704545454545;
MG94custom[30][31]:=synRate*GT*0.2204545454545455;
MG94custom[30][46]:=synRate*R*CG*0.284375;
MG94custom[30][59]:=synRate*CT*0.1769886363636364;
MG94custom[31][15]:=synRate*R*AC*0.3488636363636364;
MG94custom[31][19]:=synRate*R*AT*0.3863636363636364;
MG94custom[31][23]:=synRate*R*CT*0.2014204545454545;
MG94custom[31][27]:=synRate*R*GT*0.1505681818181818;
MG94custom[31][28]:=synRate*AT*0.478125;
MG94custom[31][29]:=synRate*CT*0.1076704545454545;
MG94custom[31][30]:=synRate*GT*0.19375;
MG94custom[31][47]:=synRate*R*CG*0.284375;
MG94custom[31][60]:=synRate*R*CT*0.1769886363636364;
MG94custom[32][0]:=synRate*R*0.3488636363636364;
MG94custom[32][16]:=synRate*R*CG*0.1897727272727273;
MG94custom[32][33]:=synRate*R*AC*0.1076704545454545;
MG94custom[32][34]:=synRate*0.19375;
MG94custom[32][35]:=synRate*R*AT*0.2204545454545455;
MG94custom[32][36]:=synRate*R*AC*0.2014204545454545;
MG94custom[32][40]:=synRate*R*0.1505681818181818;
MG94custom[32][44]:=synRate*R*AT*0.2616477272727273;
MG94custom[33][1]:=synRate*R*0.3488636363636364;
MG94custom[33][17]:=synRate*R*CG*0.1897727272727273;
MG94custom[33][32]:=synRate*R*AC*0.478125;
MG94custom[33][34]:=synRate*R*CG*0.19375;
MG94custom[33][35]:=synRate*CT*0.2204545454545455;
MG94custom[33][37]:=synRate*R*AC*0.2014204545454545;
MG94custom[33][41]:=synRate*R*0.1505681818181818;
MG94custom[33][45]:=synRate*R*AT*0.2616477272727273;
MG94custom[33][48]:=synRate*R*GT*0.1769886363636364;
MG94custom[34][2]:=synRate*R*0.3488636363636364;
MG94custom[34][18]:=synRate*R*CG*0.1897727272727273;
MG94custom[34][32]:=synRate*0.478125;
MG94custom[34][33]:=synRate*R*CG*0.1076704545454545;
MG94custom[34][35]:=synRate*R*GT*0.2204545454545455;
MG94custom[34][38]:=synRate*R*AC*0.2014204545454545;
MG94custom[34][42]:=synRate*R*0.1505681818181818;
MG94custom[34][46]:=synRate*R*AT*0.2616477272727273;
MG94custom[35][3]:=synRate*R*0.3488636363636364;
MG94custom[35][19]:=synRate*R*CG*0.1897727272727273;
MG94custom[35][32]:=synRate*R*AT*0.478125;
MG94custom[35][33]:=synRate*CT*0.1076704545454545;
MG94custom[35][34]:=synRate*R*GT*0.19375;
MG94custom[35][39]:=synRate*R*AC*0.2014204545454545;
MG94custom[35][43]:=synRate*R*0.1505681818181818;
MG94custom[35][47]:=synRate*R*AT*0.2616477272727273;
MG94custom[35][49]:=synRate*R*GT*0.1769886363636364;
MG94custom[36][4]:=synRate*R*0.3488636363636364;
MG94custom[36][20]:=synRate*R*CG*0.1897727272727273;
MG94custom[36][32]:=synRate*R*AC*0.3863636363636364;
MG94custom[36][37]:=synRate*AC*0.1076704545454545;
MG94custom[36][38]:=synRate*0.19375;
MG94custom[36][39]:=synRate*AT*0.2204545454545455;
MG94custom[36][40]:=synRate*R*CG*0.1505681818181818;
MG94custom[36][44]:=synRate*R*CT*0.2616477272727273;
MG94custom[36][50]:=synRate*R*GT*0.1769886363636364;
MG94custom[37][5]:=synRate*R*0.3488636363636364;
MG94custom[37][21]:=synRate*R*CG*0.1897727272727273;
MG94custom[37][33]:=synRate*R*AC*0.3863636363636364;
MG94custom[37][36]:=synRate*AC*0.478125;
MG94custom[37][38]:=synRate*CG*0.19375;
MG94custom[37][39]:=synRate*CT*0.2204545454545455;
MG94custom[37][41]:=synRate*R*CG*0.1505681818181818;
MG94custom[37][45]:=synRate*R*CT*0.2616477272727273;
MG94custom[37][51]:=synRate*R*GT*0.1769886363636364;
MG94custom[38][6]:=synRate*R*0.3488636363636364;
MG94custom[38][22]:=synRate*R*CG*0.1897727272727273;
MG94custom[38][34]:=synRate*R*AC*0.3863636363636364;
MG94custom[38][36]:=synRate*0.478125;
MG94custom[38][37]:=synRate*CG*0.1076704545454545;
MG94custom[38][39]:=synRate*GT*0.2204545454545455;
MG94custom[38][42]:=synRate*R*CG*0.1505681818181818;
MG94custom[38][46]:=synRate*R*CT*0.2616477272727273;
MG94custom[38][52]:=synRate*R*GT*0.1769886363636364;
MG94custom[39][7]:=synRate*R*0.3488636363636364;
MG94custom[39][23]:=synRate*R*CG*0.1897727272727273;
MG94custom[39][35]:=synRate*R*AC*0.3863636363636364;
MG94custom[39][36]:=synRate*AT*0.478125;
MG94custom[39][37]:=synRate*CT*0.1076704545454545;
MG94custom[39][38]:=synRate*GT*0.19375;
MG94custom[39][43]:=synRate*R*CG*0.1505681818181818;
MG94custom[39][47]:=synRate*R*CT*0.2616477272727273;
MG94custom[39][53]:=synRate*R*GT*0.1769886363636364;
MG94custom[40][8]:=synRate*R*0.3488636363636364;
MG94custom[40][24]:=synRate*R*CG*0.1897727272727273;
MG94custom[40][32]:=synRate*R*0.3863636363636364;
MG94custom[40][36]:=synRate*R*CG*0.2014204545454545;
MG94custom[40][41]:=synRate*AC*0.1076704545454545;
MG94custom[40][42]:=synRate*0.19375;
MG94custom[40][43]:=synRate*AT*0.2204545454545455;
MG94custom[40][44]:=synRate*R*GT*0.2616477272727273;
MG94custom[41][9]:=synRate*R*0.3488636363636364;
MG94custom[41][25]:=synRate*R*CG*0.1897727272727273;
MG94custom[41][33]:=synRate*R*0.3863636363636364;
MG94custom[41][37]:=synRate*R*CG*0.2014204545454545;
MG94custom[41][40]:=synRate*AC*0.478125;
MG94custom[41][42]:=synRate*CG*0.19375;
MG94custom[41][43]:=synRate*CT*0.2204545454545455;
MG94custom[41][45]:=synRate*R*GT*0.2616477272727273;
MG94custom[41][54]:=synRate*R*GT*0.1769886363636364;
MG94custom[42][10]:=synRate*R*0.3488636363636364;
MG94custom[42][26]:=synRate*R*CG*0.1897727272727273;
MG94custom[42][34]:=synRate*R*0.3863636363636364;
MG94custom[42][38]:=synRate*R*CG*0.2014204545454545;
MG94custom[42][40]:=synRate*0.478125;
MG94custom[42][41]:=synRate*CG*0.1076704545454545;
MG94custom[42][43]:=synRate*GT*0.2204545454545455;
MG94custom[42][46]:=synRate*R*GT*0.2616477272727273;
MG94custom[42][55]:=synRate*R*GT*0.1769886363636364;
MG94custom[43][11]:=synRate*R*0.3488636363636364;
MG94custom[43][27]:=synRate*R*CG*0.1897727272727273;
MG94custom[43][35]:=synRate*R*0.3863636363636364;
MG94custom[43][39]:=synRate*R*CG*0.2014204545454545;
MG94custom[43][40]:=synRate*AT*0.478125;
MG94custom[43][41]:=synRate*CT*0.1076704545454545;
MG94custom[43][42]:=synRate*GT*0.19375;
MG94custom[43][47]:=synRate*R*GT*0.2616477272727273;
MG94custom[43][56]:=synRate*R*GT*0.1769886363636364;
MG94custom[44][12]:=synRate*R*0.3488636363636364;
MG94custom[44][28]:=synRate*R*CG*0.1897727272727273;
MG94custom[44][32]:=synRate*R*AT*0.3863636363636364;
MG94custom[44][36]:=synRate*R*CT*0.2014204545454545;
MG94custom[44][40]:=synRate*R*GT*0.1505681818181818;
MG94custom[44][45]:=synRate*AC*0.1076704545454545;
MG94custom[44][46]:=synRate*0.19375;
MG94custom[44][47]:=synRate*AT*0.2204545454545455;
MG94custom[44][57]:=synRate*R*GT*0.1769886363636364;
MG94custom[45][13]:=synRate*R*0.3488636363636364;
MG94custom[45][29]:=synRate*R*CG*0.1897727272727273;
MG94custom[45][33]:=synRate*R*AT*0.3863636363636364;
MG94custom[45][37]:=synRate*R*CT*0.2014204545454545;
MG94custom[45][41]:=synRate*R*GT*0.1505681818181818;
MG94custom[45][44]:=synRate*AC*0.478125;
MG94custom[45][46]:=synRate*CG*0.19375;
MG94custom[45][47]:=synRate*CT*0.2204545454545455;
MG94custom[45][58]:=synRate*R*GT*0.1769886363636364;
MG94custom[46][14]:=synRate*R*0.3488636363636364;
MG94custom[46][30]:=synRate*R*CG*0.1897727272727273;
MG94custom[46][34]:=synRate*R*AT*0.3863636363636364;
MG94custom[46][38]:=synRate*R*CT*0.2014204545454545;
MG94custom[46][42]:=synRate*R*GT*0.1505681818181818;
MG94custom[46][44]:=synRate*0.478125;
MG94custom[46][45]:=synRate*CG*0.1076704545454545;
MG94custom[46][47]:=synRate*GT*0.2204545454545455;
MG94custom[46][59]:=synRate*R*GT*0.1769886363636364;
MG94custom[47][15]:=synRate*R*0.3488636363636364;
MG94custom[47][31]:=synRate*R*CG*0.1897727272727273;
MG94custom[47][35]:=synRate*R*AT*0.3863636363636364;
MG94custom[47][39]:=synRate*R*CT*0.2014204545454545;
MG94custom[47][43]:=synRate*R*GT*0.1505681818181818;
MG94custom[47][44]:=synRate*AT*0.478125;
MG94custom[47][45]:=synRate*CT*0.1076704545454545;
MG94custom[47][46]:=synRate*GT*0.19375;
MG94custom[47][60]:=synRate*R*GT*0.1769886363636364;
MG94custom[48][1]:=synRate*R*AT*0.3488636363636364;
MG94custom[48][17]:=synRate*R*CT*0.1897727272727273;
MG94custom[48][33]:=synRate*R*GT*0.284375;
MG94custom[48][49]:=synRate*CT*0.2204545454545455;
MG94custom[48][51]:=synRate*R*AC*0.2014204545454545;
MG94custom[48][54]:=synRate*R*0.1505681818181818;
MG94custom[48][58]:=synRate*R*AT*0.2616477272727273;
MG94custom[49][3]:=synRate*R*AT*0.3488636363636364;
MG94custom[49][19]:=synRate*R*CT*0.1897727272727273;
MG94custom[49][35]:=synRate*R*GT*0.284375;
MG94custom[49][48]:=synRate*CT*0.1076704545454545;
MG94custom[49][53]:=synRate*R*AC*0.2014204545454545;
MG94custom[49][56]:=synRate*R*0.1505681818181818;
MG94custom[49][60]:=synRate*R*AT*0.2616477272727273;
MG94custom[50][4]:=synRate*R*AT*0.3488636363636364;
MG94custom[50][20]:=synRate*R*CT*0.1897727272727273;
MG94custom[50][36]:=synRate*R*GT*0.284375;
MG94custom[50][51]:=synRate*AC*0.1076704545454545;
MG94custom[50][52]:=synRate*0.19375;
MG94custom[50][53]:=synRate*AT*0.2204545454545455;
MG94custom[50][57]:=synRate*R*CT*0.2616477272727273;
MG94custom[51][5]:=synRate*R*AT*0.3488636363636364;
MG94custom[51][21]:=synRate*R*CT*0.1897727272727273;
MG94custom[51][37]:=synRate*R*GT*0.284375;
MG94custom[51][48]:=synRate*R*AC*0.3863636363636364;
MG94custom[51][50]:=synRate*AC*0.478125;
MG94custom[51][52]:=synRate*CG*0.19375;
MG94custom[51][53]:=synRate*CT*0.2204545454545455;
MG94custom[51][54]:=synRate*R*CG*0.1505681818181818;
MG94custom[51][58]:=synRate*R*CT*0.2616477272727273;
MG94custom[52][6]:=synRate*R*AT*0.3488636363636364;
MG94custom[52][22]:=synRate*R*CT*0.1897727272727273;
MG94custom[52][38]:=synRate*R*GT*0.284375;
MG94custom[52][50]:=synRate*0.478125;
MG94custom[52][51]:=synRate*CG*0.1076704545454545;
MG94custom[52][53]:=synRate*GT*0.2204545454545455;
MG94custom[52][55]:=synRate*R*CG*0.1505681818181818;
MG94custom[52][59]:=synRate*R*CT*0.2616477272727273;
MG94custom[53][7]:=synRate*R*AT*0.3488636363636364;
MG94custom[53][23]:=synRate*R*CT*0.1897727272727273;
MG94custom[53][39]:=synRate*R*GT*0.284375;
MG94custom[53][49]:=synRate*R*AC*0.3863636363636364;
MG94custom[53][50]:=synRate*AT*0.478125;
MG94custom[53][51]:=synRate*CT*0.1076704545454545;
MG94custom[53][52]:=synRate*GT*0.19375;
MG94custom[53][56]:=synRate*R*CG*0.1505681818181818;
MG94custom[53][60]:=synRate*R*CT*0.2616477272727273;
MG94custom[54][9]:=synRate*R*AT*0.3488636363636364;
MG94custom[54][25]:=synRate*R*CT*0.1897727272727273;
MG94custom[54][41]:=synRate*R*GT*0.284375;
MG94custom[54][48]:=synRate*R*0.3863636363636364;
MG94custom[54][51]:=synRate*R*CG*0.2014204545454545;
MG94custom[54][55]:=synRate*R*CG*0.19375;
MG94custom[54][56]:=synRate*CT*0.2204545454545455;
MG94custom[54][58]:=synRate*R*GT*0.2616477272727273;
MG94custom[55][10]:=synRate*R*AT*0.3488636363636364;
MG94custom[55][26]:=synRate*R*CT*0.1897727272727273;
MG94custom[55][42]:=synRate*R*GT*0.284375;
MG94custom[55][52]:=synRate*R*CG*0.2014204545454545;
MG94custom[55][54]:=synRate*R*CG*0.1076704545454545;
MG94custom[55][56]:=synRate*R*GT*0.2204545454545455;
MG94custom[55][59]:=synRate*R*GT*0.2616477272727273;
MG94custom[56][11]:=synRate*R*AT*0.3488636363636364;
MG94custom[56][27]:=synRate*R*CT*0.1897727272727273;
MG94custom[56][43]:=synRate*R*GT*0.284375;
MG94custom[56][49]:=synRate*R*0.3863636363636364;
MG94custom[56][53]:=synRate*R*CG*0.2014204545454545;
MG94custom[56][54]:=synRate*CT*0.1076704545454545;
MG94custom[56][55]:=synRate*R*GT*0.19375;
MG94custom[56][60]:=synRate*R*GT*0.2616477272727273;
MG94custom[57][12]:=synRate*R*AT*0.3488636363636364;
MG94custom[57][28]:=synRate*CT*0.1897727272727273;
MG94custom[57][44]:=synRate*R*GT*0.284375;
MG94custom[57][50]:=synRate*R*CT*0.2014204545454545;
MG94custom[57][58]:=synRate*R*AC*0.1076704545454545;
MG94custom[57][59]:=synRate*0.19375;
MG94custom[57][60]:=synRate*R*AT*0.2204545454545455;
MG94custom[58][13]:=synRate*R*AT*0.3488636363636364;
MG94custom[58][29]:=synRate*R*CT*0.1897727272727273;
MG94custom[58][45]:=synRate*R*GT*0.284375;
MG94custom[58][48]:=synRate*R*AT*0.3863636363636364;
MG94custom[58][51]:=synRate*R*CT*0.2014204545454545;
MG94custom[58][54]:=synRate*R*GT*0.1505681818181818;
MG94custom[58][57]:=synRate*R*AC*0.478125;
MG94custom[58][59]:=synRate*R*CG*0.19375;
MG94custom[58][60]:=synRate*CT*0.2204545454545455;
MG94custom[59][14]:=synRate*R*AT*0.3488636363636364;
MG94custom[59][30]:=synRate*CT*0.1897727272727273;
MG94custom[59][46]:=synRate*R*GT*0.284375;
MG94custom[59][52]:=synRate*R*CT*0.2014204545454545;
MG94custom[59][55]:=synRate*R*GT*0.1505681818181818;
MG94custom[59][57]:=synRate*0.478125;
MG94custom[59][58]:=synRate*R*CG*0.1076704545454545;
MG94custom[59][60]:=synRate*R*GT*0.2204545454545455;
MG94custom[60][15]:=synRate*R*AT*0.3488636363636364;
MG94custom[60][31]:=synRate*R*CT*0.1897727272727273;
MG94custom[60][47]:=synRate*R*GT*0.284375;
MG94custom[60][49]:=synRate*R*AT*0.3863636363636364;
MG94custom[60][53]:=synRate*R*CT*0.2014204545454545;
MG94custom[60][56]:=synRate*R*GT*0.1505681818181818;
MG94custom[60][57]:=synRate*R*AT*0.478125;
MG94custom[60][58]:=synRate*CT*0.1076704545454545;
MG94custom[60][59]:=synRate*R*GT*0.19375;


vectorOfFrequencies={
{0.06846343874760828}
{0.01541749452486247}
{0.02774335426373669}
{0.03156721834114321}
{0.03569160152356932}
{0.008037502660387861}
{0.01446326336249214}
{0.01645673367931657}
{0.02668060480605323}
{0.006008288307483169}
{0.01081174835277974}
{0.01230193067706317}
{0.04636384344599061}
{0.01044081798338113}
{0.01878796270360404}
{0.02137750595014184}
{0.03724232661514847}
{0.008386715262710204}
{0.01509166176561572}
{0.01717174417905836}
{0.0194153011545149}
{0.004372192000927598}
{0.007867638376339373}
{0.00895203428158263}
{0.01451355375443286}
{0.003268352271497358}
{0.005881309364541421}
{0.006691929716838918}
{0.02522072265628805}
{0.005679532909526541}
{0.01022016212215594}
{0.0116288061683182}
{0.05580773793677189}
{0.01256751793109718}
{0.02261490034039122}
{0.02573191006472667}
{0.02909388690968476}
{0.006551742803785218}
{0.01178967966274807}
{0.01341465017344942}
{0.0217486037547714}
{0.004897635664324634}
{0.00881315969147599}
{0.01002787671640084}
{0.03779332841159332}
{0.008510797069515073}
{0.01531494353933847}
{0.01742580086000975}
{0.007821741929144397}
{0.0160149650053194}
{0.01810738416057303}
{0.004077658108649541}
{0.007337632797094954}
{0.008348978079979009}
{0.003048178840034214}
{0.005485113374415129}
{0.006241126068249472}
{0.02352172187854409}
{0.005296929644663227}
{0.009531678146861006}
{0.0108454285072788}
};

Model MG94customModel=(MG94custom,vectorOfFrequencies,0);

UseModel (MG94customModel);
Tree givenTree=(((D_CD_83_ELI_ACC_K03454,D_CD_83_NDK_ACC_M27323)Node3,D_UG_94_94UG114_ACC_U88824)Node2,D_CD_84_84ZR085_ACC_U88822,(B_US_83_RF_ACC_M17451,((B_FR_83_HXB2_ACC_K03455,B_US_86_JRFL_ACC_U63632)Node11,B_US_90_WEAU160_ACC_U21135)Node10)Node8);

DataSet ds = ReadDataFile(USE_NEXUS_FILE_DATA);
DataSetFilter filteredData = CreateFilter(ds,3,"0-1319","4,5,7,6,1,0,2,3","TAA,TAG,TGA");

PARAMETER_GROUPING = {"0" : {{"R","AC","AT","CT"}}};
LikelihoodFunction lf = (filteredData,givenTree);
OPTIMIZATION_PRECISION     = 0.001;
VERBOSITY_LEVEL	           = 1;
OPTIMIZATION_METHOD		   = 4;
USE_ADAPTIVE_VARIABLE_STEP = 1;

Optimize 			(res,lf);

//Export (lfe, lf);
//fprintf ("/tmp/test.bf", CLEAR_FILE, lfe);

//fprintf (stdout, "\n\n", lf.trace, "\n\n");

/* test epilogue */
	timeMatrix = endTestTimer 				  (_testDescription);
	if (logTestResult    (Abs (res[1][0] - _expectedLL) < 2*OPTIMIZATION_PRECISION))
	{
		return timeMatrix;
	}
	return 0;
/* end test epilogue */


END;
