/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: SongEditor.h,v 1.29 2004/07/08 16:18:48 comix Exp $
 *
 */

#ifndef SONG_EDITOR_H
#define SONG_EDITOR_H


#include <string>
using std::string;

#include "qwidget.h"
#include "qscrollview.h"
#include "qpixmap.h"
#include "qpopupmenu.h"

#include "lib/Object.h"
#include "lib/EngineListener.h"


class Button;
class ToggleButton;
class SongEditor;
class SongEditorPatternList;
class SongEditorPositionRuler;

///
/// Song Editor panel
///
class SongEditorPanel : public QWidget, public EngineListener, public Object
{
	Q_OBJECT

	public:
		SongEditorPanel( QWidget *parent );
		~SongEditorPanel();

		void updateAll();
	
	public slots:
		void contentsMove( int x, int y );
		void newPatBtnClicked( Button* );
		void songBtnClicked( Button* );
		void upBtnClicked( Button* );
		void downBtnClicked( Button* );
		void songLoopBtnClicked(Button* ref);

		void songPopup_songProperties();
		void songPopup_clearSequence();
		void songPopup_deleteAllPatterns();

	private:
		uint m_nInitialWidth;
		uint m_nInitialHeight;

		static const int m_nPatternListWidth = 150;

		QScrollView* m_pSv1;
		QScrollView* m_pSv2;
		QScrollView* m_pSv3;

		SongEditor *m_pSongEditor;
		SongEditorPatternList *m_pSongEditorPatternList;
		SongEditorPositionRuler *m_pSongEditorPositionRuler;

		Button *m_pUpBtn;
		Button *m_pDownBtn;
		Button *m_pSongBtn;
		
		QPopupMenu *m_pSongPopup;

		ToggleButton *m_pSongLoopBtn;

		
		virtual void patternChanged();
		void customEvent( QCustomEvent *ev );
		void resizeEvent ( QResizeEvent *ev );
};




///
/// Song editor
///
class SongEditor : public QWidget, public EngineListener, public Object
{
	Q_OBJECT

	public:
		SongEditor( QWidget *parent );
		~SongEditor();

		void updateEditor();
		void createBackground();

	private:
		enum CellManipulationModes { //when manipulating single cells
			SWAP, 
			ADD, 
			REMOVE
		};
		
		enum RegionManipulationModes { //when manipulating selected regions
			DELETE, 
			COPY, 
			//COPY_OVERWRITE,
			MOVE
		};
		
		enum ShiftModes {
			SHIFT_LEFT,
			SHIFT_RIGHT
		};

		uint m_nGridWidth;
		uint m_nGridHeight;
		static const uint m_nMaxPatternSequence = 300;
		uint m_nInitialWidth;
		uint m_nInitialHeight;
		bool m_bChanged;
		bool m_bSequenceChanged;
		QPixmap m_tempPixmap;
		QPixmap m_backgroundPixmap;
		QPixmap m_sequencePixmap;

		//drag, lasso, select etc
		bool m_bLasso;
		bool m_bLassoRepaint;
		bool m_bDragRepaint;
		bool m_bSelect;
		bool m_bDrag;
		bool m_bDragCopy;
		QPoint m_mousePos;
		QRect m_srcRegion;
		QRect m_oldRegion;
		QRect m_dstRegion;
		QPixmap m_dragPixmap;
		vector<QRect> m_markedCells;
		vector<QPoint> m_cellList;

		void shiftColumns(ShiftModes dir);
		void markupCells();
		void manipulateCell( int column, int row, CellManipulationModes type);
		void manipulateRegion(RegionManipulationModes type);
		void pos2Grid(QRect area, int &top, int &left, int &bottom, int &right);
		void mousePressEvent(QMouseEvent *ev);
		void mouseReleaseEvent(QMouseEvent *ev);
		void mouseMoveEvent(QMouseEvent *ev);
		void keyPressEvent (QKeyEvent *ev);
		bool inSelect( int nColumn, int nRow, QRect area);
		void paintEvent(QPaintEvent *ev);
		void drawSequence();
		void drawPattern( int pos, int number );
};




///
/// Song editor pattern list
///
class SongEditorPatternList : public QWidget, public EngineListener, public Object
{
	Q_OBJECT

	public:
		SongEditorPatternList( QWidget *parent );
		~SongEditorPatternList();

		void updateEditor();
		void createBackground();

	public slots:
		void patternPopup_edit();
		void patternPopup_properties();
		void patternPopup_delete();
		void patternPopup_copy();


	private:
		uint m_nGridHeight;
		uint m_nWidth;
		static const uint m_nInitialHeight = 10;
		bool m_bChanged;
		QPixmap m_tempPixmap;
		QPixmap m_backgroundPixmap;

		QPopupMenu *m_pPatternPopup;

		void mousePressEvent( QMouseEvent *ev );
		void mouseDoubleClickEvent( QMouseEvent *ev );
		void paintEvent( QPaintEvent *ev );
};



class SongEditorPositionRuler : public QWidget, public Object
{
	Q_OBJECT

	public:
		SongEditorPositionRuler( QWidget *parent );
		~SongEditorPositionRuler();

		void updateRuler();
		void createBackground();

	public slots:
		void updatePosition();

	private:
		QTimer *m_pTimer;
		static const uint m_nGridWidth = 16;
		static const uint m_nMaxPatternSequence = 300;
		static const uint m_nInitialWidth = m_nMaxPatternSequence * m_nGridWidth;
		static const uint m_nHeight = 25;

		bool m_bChanged;
		QPixmap m_tempPixmap;
		QPixmap m_backgroundPixmap;
		QPixmap m_tickPositionPixmap;

		void mousePressEvent( QMouseEvent *ev );
		void paintEvent( QPaintEvent *ev );
};

#endif
