/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: AudioEngineInfoForm.h,v 1.9 2004/01/26 11:17:48 comix Exp $
 *
 */


#ifndef AUDIO_ENGINE_INFO_FORM_H
#define AUDIO_ENGINE_INFO_FORM_H


#include <iostream>
using std::cout;
using std::cerr;
using std::endl;

#include "qtextedit.h"
#include "qtimer.h"
#include "qlabel.h"
#include "qpixmap.h"
#include "qapplication.h"

#include "lib/EngineListener.h"
#include "lib/Object.h"

#include "AudioEngineInfoForm_UI.h"


/**
 * Audio Engine information form
 */
class AudioEngineInfoForm : public AudioEngineInfoForm_UI, public EngineListener, public Object
{
	Q_OBJECT
	private:
		QTimer *timer;

		void stateChanged(int state);
		void customEvent( QCustomEvent *ev );
		virtual void updateAudioEngineState();
		virtual void patternChanged();

	public:
		/** Constructor */
		AudioEngineInfoForm(QWidget* parent);

		/** Destructor */
		~AudioEngineInfoForm();

		void showEvent ( QShowEvent *ev );
		void hideEvent ( QHideEvent *ev );

	public slots:
		void updateInfo();
};

#endif

