/* This file is part of MemMXtest
 * Copyright (C) 1999, 2000  J.A. Bezemer
 * This program is licensed under the GNU General Public License,
 * see the top-level README file for details.
 */

/* The `PSEUDO-RANDOM MARCH C-' march test */

#include "mtest.h"
#include "tests.h"

/* The name of this test */
#define TESTNAME "PR-march C-"

void
prmarch_prcminus (unsigned long passes)
{
  pattern64 p, n;
  unsigned long i;

  /* Print test name and parameters */
  printtestname_0 (TESTNAME);

  p = currentpr64;

  startpr64 = p;
  prmarchel_up_wp (&p);
  endpr64 = p;

  p = startpr64;		/* The start and end of the _read_ element */
  n = endpr64;

  for (i = 0; i < passes; i++)
    prmarchel_up_rp_wn (&p, &n);

  currentpr64 = n;
}
