/* irqtune/load.c -- irqtune module loader */

/*
// Copyright 1996, 1997 by Craig Estey -- See the file COPYING for details
*/

#include <linux/types.h>
#include <linux/errno.h>
#include <linux/kernel.h>
#include <linux/version.h>
#include <asm/system.h>

#include <src/irqhigh.c>

/* overridden by insmod command line (e.g. "priority=3,14") */
u_long priority[] = { IRQHIGH_MST_DFT, IRQHIGH_SLV_DFT };

/* yes_we_used_it -- allow us to compile */
extern inline void
yes_we_used_it(void *x)
{
}

#ifdef NPR
#define zprtx				printk_npr
/* printk_npr -- all zprtx's become nulled */
static int
printk_npr(const char *fmt,...)
{
	return 0;
}
#else /*NPR*/
#define zprtx				printk
#endif /*NPR*/

/* init_module -- called by modules package when installing the driver */
/* RETURNS: error code */
int
init_module(void)
{
	int err;
	int idx;
	char *cp;
	u_long flags;
	u_char vals[2];

	err = 0;

	yes_we_used_it(irqhigh_calc);

	/* grab data from insmod command line */
	for (idx = 0;  idx <= 1;  ++idx)
		vals[idx] = priority[idx] & 0x0F;

	do {
		/* check the sanity */
		cp = irqhigh_insane(vals[0],vals[1]);
		if (cp != NULL) {
			zprtx("irqtune/%s: SANITYERROR %u/%u -- %s\n",
				IRQTUNE_VERSION,vals[0],vals[1],cp);
			err = -EINVAL;
			break;
		}

		zprtx("irqtune/%s: setting system IRQ priority to %u/%u\n",
			IRQTUNE_VERSION,vals[0],vals[1]);

		/* perform the set */
		save_flags(flags);
		cli();
		err = irqhigh_set(1,vals[0],vals[1]);
		restore_flags(flags);

		/* insure that things worked (should not occur if irqtune invoked us */
		/* as it does the exact same check) */
		if (err) {
			zprtx("irqtune/%s: ERROR expected %u/%u but got %u/%u\n",
				IRQTUNE_VERSION,vals[0],vals[1],
				irqhigh_list[0],irqhigh_list[1]);
			break;
		}
	} while (0);

	return err;
}

/* cleanup_module -- called by modules package when removing the driver */
void
cleanup_module(void)
{

	zprtx("irqtune/%s: module cleanup\n",IRQTUNE_VERSION);
}
