/* lib/opt -- irqtune support library (command line option control) */

#pragma member irqtune.h

/* optget -- get options */
/* RETURNS: 1=ok, 0=error */
int
optget(struct optblk *opt,char *cp)
{
	int ok;

	ok = 0;
	for (;  *cp != 0;  ++cp) {
		for (;  opt->opt_fmt != NULL;  ++opt) {
			if (opt->opt_fmt[0] != '-')
				continue;
			if (*cp == opt->opt_fmt[1])
				break;
		}

		/* bug out if no match */
		if (opt->opt_fmt == NULL) {
			ok = 0;
			break;
		}

		mstopt |= opt->opt_msk;
		ok = 1;

		/* handle single valued option */
		if (opt->opt_ptr != NULL) {
			++cp;
			*opt->opt_ptr = cp;
			break;
		}
	}

	return ok;
}

/* optusage -- show option usage */
void
optusage(const struct optblk *opt)
{

	for (;  opt->opt_fmt != NULL;  ++opt) {
		if (opt->opt_fmt[0] == '-')
			zprtx("  %s\n",opt->opt_fmt);
		else
			zprtx("%s options:\n",opt->opt_fmt);
	}
}

