///////
   //    HtmlStatement.h
   //    HtmlStatement Class declaration
   //
   //    Class for HtmlStatement storage
   //
   //    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
   //    Some Portions Copyright (c) 1995-2000 The ht://Dig Group <www.htdig.org>
   //    Some Portions Copyright (c) 2008 Devise.IT srl <http://www.devise.it/>
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: HtmlStatement.h,v 1.13 2008-11-16 18:28:52 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 05.10.1999
///////

#ifndef _HTMLSTATEMENT_H
#define _HTMLSTATEMENT_H

#include <Object.h>

#ifdef HAVE_STD
#include <iostream>
#include <string>
#include <map>
#ifdef HAVE_NAMESPACES
using namespace std;
#endif
#else
#include <iostream.h>
#include <string.h>
#include <map.h>
#endif /* HAVE_STD */

class HtmlStatement : public Object
{

   // Write the object to the output
   friend ostream& operator<<(ostream&, const HtmlStatement& );
   
   public:
   
    // Possible HTML 4 tags
    enum ElementLabel
    {
	Tag_Unknown,
	Tag_A,
	Tag_ABBR,
	Tag_ACRONYM,
	Tag_ADDRESS,
	Tag_APPLET,
	Tag_AREA,
	Tag_B,
	Tag_BASE,
	Tag_BASEFONT,
	Tag_BDO,
	Tag_BIG,
	Tag_BLINK,
	Tag_BLOCKQUOTE,
	Tag_BODY,
	Tag_BR,
	Tag_BUTTON,
	Tag_CAPTION,
	Tag_CENTER,
	Tag_CITE,
	Tag_CODE,
	Tag_COL,
	Tag_COLGROUP,
	Tag_DD,
	Tag_DEL,
	Tag_DFN,
	Tag_DIR,
	Tag_DIV,
	Tag_DL,
	Tag_DT,
	Tag_EM,
	Tag_EMBED,
	Tag_FIELDSET,
	Tag_FONT,
	Tag_FORM,
	Tag_FRAME,
	Tag_FRAMESET,
	Tag_H1,
	Tag_H2,
	Tag_H3,
	Tag_H4,
	Tag_H5,
	Tag_H6,
	Tag_HEAD,
	Tag_HR,
	Tag_HTML,
	Tag_I,
	Tag_IFRAME,
	Tag_IMG,
	Tag_INPUT,
	Tag_INS,
	Tag_ISINDEX,
	Tag_KBD,
	Tag_LABEL,
	Tag_LAYER,
	Tag_LEGEND,
	Tag_LI,
	Tag_LINK,
	Tag_MAP,
	Tag_MARQUEE,
	Tag_MENU,
	Tag_META,
	Tag_NOEMBED,
	Tag_NOFRAMES,
	Tag_NOSCRIPT,
	Tag_OBJECT,
	Tag_OL,
	Tag_OPTGROUP,
	Tag_OPTION,
	Tag_P,
	Tag_PARAM,
	Tag_PRE,
	Tag_Q,
	Tag_S,
	Tag_SAMP,
	Tag_SCRIPT,
	Tag_SELECT,
	Tag_SHADOW,
	Tag_SMALL,
	Tag_SPAN,
	Tag_STRIKE,
	Tag_STRONG,
	Tag_STYLE,
	Tag_SUB,
	Tag_SUP,
	Tag_TABLE,
	Tag_TBODY,
	Tag_TD,
	Tag_TEXTAREA,
	Tag_TFOOT,
	Tag_TH,
	Tag_THEAD,
	Tag_TITLE,
	Tag_TR,
	Tag_TT,
	Tag_U,
	Tag_UL,
	Tag_VAR
    };

      // Construction / Destruction
      HtmlStatement();
      virtual ~HtmlStatement();

///////
   //    Public Interface
///////

      void Reset();

      void SetIDUrl        (unsigned int id) { IDUrl = id; }
      void SetTagPosition  (unsigned int tp) { TagPosition = tp; }
      void SetTag (const std::string &t);
      void SetStatement    (const std::string &s) { Statement = s; }
      void SetRow          (unsigned int r) { Row = r; }
      void SetCol          (unsigned int c) { Col = c; }
      void SetLinkTagPosition  (unsigned int ltp) { LinkTagPosition = ltp; }
      void empty (const bool empty = true) { _empty_tag = empty; }

      unsigned int GetIDUrl() const          { return IDUrl; }
      unsigned int GetTagPosition() const    { return TagPosition; }
      const std::string &GetTag() const           { return Tag; }
      const std::string &GetLowercaseTag() const           { return LowercaseTag; }
      const std::string &GetStatement() const     { return Statement; }
      unsigned int GetRow() const    { return Row; }
      unsigned int GetCol() const    { return Col; }
      unsigned int GetLinkTagPosition() const    { return LinkTagPosition; }
      const ElementLabel GetElementLabel() const           { return _tag_label; }
      const bool isClosingTag() const { return _closing_tag; }
      const bool isEmptyTag() const { return _empty_tag; }

      // Static methods for managing debug level
      static void SetDebugLevel (int d) { debug=d;}

      // Initialise the map of tags
      static void initElementsMap();

///////
   //    Protected attributes
///////

   protected:

      unsigned int   IDUrl;
      unsigned int   TagPosition;
      std::string    Tag;
      std::string    LowercaseTag;
      std::string    Statement;
      unsigned int   Row;
      unsigned int   Col;
      unsigned int   LinkTagPosition;
      ElementLabel   _tag_label;
      bool	     _closing_tag;
      bool	     _empty_tag;
      
///////
   //    Static attributes
///////

      static int debug;    // Run-time debugging level

      typedef std::map <std::string, ElementLabel> ElementsMap;
      static ElementsMap TagMap;

};

#endif
