<?php

//    showurl.php
//    Shows the info of a either retrieved or not URL
//
//    Part of the ht://Check package
//
//    Copyright (c) 1999-2002 Comune di Prato - Prato - Italy
//    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
//
//    For copyright details, see the file COPYING in your distribution
//    or the GNU General Public License version 2 or later 
//    <http://www.gnu.org/copyleft/gpl.html>
//
//    $Id: showurl.php,v 1.20 2002/02/11 08:47:38 angusgb Exp $

///////
   //    Global settings
///////

include ("./include/global.inc.php");


if (!isset($dbname))
{
   // Error
   DisplayErrMsg($strErrorNoDBSelected);
   echo "<A href=\"index.php\">" . $strMainPage . "</A>";
   die;
}
else
{
   eval("\$strhome = \"$strDBHome \";");
   if (!isset($IDUrl))
   {
      // Error
      DisplayErrMsg($strErrorNoUrlSelected);
      echo "<A href=\"index.php?dbname=". $dbname . "\">". $strhome."</A>";
      die;
   }
   
   // Retrieve Information from the DB
   $strSQL = "Select Schedule.Url as SUrl, Schedule.HopCount," .
      " Schedule.IDReferer, Schedule.IDServer as SIDServer, Url.*" .
      " from Schedule" .
      " LEFT JOIN Url ON Schedule.IDUrl=Url.IDUrl" .
      " WHERE Schedule.IDUrl=" . $IDUrl;

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows()>1)
   {
      DisplayErrMsg($strErrorDuplicateKey);
      die;
   }
   else if ($MyDB->NumRows()==0)
   {
?>
<P><?php echo $strNoOccurrencies; ?></P>
<?php
   }
   else
   {

      // Information retrieved
      $row = $MyDB->FetchArray();
      $MyDB->Free();

      $Server="";

      // Get the server name
      if ($row["SIDServer"])
      {
         // Get the server name, if any
         $strSQL = "SELECT Server"
            . " FROM Server"
            . " WHERE IDServer=" . $row["SIDServer"];

         $result=$MyDB->Query($dbname, $strSQL);

         if ($result)
         {
            DisplayErrMsg($MyDB->errmsg);
            die;
         }

         if ($servrow = $MyDB->FetchArray())
            $Server=$servrow["Server"];

         $MyDB->Free();

      }

      $RefererUrl="";

      // Get the referer
      if ($row["IDReferer"])
      {

         $strSQL = "Select Schedule.Url" .
            " from Schedule" .
            " WHERE Schedule.IDUrl=" . $row["IDReferer"] ;

         $result=$MyDB->Query($dbname, $strSQL);

         if ($result)
         {
            DisplayErrMsg($MyDB->errmsg);
            die;
         }

         $refrow = $MyDB->FetchArray();
         $RefererUrl=$refrow["Url"];
         $MyDB->Free();

      }
            
      $URLName = $row["SUrl"];
      $pagetitle = "Database: $dbname - " . $strShowUrl . ": " . $URLName;
      $linkbar = "<A href=\"index.php?dbname=". $dbname . "\">". $strhome."</A>";
      $linkbar = $linkbar . " | " .
         "<A href=\"javascript:history.go(-1)\">" . $strBack . "</A>";
      
?>
<?php include ("./include/header.inc.php"); ?>
<?php

      // A database and a URL have been selected

?>
<H3><?php echo $URLName; ?></H3>
<?php
   if ($row["Url"])
   {
         // Info available - retrieved
?>         
<H4><?php echo $strInfoAvailable; ?>:</H4>
<BLOCKQUOTE>
<?php
      if ($row["Title"])
      {
?>
<B><?php echo $strTitle; ?></B>:  <?php echo $row["Title"]; ?><BR>
<?php
      }
?>
<B>Server</B>:  <?php echo $Server; ?><BR>
<B><?php echo $strContentType; ?></B>:  <?php echo $row["ContentType"]; ?><BR>
<B><?php echo $strContentLanguage; ?></B>:  <?php
   echo (empty($row['ContentLanguage'])?'-':$row['ContentLanguage']); ?><BR>
<B><?php echo $strLastModified; ?></B>:  <?php

   if (!strncmp($row["LastModified"], "0000", 4))
   {
      // No last modified value available"
      echo $strNoLastModified;
   }
   else echo $row["LastModified"] . '  GMT';      
   ?><BR>
</BLOCKQUOTE>

<H4><?php echo $strRetrievingInfo; ?>:</H4>
<BLOCKQUOTE>
<B><?php echo $strLastAccess; ?></B>:  <?php echo $row["LastAccess"]; ?> GMT<BR>
<B><?php echo $strStatusCode; ?></B>:  <?php echo $row["StatusCode"]; ?><BR>
<B><?php echo $strReasonPhrase; ?></B>:  <?php echo $row["ReasonPhrase"]; ?><BR>
<B><?php echo $strReferer; ?></B>:  <?php
   if ($RefererUrl) print GetURL($RefererUrl);
   else print ("-"); ?><BR>
<B><?php echo $strHopCount; ?></B>:  <?php echo $row["HopCount"]; ?><BR>
<?php
      if ($row["Location"])
      {
         // The URL has been redirected, so no outcoming info and size info
         // We should retrieve the Index of the redirected URL

      // Retrieve Information from the DB
      $strSQL = "Select IDUrl from Schedule" .
      " WHERE Url='" . $row["Location"] . "'";

      $result=$MyDB->Query($dbname, $strSQL);
   
      if ($resultloc)
      {
         DisplayErrMsg($MyDB->errmsg);
         die;
      }

      $rowloc = $MyDB->FetchArray();
      $IDLocation=$rowloc["IDUrl"];
      $MyDB->Free();
      
      
                  
?>
<B><?php echo $strLocation; ?></B>:
<A href="<?php echo $PHP_SELF; ?>?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $IDLocation; ?>"><?php echo $row["Location"]; ?></A><BR>
<?php
      }
?>
<B><?php echo $strConnectionStatus; ?></B>:  <?php echo $row["ConnStatus"]; ?><BR>
<B><?php echo $strTransferEncoding; ?></B>:  <?php echo $row["TransferEncoding"]?$row["TransferEncoding"]:"-"; ?><BR>
</BLOCKQUOTE>

<?php
      if (! $row["Location"])
      {
?>
<H4><?php echo $strSizeInfo; ?>:</H4>
<BLOCKQUOTE>
<B><?php echo $strSize; ?></B>:  <?php
   if ($row["Size"] >= 0) {
?>
<?php echo number_format($row["Size"]); ?> Bytes<BR>
<B><?php echo $strSizeAdd; ?></B>:  <?php echo number_format($row["SizeAdd"]); ?> Bytes<BR>
<B><?php echo $strPageWeight; ?></B>:  <?php echo number_format($row["Size"]+$row["SizeAdd"]); ?> Bytes<BR>
<?php
   }
   else echo $strUnknown;
   ?><BR>
</BLOCKQUOTE>
<?php
      }

      // Get the number of outgoing links from the current URL
      $strSQL = "SELECT COUNT(*) " .
         " FROM Link" .
         " WHERE Link.IDUrlSrc=$IDUrl" .
         " AND Link.LinkType='Normal'"; 

      if ($result=$MyDB->Query($dbname, $strSQL))
      {
         DisplayErrMsg($MyDB->errmsg);
         die;
      }
      else
      {
         $row = $MyDB->FetchRow();
         $NumWSM_OL=$row[0];
      }

      // Get the number of ingoing links to the current URL
      $strSQL = "SELECT COUNT(*) " .
         " FROM Link" .
         " WHERE Link.IDUrlDest=$IDUrl" .
         " AND Link.LinkType='Normal'"; 

      if ($result=$MyDB->Query($dbname, $strSQL))
      {
         DisplayErrMsg($MyDB->errmsg);
         die;
      }
      else
      {
         $row = $MyDB->FetchRow();
         $NumWSM_IL=$row[0];
      }

      // Get the number of documents in outgoing links from the current URL
      $strSQL = "SELECT DISTINCT IDUrlDest " .
         " FROM Link" .
         " WHERE Link.IDUrlSrc=$IDUrl" .
         " AND Link.LinkType='Normal'"; 

      if ($result=$MyDB->Query($dbname, $strSQL))
      {
         DisplayErrMsg($MyDB->errmsg);
         die;
      }
      else $NumWSM_OD = $MyDB->NumRows();

      // Get the number of documents in ingoing links from the current URL
      $strSQL = "SELECT DISTINCT IDUrlSrc " .
         " FROM Link" .
         " WHERE Link.IDUrlDest=$IDUrl" .
         " AND Link.LinkType='Normal'"; 

      if ($result=$MyDB->Query($dbname, $strSQL))
      {
         DisplayErrMsg($MyDB->errmsg);
         die;
      }
      else $NumWSM_ID = $MyDB->NumRows();

      // Calculates the total number of documents from links and links themselves
      // Obviously documents from links are always <= than links
      $NumWSM_L = $NumWSM_OL + $NumWSM_IL;
      $NumWSM_D = $NumWSM_OD + $NumWSM_ID;
      $ProWSM_OL = ($NumWSM_L > 0)?($NumWSM_OL / $NumWSM_L):0;
      $ProWSM_IL = ($NumWSM_L > 0)?($NumWSM_IL / $NumWSM_L):0;
      $ProWSM_OD = ($NumWSM_D > 0)?($NumWSM_OD / $NumWSM_D):0;
      $ProWSM_ID = ($NumWSM_D > 0)?($NumWSM_ID / $NumWSM_D):0;
?>

<H4><?php echo $strWSM_Indexes; ?>: &nbsp;
[ <a href="#wsm_notes"><?php echo $strWSM_Notes; ?></a> ]
</H4>

<table border="0">
<tr>
<td>

<table border="1" class="wsm_graph" cellpadding="5" cellspacing="0">
<tr>
<td class="wsm_column">
<?php echo $strWSM_ExplaL; ?>: &nbsp;
</td>
<td>
<?php if ($NumWSM_L > 0) : ?>
<?php if ($NumWSM_OL > 0) : ?>
<img src="img/out.png" align="middle" hspace="2" alt="<?php
   echo $strWSM_ProOL . ': ' . number_format($ProWSM_OL, 2); ?>" height="5"
   width="<?php echo number_format(100*$ProWSM_OL, 0); ?>" border="1" bordercolor="black"><?php
   endif;
   if ($NumWSM_IL > 0) : ?><img src="img/in.png" align="middle" hspace="2" alt="<?php
   echo $strWSM_ProIL . ': ' . number_format($ProWSM_IL, 2); ?>" height="5"
   width="<?php echo number_format(100*$ProWSM_IL, 0); ?>" border="1" bordercolor="black"><?php
   endif; ?>
<?php else: ?>-
<?php endif; ?>
</td>
</tr>

<tr>
<td class="wsm_column">
<?php echo $strWSM_ExplaD; ?>: &nbsp;
</td>
<td>
<?php if ($NumWSM_D > 0) : ?>
<?php if ($NumWSM_OD > 0) : ?>
<img src="img/out.png" align="middle" hspace="2" alt="<?php
   echo $strWSM_ProOD . ': ' . number_format($ProWSM_OD, 2); ?>" height="5"
   width="<?php echo number_format(100*$ProWSM_OD, 0); ?>" border="1" bordercolor="black"><?php
   endif;
   if ($NumWSM_ID > 0) : ?><img
   src="img/in.png" align="middle" hspace="2" alt="<?php
   echo $strWSM_ProID . ': ' . number_format($ProWSM_ID, 2); ?>" height="5"
   width="<?php echo number_format(100*$ProWSM_ID, 0); ?>" border="1" bordercolor="black"><?php
   endif; ?>
<?php else: ?>-
<?php endif; ?>
</td>
</tr>

<tr>
<td colspan="2" class="wsm_notes">
<table border="0">
<tr>
<td>
<img src="img/out.png" hspace="2" alt="<?php
   echo $strWSM_ExplaOut; ?>" height="5" width="5" border="1" bordercolor="black">
</td>
<td>
<?php echo $strWSM_ExplaOut; ?>
</td>
<td>
&nbsp; - &nbsp;
</td>
<td>
<img src="img/in.png" hspace="2" alt="<?php
   echo $strWSM_ExplaIn; ?>" height="5" width="5" border="1" bordercolor="black">
</td>
<td>
<?php echo $strWSM_ExplaIn; ?>
</td>
</tr>
</table>
</td>
</tr>
</table>
</td>

<td>
<table border="1" class="wsm_data" cellpadding="5" cellspacing="0">

<tr>
<th colspan="2">
<?php echo $strWSM_Ratios; ?>
</th>
</tr>

<tr>
<td class="wsm_column">
<?php echo $strWSM_RatioL; ?>: &nbsp;
</td>
<td>
<?php if ($NumWSM_IL > 0)
      echo number_format(($NumWSM_OL / $NumWSM_IL), 2);
   else echo '-'; ?>
</td>
</tr>

<tr>
<td class="wsm_column">
<?php echo $strWSM_RatioD; ?>: &nbsp;
</td>
<td>
<?php if ($NumWSM_ID > 0)
      echo number_format(($NumWSM_OD / $NumWSM_ID), 2);
   else echo '-'; ?>
</td>
</tr>

</table>
</td>
</tr>
</table>

<?php

      // Info about outgoing links (both retrieved or not)
   
      $strSQL = "SELECT Schedule.Url, Schedule.Status, Link.*, " .
         " Url.StatusCode, Url.ReasonPhrase, Url.ContentType" . 
         " FROM Schedule, Link" .
         " LEFT JOIN Url ON Url.IDUrl=Link.IDUrlDest " .
         " WHERE Link.IDUrlSrc=" . $IDUrl . " AND " .
         " Schedule.IDUrl=Link.IDUrlDest" . 
         " ORDER BY Link.TagPosition, Link.AttrPosition";

      $result=$MyDB->Query($dbname, $strSQL);
   
      if ($result)
      {
         DisplayErrMsg($MyDB->errmsg);
         die;
      }
   
?>
<H4><?php echo $strOutgoingLinks; ?>:</H4>
<?php
      if ($num=$MyDB->NumRows())
      {
?>
<B><?php echo $strRecordFound; ?></B>: <?php echo $num; ?><BR>
<TABLE border="1">
<TR>
<TH>Url</TH>
<TH><?php echo $strRetrievingFlag; ?></TH>
<TH><?php echo $strLinkType; ?></TH>
<TH><?php echo $strStatusCode; ?></TH>
<TH><?php echo $strReasonPhrase; ?></TH>
<TH><?php echo $strContentType; ?></TH>
<TH><?php echo $strShow; ?></TH>
</TR>
<?php      
         $i=0;
         while ($link=$MyDB->FetchArray())
         {
            ++$i;
            ($i % 2)? $trclass='odd':$trclass='even';
?>
 <TR class="<?php echo $trclass; ?>">
   <TD><A href="<?php echo $PHP_SELF; ?>?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $link["IDUrlDest"]; ?>"><?php echo GetURL($link["Url"]); ?></A></TD>
   <TD align="center"><?php echo $link["Status"]; ?></TD>
   <TD align="center"><?php echo $link["LinkType"]; ?></TD>
<?php
            if ($link["StatusCode"])
            {
?>
   <TD align="center"><?php echo $link["StatusCode"]; ?></TD>
   <TD align="center"><?php echo $link["ReasonPhrase"]; ?></TD>
   <TD align="center"><?php echo $link["ContentType"]; ?></TD>
<?php
            }
            else
            {
?>
   <TD colspan="3" align="center"><EM><?php echo $strNotRetrieved; ?></EM></TD>
<?php
            }
?>
   <TD align="center">
<?php
   if (strcmp($link["LinkType"], "Redirection"))  // It's not a redirection
   {
?>
   <A href="showlink.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $link["IDUrlSrc"]; ?>&TagPosition=<?php echo $link["TagPosition"]; ?>&AttrPosition=<?php echo $link["AttrPosition"]; ?>"><?php echo $strShowLink; ?></A>
<?php
   }
?>
   </TD>
 </TR>
<?php
         }
?>
</TABLE>
<?php
      }
      else
      {
?>
<P><?php echo $strNoOccurrencies; ?></P>
<?php
      }
   }
   else
   {
?>
<EM><?php echo $strNotRetrieved; ?></EM><BR>
<?php
   }
?>
<H4><?php echo $strIncomingLinks; ?>:</H4>
<?php

      // Info about incoming links - only retrieved, of course
   
   $strSQL = "Select Url.IDUrl, Url.Url, Url.ContentType," .
      " Link.*" .
      " from Link, Url" .
      " WHERE Link.IDUrlDest=" . $IDUrl . " AND " .
      " Link.IDUrlSrc=Url.IDUrl" . 
      " ORDER BY Url.Url";

      $result=$MyDB->Query($dbname, $strSQL);
   
      if ($result)
      {
         DisplayErrMsg($MyDB->errmsg);
         die;
      }
   
      if ($num=$MyDB->NumRows())
      {
?>
<B><?php echo $strRecordFound; ?></B>: <?php echo $num; ?><BR>
<TABLE border="1">
<TR>
<TH>Url</TH>
<TH><?php echo $strLinkType; ?></TH>
<TH><?php echo $strContentType; ?></TH>
<TH><?php echo $strShow; ?></TH>
</TR>
<?php      
         $i=0;
         while ($link=$MyDB->FetchArray())
         {
            ++$i;
            ($i % 2)? $trclass='odd':$trclass='even';
?>
 <TR class="<?php echo $trclass; ?>">
   <TD><A href="<?php echo $PHP_SELF; ?>?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $link["IDUrlSrc"]; ?>"><?php echo GetURL($link["Url"]); ?></A></TD>
   <TD align="center"><?php echo $link["LinkType"]; ?></TD>
   <TD align="center"><?php echo $link["ContentType"]; ?></TD>
   <TD align="center">
<?php
   if (strcmp($link["LinkType"], "Redirection"))  // It's not a redirection
   {
?>
   <A href="showlink.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $link["IDUrlSrc"]; ?>&TagPosition=<?php echo $link["TagPosition"]; ?>&AttrPosition=<?php echo $link["AttrPosition"]; ?>"><?php echo $strShowLink; ?></A>
<?php
   }
?>
   </TD>
 </TR>
<?php
         }
?>
</TABLE>
<?php
      }
      else
      {
?>
<P><?php echo $strNoOccurrencies; ?></P>
<?php
      }
   }
}

?>

<H4><?php echo $strOperations; ?></H4>
<MENU>
<LI><A href="<?php echo $URLName; ?>" target="_blank"><?php echo $strOpenThisUrl; ?></A> (<?php echo $URLName; ?>)</LI>
</MENU>

<BR>

<a name="wsm_notes">
<B><?php echo $strWSM_Notes; ?></B><BR>
<MENU>
<LI><?php echo $strWSM_L; ?></LI>
<LI><?php echo $strWSM_D; ?></LI>
<LI><?php echo $strWSM_OL; ?></LI>
<LI><?php echo $strWSM_IL; ?></LI>
<LI><?php echo $strWSM_OD; ?></LI>
<LI><?php echo $strWSM_ID; ?></LI>
</MENU>
</a>

<br>

<?php include ("./include/footer.inc.php"); ?>
