<?php

//    qryurls.php
//    Shows a List of URLs previously set with a form
//
//    Part of the ht://Check package
//
//    Copyright (c) 1999-2002 Comune di Prato - Prato - Italy
//    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
//
//    For copyright details, see the file COPYING in your distribution
//    or the GNU General Public License version 2 or later 
//    <http://www.gnu.org/copyleft/gpl.html>
//
//    $Id: qryurls.php,v 1.10 2002/02/11 08:47:38 angusgb Exp $

///////
   //    Global settings
///////

include ("./include/global.inc.php");


if (!isset($dbname))
{
   // Error
   DisplayErrMsg($strErrorNoDBSelected);
   echo "<A href=\"index.php\">" . $strMainPage . "</A>";
   die;
}

$strSection=$strListofUrls;
$pagetitle = "Database: $dbname - " . $strSection;
eval("\$strhome = \"$strDBHome \";");
$linkbar = "<A href=\"index.php?dbname=". $dbname . "\">". $strhome."</A>";

// A database has been selected

include ("./include/header.inc.php");

if (isset ($cmd))
{

   if (!isset($initpage))
      $initpage=0;

   if (!isset($pagesize))
      $pagesize=30;

   $strwhere = "WHERE 1 ";
   $otherinfo = '&cmd=' . urlencode($cmd);
   
   if (isset($ctype) && $ctype!="AllCTypes")
   {
      $strwhere = $strwhere . "AND Url.ContentType $whatctype '$ctype' ";
      $otherinfo = $otherinfo . '&whatctype=' . urlencode($whatctype)
         . '&ctype=' . urlencode($ctype);
   }

   if (isset($scode) && $scode!="AllSCodes")
   {
      $strwhere = $strwhere . "AND Url.StatusCode $whatscode '$scode' ";
      $otherinfo = $otherinfo . '&whatscode=' . urlencode($whatscode)
         . '&scode=' . urlencode($scode);
   }

   if (isset($size) && strlen($size) && settype($size, "integer"))
   {
      $size *= 1024;
      $strwhere = $strwhere . "AND Url.Size $whatsize $size AND Url.Size >= 0 ";
      $otherinfo = $otherinfo . '&whatsize=' . urlencode($whatsize)
         . '&size=' . urlencode ($size);
   }

   if (isset($sizeadd) && strlen($sizeadd) && settype($sizeadd, "integer"))
   {
      $sizeadd *= 1024;
      $strwhere = $strwhere . "AND (Url.SizeAdd + Url.Size) $whatsizeadd $sizeadd "
         . "AND Url.Size >= 0 ";
      $otherinfo = $otherinfo . '&whatsizeadd=' . urlencode($whatsizeadd)
         . '&sizeadd=' . urlencode ($sizeadd);
   }


   $num=count($url); // Count the elements

   // Set the URL filter   
   for ($i=0; $i<$num; $i++)
   {
      if (isset($url[$i]) && $url[$i] && strlen($url[$i]) > 0)
      {
         if(isset($whaturl[$i]))
         {
            $strwhere = $strwhere . "AND Url.Url " . $whaturl[$i]
               . " '" . $url[$i] . "' ";
            $otherinfo = $otherinfo . "&whaturl[$i]=" . urlencode($whaturl[$i])
               . "&url[$i]=" . urlencode ($url[$i]);
          }
      }
   }


   $num=count($title); // Count the elements

   // Set the title filter   
   for ($i=0; $i<$num; $i++)
   {
      if (isset($title[$i]) && $title[$i] && strlen($title[$i]) > 0)
      {
         if(isset($whattitle[$i]))
         {
            $strwhere = $strwhere . "AND Url.Title " . $whattitle[$i]
               . " '" . $title[$i] . "' ";
            $otherinfo = $otherinfo . "&whattitle[$i]="
               . urlencode($whattitle[$i])
               ."&title[$i]=" . urlencode($title[$i]);
          }
      }
   }
   
   // Show all the URLs, retrieved ones as well as not
   $strGenSQL = "SELECT * "
      . "FROM Url "
      . $strwhere
      . " LIMIT " . $initpage . ", " . $pagesize;

   if (!isset($count))
   {
      $strCountSQL="select count(*) from Url "
         . $strwhere;

      $count = $MyDB->CountEntries($strCountSQL,$dbname,true);
      if ($count<0)
      {
         DisplayErrMsg($MyDB->errmsg);
         return;
      }
      $MyDB->Free();
   }

?>

<?php

// HTTP results
   
?>

<!--
SQL: <?php echo $strGenSQL; ?>
-->

<H4><?php echo $strSection; ?></H4>
<P>
<?
if ($count) printf ($strListPageInfo, number_format($initpage+1), number_format(($initpage+$pagesize)>$count?$count:$initpage+$pagesize), number_format($count));
?>  
<BR>
<?php WritePageLink($initpage, $pagesize, $count, $dbname, $otherinfo); ?>
</P>

<?php

   $result=$MyDB->Query($dbname, $strGenSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows())
   {
      // At least one occurrence found

?>

<TABLE border="1" cellpadding="2" cellspacing="2">
<TR>
<TH> N. </TH>
<TH> ID </TH>
<TH> Url </TH>
<TH> <?php echo $strStatusCode; ?> & <BR> <?php echo $strReasonPhrase; ?></TH>
<TH> <?php echo $strConnectionStatus; ?></TH>
</TR>
      
<?php
      $i=0;
      while ($row = $MyDB->FetchArray())
      {
         // Get next row
         $i++;
         ($i % 2)? $trclass='odd':$trclass='even';
?>
 <TR class="<?php echo $trclass; ?>">
   <TD align="right"> <?php echo number_format($initpage+$i); ?> </TD>
   <TD align="right"> <?php echo number_format($row["IDUrl"]); ?> </TD>
   <TD class="url" align="left"><A href="showurl.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $row["IDUrl"]; ?>"><?php echo GetURL($row["Url"]); ?></A></TD><?php
   if ($row["StatusCode"])
   {
?>
   <TD align="center"> <?php echo $row["StatusCode"]; ?> - <?php echo $row["ReasonPhrase"]; ?></TD>
   <TD align="center"> <?php echo $row["ConnStatus"]; ?></TD>
<?php
   }
   else
   {
?>
   <TD align="center" colspan="2"><EM><?php echo $strNotRetrieved; ?></EM></TD>
<?php   
   }
?>
 </TR>
<?php         
      }

?>
</TABLE>
<?php      
      // Page management

      WritePageLink($initpage, $pagesize, $count, $dbname,$otherinfo);
   }
   else
   {
?>
<P><?php echo $strNoOccurrencies; ?></P>

<?php
   }

   $MyDB->Free();

}
else
{
?>
<P><?php echo $strFilterUrls; ?>:</P>

<FORM action="<?php echo $PHP_SELF; ?>" method="GET">
<INPUT type="hidden" name="dbname" value="<?php echo $dbname; ?>">
<TABLE border="1" cellpadding="5" cellspacing="2">

<TR>
<TH>
<?php echo $strUrl; ?> : 
</TH>
</TR>

<?php
   for ($i=0; $i<$NumFilterRows; $i++)
   {
?>

<TR>
<TD>
<SELECT name="whaturl[<?php echo $i; ?>]">
 <OPTION value="LIKE"><?php echo $strLike; ?></OPTION>
 <OPTION value="NOT LIKE"><?php echo $strNotLike; ?></OPTION>
 <OPTION value="REGEXP"><?php echo $strRegExp; ?></OPTION>
 <OPTION value="NOT REGEXP"><?php echo $strNotRegExp; ?></OPTION>
</SELECT>
<INPUT name="url[<?php echo $i; ?>]" type="text" value="<?php echo $url[$i]; ?>"
   size="30" maxlength="255">
</TD>
</TR>
<?php
   }
?>


<?php

   // Retrieving all the Status Codes found
   $strSQL="SELECT count(*) as Count, StatusCode "
      . "FROM Url GROUP BY StatusCode "
      . "ORDER BY StatusCode ASC";

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows())
   {

?>
<TR>
<TD>
<B><?php echo $strStatusCode; ?> : </B>
<SELECT name="whatscode">
 <OPTION value="="><?php echo $strLike; ?></OPTION>
 <OPTION value="!="><?php echo $strNotLike; ?></OPTION>
</SELECT>
<SELECT name="scode">
 <OPTION value="AllSCodes"><?php echo $strAllSCodes; ?></OPTION>
<?php
      while ($row = $MyDB->FetchArray())
      {
?>
 <OPTION value="<?php echo $row["StatusCode"]; ?>">
   <?php echo $row["StatusCode"]; ?> (<?php echo $row["Count"]; ?>)</OPTION>
<?php
      }
?>
</SELECT>
</TD>
</TR>
<?php
   }

   $MyDB->Free();

?>

<?php

   // Retrieving all the ContentTypes found
   $strSQL="SELECT count(*) as Count, ContentType "
      . "FROM Url GROUP BY ContentType "
      . "ORDER BY ContentType ASC";

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows())
   {

?>
<TR>
<TD>
<B><?php echo $strContentType; ?> : </B>
<SELECT name="whatctype">
 <OPTION value="="><?php echo $strLike; ?></OPTION>
 <OPTION value="!="><?php echo $strNotLike; ?></OPTION>
</SELECT>
<SELECT name="ctype">
 <OPTION value="AllCTypes"><?php echo $strAllCTypes; ?></OPTION>
<?php
      while ($row = $MyDB->FetchArray())
      {
?>
 <OPTION value="<?php echo $row["ContentType"]; ?>">
   <?php echo $row["ContentType"]; ?> (<?php echo $row["Count"]; ?>)</OPTION>
<?php
      }
?>
</SELECT>
</TD>
</TR>
<?php
   }

   $MyDB->Free();

?>

<TR>
<TD>
<B><?php echo $strSize; ?> : </B>
<SELECT name="whatsize">
 <OPTION value=">"><?php echo $strGt; ?></OPTION>
 <OPTION value="<"><?php echo $strLt; ?></OPTION>
 <OPTION value="="><?php echo $strLike; ?></OPTION>
</SELECT>
<INPUT name="size" type="text" value="<?php echo $size; ?>"
   size="10" maxlength="9"> KBytes
</TD>
</TR>


<TR>
<TD>
<B><?php echo $strPageWeight; ?> : </B>
<SELECT name="whatsizeadd">
 <OPTION value=">"><?php echo $strGt; ?></OPTION>
 <OPTION value="<"><?php echo $strLt; ?></OPTION>
 <OPTION value="="><?php echo $strLike; ?></OPTION>
</SELECT>
<INPUT name="sizeadd" type="text" value="<?php echo $sizeadd; ?>"
   size="10" maxlength="9"> KBytes
</TD>
</TR>


<TR>
<TH>
<?php echo $strTitle; ?> : 
</TH>
</TR>

<?php
   for ($i=0; $i<$NumFilterRows; $i++)
   {
?>

<TR>
<TD>
<SELECT name="whattitle[<?php echo $i; ?>]">
 <OPTION value="LIKE"><?php echo $strLike; ?></OPTION>
 <OPTION value="NOT LIKE"><?php echo $strNotLike; ?></OPTION>
 <OPTION value="REGEXP"><?php echo $strRegExp; ?></OPTION>
 <OPTION value="NOT REGEXP"><?php echo $strNotRegExp; ?></OPTION>
</SELECT>
<INPUT name="title[<?php echo $i; ?>]" type="text" value="<?php echo $title[$i]; ?>"
   size="30" maxlength="255">
</TD>
</TR>
<?php
   }
?>



<TR>
<TD colspan="2" align="right">
<INPUT type="submit" name="cmd" value="<?php echo $strLinkSubmit; ?>">
</TD>
</TR>
</FORM>
</TABLE>

<P align="justify">
<?php echo $strHelpOnString; ?>
</P>
<P align="justify">
<?php echo $strHelpOnRegExp; ?>
</P>

<?php
}

?>

<BR>

<?php include ("./include/footer.inc.php"); ?>
