/*
 *	HT Editor
 *	hthelp.cc
 *
 *	Copyright (C) 1999, 2000, 2001 Stefan Weyergraf (stefan@weyergraf.de)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2 as
 *	published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "htapp.h"
#include "hthelp.h"
#include "htpal.h"
#include "htreg.h"

#define palclasskey_help	     				"help"

#define palkey_help_default					"help"

#define palcolors_help						3

#define palidx_help_normal					0
#define palidx_help_link_selected				1
#define palidx_help_link_unselected			2

/* HELP */

defpal defpal_help[palcolors_help]={
{palidx_help_normal, "normal", VCP(VC_BLACK, VC_CYAN)},
{palidx_help_link_selected, "selected link", VCP(VC_LIGHT(VC_YELLOW), VC_BLUE)},
{palidx_help_link_unselected, "unselected link", VCP(VC_LIGHT(VC_YELLOW), VC_CYAN)}
};

/*
 *	CLASS ht_help_window
 */

void ht_help_window::handlemsg(htmsg *msg)
{
	if (msg->msg == msg_keypressed) {
		switch (msg->data1.integer) {
			case K_Escape: {
				htmsg m;
				m.msg = cmd_window_close;
				((ht_app*)app)->queuemsg(app, &m);
				clearmsg(msg);
				return;
			}				
		}				
	}
	ht_window::handlemsg(msg);
}

/*
 *	INIT
 */

bool init_help()
{
	int b=0;
	ht_registry_node_type rnt_pal=registry->have_node_type(rnt_palette_name, NULL);

/* HELP */
	b|=registry->create_subdir(palettekey"/"palclasskey_help);

	b|=create_pal(palclasskey_help, palkey_help_default, defpal_help, palcolors_help, rnt_pal);

	return b ? false : true;
}

/*
 *	DONE
 */

void done_help()
{
}
