/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.types.Type;

public class ExpressionColumnAccessor
extends Expression {
    ColumnSchema column;

    ExpressionColumnAccessor(ColumnSchema columnSchema) {
        super(2);
        this.column = columnSchema;
        this.dataType = columnSchema.getDataType();
    }

    @Override
    String getAlias() {
        return this.column.getNameString();
    }

    @Override
    void collectObjectNames(Set set) {
        set.add(this.column.getName());
        if (this.column.getName().parent != null) {
            set.add(this.column.getName().parent);
        }
    }

    @Override
    String getColumnName() {
        return this.column.getNameString();
    }

    @Override
    public ColumnSchema getColumn() {
        return this.column;
    }

    @Override
    RangeVariable getRangeVariable() {
        return null;
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeGroup rangeGroup, int n, RangeGroup[] rangeGroupArray, HsqlList hsqlList, boolean bl) {
        return hsqlList;
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
    }

    @Override
    public Object getValue(Session session) {
        return null;
    }

    @Override
    public String getSQL() {
        return this.column.getName().statementName;
    }

    @Override
    protected String describe(Session session, int n) {
        return this.column.getName().name;
    }

    @Override
    public OrderedHashSet getUnkeyedColumns(OrderedHashSet orderedHashSet) {
        return orderedHashSet;
    }

    @Override
    OrderedHashSet collectRangeVariables(RangeVariable[] rangeVariableArray, OrderedHashSet orderedHashSet) {
        return orderedHashSet;
    }

    @Override
    Expression replaceAliasInOrderBy(Expression[] expressionArray, int n) {
        return this;
    }

    @Override
    Expression replaceColumnReferences(RangeVariable rangeVariable, Expression[] expressionArray) {
        return this;
    }

    @Override
    boolean hasReference(RangeVariable rangeVariable) {
        return false;
    }

    @Override
    public boolean equals(Expression expression) {
        if (expression == this) {
            return true;
        }
        if (expression == null) {
            return false;
        }
        if (this.opType != expression.opType) {
            return false;
        }
        return this.column == expression.getColumn();
    }

    @Override
    void replaceRangeVariables(RangeVariable[] rangeVariableArray, RangeVariable[] rangeVariableArray2) {
    }

    @Override
    void resetColumnReferences() {
    }

    @Override
    public boolean isIndexable(RangeVariable rangeVariable) {
        return false;
    }

    @Override
    public boolean isUnresolvedParam() {
        return false;
    }

    @Override
    boolean isDynamicParam() {
        return false;
    }

    @Override
    public Type getDataType() {
        return this.column.getDataType();
    }
}

