/*
 * ### Copyright (C) 2001-2003 Michael Fuchs ###
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Michael Fuchs
 * E-Mail: mfuchs@unico-consulting.com
 *
 * RCS Information:
 * ---------------
 * Id.........: $Id: ParserException.java,v 1.1.1.1 2004/12/21 14:01:33 mfuchs Exp $
 * Author.....: $Author: mfuchs $
 * Date.......: $Date: 2004/12/21 14:01:33 $
 * Revision...: $Revision: 1.1.1.1 $
 * State......: $State: Exp $
 */
package org.dbdoclet.trafo.html.parser;

public class ParserException extends Exception {

    private static final long serialVersionUID = 1L;

    public ParserException(String msg) {
	super(msg);
    }

    public ParserException(Throwable oops) {
	super(oops);
    }

    @Override
    public String getMessage() {

	String str;
	String msg;

	Throwable cause = getCause();

	if (cause != null) {

	    msg = "[" + cause.getClass().getName() + "] ";
	    str = cause.getMessage();

	    if ((str != null) && (str.length() > 0)) {
		msg += str;
	    }

	} else {

	    msg = super.getMessage();
	}

	return msg;
    }
}
