/*C* -*-c++-*-
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "Background.h"
#include "Data.h"
#include "globals.h"
#include "spriteslide.h"
#include "../gl/Console.h"
#include "../gl/Sprite.h"
#include "../gl/VgaBlur.h"
#include "../gl/VgaContext.h"
#include "../util/Collection.h"
#include "../util/util.h"

SpriteSlide::SpriteSlide(Collection<Sprite>* _sprites)
{
 sprites = _sprites;
 sel = 0;
 w = sprites->at(0)->size().x;
 h = sprites->at(0)->size().y;
}

SpriteSlide::~SpriteSlide()
{
}

int SpriteSlide::operator ++ (int)
{
 wrap(sel, +1, sprites->length());
 return sel;
}

int SpriteSlide::operator -- (int)
{
 wrap(sel, -1, sprites->length());
 return sel;
}

void SpriteSlide::update(int i)
{
 //sprites->at((sel+i)%sprites->length())->restoreAndDrawAndUpdate(screen, Point(vgaW - w, i * h));
}

void SpriteSlide::draw()
{
 screen->restore(Rect(vgaW-w, 0, w, vgaH));
 for(int i=0; i<(int)(vgaH / h); i++)
  sprites->at((sel+i)%sprites->length())->draw(screen, Point(vgaW - w, i * h));
 screen->update(Rect(vgaW-w, 0, w, vgaH));
}
