
/*  A Bison parser, made from readgame-parser.yy
 by  GNU Bison version 1.25
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	d_string	258
#define	d_symbol	259
#define	d_number	260
#define	k_hatgame	261
#define	k_level	262
#define	k_cutscene	263

#line 3 "readgame-parser.yy"


#ifndef NDEBUG
#define YYDEBUG 1
#endif

#include "rg.h"

#include "GameItem.h"
#include "GameItems.h"
#include "gameitems.h"
#include "../util/Collection.h"
#include "../util/Object.h"
#include "../util/debug.h"
#include "../util/util.h"
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

extern int rglex();
static void rgerror(char* s);

static int fillStruct(void* data, MemberTable* members, Collection<void>* rubbishMan);

//--------------------------------------------------------------------------------------------------------------------------------

class Variable : public Object
{
private:
 char* pName;

public:
 Variable(const char* _name)
  { pName = newString(_name); }
 Variable(Variable& object)
  { pName = newString(object.pName); }
 virtual ~Variable()
  { delete pName; }
 const char* name()
  { return pName; }
};

//--------------------------------------------------------------------------------------------------------------------------------

class StringVar : public Variable
{
private:
 char* pValue;

public:
 StringVar(const char* _name, const char* _value)
  : Variable(_name) 
  { pValue = newString(_value); }
 StringVar(StringVar& object)
  : Variable(object)
  { pValue = newString(object.pValue); }
 ~StringVar() 
  { delete pValue; }

 StringVar& operator = (const char* _value)
  {
   delete pValue;
   pValue = newString(_value);
   return *this;
  }

 const char* value() { return pValue; }
};
template class Collection<StringVar>;

//--------------------------------------------------------------------------------------------------------------------------------

class IntegerVar : public Variable
{
private:
 int pValue;

public:
 IntegerVar(const char* _name, int _value) 
  : Variable(_name)
  { pValue = _value; }
 IntegerVar(IntegerVar& object)
  : Variable(object)
  { pValue = object.pValue; }

 IntegerVar& operator = (int _value)
  {
   pValue = _value;
   return *this;
  }
 int value() { return pValue; }
};
template class Collection<IntegerVar>;

//--------------------------------------------------------------------------------------------------------------------------------

class VarContext : public Object
{
private:
 VarContext* pNext;
 Collection<IntegerVar>* pIntegerVars;
 Collection<StringVar>* pStringVars;

 VarContext* next(VarContext* _next) { return pNext = _next; }

public:
 VarContext(VarContext* _next)
  {
   // create some new variable collections
   pIntegerVars = new Collection<IntegerVar>(32, 16);
   pStringVars = new Collection<StringVar>(32, 16);

   // if there is a context around us copy it's variables
   if(next(_next))
    {
     foreach(*next()->integerVars(), i) integerVars()->add(new IntegerVar(*next()->integerVars()->at(i)));
     foreach(*next()->stringVars(), i) stringVars()->add(new StringVar(*next()->stringVars()->at(i)));
    }
  }
 ~VarContext()
  {
   delete pIntegerVars;
   delete pStringVars;
  }

 VarContext* next() { return pNext; }
 Collection<IntegerVar>* integerVars() { return pIntegerVars; }
 Collection<StringVar>* stringVars() { return pStringVars; }
};

//--------------------------------------------------------------------------------------------------------------------------------

static VarContext* varContext; // created by rgParse
static GameItems* gameItems; // set by rgParse to it's parameter

//--------------------------------------------------------------------------------------------------------------------------------


#line 143 "readgame-parser.yy"
typedef union
{
 char* string;
 int integer;
} YYSTYPE;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		35
#define	YYFLAG		-32768
#define	YYNTBASE	19

#define YYTRANSLATE(x) ((unsigned)(x) <= 263 ? yytranslate[x] : 24)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,    17,
    18,    10,    12,     2,    13,     2,    11,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
    16,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     9,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    14,     2,    15,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     1,     8,     9,    14,    19,    20,    27,    29,    31,
    35,    39,    43,    47,    51,    55
};

static const short yyrhs[] = {    -1,
     6,     5,    20,    14,    21,    15,     0,     0,    21,     4,
    16,     3,     0,    21,     4,    16,    23,     0,     0,    21,
     7,    22,    14,    21,    15,     0,     5,     0,     4,     0,
    17,    23,    18,     0,    23,    12,    23,     0,    23,    13,
    23,     0,    23,    10,    23,     0,    23,    11,    23,     0,
    23,     9,    23,     0,    13,    23,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   160,   163,   169,   171,   186,   202,   206,   217,   219,   232,
   233,   234,   235,   236,   237,   238
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","d_string",
"d_symbol","d_number","k_hatgame","k_level","k_cutscene","'^'","'*'","'/'","'+'",
"'-'","'{'","'}'","'='","'('","')'","input","@1","lines","@2","expr", NULL
};
#endif

static const short yyr1[] = {     0,
    20,    19,    21,    21,    21,    22,    21,    23,    23,    23,
    23,    23,    23,    23,    23,    23
};

static const short yyr2[] = {     0,
     0,     6,     0,     4,     4,     0,     6,     1,     1,     3,
     3,     3,     3,     3,     3,     2
};

static const short yydefact[] = {     0,
     0,     1,     0,     3,     0,     0,     6,     2,     0,     0,
     4,     9,     8,     0,     0,     5,     3,    16,     0,     0,
     0,     0,     0,     0,     0,    10,    15,    13,    14,    11,
    12,     7,     0,     0,     0
};

static const short yydefgoto[] = {    33,
     3,     5,    10,    16
};

static const short yypact[] = {     1,
     0,-32768,     8,-32768,     2,     7,-32768,-32768,    -3,    10,
-32768,-32768,-32768,    -1,    -1,    32,-32768,-32768,    22,    -1,
    -1,    -1,    -1,    -1,     4,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,    13,    15,-32768
};

static const short yypgoto[] = {-32768,
-32768,    19,-32768,     6
};


#define	YYLAST		45


static const short yytable[] = {    11,
    12,    13,    12,    13,     2,     6,     1,     6,     7,    14,
     7,    14,    34,    15,    35,    15,     8,     0,    32,    18,
    19,     4,     9,    17,     0,    27,    28,    29,    30,    31,
    20,    21,    22,    23,    24,    25,     0,     0,     0,    26,
    20,    21,    22,    23,    24
};

static const short yycheck[] = {     3,
     4,     5,     4,     5,     5,     4,     6,     4,     7,    13,
     7,    13,     0,    17,     0,    17,    15,    -1,    15,    14,
    15,    14,    16,    14,    -1,    20,    21,    22,    23,    24,
     9,    10,    11,    12,    13,    17,    -1,    -1,    -1,    18,
     9,    10,    11,    12,    13
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/lib/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#else /* not MSDOS, __TURBOC__, or _AIX */
#ifdef __hpux
#ifdef __cplusplus
extern "C" {
void *alloca (unsigned int);
};
#else /* not __cplusplus */
void *alloca ();
#endif /* not __cplusplus */
#endif /* __hpux */
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
int yyparse (void);
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 196 "/usr/lib/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 1:
#line 160 "readgame-parser.yy"
{
	    VPRINTF("<rg> hatgame {\n");
            if(yyvsp[0].integer != 1) { yyerror("Wrong version"); YYABORT; }
          ;
    break;}
case 2:
#line 163 "readgame-parser.yy"
{
	    VPRINTF("<rg> } hatgame\n");
            //if(rg_setGameOptions() != 0) YYABORT;
          ;
    break;}
case 3:
#line 169 "readgame-parser.yy"
{;
    break;}
case 4:
#line 172 "readgame-parser.yy"
{
	    // get rid of any old definition
	    foreach(*varContext->stringVars(), i)
	     if(strcmp(varContext->stringVars()->at(i)->name(), yyvsp[-2].string) == 0)
	      { varContext->stringVars()->del(i); varContext->stringVars()->pack(); break; }

	    // set the new value
	    varContext->stringVars()->add(new StringVar(yyvsp[-2].string, yyvsp[0].string));

	    // free the strings we were passed
	    free(yyvsp[-2].string);
	    free(yyvsp[0].string);
	   ;
    break;}
case 5:
#line 187 "readgame-parser.yy"
{
	    VPRINTF("<rg> setting int \"%s\" to %d\n", yyvsp[-2].string, yyvsp[0].integer);

	    // get rid of any old definition
	    foreach(*varContext->integerVars(), i)
	     if(strcmp(varContext->integerVars()->at(i)->name(), yyvsp[-2].string) == 0)
	      { varContext->integerVars()->del(i); varContext->integerVars()->pack(); break; }

	    // set the new value
	    varContext->integerVars()->add(new IntegerVar(yyvsp[-2].string, yyvsp[0].integer));

	    // free the strings we were passed
	    free(yyvsp[-2].string);
	   ;
    break;}
case 6:
#line 203 "readgame-parser.yy"
{
	    varContext = new VarContext(varContext);
            VPRINTF("<rg> level {\n");
          ;
    break;}
case 7:
#line 206 "readgame-parser.yy"
{
            LevelOptions* levelOptions = new LevelOptions;
	    memcpy(levelOptions, levelOptionsDefault, sizeof(LevelOptions));
            Collection<void>* rubbishMan = new Collection<void>;
	    fillStruct(levelOptions, levelOptionsMembers, rubbishMan);
	    gameItems->add(new GameItemLevel(levelOptions, rubbishMan));
            VPRINTF("<rg> } level\n");
	  ;
    break;}
case 8:
#line 217 "readgame-parser.yy"
{ yyval.integer = yyvsp[0].integer; ;
    break;}
case 9:
#line 220 "readgame-parser.yy"
{
	    foreach(*varContext->integerVars(), i)
	     if(strcmp(varContext->integerVars()->at(i)->name(), yyvsp[0].string) == 0)
	      { yyval.integer = varContext->integerVars()->at(i)->value(); goto foundSymbol; }

	    yyerror("undefined symbol");
	    YYABORT;

	   foundSymbol:
	    free(yyvsp[0].string);
	   ;
    break;}
case 10:
#line 232 "readgame-parser.yy"
{ yyval.integer = yyvsp[-1].integer; ;
    break;}
case 11:
#line 233 "readgame-parser.yy"
{ yyval.integer = yyvsp[-2].integer + yyvsp[0].integer; ;
    break;}
case 12:
#line 234 "readgame-parser.yy"
{ yyval.integer = yyvsp[-2].integer - yyvsp[0].integer; ;
    break;}
case 13:
#line 235 "readgame-parser.yy"
{ yyval.integer = yyvsp[-2].integer * yyvsp[0].integer; ;
    break;}
case 14:
#line 236 "readgame-parser.yy"
{ yyval.integer = yyvsp[-2].integer / yyvsp[0].integer; ;
    break;}
case 15:
#line 237 "readgame-parser.yy"
{ yyval.integer = yyvsp[-2].integer ^ yyvsp[0].integer; ;
    break;}
case 16:
#line 238 "readgame-parser.yy"
{ yyval.integer = - yyvsp[0].integer; ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 498 "/usr/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 242 "readgame-parser.yy"


//--------------------------------------------------------------------------------------------------------------------------------

bool rgParse(GameItems* _gameItems)
{
 VPRINTF("<rg> rgParse(...)\n");
 assert(_gameItems != NULL);
 gameItems = _gameItems;
 varContext = new VarContext(NULL);

 int i = yyparse();

 delete varContext;
 return (i==0)? true : false;
}

//--------------------------------------------------------------------------------------------------------------------------------

static int fillStruct(void* data, MemberTable* members, Collection<void>* rubbishMan)
{
 while(members->type != mt_end)
  {
   switch(members->type)
    {
    case mt_str:
     foreach(*varContext->stringVars(), i)
      if(strcmp(varContext->stringVars()->at(i)->name(), members->name) == 0)
       {
	char* s = newString(varContext->stringVars()->at(i)->value());
	rubbishMan->add(s);
	*(char**)((char*)data + (unsigned long)members->offset) = s;
	break;
       }
     break;
     
    case mt_int:
     foreach(*varContext->integerVars(), i)
      if(strcmp(varContext->integerVars()->at(i)->name(), members->name) == 0)
       {
	*(int*)((char*)data + (unsigned long)members->offset) = varContext->integerVars()->at(i)->value();
	break;
       }
     break;
     
    case mt_end:
     fatal("Something has gone horribly, horribly wrong...\n");
     // this can never actually happen, but gcc complains...
     break;
    }
   members++;
  }
 return 0;
}

//--------------------------------------------------------------------------------------------------------------------------------

static void rgerror(char* s)
{
 nonFatal("%s\n", s);
}

//--------------------------------------------------------------------------------------------------------------------------------
