/*C* $Id: sprite.h,v 1.6 1997/09/27 12:11:33 james Exp james $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef vgaxx_sprite_h
#define vgaxx_sprite_h

#include "../gl/Color.h"
#include "../gl/Point.h"
#include "../util/File.h"
#include "../util/Object.h"

class Sprite : public Object
{
private:
 unsigned char** data32;
 unsigned char** data8;
 Point z;

public:
 Sprite();
 Sprite(Sprite&);
 virtual ~Sprite();

 void alloc();
 void free();

 void alloc8();
 void free8();

 Point size() { return z; }
 Point size(Point newSize);

 Color setPixel(Point p, Color c);
 int setPixel(Point p, int mask);
 void setPixel(Point p, Color c, int mask);

 void dither();

 class Rect draw(class VgaContext* vc, Point p);

 bool read(class File& f);
 bool write(class File& f);

 bool readTga(class File& f);
 bool writeTga(class File& f);

 bool readJpeg(class File& f);
 bool writeJpeg(class File& f);

 void flipH();
 void flipV();
 void rotate();
 void dim(int factor);
 void swapRB();

 void setMask(Sprite& s);

 static objectCreateFunc getCreateFunc(const char* filename);
 static Sprite* create(class File& f);
 static Sprite* createTga(class File& f);
 static Sprite* createJpeg(class File& f);

 bool ok() { return data32? true : false; }
};

extern Sprite emptySprite;

#endif
