module Foreign.Ptr
  ( Ptr
  , nullPtr      -- :: Ptr a
  , castPtr      -- :: Ptr a -> Ptr b
  , plusPtr      -- :: Ptr a -> Int -> Ptr b
  , alignPtr     -- :: Ptr a -> Int -> Ptr a
  , minusPtr     -- :: Ptr a -> Ptr b -> Int
    
  , FunPtr
  , nullFunPtr      -- :: FunPtr a
  , castFunPtr      -- :: FunPtr a -> FunPtr b
  , castFunPtrToPtr -- :: FunPtr a -> Ptr b
  , castPtrToFunPtr -- :: Ptr a -> FunPtr b
    
  , freeHaskellFunPtr -- :: FunPtr a -> IO ()

  ) where

import Foreign.BuiltinTypes
import PreludeBuiltinTypes
import qualified TraceOrigForeign.Ptr

foreign import haskell "Foreign.Ptr.nullPtr"  nullPtr  :: Ptr a
foreign import haskell "Foreign.Ptr.castPtr"  castPtr  :: Ptr a -> Ptr b
foreign import haskell "Foreign.Ptr.plusPtr"  plusPtr  :: Ptr a -> Int -> Ptr b
foreign import haskell "Foreign.Ptr.alignPtr" alignPtr :: Ptr a -> Int -> Ptr a
foreign import haskell "Foreign.Ptr.minusPtr" minusPtr :: Ptr a -> Ptr b -> Int

foreign import haskell "Foreign.Ptr.nullFunPtr"
  nullFunPtr :: FunPtr a
foreign import haskell "Foreign.Ptr.castFunPtr"
  castFunPtr :: FunPtr a -> FunPtr b
foreign import haskell "Foreign.Ptr.castFunPtrToPtr"
  castFunPtrToPtr :: FunPtr a -> Ptr b
foreign import haskell "Foreign.Ptr.castPtrToFunPtr"
  castPtrToFunPtr :: Ptr a -> FunPtr b

foreign import haskell "Foreign.Ptr.freeHaskellFunPtr"
    freeHaskellFunPtr :: FunPtr a -> IO ()

--
foreign import haskell "Prelude.=="
  eqPtr :: Ptr a -> Ptr a -> Bool
foreign import haskell "Prelude.<="
  leqPtr :: Ptr a -> Ptr a -> Bool
foreign import haskell "Prelude.showsPrec"
  showsPrecPtr :: Int -> Ptr a -> String -> String

instance Eq (Ptr a) where
  (==) = eqPtr
instance Ord (Ptr a) where
  (<=) = leqPtr
instance Show (Ptr a) where
  showsPrec = showsPrecPtr

--
foreign import haskell "Prelude.=="
  eqFunPtr :: FunPtr a -> FunPtr a -> Bool
foreign import haskell "Prelude.<="
  leqFunPtr :: FunPtr a -> FunPtr a -> Bool
foreign import haskell "Prelude.showsPrec"
  showsPrecFunPtr :: Int -> FunPtr a -> String -> String

instance Eq (FunPtr a) where
  (==) = eqFunPtr
instance Ord (FunPtr a) where
  (<=) = leqFunPtr
instance Show (FunPtr a) where
  showsPrec = showsPrecFunPtr

