#!/usr/bin/runghc

\begin{code}
import Distribution.Simple
import Distribution.Setup
import Distribution.PackageDescription
import System.Info

main = defaultMainWithHooks defaultUserHooks{preConf=configure}
  where
    configure :: [String] -> ConfigFlags -> IO HookedBuildInfo
    configure args flags = do
      let binfo | os == "mingw32" = emptyBuildInfo{extraLibs=["odbc32"], ccOptions=["-Dmingw32_HOST_OS"]}
                | otherwise       = emptyBuildInfo{extraLibs=["odbc"]}
          hbi = (Just binfo,[])
      writeHookedBuildInfo "ODBC.buildinfo" hbi
      return hbi
\end{code}
