/*
 * happydigger - program for cataloging archaeological finds
 * Copyright (C) 2004, 2005 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <sqlite3.h>
#include <string.h>
#include "callbacks.h"
#include "preferences.h"
#include "interface.h"
#include "support.h"
#include "db.h"
#include "gui_warningdialog.h"
#include "gui_utils.h"

extern GtkWidget *window, *startupwindow;
extern sqlite3 *db;
extern statestype state;

gboolean
on_startupwindow_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	sqlite3_close (db);
	gtk_widget_destroy (widget);
	gtk_widget_destroy (window);
	g_free (state.imageloaddir);
	g_free (state.table);
	gtk_main_quit ();

	return FALSE;
}

void
on_newtablebutton_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *newdialog, *newentry, *identry, *tablecombo, *entry;
	gint response, result;
	gchar *dbname, *id, *msg, *name;
	GtkTreeModel *model;
	GtkTreeIter iter;
	gboolean iter_valid;

	newdialog = create_newdialog ();
	response = gtk_dialog_run (GTK_DIALOG(newdialog));
	if (response == GTK_RESPONSE_OK)
	{
		newentry = lookup_widget (newdialog, "newentry");
		dbname = gtk_editable_get_chars (GTK_EDITABLE(newentry), 0, -1);
		if (strlen(dbname) > 0)
		{
			result = create_db (dbname);
	/* create a first record, update the combobox and set to the created table*/
			if (result == SQLITE_OK)
			{
				state.table = g_strdup (dbname);
				clearall ();
				entry = lookup_widget (window, "entry");
				gtk_entry_set_text (GTK_ENTRY (entry), "1");
				result = add_to_db ();
				identry = lookup_widget (window, "identry");
				id = g_strdup_printf ("%d", result);
				gtk_entry_set_text (GTK_ENTRY(identry), id);
				g_free (id);

				tablecombo = lookup_widget (startupwindow, "tablecombo");
				model = gtk_combo_box_get_model (GTK_COMBO_BOX (tablecombo));
				gtk_list_store_clear (GTK_LIST_STORE (model));
				find_tables ();

				for (iter_valid = gtk_tree_model_get_iter_first (model, &iter);
					iter_valid;
					iter_valid = gtk_tree_model_iter_next (model, &iter))
				{
					gtk_tree_model_get (model, &iter, 0, &name, -1);
					if (!strcmp(name, dbname))
					{
						gtk_combo_box_set_active_iter
							(GTK_COMBO_BOX(tablecombo), &iter);
						break;
					}
				}
			}
			else
			{
				msg = g_strdup_printf
				(_("Error creating table %s: %s"), dbname, sqlite3_errmsg (db));
				warningdialog (_("happydigger - error"), msg, "gtk-dialog-error");	
				g_free (msg);
			}
		}
		g_free (dbname);
	}
	gtk_widget_destroy (newdialog);
}


void
on_startbutton_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *startupwindow, *tablecombo;
	gchar *title;
	gint result;

	startupwindow = gtk_widget_get_toplevel(GTK_WIDGET(button));
	tablecombo = lookup_widget (startupwindow, "tablecombo");
	state.table = gtk_combo_box_get_active_text (GTK_COMBO_BOX(tablecombo));
	gtk_widget_destroy (startupwindow);
	title = g_strdup_printf (_("happydigger - table %s"), state.table);
	gtk_window_set_title (GTK_WINDOW(window), title);
	g_free (title);
	result = load_from_db (1);
	gtk_widget_show (window);
}


void
on_exitbutton_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	sqlite3_close (db);
	gtk_widget_destroy (gtk_widget_get_toplevel(GTK_WIDGET(button)));
	gtk_widget_destroy (window);
	g_free (state.imageloaddir);
	g_free (state.table);
	gtk_main_quit ();
}



