#!/usr/bin/perl
#
# $Id: hist2scn.pl,v 1.2 2001/12/17 00:19:20 nfx3 Exp $
#
# $Source: /cvsroot/hammerhead/hammerhead/bin/hist2scn.pl,v $
# $Revision: 1.2 $
# $Date: 2001/12/17 00:19:20 $
# $State: Exp $
#
# hist2scn.pl: Takes an urlfile i.e. netscapes
#              history file and creates scenario
#              files (.scn) for use with hammerhead
# Version:     0.1alpha
#
# Author:      Niklas Fondberg<nfx3@sourceforge.net>
# Note:        This utility is part of the hammerhead project
#              (http://hammerhead.sourceforge.net).
#              The resulting .scn files should be examined
#              because of the early state of this utility.
#
# Usage:       hist2scn.pl urlfile.txt
#              Where the urlfile has an url on each line
#              Lines with comments ("#") are ignored
#
my $file = $ARGV[0];
my $page;
my $i = 0;
my $line;
my $url;
open(URLS, "$file") or die "could not find file: $!";

while($line = <URLS>)
{
  if ( $line =~ /^\s*$/ or $line =~ /^\s*\#/ )
  {
   next;
  }
  chomp($line);
  $line =~ s/http:\/\///;
  $url = $line;

  if($line !~ m/\//)
  {
    $line = "index";
  }
  elsif ( $line =~ m/.*\/(.*)\./ )
  {
    $line = $1;
  }
  else
  {
    print "Couldn't find pattern to name PAGE after" . $line . "\n";
    next;
  }
  $page = $line . ++$i;
  $scn_file = $line .$i . ".scn";

  print "writing scenario to file: $scn_file \n";
  if (open(SCN, ">$scn_file")) 
  {
    print SCN ("NPAGE $page\n");
    print SCN ("RGET $url\n");
    print SCN ("T0\n.");
    close(SCN);
  }
}

close URLS;

exit 0;
