/*
 *  DesktopPreferences.h: Interface and declarations for the DesktopPrefsView Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef DESKTOPPREFERENCES_H
#define DESKTOPPREFERENCES_H

#import <AppKit/NSView.h>

@class NSString;
@class NSColor;
@class NSTextField;
@class NSTextFieldCell;
@class NSSlider;
@class NSButton;
@class ColorsView;
@class GWorkspace;

@interface ColorsView : NSView
{
  NSColor *color;
}

- (void)setColor:(NSColor *)c;

@end

@interface DesktopPrefsView : NSView
{
  ColorsView *colorsView;
  NSColor *color;
  float r, g, b, alpha;
  NSTextFieldCell *cell;
	NSTextField *redlabel, *greenlabel, *bluelabel;
  NSSlider *redSlider, *greenSlider, *blueSlider;
  NSButton *setColorButt, *chooseButt, *setImageButt;
	NSTextField *chooseLabel;
	BOOL active;
	GWorkspace *gw;  
}

- (NSString *)prefsname;

- (void)setState:(id)sender;

- (void)makeColor:(id)sender;

- (void)setColor:(id)sender;

- (void)chooseImage:(id)sender;

- (void)unsetImage:(id)sender;

@end

#endif // DESKTOPPREFERENCES_H
