 /*  -*-objc-*-
 *  DefaultEditor.m: Implementation of the DefaultEditorView Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "DefaultEditor.h"
#include "GWorkspace.h"
#include "Functions.h"
#include "GNUstep.h"

@implementation DefaultEditorView

- (void)dealloc
{
  RELEASE (imView);
  RELEASE (nameLabel);
  RELEASE (noEditLabel);
  RELEASE (iconBox);
	RELEASE (chooseButt);
  TEST_RELEASE (defEditor);
  [super dealloc];
}

- (id)init
{
  self = [super init];
  if (self) {  
	  NSUserDefaults *defaults;
    NSString *fullPath;
    NSImage *image;
    NSFont *font;
        
    iconBox = [[NSBox alloc] initWithFrame: NSMakeRect(98, 95, 197, 93)];
    [iconBox setBorderType: NSGrooveBorder];
		[iconBox setTitle: NSLocalizedString(@"Default Editor", @"")];
    [iconBox setTitlePosition: NSAtTop];
		[iconBox setContentViewMargins: NSZeroSize]; 

		imView = [[NSImageView alloc] initWithFrame: NSMakeRect(74, 23, 48, 48)];
		[imView setImageFrameStyle: NSImageFrameNone];
		[imView setImageAlignment: NSImageAlignCenter];
		[imView setImageScaling: NSScaleNone];
		[iconBox addSubview: imView]; 

    font = [NSFont systemFontOfSize: 12];

		nameLabel = [[NSTextField alloc] initWithFrame: NSZeroRect];	
		[nameLabel setFont: font];
		[nameLabel setAlignment: NSCenterTextAlignment];
		[nameLabel setBackgroundColor: [NSColor whiteColor]];
		[nameLabel setBezeled: NO];
		[nameLabel setEditable: NO];
		[nameLabel setSelectable: NO];
    [iconBox addSubview: nameLabel]; 
    
		ws = [NSWorkspace sharedWorkspace];
    gw = [GWorkspace gworkspace];
    
    defaults = [NSUserDefaults standardUserDefaults];      
	  defEditor = [defaults stringForKey: @"defaulteditor"];
    if (defEditor != nil) {
      istheeditor = YES;
		  RETAIN (defEditor);
      
      fullPath = [ws fullPathForApplication: defEditor];
      image = [ws iconForFile: fullPath];
      [imView setImage: image];
      
	    [nameLabel setStringValue: defEditor];
	    [nameLabel setFrame: NSMakeRect(0, 0, [font widthOfString: defEditor] + 8, 14)];
      [nameLabel setFrameOrigin: NSMakePoint((197 - [nameLabel frame].size.width) / 2, 5)]; 
      
      [self addSubview: iconBox];       
      
    } else {
      istheeditor = NO;

		  noEditLabel = [[NSTextField alloc] initWithFrame: NSMakeRect(47, 150, 300, 20)];	
		  [noEditLabel setFont: [NSFont systemFontOfSize: 18]];
		  [noEditLabel setAlignment: NSCenterTextAlignment];
		  [noEditLabel setBackgroundColor: [NSColor windowBackgroundColor]];
		  [noEditLabel setTextColor: [NSColor grayColor]];	
		  [noEditLabel setBezeled: NO];
		  [noEditLabel setEditable: NO];
		  [noEditLabel setSelectable: NO];
		  [noEditLabel setStringValue: NSLocalizedString(@"No Default Editor", @"")];

      [self addSubview: noEditLabel];       
    }
    
		chooseButt = [[NSButton alloc] initWithFrame: NSMakeRect(138, 66, 118, 24)];
		[chooseButt setButtonType: NSMomentaryLight];
		[chooseButt setTitle: NSLocalizedString(@"Choose...", @"")];	
    [chooseButt setTarget: self];
    [chooseButt setAction: @selector(chooseEditor:)];	
		[self addSubview: chooseButt]; 
  }
  
  return self;
}

- (NSString *)prefsname
{
  return NSLocalizedString(@"Editor", @"");
}

- (void)chooseEditor:(id)sender
{
	NSOpenPanel *openPanel;
	NSArray *fileTypes;
	NSString *appName;
  NSString *app, *type;
	int result;

	fileTypes = [NSArray arrayWithObjects: @"app", @"debug", nil];
  
	openPanel = [NSOpenPanel openPanel];
	[openPanel setTitle: @"open"];	
  [openPanel setAllowsMultipleSelection: NO];
  [openPanel setCanChooseFiles: YES];
  [openPanel setCanChooseDirectories: NO];

  result = [openPanel runModalForDirectory: NSHomeDirectory() file: nil types: fileTypes];
	if(result != NSOKButton) {
		return;
  }
  
	appName = [NSString stringWithString: [openPanel filename]];
  
  [ws getInfoForFile: appName application: &app type: &type];
  
  if ([type isEqualToString: NSApplicationFileType] == NO) {
    NSRunAlertPanel(nil, 
        [NSString stringWithFormat: @"%@ is not a valid application!", appName], 
                            @"Continue", nil, nil);  
    return;
  }	
      
  [self setEditor: [appName lastPathComponent]];
}

- (void)setEditor:(NSString *)editor
{
  NSUserDefaults *defaults;
  NSImage *image;
  NSString *fullPath;
  NSFont *font;
  
  if ([editor isEqualToString: defEditor] == YES) {
    return;
  }
  
  if (istheeditor == NO) {  
    istheeditor = YES;
    [noEditLabel removeFromSuperview];
    [self addSubview: iconBox];       
  }
  
  ASSIGN (defEditor, editor);
  
  fullPath = [ws fullPathForApplication: defEditor];
  image = [ws iconForFile: fullPath];
  [imView setImage: image];
      
  [nameLabel setStringValue: defEditor];
  font = [NSFont systemFontOfSize: 12];
  [nameLabel setFrame: NSMakeRect(0, 0, [font widthOfString: defEditor] + 8, 14)];
  [nameLabel setFrameOrigin: NSMakePoint((197 - [nameLabel frame].size.width) / 2, 5)]; 
      
  [self setNeedsDisplay: YES];  

  defaults = [NSUserDefaults standardUserDefaults];      
	[defaults setObject: defEditor forKey: @"defaulteditor"];
	[defaults synchronize];
  
  [gw changeDefaultEditor: defEditor];
}

@end
