 /*  -*-objc-*-
 *  BrowserViewsPreferences.m: Implementation of the BrowserViewsPrefsView Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "BrowserViewsPreferences.h"
#include "GWorkspace.h"
#include "Functions.h"
#include "GNUstep.h"

@implementation ExampleView

- (void)drawRect:(NSRect)rect
{
  NSRect bounds = [self bounds];
  NSRect sbar = NSMakeRect(2, 2, 18, rect.size.height - 4);
  
  [super drawRect: rect];
  
  NSDrawGrayBezel(bounds, rect);
  
  [[NSColor scrollBarColor] set];
  NSRectFill (sbar);
  
	STROKE_LINE (blackColor, 20, 2, 20, rect.size.height - 2);
}

@end

@implementation Resizer

- (void)dealloc
{
  RELEASE (arrow);
  [super dealloc];
}

- (id)initInPrefView:(id)view
{
  self = [super init];
  [self setFrame: NSMakeRect(0, 0, 16, 16)];	  
  prefview = view;  
  ASSIGN (arrow, [NSImage imageNamed: @"RightArr.tiff"]);  
  return self;
}

- (void)mouseDown:(NSEvent *)theEvent
{
  [prefview mouseDownOnResizer: theEvent];
}

- (void)drawRect:(NSRect)rect
{
  [super drawRect: rect];
	[arrow compositeToPoint: NSZeroPoint operation: NSCompositeSourceOver];
}

@end

@implementation BrowserViewsPrefsView

- (void)dealloc
{
  RELEASE (exampleView);
  RELEASE (resizer);
  RELEASE (cell);
	RELEASE (setButt);
  [super dealloc];
}

- (id)init
{
  self = [super init];
  
  if (self) {  
    gw = [GWorkspace gworkspace];    

    columnsWidth = [gw browserColumnsWidth];

    [self setFrame: NSMakeRect(0, 0, 394, 270)];	  

    cell = [[NSTextFieldCell alloc] initTextCell: NSLocalizedString(@"Column Width", @"")];
    [cell setAlignment: NSCenterTextAlignment];
    [cell setBordered: NO];
    [cell setEditable: NO];
    [cell setDrawsBackground: YES];
        
    exampleView = [ExampleView new];
    [exampleView setFrame: NSMakeRect(74, 84, columnsWidth, 103)];    
		[self addSubview: exampleView]; 

    resizer = [[Resizer alloc] initInPrefView: self];
    [resizer setFrame: NSMakeRect(columnsWidth + 75, 127, 16, 16)];
		[self addSubview: resizer]; 

		setButt = [[NSButton alloc] initWithFrame: NSMakeRect(138, 44, 118, 24)];
		[setButt setButtonType: NSMomentaryLight];
		[setButt setTitle: NSLocalizedString(@"Use Default Settings", @"")];	
    [setButt setTarget: self];
    [setButt setAction: @selector(setDefaultWidth:)];	
    [setButt setEnabled: NO];
		[self addSubview: setButt]; 
  }
  
  return self;
}

- (NSString *)prefsname
{
  return NSLocalizedString(@"Browser", @"");
}

- (void)resizeParts
{
  [exampleView setFrame: NSMakeRect(74, 84, columnsWidth, 103)];    
  [resizer setFrame: NSMakeRect(columnsWidth + 75, 127, 16, 16)];  
  [self setNeedsDisplay: YES];
}

- (void)mouseDownOnResizer:(NSEvent *)theEvent
{
  NSApplication	*app = [NSApplication sharedApplication];
  NSDate *farAway = [NSDate distantFuture];
  int orx = (int)[self convertPoint: [theEvent locationInWindow] fromView: nil].x;
  unsigned int eventMask = NSLeftMouseUpMask | NSLeftMouseDraggedMask;
  int newWidth = (int)[exampleView frame].size.width;
  NSEvent	*e;
  
  [self lockFocus];
  [[NSRunLoop currentRunLoop] limitDateForMode: NSEventTrackingRunLoopMode];

  e = [app nextEventMatchingMask: eventMask
		                   untilDate: farAway
			                    inMode: NSEventTrackingRunLoopMode
			                   dequeue: YES];

  while ([e type] != NSLeftMouseUp) {
    int x = (int)[self convertPoint: [e locationInWindow] fromView: nil].x;
    int diff = x - orx;
    NSRect r = [resizer frame];  
    
    if ((newWidth + diff < 230) && (newWidth + diff > 120)) {                
      newWidth += diff;
      
      [resizer setFrameOrigin: NSMakePoint(r.origin.x + diff, 127)];
      [resizer setNeedsDisplay: YES];
      [self setNeedsDisplayInRect: r];

      [exampleView setFrame: NSMakeRect(74, 84, newWidth, 103)];    
      [exampleView setNeedsDisplay: YES];
      
      orx = x;
    }
    e = [app nextEventMatchingMask: eventMask
		                     untilDate: farAway
			                      inMode: NSEventTrackingRunLoopMode
			                     dequeue: YES];
  }
  [self unlockFocus];
  
  [self setNewWidth: (int)[exampleView frame].size.width];
  
  [setButt setEnabled: YES];
}

- (void)setNewWidth:(int)w
{
  columnsWidth = w;
  [gw setBrowserColumnsWidth: w];
}

- (void)setDefaultWidth:(id)sender
{
  columnsWidth = [gw defaultBrowserColumnsWidth];
  [self resizeParts];
  [setButt setEnabled: NO];
}

- (void)drawRect:(NSRect)rect
{
  NSRect r = NSMakeRect(67, 75, 259, 127);
  NSRect cellrect = NSMakeRect(153, 194, 87, 14);
  
  [super drawRect: rect];
  
  NSDrawGroove(r, r);
  
  [cell setBackgroundColor: [NSColor windowBackgroundColor]];
  [cell drawWithFrame: cellrect inView: self];
}

@end
