/*  -*-objc-*-
 *  InspectorsWin.m: Implementation of the InspectorsWin Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "InspectorsWin.h"
#include "InspectorsProtocol.h"
#include "AttributesPanel.h"
#include "ContentsPanel.h"
#include "PermissionsPanel.h"
#include "ToolsPanel.h"
#include "GWorkspace.h"
#include "Functions.h"
#include "GNUstep.h"

@implementation InspectorsWin

- (void)dealloc
{
	RELEASE (currentPaths);
	RELEASE (inspectors);
	RELEASE (inspectorsPopUp);
	RELEASE (topView);
  [super dealloc];
}

- (id)initWithInspectorsForPath:(NSArray *)paths
{
  id<InspectorsProtocol> inspector;

#define MAKE_INSPECTOR(i, n) \
inspector = [[i alloc] init];	\
[inspectorsPopUp addItemWithTitle: [inspector inspname]]; \
[inspectors addObject: inspector]; \
[(id)inspector release]
	
	self = [super initWithContentRect: NSZeroRect
						styleMask: NSTitledWindowMask | NSClosableWindowMask 
				  							backing: NSBackingStoreRetained defer: NO];
	if(self) {
    if ([self setFrameUsingName: @"inspectorsWin"] == NO) {
      [self setFrame: NSMakeRect(100, 100, 276, 446) display: NO];
    }            
		[self setReleasedWhenClosed: NO];
		ASSIGN (currentPaths, paths);
		
		topView = [[NSView alloc] init];			
	  [topView setFrame: NSMakeRect(0, 385, 274, 37)];
		[[self contentView] addSubview: topView];
		
		inspectorsPopUp = [[NSPopUpButton alloc] initWithFrame: NSZeroRect pullsDown: NO];
	  [inspectorsPopUp setFrame: NSMakeRect(81, 8, 112, 20)];
		[inspectorsPopUp setTarget: self];
		[inspectorsPopUp setAction: @selector(activateInspector:)];
		
		inspectors = [[NSMutableArray alloc] initWithCapacity: 1];
		currentInspector = nil;

		MAKE_INSPECTOR([AttributesPanel class], 0);
		MAKE_INSPECTOR([ContentsPanel class], 0);
		MAKE_INSPECTOR([PermissionsPanel class], 0);
		MAKE_INSPECTOR([ToolsPanel class], 0);

		[topView addSubview: inspectorsPopUp];				      					
		[inspectorsPopUp selectItemAtIndex: 0];
		[self activateInspector: inspectorsPopUp];
	}
	return self;
}

- (void)setPaths:(NSArray *)paths
{
	if (paths == nil) {
		return;
	}
	if([currentPaths isEqualToArray: paths] == YES) {
		return;
	}
	ASSIGN (currentPaths, paths);
	[currentInspector activateForPaths: currentPaths];
}

- (void)activateInspector:(id)sender
{
	NSString *inspectorName = [sender titleOfSelectedItem];
	int i;
	
	if(currentInspector != nil) {
		if([[currentInspector inspname] isEqualToString: inspectorName] == YES) {
			return;
    }
		[currentInspector deactivate];
	}
	
	for (i = 0; i < [inspectors count]; i++) {
		id<InspectorsProtocol> inspector = [inspectors objectAtIndex: i];		
		if([[inspector inspname] isEqualToString: inspectorName]) {
			currentInspector = inspector;
			break;
		}
	}

	[currentInspector activateForPaths: currentPaths];
	[self setTitle: [currentInspector winname]];
	[[self contentView] addSubview: currentInspector];							
	[self orderFrontRegardless];
	[currentInspector display];	
}

- (void)showAttributes
{
  [inspectorsPopUp selectItemWithTitle: NSLocalizedString(@"Attributes", @"")];
  [self activateInspector: inspectorsPopUp];
}

- (void)showContents
{
  [inspectorsPopUp selectItemWithTitle: NSLocalizedString(@"Contents", @"")];
  [self activateInspector: inspectorsPopUp];
}

- (void)showTools
{
  [inspectorsPopUp selectItemWithTitle: NSLocalizedString(@"Tools", @"")];
  [self activateInspector: inspectorsPopUp];
}

- (void)showPermissions
{
  [inspectorsPopUp selectItemWithTitle: NSLocalizedString(@"Access Control", @"")];
  [self activateInspector: inspectorsPopUp];
}

- (NSArray *)currentPaths
{
	return currentPaths;
}

- (void)updateDefaults
{
  [self saveFrameUsingName: @"inspectorsWin"];
}

- (void)close
{
  [self updateDefaults];
	[super close];
	[[GWorkspace gworkspace] closeInspectors];
}

- (BOOL)validateMenuItem:(id <NSMenuItem>)menuItem
{
	return YES;
}
	
@end
