/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Mon Jan  7 12:56:44 EST 2002
    copyright            : (C) 1999-2002 by Jacques Fortier & Brian Ashe
    email                : gtkpool@seul.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <gtk/gtk.h>
#include "application.h"
#include "options.h"
#include "sound.h"

// FPS (Frames Per Second) This sets the heartbeat of the program.
const int FPS=64;

// Events to handle the buttons on top (and bottom somday)
void destroy_event(GtkWidget *widget, gpointer data);
void restart_event(GtkWidget *widget, gpointer data);
void replace_event(GtkWidget *widget, gpointer data);
void set_cue(GtkWidget *widget, gpointer data);
void options_event(GtkWidget *widget, gpointer data);
void toggle_event(GtkWidget *widget, gpointer data);
void entry_activate_event(GtkWidget *widget, Application *);
void connect_event(GtkWidget *widget, Application *);

// Shutdown
gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data);

gint configure_event(GtkWidget *widget, GdkEventConfigure *event);
gint expose_event(GtkWidget *widget, GdkEventExpose *event);
gint motion_notify_event(GtkWidget *widget, GdkEventMotion *event);
gint button_press_event(GtkWidget *widget, GdkEventButton *event);
gint button_release_event(GtkWidget *widget, GdkEventButton *event);
gint timeout_event(gpointer widget);

gint rack_expose_event(GtkWidget *widget, GdkEventExpose *event);

void usage();

// connect dialog stuff
void setup_connect_dialog(ConnectDialog *cd);
void cd_connect_event(GtkWidget *widget, Application *);
void cd_close_event(GtkWidget *widget, GtkWidget *);
void cd_destroy_event(GtkWidget *widget, Application *);


gint old_width, old_height;
bool debug = true;

Application app;

int main(int argc, char *argv[])
{
//	gboolean success[7];
	GtkWidget *window;
	GtkWidget *button;
	GtkWidget *parent_box;
	GtkWidget *top_box;
	GtkWidget *bottom_box;
	GtkWidget *entry;

	app.sound = true;

	old_width = old_height = 0;

	gtk_init(&argc, &argv);

	// setup main window
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window), "GtkPool");
	gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
	gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
	gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(destroy_event), NULL);
	gtk_signal_connect(GTK_OBJECT(window), "delete_event", GTK_SIGNAL_FUNC(delete_event), NULL);
	gtk_container_set_border_width(GTK_CONTAINER(window), 10);

	// start setting up boxes
	parent_box = gtk_vbox_new(FALSE, 0);
	top_box = gtk_hbox_new(TRUE, 0);
	bottom_box = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(window), parent_box);
	gtk_box_pack_start(GTK_BOX(parent_box), top_box, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent_box), bottom_box, FALSE, FALSE, 0);

	// setup drawing_area -- where pool table will be displayed
	app.drawing_area = gtk_drawing_area_new();
	gtk_signal_connect(GTK_OBJECT(app.drawing_area),"configure_event",
	                   GTK_SIGNAL_FUNC(configure_event), NULL);
	gtk_signal_connect(GTK_OBJECT(app.drawing_area),"expose_event",
	                   GTK_SIGNAL_FUNC(expose_event), NULL);
	gtk_signal_connect(GTK_OBJECT(app.drawing_area),"motion_notify_event",
	                   GTK_SIGNAL_FUNC(motion_notify_event), NULL);
	app.button_press_handler_id = gtk_signal_connect(GTK_OBJECT(app.drawing_area),
	          "button_press_event",GTK_SIGNAL_FUNC(button_press_event), NULL);
	app.qbp_hndlr = gtk_signal_connect(GTK_OBJECT(app.drawing_area),
	          "button_press_event",GTK_SIGNAL_FUNC(Application::cue_ball_placed),
			&app);
	gtk_signal_handler_block(GTK_OBJECT(app.drawing_area), app.qbp_hndlr);
	gtk_signal_connect(GTK_OBJECT(app.drawing_area),"button_release_event",
	                   GTK_SIGNAL_FUNC(button_release_event), NULL);
	gtk_widget_set_events (app.drawing_area, GDK_EXPOSURE_MASK
	                                   | GDK_LEAVE_NOTIFY_MASK
								| GDK_BUTTON_PRESS_MASK
								| GDK_BUTTON_RELEASE_MASK
								| GDK_POINTER_MOTION_MASK
								| GDK_POINTER_MOTION_HINT_MASK);
	gtk_drawing_area_size(GTK_DRAWING_AREA(app.drawing_area), app.width, app.height);

	app.rack_area = gtk_drawing_area_new();
	gtk_signal_connect(GTK_OBJECT(app.rack_area),"expose_event",
	                   GTK_SIGNAL_FUNC(rack_expose_event), NULL);
	gtk_widget_set_events (app.rack_area, GDK_EXPOSURE_MASK);
	gtk_drawing_area_size(GTK_DRAWING_AREA(app.rack_area), app.width, 70);


	// setup buttons that go along top of window -- quit pause restart
	button = gtk_button_new_with_label("Quit");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
	                   GTK_SIGNAL_FUNC(destroy_event), NULL);
	gtk_box_pack_start(GTK_BOX(top_box), button, TRUE, TRUE, 0);
	gtk_widget_show(button);
	button = gtk_toggle_button_new_with_label("Pause");
	gtk_signal_connect(GTK_OBJECT(button), "toggled",
	                   GTK_SIGNAL_FUNC(toggle_event), app.drawing_area);
	gtk_box_pack_start(GTK_BOX(top_box), button, TRUE, TRUE, 0);
	gtk_widget_show(button);
	button = gtk_button_new_with_label("Options");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
	                   GTK_SIGNAL_FUNC(options_event), NULL);
	gtk_box_pack_start(GTK_BOX(top_box), button, TRUE, TRUE, 0);
	gtk_widget_show(button);
	button = gtk_button_new_with_label("Restart");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
	                   GTK_SIGNAL_FUNC(restart_event), NULL);
	gtk_box_pack_start(GTK_BOX(top_box), button, TRUE, TRUE, 0);
	gtk_widget_show(button);
	button = gtk_button_new_with_label("Replace");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
	                   GTK_SIGNAL_FUNC(replace_event), NULL);
	gtk_box_pack_start(GTK_BOX(top_box), button, TRUE, TRUE, 0);
	gtk_widget_show(button);
	button = gtk_button_new_with_label("Set Cue Ball");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
	                   GTK_SIGNAL_FUNC(set_cue), NULL);
	gtk_box_pack_start(GTK_BOX(top_box), button, TRUE, TRUE, 0);
	gtk_widget_show(button);

/*	button = gtk_button_new_with_label("Connect");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
	                   GTK_SIGNAL_FUNC(connect_event), &app);
	gtk_box_pack_start(GTK_BOX(top_box), button, TRUE, TRUE, 0);
	gtk_widget_show(button);*/

	//setup chat box for multiplayer
	app.chat_text = gtk_text_new(NULL, NULL);
	gtk_widget_set_usize(app.chat_text, -2, 100);
	gtk_text_set_editable(GTK_TEXT(app.chat_text), FALSE);
	gtk_text_set_word_wrap(GTK_TEXT(app.chat_text), TRUE);
//	gtk_widget_show(app.chat_text);
//	networking not ready for this version

	entry = gtk_entry_new();
	gtk_signal_connect(GTK_OBJECT(entry), "activate",
	                   GTK_SIGNAL_FUNC(entry_activate_event), &app);
//	gtk_widget_show(entry);
//	networking not ready for this version

	gtk_box_pack_start(GTK_BOX(bottom_box), app.drawing_area, TRUE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(bottom_box), app.rack_area, TRUE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(bottom_box), app.chat_text, TRUE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(bottom_box), entry, TRUE, FALSE, 0);
	gtk_widget_show(app.drawing_area);
	gtk_widget_show(app.rack_area);

	gtk_widget_show(top_box);
	gtk_widget_show(bottom_box);
	gtk_widget_show(parent_box);

	app.init();

	gtk_widget_show  (window);

	app.print_message("gtkpool version 0.3.6, Copyright (C) 1999 Jacques Fortier");
	app.print_message("This is free software, and you are welcome to redistribute it under certain conditions.  However, it comes with ABSOLUTELY NO WARRANTY; for details see the file 'COPYING'.");

	app.running = true;
	gtk_timeout_add(1024 / FPS, GtkFunction(timeout_event), app.drawing_area);
	gtk_main ();

	return(0);

}

gint expose_event (GtkWidget *widget, GdkEventExpose *event)
{
	gdk_draw_pixmap(widget->window, widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
	                app.buf_pixmap, event->area.x, event->area.y, event->area.x,
				 event->area.y, event->area.width, event->area.height);
	return FALSE;
}

gint configure_event(GtkWidget *widget, GdkEventConfigure *event)
{
	if(old_width != widget->allocation.width || old_height != widget->allocation.height)
	{
		if(app.buf_pixmap)
			gdk_pixmap_unref(app.buf_pixmap);
		app.buf_pixmap = gdk_pixmap_new(widget->window, widget->allocation.width,
		                                widget->allocation.height, -1);
		app.gc = gdk_gc_new(widget->window);
		gdk_gc_set_foreground(app.gc, app.black);
		gdk_draw_rectangle(app.buf_pixmap, app.gc, 1, 0, 0,
		                   widget->allocation.width, widget->allocation.height);
		app.paint(app.buf_pixmap, app.gc);
		gdk_gc_unref(app.gc);
		old_width = widget->allocation.width; old_height = widget->allocation.height;
	}
	return TRUE;
}


gint motion_notify_event(GtkWidget *widget, GdkEventMotion *event)
{
	int x, y;
	GdkModifierType state;
	if(event->is_hint)
		gdk_window_get_pointer(widget->window, &x, &y, &state);
	else
	{
		x = int(event->x); y = int(event->y);
		state = (GdkModifierType)event->state;
	}
	if(state & GDK_BUTTON1_MASK && app.running)
		app.mouse_drag(x, y);
	return TRUE;
}


gint button_press_event(GtkWidget *widget, GdkEventButton *event)
{
	if(event->button == 1 && app.running)
	{
		app.mouse_down(int(event->x), int(event->y));
		gtk_grab_add(widget);
	}
	return TRUE;
}
gint button_release_event(GtkWidget *widget, GdkEventButton *event)
{
	if(event->button == 1 && app.running)
	{
		app.mouse_up(int(event->x), int(event->y));
		gtk_grab_remove(widget);
	}
	return TRUE;
}


void destroy_event(GtkWidget *widget, gpointer data)
{
	app.running = false;
	app.destroy();
	gtk_main_quit();
}

void replace_event(GtkWidget *widget, gpointer data)
{
	app.replaceBall();
}
				
void set_cue(GtkWidget *widget, gpointer data)
{				
	app.ball_in_hand();
}

void restart_event(GtkWidget *widget, gpointer data)
{
	app.resetTable();
}

void options_event(GtkWidget *widget, gpointer data)
{
	if(app.opt_dlg == (GtkWidget *)NULL) {
		app.opt_dlg = open_opt_dlg(&app);
		gtk_widget_show(app.opt_dlg);
	} else
	{
		gtk_widget_show(app.opt_dlg);
	}
}

gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	return FALSE; // okay to close down--could later add ok to quit thing
}

void toggle_event(GtkWidget *widget, gpointer data)
{
	if(GTK_TOGGLE_BUTTON(widget)->active)
	{
		app.running = false; // pause the game
	}
	else
	{
		app.running = true; // unpause
		gtk_timeout_add(1024 / FPS, GtkFunction(timeout_event),
		                GTK_WIDGET(data)); // data = drawing_area
	}
}

/*******************************************************************
This is the function that controls the beat of the game.  Every time
it is called, it moves everything one animation frame and then updates
the screen.  It uses a sort of "compromise dirty rectangle" system.
The buffer is updated at every iteration, but only the parts of the
buffer that have changed are copied to the screen.
*******************************************************************/
gint timeout_event(gpointer widget)
{
	if(!app.running)
		return FALSE; // no more timeouts, no more animation
	app.updateBalls();
	if(udl != -1)
	{
		GdkRectangle ud_rect;
		ud_rect.x = udl; ud_rect.width  = udr - udl;
		ud_rect.y = udt; ud_rect.height = udb - udt;
		app.gc = gdk_gc_new(GTK_WIDGET(widget)->window);
		app.paint(app.buf_pixmap, app.gc);
		gdk_gc_unref(app.gc);
		gtk_widget_draw(GTK_WIDGET(widget), &ud_rect);
		udl = -1;
	}
	if(app.collide_tf && app.sound)
		play_sound(app.coll_snd, app.coll_sndc);
	return TRUE; // keep them timeouts coming
}

gint rack_expose_event (GtkWidget *widget, GdkEventExpose *event)
{
	int c = 0;
	GdkGC *gc = gdk_gc_new(widget->window);
	gdk_gc_set_foreground(gc, app.black);
	gdk_draw_rectangle(widget->window, gc, 1, event->area.x, event->area.y,
	                   event->area.width, event->area.height);
	gdk_gc_set_clip_mask(gc, app.rack_mask);
	gdk_gc_set_clip_origin(gc, (app.width - 256) / 2, 3);

	for(vector<int>::iterator i = app.sunk_balls1.begin();
	    i < app.sunk_balls1.end(); i++)
	{
		// draw each sunk ball onto the rack, in the order it was sunk
		int rx = c * 36 + 3; // 32 pixels for the ball image, plus 4 for spacing, and a 3 px border
		int ry = 3;
		gdk_gc_set_clip_mask(gc, app.balls_big_pixmap_masks[*i]);
		gdk_gc_set_clip_origin(gc, rx, ry);
		gdk_draw_pixmap(widget->window, gc, app.balls_big_pixmaps[*i], 0, 0, rx, ry, 32, 32);
		c++;
	}
	c = 0;
	for(vector<int>::iterator i = app.sunk_balls2.begin();
	    i < app.sunk_balls2.end(); i++)
	{
		// draw each sunk ball onto the rack, in the order it was sunk
		int rx = c * 36 + 3; // 32 pixels for the ball image, plus 4 for spacing, and a 3 px border
		int ry = 3 + 36; // second row
		gdk_gc_set_clip_mask(gc, app.balls_big_pixmap_masks[*i]);
		gdk_gc_set_clip_origin(gc, rx, ry);
		gdk_draw_pixmap(widget->window, gc, app.balls_big_pixmaps[*i], 0, 0, rx, ry, 32, 32);
		c++;
	}

	gdk_gc_unref(gc);
	return FALSE;
}

void entry_activate_event(GtkWidget *widget, Application *app)
{
	if(app->connected)
	{
		app->print_message(gtk_entry_get_text(GTK_ENTRY(widget)), 4);
	}
	else
		app->print_message("You are not currently in a network game");
	gtk_entry_set_text(GTK_ENTRY(widget), "");
}

void connect_event(GtkWidget *widget, Application *app)
{
	if(app->connect_dialog)
		return;
	app->connect_dialog = new ConnectDialog;
	setup_connect_dialog(app->connect_dialog);
}

void setup_connect_dialog(ConnectDialog *cd)
{
	cd->dialog = gtk_dialog_new();
//	GtkWidget *button;
	GtkWidget *table;;
	GtkWidget *label;
//	GtkWidget *hbox;
//	GtkWidget *frame;
//	GtkWidget *btn_box;
//	GSList *group;
	gtk_window_set_title(GTK_WINDOW(cd->dialog), "Multiplayer Setup");

	// setup table
	table = gtk_table_new(4, 2, FALSE);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(cd->dialog)->vbox), table, TRUE, TRUE, 0);
	gtk_widget_show(table);

	label = gtk_label_new("Hostname");
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);
	gtk_widget_show(label);
	label = gtk_label_new("Port");
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);
	gtk_widget_show(label);
	label = gtk_label_new("Handle");
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 2, 3);
	gtk_widget_show(label);

	cd->host_entry = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(table), cd->host_entry, 1, 2, 0, 1);
	gtk_widget_show(cd->host_entry);

	cd->port_entry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(cd->port_entry), "9874");
	gtk_table_attach_defaults(GTK_TABLE(table), cd->port_entry, 1, 2, 1, 2);
	gtk_widget_show(cd->port_entry);

	cd->handle_entry = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(table), cd->handle_entry, 1, 2, 2, 3);
	gtk_widget_show(cd->handle_entry);

	cd->connect_button = gtk_button_new_with_label("Connect");
	gtk_signal_connect(GTK_OBJECT(cd->connect_button), "clicked",
	                   GTK_SIGNAL_FUNC(cd_connect_event), &app);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(cd->dialog)->action_area), cd->connect_button,
	                   TRUE, TRUE, 0);
	gtk_widget_show(cd->connect_button);

	cd->cancel_button = gtk_button_new_with_label("Cancel");
	gtk_signal_connect(GTK_OBJECT(cd->cancel_button), "clicked",
	                   GTK_SIGNAL_FUNC(cd_close_event), cd->dialog);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(cd->dialog)->action_area), cd->cancel_button,
	                   TRUE, TRUE, 0);
	gtk_widget_show(cd->cancel_button);

//	gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
	gtk_signal_connect(GTK_OBJECT(cd->dialog), "destroy", GTK_SIGNAL_FUNC(cd_destroy_event), &app);
//	gtk_signal_connect(GTK_OBJECT(window), "delete_event", GTK_SIGNAL_FUNC(delete_event), NULL);

	gtk_widget_show(cd->dialog);
}

void cd_connect_event(GtkWidget *widget, Application *app)
{
	if(!strlen(gtk_entry_get_text(GTK_ENTRY(app->connect_dialog->host_entry))))
	{
		app->print_message("You must specify a host to connect to");
	}
	else if(!strlen(gtk_entry_get_text(GTK_ENTRY(app->connect_dialog->port_entry))))
	{
		app->print_message("You must specify a port to connect to");
	}
	else if(!strlen(gtk_entry_get_text(GTK_ENTRY(app->connect_dialog->handle_entry))))
	{
		app->print_message("You must give yourself a handle");
	}
	else
	{
//connect
		app->print_message("Network mode unimplemented");
		gtk_widget_destroy(app->connect_dialog->dialog);
	}
}

void cd_close_event(GtkWidget *widget, GtkWidget *cd)
{
	gtk_widget_destroy(cd);
}

void cd_destroy_event(GtkWidget *widget, Application *app)
{
	delete app->connect_dialog;
	app->connect_dialog = NULL;
}


void usage()
{
	g_message("Usage not implemented right now.\n");
}
