/***************************************************************************
                          check_table_collision.cpp  -  description
                             -------------------
    begin                : Mon Jan 7 2002
    copyright            : (C) 1999-2002 by Jacques Fortier & Brian Ashe
    email                : gtkpool@seul.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "check_table_collision.h"

check_table_collision::check_table_collision(double &pei, double ptime, Ball *pbnc, GdkRectangle ptable) : ei(pei), time(ptime), table(ptable){
	bnc = pbnc;
}
check_table_collision::~check_table_collision(){
}
	
void check_table_collision::operator() (Ball &bb)
{
	if(bb.vel.dx == 0 && bb.vel.dy == 0)
		return;
	double eb = bb.edgeIntercept(table);
	if(eb < ei && eb < time)
	{
		ei = eb;
		bnc = &bb;
	}
}
	
