/***************************************************************************
                          ball.h  -  description
                             -------------------
    begin                : Tue Jan 8 2002
    copyright            : (C) 1999-2002 by Jacques Fortier & Brian Ashe
    email                : gtkpool@seul.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BALL_H
#define BALL_H
#define CUE 0
#define YELLOW 1
#define BLUE 2
#define RED 3
#define PURPLE 4
#define ORANGE 5
#define GREEN 6
#define BROWN 7
#define EIGHT 8

#define YELLOW_S 9
#define BLUE_S 10
#define RED_S 11
#define PURPLE_S 12
#define ORANGE_S 13
#define GREEN_S 14
#define BROWN_S 15

#define NUM_BALLS 16

#define TABLE_MA 0
#define TABLE_MB 1
#define TABLE_BL 2
#define TABLE_BP 3

const int BALL_SIZE = 16;

#include "point2d.h"
#include "vec2d.h"
#include "check_table_collision.h"
#include "move_balls.h"
#include "apply_friction.h"
#include "draw_ball.h"
#include "pointer_selects.h"
#include "check_pocket.h"
#include "support.h"

class Point2D;

/**
  *@author Brian Ashe
  */

void update_dirty(int, int, int, int);

class Ball : public Point2D  {
public: 
	int diam;
	double radius;
	Vec2D vel;
	double hCol, vCol;
	bool is_cue, is_eight, is_nine, is_solid, is_stripe;
	GdkPixmap *picture;
	GdkBitmap *clip_bmp;
	GdkPixmap *big_picture;
	GdkPixmap *big_clip_bmp;
	int ball_num;
	Vec2D bnc;
	Vec2D tvec;
	GdkColor *clr;

	Ball(void);
	Ball (double x, double y, int d, GdkColor *c, bool isq = false, bool ise = false, bool isn = false, bool isso = false, bool isst = false);
	Ball (double x, double y, int d, int bn, GdkPixmap *pixmap, GdkBitmap *c_bmp, GdkPixmap *b_pixmap, GdkBitmap *b_clip_bmp, bool isq = false, bool ise = false, bool isn = false, bool isso = false, bool isst = false);
	bool moving ();
	void decel (double val);
	double pathIntercept (Ball b);
	void collide (Ball *b, double);
	double edgeIntercept (GdkRectangle bd);
	void bounce (double t, double);
	void move (double t);
	void draw (GdkDrawable *pixmap, GdkGC *gc) const;
	void shoot (Point2D ptr);
	bool touches (int mx, int my);
	~Ball();
};

#endif
