/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */


#include "gstalker.h"


/*****************************************************************************************
draw the chart grid.
**************************************************************************************/
void 
draw_grid ()
{
  GdkColor *color;
  GdkGC *gc;
  GString *tstring;
  gint tint, x, tint2, tint3, current_width, current_height, pixelspace, records, wmflag=0;
  guint tuint, oldmonth=0, newmonth=0, oldyear=0, newyear=0;
  extern GtkWidget *chart;
  extern GdkPixmap *chart_pixmap;
  extern struct record config;
  gfloat tfloat, tfloat2, interval, y = 0;
  extern gfloat range, maxhigh, maxlow;
  extern GArray *date_array;
  extern gint current_records, current_line_pixelspace, current_ohlc_pixelspace, array_size;
  


  
  tstring = g_string_new (NULL);
  
  gc = gdk_gc_new (chart->window);
  color = (GdkColor *) malloc (sizeof (GdkColor));
  color->red = config.grid_red << 8;
  color->green = config.grid_green << 8;
  color->blue = config.grid_blue << 8;
  gdk_color_alloc (gtk_widget_get_colormap (chart), color);
  gdk_gc_set_foreground (gc, color);

  current_width = chart->allocation.width;
  current_height = chart->allocation.height - DATE_SIZE;

  if (config.style == 0)
    pixelspace = current_line_pixelspace;
  else
    pixelspace = current_ohlc_pixelspace;
    
  g_string_sprintf (tstring, "%ld", g_array_index(date_array, glong, 0));

  if (strstr(config.chart_type, "Daily"))
  {
  	if (config.bars)
  	{
  		/* get the smallest number of data to load, either total records or maximum */
      		if (current_records < config.bars)
			records = current_records;
      		else
			records = config.bars;
	}
	else
		records = current_records;
		
  	g_string_erase (tstring, 0, 4);
  	g_string_truncate (tstring, 2);
  	oldmonth = atoi(tstring->str);
  }
  else
  {
	records = array_size;
	g_string_truncate (tstring, 4);
  	oldyear = atoi(tstring->str);
  	wmflag++;
  }    
  
  for (tuint = 0; tuint < records; tuint++)
    {
      g_string_sprintf (tstring, "%ld", g_array_index(date_array, glong, tuint));
      
      if (wmflag)
      {
      	g_string_truncate (tstring, 4);
  	newyear = atoi(tstring->str);
      }
      else
      {
      	g_string_erase (tstring, 0, 4);
      	g_string_truncate (tstring, 2);
      	newmonth = atoi(tstring->str);
      }
      
      if (wmflag)
      {
      	if (oldyear != newyear)
	{
	  	oldyear = newyear;
	  	x = tuint * pixelspace;
	  	tint = 1;
	  	while (tint < current_height)
	  	{
	      		gdk_draw_point (chart_pixmap, gc, x, tint);
	      		tint = tint + 4;
	  	}
	}
      }
      else
      {
	if (oldmonth != newmonth)
	{
	  	oldmonth = newmonth;
	  	x = tuint * pixelspace;
	  	tint = 1;
	  	while (tint < current_height)
	  	{
	      		gdk_draw_point (chart_pixmap, gc, x, tint);
	      		tint = tint + 4;
	  	}
	}
      }

    }
    
  if (range < 1)
    {
      interval = 0.1;
      if (range / interval < 10)
	{
	  for (interval = 0.0025; (range / interval) >= 10; interval = interval + 0.0025)
	    {
	    }
	}
    }
  else
    {
      if (range < 10)
	{
	  interval = 1;
	  if (range / interval < 10)
	    {
	      for (interval = 0.1; (range / interval) >= 10; interval = interval + 0.1)
		{
		}
	    }
	}
      else
	{
	  if (range < 50)
	    {
	      interval = 5;
	      if (range / interval < 10)
		{
		  for (interval = 1; (range / interval) >= 10; interval = interval + 1)
		    {
		    }
		}
	    }
	  else
	    {
	      if (range < 100)
		{
		  interval = 10;
		  if (range / interval < 10)
		    {
		      for (interval = 5; (range / interval) >= 10; interval = interval + 1)
			{
			}
		    }
		}
	      else
		{
		  if (range < 500)
		    {
		      interval = 50;
		      if (range / interval < 10)
			{
			  for (interval = 25; (range / interval) >= 10; interval = interval + 5)
			    {
			    }
			}
		    }
		  else
		    {
		      if (range < 1000)
			{
			  interval = 100;
			  if (range / interval < 10)
			    {
			      for (interval = 50; (range / interval) >= 10; interval = interval + 10)
				{
				}
			    }
			}
		      else
			{
			  if (range < 5000)
			    {
			      interval = 500;
			      if (range / interval < 10)
				{
				  for (interval = 250; (range / interval) >= 10; interval = interval + 25)
				    {
				    }
				}
			    }
			  else
			    {
			      interval = 1000;
			    }
			}
		    }
		}
	    }
	}
    }
    
  if (config.volume_status)
  	current_height = current_height - VOLUME_SIZE;
  
  tint2 = (int) (maxlow / interval);
  for (tint = 1; tint < 10; tint++)
    {
      if (maxlow > 10)
	tfloat = (tint2 * interval) + (interval * tint);
      else
	tfloat = (tint2 * interval) + (interval * tint);
      tfloat2 = (maxhigh - tfloat) * (current_height / range);
      y = (int) tfloat2 + 2;
      tint3 = 1;
      while (tint3 < current_width)
	{
	  gdk_draw_point (chart_pixmap, gc, tint3, y - 2);
	  tint3 = tint3 + 4;
	}
    }
    
    g_string_free (tstring, TRUE);
}
/*****************************************************************************************
draw the date area on the chart.
****************************************************************************************/
void 
draw_date ()
{
  GdkColor *color;
  GdkGC *gc;
  GString *tstring, *tstring2, *tstring3, *monthstring;
  gint x, current_width, current_height, pixelspace, records;
  guint tuint, week=0, week2=0;
  GdkFont *font;
  GDateMonth oldmonth=0, newmonth=0;
  GDateYear oldyear=0, newyear=0;
  extern GDate *gdate;
  extern GdkPixmap *chart_pixmap;
  extern GtkWidget *chart;
  extern struct record config;
  extern GArray *date_array;
  extern gint current_records, current_line_pixelspace, current_ohlc_pixelspace, array_size;
  extern gchar *label_feb, *label_mar, *label_apr, *label_may, *label_jun, *label_jul, *label_aug;
  extern gchar *label_sep, *label_oct, *label_nov, *label_dec, *label_f, *label_m, *label_a;
  extern gchar *label_j, *label_s, *label_o, *label_n, *label_d;
  

  
  tstring = g_string_new (NULL);
  tstring2 = g_string_new (NULL);
  tstring3 = g_string_new (NULL);
  monthstring = g_string_new (NULL);
  
  gc = gdk_gc_new (chart->window);
  color = (GdkColor *) malloc (sizeof (GdkColor));
  color->red = config.border_red << 8;
  color->green = config.border_green << 8;
  color->blue = config.border_blue << 8;
  gdk_color_alloc (gtk_widget_get_colormap (chart), color);
  gdk_gc_set_foreground (gc, color);

  current_width = chart->allocation.width;
  current_height = chart->allocation.height - DATE_SIZE;
  font = gdk_font_load ("-Adobe-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-*");
  gdk_draw_line (chart_pixmap, gc, 0, current_height,
		 current_width, current_height);

  if (config.style == 0)
    pixelspace = current_line_pixelspace;
  else
    pixelspace = current_ohlc_pixelspace;

  g_string_sprintf (tstring, "%ld", g_array_index(date_array, glong, 0));
  
  create_gdate_from_string (tstring->str);
  
  if (strstr(config.chart_type, "Daily"))
  {
  	if (config.bars)
  	{
  		/* get the smallest number of data to load, either total records or maximum */
      		if (current_records < config.bars)
			records = current_records;
      		else
			records = config.bars;
	}
	else
		records = current_records;
		
  	week = g_date_monday_week_of_year (gdate);
  	oldmonth = g_date_month (gdate);
  }
  else
  {
  	if (strstr(config.chart_type, "Weekly"))
  	{
		records = array_size;
		oldmonth = g_date_month (gdate);
	}
	else
	{
		records = array_size;
		oldyear = g_date_year (gdate);
	}
  }
  
  for (tuint = 0; tuint < records; tuint++)
    {
      g_string_sprintf (tstring, "%ld", g_array_index(date_array, glong, tuint));
      
      create_gdate_from_string (tstring->str);
      
      if (strstr(config.chart_type, "Daily"))
      {
      	week2 = g_date_monday_week_of_year (gdate);
      	if ((week2 > week) || (week2 < week))
      	{
      		/* it's a monday so make a tick */
      		week = week2;
      		x = tuint * pixelspace;
		gdk_draw_line (chart_pixmap, gc, x, current_height, x, current_height + 3);
      	}
      }
      
      if (! strstr(config.chart_type, "Daily"))
      {
      	newyear = g_date_year (gdate);
      	if (newyear != oldyear)
      	{
      		oldyear = newyear;
	  	x = tuint * pixelspace;
	  	gdk_draw_line (chart_pixmap, gc, x, current_height, x, current_height + 6);
	  	g_string_assign (tstring2, tstring->str);
	      	g_string_truncate (tstring2, 4);
	      	gdk_draw_string(chart_pixmap,font,gc,x-13,current_height+16,tstring2->str);
      	}
      }
      else
      {
      	newmonth = g_date_month (gdate);
      	if (newmonth != oldmonth)
	{
	  oldmonth = newmonth;
	  x = tuint * pixelspace;
	  gdk_draw_line (chart_pixmap, gc, x, current_height, x, current_height + 6);
	  switch (newmonth)
	    {
	    case 1:
	      g_string_assign (tstring2, tstring->str);
	      g_string_truncate (tstring2, 4);
	      gdk_draw_string (chart_pixmap, font, gc, x - 13, current_height + 16, tstring2->str);
	      break;
	    case 2:
	      if (pixelspace > 2)
		{
		  g_string_assign (monthstring, label_feb);
		  x = x - 9;
		}
	      else
		{
		  g_string_assign (monthstring, label_f);
		  x = x - 4;
		}
	      gdk_draw_string (chart_pixmap, font, gc, x, current_height + 16, monthstring->str);
	      break;
	    case 3:
	      if (pixelspace > 2)
		{
		  g_string_assign (monthstring, label_mar);
		  x = x - 13;
		}
	      else
		{
		  g_string_assign (monthstring, label_m);
		  x = x - 5;
		}
	      gdk_draw_string (chart_pixmap, font, gc, x, current_height + 16, monthstring->str);
	      break;
	    case 4:
	      if (pixelspace > 2)
		{
		  g_string_assign (monthstring, label_apr);
		  x = x - 9;
		}
	      else
		{
		  g_string_assign (monthstring, label_a);
		  x = x - 4;
		}
	      gdk_draw_string (chart_pixmap, font, gc, x, current_height + 16, monthstring->str);
	      break;
	    case 5:
	      if (pixelspace > 2)
		{
		  g_string_assign (monthstring, label_may);
		  x = x - 13;
		}
	      else
		{
		  g_string_assign (monthstring, label_m);
		  x = x - 5;
		}
	      gdk_draw_string (chart_pixmap, font, gc, x, current_height + 16, monthstring->str);
	      break;
	    case 6:
	      if (pixelspace > 2)
		{
		  g_string_assign (monthstring, label_jun);
		  x = x - 9;
		}
	      else
		{
		  g_string_assign (monthstring, label_j);
		  x = x - 5;
		}
	      gdk_draw_string (chart_pixmap, font, gc, x, current_height + 16, monthstring->str);
	      break;
	    case 7:
	      if (pixelspace > 2)
		{
		  g_string_assign (monthstring, label_jul);
		  x = x - 10;
		}
	      else
		{
		  g_string_assign (monthstring, label_j);
		  x = x - 5;
		}
	      gdk_draw_string (chart_pixmap, font, gc, x, current_height + 16, monthstring->str);
	      break;
	    case 8:
	      if (pixelspace > 2)
		{
		  g_string_assign (monthstring, label_aug);
		  x = x - 10;
		}
	      else
		{
		  g_string_assign (monthstring, label_a);
		  x = x - 4;
		}
	      gdk_draw_string (chart_pixmap, font, gc, x, current_height + 16, monthstring->str);
	      break;
	    case 9:
	      if (pixelspace > 2)
		{
		  g_string_assign (monthstring, label_sep);
		  x = x - 11;
		}
	      else
		{
		  g_string_assign (monthstring, label_s);
		  x = x - 5;
		}
	      gdk_draw_string (chart_pixmap, font, gc, x, current_height + 16, monthstring->str);
	      break;
	    case 10:
	      if (pixelspace > 2)
		{
		  g_string_assign (monthstring, label_oct);
		  x = x - 11;
		}
	      else
		{
		  g_string_assign (monthstring, label_o);
		  x = x - 5;
		}
	      gdk_draw_string (chart_pixmap, font, gc, x, current_height + 16, monthstring->str);
	      break;
	    case 11:
	      if (pixelspace > 2)
		{
		  g_string_assign (monthstring, label_nov);
		  x = x - 10;
		}
	      else
		{
		  g_string_assign (monthstring, label_n);
		  x = x - 5;
		}
	      gdk_draw_string (chart_pixmap, font, gc, x, current_height + 16, monthstring->str);
	      break;
	    case 12:
	      if (pixelspace > 2)
		{
		  g_string_assign (monthstring, label_dec);
		  x = x - 10;
		}
	      else
		{
		  g_string_assign (monthstring, label_d);
		  x = x - 5;
		}
	      gdk_draw_string (chart_pixmap, font, gc, x, current_height + 16, monthstring->str);
	      break;
	    default:
	      break;
	    }
	}
      }
    }
    g_string_free (tstring, TRUE);
    g_string_free (tstring2, TRUE);
    g_string_free (tstring3, TRUE);
    g_string_free (monthstring, TRUE);
}
/*********************************************************************************
draw the volume indicator.
********************************************************************************/
void 
draw_volume ()
{
  GdkColor *color;
  GdkGC *gc;
  gint tint, tint2, red=0, green=0, blue=0, current_width, current_height, pixelspace, records;
  guint tuint;
  gulong tlong;
  gfloat percent;
  extern GdkPixmap *chart_pixmap;
  extern GtkWidget *chart;
  extern glong volume_high;
  extern struct record config;
  extern GArray *volume_array;
  extern gint current_records, current_line_pixelspace, current_ohlc_pixelspace, array_size;
  


  gc = gdk_gc_new (chart->window);
  color = (GdkColor *) malloc (sizeof (GdkColor));
  color->red = config.border_red << 8;
  color->green = config.border_green << 8;
  color->blue = config.border_blue << 8;
  gdk_color_alloc (gtk_widget_get_colormap (chart), color);
  gdk_gc_set_foreground (gc, color);

  current_width = chart->allocation.width;
  current_height = chart->allocation.height - DATE_SIZE;
  gdk_draw_line (chart_pixmap, gc, 0, current_height - VOLUME_SIZE,
		 current_width, current_height - VOLUME_SIZE);

  red = config.volume_red;
  green = config.volume_green;
  blue = config.volume_blue;

  color->red = red << 8;
  color->green = green << 8;
  color->blue = blue << 8;
  gdk_color_alloc (gtk_widget_get_colormap (chart), color);
  gdk_gc_set_foreground (gc, color);

  if (config.style == 0)
    pixelspace = current_line_pixelspace;
  else
    pixelspace = current_ohlc_pixelspace;
    
  if (strstr(config.chart_type, "Daily"))
  {
  	if (config.bars)
  	{
  		/* get the smallest number of data to load, either total records or maximum */
      		if (current_records < config.bars)
			records = current_records;
      		else
			records = config.bars;
	}
	else
		records = current_records;
  }
  else
	records = array_size;

  tint = 0;
  percent = volume_high / (VOLUME_SIZE - 1);
  for (tuint = 0; tuint < records; tuint++)
    {
      tlong = g_array_index(volume_array, glong, tuint);
      tint2 = (int) (tlong / percent);
      if (tint2 > 0)
	{
	  gdk_draw_line (chart_pixmap, gc, tint, current_height - tint2,
			 tint, current_height - 1);
	}
      tint = tint + pixelspace;
    }
}
/**********************************************************************************
draw the scale area.
*********************************************************************************/
void 
draw_scale ()
{
  GdkRectangle area;
  GdkColor *color;
  GdkGC *gc;
  gfloat tfloat, tfloat2, interval, y = 0;
  GString *tstring;
  gint tint, tint2 = 0, current_height, current_width;
  GdkFont *font;
  extern GdkPixmap *scale_pixmap;
  extern GtkWidget *scale, *chart;
  extern gfloat range, maxhigh, maxlow;
  extern struct record config;
  
  

  tstring = g_string_new (NULL);
  
  gc = gdk_gc_new (scale->window);
  color = (GdkColor *) malloc (sizeof (GdkColor));
  color->red = config.background_red << 8;
  color->green = config.background_green << 8;
  color->blue = config.background_blue << 8;
  gdk_color_alloc (gtk_widget_get_colormap (scale), color);
  gdk_gc_set_foreground (gc, color);

  gdk_draw_rectangle (scale_pixmap, gc, TRUE, 0, 0,
		      scale->allocation.width,
		      scale->allocation.height);

  color->red = config.border_red << 8;
  color->green = config.border_green << 8;
  color->blue = config.border_blue << 8;
  gdk_color_alloc (gtk_widget_get_colormap (scale), color);
  gdk_gc_set_foreground (gc, color);
  
  current_height = scale->allocation.height;
  gdk_draw_line (scale_pixmap, gc, 0, 0, 0, current_height);
  current_width = chart->allocation.width;
  current_height = get_current_chart_height ();
  font = gdk_font_load ("-Adobe-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-*");
  if (range < 1)
    {
      interval = 0.1;
      if (range / interval < 10)
	{
	  for (interval = 0.0025; (range / interval) >= 10; interval = interval + 0.0025)
	    {
	    }
	}
    }
  else
    {
      if (range < 10)
	{
	  interval = 1;
	  if (range / interval < 10)
	    {
	      for (interval = 0.1; (range / interval) >= 10; interval = interval + 0.1)
		{
		}
	    }
	}
      else
	{
	  if (range < 50)
	    {
	      interval = 5;
	      if (range / interval < 10)
		{
		  for (interval = 1; (range / interval) >= 10; interval = interval + 1)
		    {
		    }
		}
	    }
	  else
	    {
	      if (range < 100)
		{
		  interval = 10;
		  if (range / interval < 10)
		    {
		      for (interval = 5; (range / interval) >= 10; interval = interval + 1)
			{
			}
		    }
		}
	      else
		{
		  if (range < 500)
		    {
		      interval = 50;
		      if (range / interval < 10)
			{
			  for (interval = 25; (range / interval) >= 10; interval = interval + 5)
			    {
			    }
			}
		    }
		  else
		    {
		      if (range < 1000)
			{
			  interval = 100;
			  if (range / interval < 10)
			    {
			      for (interval = 50; (range / interval) >= 10; interval = interval + 10)
				{
				}
			    }
			}
		      else
			{
			  if (range < 5000)
			    {
			      interval = 500;
			      if (range / interval < 10)
				{
				  for (interval = 250; (range / interval) >= 10; interval = interval + 25)
				    {
				    }
				}
			    }
			  else
			    {
			      interval = 1000;
			    }
			}
		    }
		}
	    }
	}
    }
  tint2 = (int) (maxlow / interval);
  for (tint = 1; tint < 10; tint++)
    {
      if (maxlow > 10)
	{
	  g_string_sprintf (tstring, "%5.2f", (tint2 * interval) + (interval * tint));
	  tfloat = (tint2 * interval) + (interval * tint);
	}
      else
	{
	  g_string_sprintf (tstring, "%5.4f", (tint2 * interval) + (interval * tint));
	  tfloat = (tint2 * interval) + (interval * tint);
	}
      tfloat2 = (maxhigh - tfloat) * (current_height / range);
      y = (int) tfloat2 + 2;
      gdk_draw_string (scale_pixmap, font, gc, 6, y + 5, tstring->str);
      gdk_draw_line (scale_pixmap, gc, 0, y, 4, y);
    }
  area.x = 0;
  area.y = 0;
  area.width = scale->allocation.width;
  area.height = scale->allocation.height;
  gtk_widget_draw (scale, &area);
  
  g_string_free (tstring, TRUE);
}
/***********************************************************************************
draw the close plot line.
***********************************************************************************/
void 
draw_price ()
{
  gint tint, firstx, firsty, secondy, current_height, pixelspace, records;
  guint tuint;
  GdkColor *color = NULL;
  GdkGC *gc;
  extern gfloat maxhigh, range;
  extern GdkPixmap *chart_pixmap;
  extern GtkWidget *chart;
  extern struct record config;
  extern GArray *close_array, *open_array, *high_array, *low_array;
  extern gint current_records, current_line_pixelspace, current_ohlc_pixelspace, array_size;



  gc = gdk_gc_new (chart->window);
  color = (GdkColor *) malloc (sizeof (GdkColor));
  color->red = config.price_red << 8;
  color->green = config.price_green << 8;
  color->blue = config.price_blue << 8;
  gdk_color_alloc (gtk_widget_get_colormap (chart), color);
  gdk_gc_set_foreground (gc, color);

  if (config.style == 0)
    pixelspace = current_line_pixelspace;
  else
    pixelspace = current_ohlc_pixelspace;
    
  if (strstr(config.chart_type, "Daily"))
  {
  	if (config.bars)
  	{
  		/* get the smallest number of data to load, either total records or maximum */
      		if (current_records < config.bars)
			records = current_records;
      		else
			records = config.bars;
	}
	else
		records = current_records;
  }
  else
	records = array_size;
    
  current_height = get_current_chart_height ();
  tint = 0;
  if (!config.style)
    {
      firstx = 0;
      firsty = (maxhigh - g_array_index(close_array, gfloat, 0)) * (current_height / range);
      for (tuint = 0; tuint < records; tuint++)
	{
	  secondy = (maxhigh - g_array_index(close_array, gfloat, tuint)) * (current_height / range);
	  gdk_draw_line (chart_pixmap, gc, firstx, firsty, tint, secondy);
	  firstx = tint;
	  firsty = secondy;
	  tint = tint + pixelspace;
	}
    }
  else
    {
      for (tuint = 0; tuint < records; tuint++)
	{
	  firsty = (maxhigh-g_array_index(open_array, gfloat, tuint)) * (current_height / range);
	  secondy = firsty;
	  gdk_draw_line (chart_pixmap, gc, tint, firsty, (tint - 2), secondy);
	  firsty = (maxhigh-g_array_index(high_array, gfloat, tuint)) * (current_height /range);
	  secondy = (maxhigh-g_array_index(low_array, gfloat, tuint)) * (current_height /range);
	  gdk_draw_line (chart_pixmap, gc, tint, firsty, tint, secondy);
	  firsty = (maxhigh-g_array_index(close_array, gfloat, tuint))*(current_height /range);
	  secondy = firsty;
	  gdk_draw_line (chart_pixmap, gc, tint, firsty, (tint + 2), secondy);
	  tint = tint + pixelspace;
	}
    }
}
/************************************************************************************
draw the MA plot.
*************************************************************************************/
void 
draw_moving_average ()
{
  gint tint, firstx, firsty, secondy, type, red, green, blue, period, current_height, records;
  gint pixelspace;
  guint tuint;
  gfloat tfloat = 0.0;
  GdkColor *color;
  GdkGC *gc;
  extern gfloat maxhigh, range;
  extern GdkPixmap *chart_pixmap;
  extern GtkWidget *chart;
  extern struct record config;
  extern GArray *ma_array;
  extern gint current_records, current_line_pixelspace, current_ohlc_pixelspace, array_size;
  

  if (! ma_array)
  	return;
  	
  type = config.moving_type;
  period = config.moving_value;
  red = config.moving_red;
  green = config.moving_green;
  blue = config.moving_blue;

  gc = gdk_gc_new (chart->window);
  color = (GdkColor *) malloc (sizeof (GdkColor));
  color->red = red << 8;
  color->green = green << 8;
  color->blue = blue << 8;
  gdk_color_alloc (gtk_widget_get_colormap (chart), color);
  gdk_gc_set_foreground (gc, color);

  if (config.style == 0)
    pixelspace = current_line_pixelspace;
  else
    pixelspace = current_ohlc_pixelspace;
    
  if (strstr(config.chart_type, "Daily"))
  {
  	if (config.bars)
  	{
  		/* get the smallest number of data to load, either total records or maximum */
      		if (current_records < config.bars)
			records = current_records;
      		else
			records = config.bars;
	}
	else
		records = current_records;
  }
  else
	records = array_size;
    
  current_height = get_current_chart_height ();
  tuint = period;
  firstx = period * pixelspace;
  tint = firstx;
  tfloat = g_array_index(ma_array, gfloat, tuint);
  firsty = (maxhigh - tfloat) * (current_height / range);
  tuint++;
  tint = tint + pixelspace;
  
  for (tuint = tuint; tuint < records; tuint++)
  {
	tfloat = g_array_index(ma_array, gfloat, tuint);
	secondy = (maxhigh - tfloat) * (current_height / range);
	gdk_draw_line (chart_pixmap, gc, firstx, firsty, tint, secondy);
	firstx = tint;
	tint = tint + pixelspace;
	firsty = secondy;
  }
}
/*************************************************************************************
draw the MA2 plot.
**************************************************************************************/
void 
draw_moving_average2 ()
{
  gint tint, firstx, firsty, secondy, type, red, green, blue, period, current_height, records;
  gint pixelspace;
  guint tuint;
  gfloat tfloat = 0.0;
  GdkColor *color;
  GdkGC *gc;
  extern gfloat maxhigh, range;
  extern GdkPixmap *chart_pixmap;
  extern GtkWidget *chart;
  extern struct record config;
  extern GArray *ma2_array;
  extern gint current_records, current_line_pixelspace, current_ohlc_pixelspace, array_size;
  

  if (! ma2_array)
  	return;
  	
  type = config.moving2_type;
  period = config.moving2_value;
  red = config.moving2_red;
  green = config.moving2_green;
  blue = config.moving2_blue;

  gc = gdk_gc_new (chart->window);
  color = (GdkColor *) malloc (sizeof (GdkColor));
  color->red = red << 8;
  color->green = green << 8;
  color->blue = blue << 8;
  gdk_color_alloc (gtk_widget_get_colormap (chart), color);
  gdk_gc_set_foreground (gc, color);

  if (config.style == 0)
    pixelspace = current_line_pixelspace;
  else
    pixelspace = current_ohlc_pixelspace;
    
  if (strstr(config.chart_type, "Daily"))
  {
  	if (config.bars)
  	{
  		/* get the smallest number of data to load, either total records or maximum */
      		if (current_records < config.bars)
			records = current_records;
      		else
			records = config.bars;
	}
	else
		records = current_records;
  }
  else
	records = array_size;
    
  current_height = get_current_chart_height ();
  tuint = period;
  firstx = period * pixelspace;
  tint = firstx;
  tfloat = g_array_index(ma2_array, gfloat, tuint);
  firsty = (maxhigh - tfloat) * (current_height / range);
  tuint++;
  tint = tint + pixelspace;
  
  for (tuint = tuint; tuint < records; tuint++)
  {
	tfloat = g_array_index(ma2_array, gfloat, tuint);
	secondy = (maxhigh - tfloat) * (current_height / range);
	gdk_draw_line (chart_pixmap, gc, firstx, firsty, tint, secondy);
	firstx = tint;
	tint = tint + pixelspace;
	firsty = secondy;
  }
}
/*************************************************************************************
draw the MA3 plot.
************************************************************************************/
void 
draw_moving_average3 ()
{
  gint tint, firstx, firsty, secondy, type, red, green, blue, period, current_height, records;
  gint pixelspace;
  guint tuint;
  gfloat tfloat = 0.0;
  GdkColor *color;
  GdkGC *gc;
  extern gfloat maxhigh, range;
  extern GdkPixmap *chart_pixmap;
  extern GtkWidget *chart;
  extern struct record config;
  extern GArray *ma3_array;
  extern gint current_records, current_line_pixelspace, current_ohlc_pixelspace, array_size;
  

  if (! ma3_array)
  	return;
  	
  type = config.moving3_type;
  period = config.moving3_value;
  red = config.moving3_red;
  green = config.moving3_green;
  blue = config.moving3_blue;

  gc = gdk_gc_new (chart->window);
  color = (GdkColor *) malloc (sizeof (GdkColor));
  color->red = red << 8;
  color->green = green << 8;
  color->blue = blue << 8;
  gdk_color_alloc (gtk_widget_get_colormap (chart), color);
  gdk_gc_set_foreground (gc, color);

  if (config.style == 0)
    pixelspace = current_line_pixelspace;
  else
    pixelspace = current_ohlc_pixelspace;
    
  if (strstr(config.chart_type, "Daily"))
  {
  	if (config.bars)
  	{
  		/* get the smallest number of data to load, either total records or maximum */
      		if (current_records < config.bars)
			records = current_records;
      		else
			records = config.bars;
	}
	else
		records = current_records;
  }
  else
	records = array_size;
    
  current_height = get_current_chart_height ();
  tuint = period;
  firstx = period * pixelspace;
  tint = firstx;
  tfloat = g_array_index(ma3_array, gfloat, tuint);
  firsty = (maxhigh - tfloat) * (current_height / range);
  tuint++;
  tint = tint + pixelspace;
  
  for (tuint = tuint; tuint < records; tuint++)
  {
	tfloat = g_array_index(ma3_array, gfloat, tuint);
	secondy = (maxhigh - tfloat) * (current_height / range);
	gdk_draw_line (chart_pixmap, gc, firstx, firsty, tint, secondy);
	firstx = tint;
	tint = tint + pixelspace;
	firsty = secondy;
  }
}
/************************************************************************************
the main draw routine.
************************************************************************************/
void 
draw ()
{
  GdkColor *color;
  GdkGC *gc;
  GdkRectangle area;
  extern gint chartflag;
  extern GtkWidget *chart;
  extern GdkPixmap *chart_pixmap;
  extern struct record config;


  if (chartflag == 0)
    return;


  gc = gdk_gc_new (chart->window);
  color = (GdkColor *) malloc (sizeof (GdkColor));
  color->red = config.background_red << 8;
  color->green = config.background_green << 8;
  color->blue = config.background_blue << 8;
  gdk_color_alloc (gtk_widget_get_colormap (chart), color);
  gdk_gc_set_foreground (gc, color);

  gdk_draw_rectangle (chart_pixmap, gc, TRUE, 0, 0,
		      chart->allocation.width,
		      chart->allocation.height);

  draw_date ();
  
  if (config.grid)
    draw_grid ();
    
  if (config.volume_status)
    draw_volume ();
    
  draw_price ();
  
  if (config.moving_status)
	draw_moving_average ();
	
  if (config.moving2_status)
	draw_moving_average2 ();
	
  if (config.moving3_status)
	draw_moving_average3 ();
	
  draw_scale ();

  area.x = 0;
  area.y = 0;
  area.width = chart->allocation.width;
  area.height = chart->allocation.height;
  gtk_widget_draw (chart, &area);
}
