/* $Id: strip_url.c,v 1.1 2001/10/31 00:01:47 kordless Exp $ */

/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2000 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *   Author:  Ledio Ago - lajesus (email: lajesus@grub.org)               *
 *                                                                        *
 **************************************************************************/
/*
 * File:	strip_url.c
 * Author:	Ledio Ago
 * Date:	Agust 3, 2001
 */
#include <string.h>
#include <stdio.h>
#include "strip_url.h"
/*
 * Function:	strip_url
 * Description:	Function strip_url will strip down a given url by 
 *		separating the protocol, the host and whatever is left
 *		which will call it the content of the url.
 */
void strip_url( const char *the_url, char *content, char *host, char *prot )
{
	int	prot_size,
		host_size,
		content_size;
	char	tmp_str[300];

	// separate protocol
	char *tmp = strstr( the_url, "://" );
	if ( tmp == NULL || tmp == the_url ) {
		*prot = '\0';
		strcpy(tmp_str,(char*)the_url);

	} else { 

		prot_size = tmp - the_url;
		strncpy( prot, the_url, prot_size );
		strcpy( tmp_str, tmp+3);
		prot[prot_size] = '\0';
	}
	// separate host
	tmp = strstr( tmp_str, "/" );
	if ( tmp ) {

		host_size = tmp - tmp_str;
		strncpy( host, tmp_str, tmp - tmp_str );
		host[tmp - tmp_str] = '\0';
		// separate content
		if ( *(tmp + 1) != '\0' ) 

			strcpy( content, tmp );
		else 
			*content = '\0';
	} else {

		strcpy( host, tmp_str );
		*content = '\0';
	}


}
